/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Signer;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public final class X500Signer
extends Signer {
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;

    public byte[] sign() throws SignatureException {
        return this.sig.sign();
    }

    public void update(byte[] byArray, int n2, int n3) throws SignatureException {
        this.sig.update(byArray, n2, n3);
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public X500Name getSigner() {
        return this.agent;
    }

    public X500Signer(Signature signature, X500Name x500Name) {
        if (signature == null || x500Name == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = signature;
        this.agent = x500Name;
        try {
            this.algid = AlgorithmId.getAlgorithmId(signature.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("internal error! " + noSuchAlgorithmException.getMessage());
        }
    }
}

