/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    int mouseDownIndex;
    int font;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final int LinkProc;
    static final TCHAR LinkClass;

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        if (OS.COMCTL32_MAJOR >= 6) {
            WNDCLASS wNDCLASS = new WNDCLASS();
            OS.GetClassInfo(0, LinkClass, wNDCLASS);
            LinkProc = wNDCLASS.lpfnWndProc;
        } else {
            LinkProc = 0;
        }
    }

    public Link(Composite composite, int n2) {
        super(composite, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (LinkProc != 0) {
            return OS.CallWindowProc(LinkProc, n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        this.checkWidget();
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (n3 != -1 && n3 < 0) {
            n3 = 0;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            n6 = OS.GetDC(this.handle);
            int n7 = OS.SendMessage(this.handle, 49, 0, 0);
            int n8 = OS.SelectObject(n6, n7);
            TCHAR tCHAR = new TCHAR(this.getCodePage(), this.parse(this.text), false);
            RECT rECT = new RECT();
            int n9 = 3072;
            if (n2 != -1) {
                n9 |= 0x10;
                rECT.right = n2;
            }
            OS.DrawText(n6, tCHAR, tCHAR.length(), rECT, n9);
            n5 = rECT.right - rECT.left;
            n4 = rECT.bottom;
            if (n7 != 0) {
                OS.SelectObject(n6, n8);
            }
            OS.ReleaseDC(this.handle, n6);
        } else {
            n6 = this.layout.getWidth();
            if (n2 == 0) {
                this.layout.setWidth(1);
                Rectangle rectangle = this.layout.getBounds();
                n5 = 0;
                n4 = rectangle.height;
            } else {
                this.layout.setWidth(n2);
                Rectangle rectangle = this.layout.getBounds();
                n5 = rectangle.width;
                n4 = rectangle.height;
            }
            this.layout.setWidth(n6);
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n4 = n3;
        }
        n6 = this.getBorderWidth();
        return new Point(n5 += n6 * 2, n4 += n6 * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
        if (OS.COMCTL32_MAJOR < 6) {
            this.layout = new TextLayout(this.display);
            this.linkColor = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) ? Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_HOTLIGHT)) : new Color(this.display, LINK_FOREGROUND);
            this.disabledColor = Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            this.offsets = new Point[0];
            this.ids = new String[0];
            this.mnemonics = new int[0];
            this.selection = new Point(-1, -1);
            this.mouseDownIndex = -1;
            this.focusIndex = -1;
        }
    }

    void createWidget() {
        super.createWidget();
        this.text = "";
        if (OS.COMCTL32_MAJOR < 6) {
            if ((this.style & 0x8000000) != 0) {
                this.layout.setOrientation(0x4000000);
            }
            this.initAccessible();
        }
    }

    void drawWidget(GC gC, RECT rECT) {
        Rectangle[] rectangleArray;
        this.drawBackground(gC.handle, rECT);
        int n2 = this.selection.x;
        int n3 = this.selection.y;
        if (n2 > n3) {
            n2 = this.selection.y;
            n3 = this.selection.x;
        }
        n3 = -1;
        n2 = -1;
        if (!OS.IsWindowEnabled(this.handle)) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n2, n3, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectangles(this.focusIndex);
            int n4 = 0;
            while (n4 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n4];
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n4;
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.gc = gC;
            rectangleArray.x = rECT.left;
            rectangleArray.y = rECT.top;
            rectangleArray.width = rECT.right - rECT.left;
            rectangleArray.height = rECT.bottom - rECT.top;
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
    }

    void enableWidget(boolean bl2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 2;
            lITEM.state = bl2 ? 2 : 0;
            while (OS.SendMessage(this.handle, 1794, 0, lITEM) != 0) {
                ++lITEM.iLink;
            }
        } else {
            TextStyle textStyle = new TextStyle(null, bl2 ? this.linkColor : this.disabledColor, null);
            textStyle.underline = true;
            int n2 = 0;
            while (n2 < this.offsets.length) {
                Point point = this.offsets[n2];
                this.layout.setStyle(textStyle, point.x, point.y);
                ++n2;
            }
            this.redraw();
        }
        super.enableWidget(bl2);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage("SWT_Press");
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int n2) {
        int n3 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n3];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n2];
        int n4 = 1;
        while (point.x > nArray[n4]) {
            ++n4;
        }
        int n5 = 1;
        while (point.y > nArray[n5]) {
            ++n5;
        }
        int n6 = 0;
        if (n4 == n5) {
            rectangleArray[n6++] = this.layout.getBounds(point.x, point.y);
        } else {
            rectangleArray[n6++] = this.layout.getBounds(point.x, nArray[n4] - 1);
            rectangleArray[n6++] = this.layout.getBounds(nArray[n5 - 1], point.y);
            if (n5 - n4 > 1) {
                int n7 = n4;
                while (n7 < n5 - 1) {
                    rectangleArray[n6++] = this.layout.getLineBounds(n7);
                    ++n7;
                }
            }
        }
        if (rectangleArray.length != n6) {
            Rectangle[] rectangleArray2 = new Rectangle[n6];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n6);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    String parse(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        this.offsets = new Point[n4 / 4];
        this.ids = new String[n4 / 4];
        this.mnemonics = new int[n4 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n4];
        string.getChars(0, string.length(), cArray, 0);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n5 < n4) {
            n3 = Character.toLowerCase(cArray[n5]);
            block0 : switch (n6) {
                case 0: {
                    if (n3 != 60) break;
                    n9 = n5;
                    ++n6;
                    break;
                }
                case 1: {
                    if (n3 != 97) break;
                    ++n6;
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 104: {
                            n6 = 7;
                            break block0;
                        }
                        case 62: {
                            n10 = n5 + 1;
                            ++n6;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n3)) break;
                    n6 = 13;
                    break;
                }
                case 3: {
                    if (n3 != 60) break;
                    n11 = n5;
                    ++n6;
                    break;
                }
                case 4: {
                    n6 = n3 == 47 ? n6 + 1 : 3;
                    break;
                }
                case 5: {
                    n6 = n3 == 97 ? n6 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n3 == 62) {
                        this.mnemonics[n7] = this.parseMnemonics(cArray, n8, n9, stringBuffer);
                        n2 = stringBuffer.length();
                        this.parseMnemonics(cArray, n10, n11, stringBuffer);
                        this.offsets[n7] = new Point(n2, stringBuffer.length() - 1);
                        if (this.ids[n7] == null) {
                            this.ids[n7] = new String(cArray, n10, n11 - n10);
                        }
                        ++n7;
                        n11 = n12 = n5 + 1;
                        n10 = n12;
                        n9 = n12;
                        n8 = n12;
                        n6 = 0;
                        break;
                    }
                    n6 = 3;
                    break;
                }
                case 7: {
                    n6 = n3 == 114 ? n6 + 1 : 0;
                    break;
                }
                case 8: {
                    n6 = n3 == 101 ? n6 + 1 : 0;
                    break;
                }
                case 9: {
                    n6 = n3 == 102 ? n6 + 1 : 0;
                    break;
                }
                case 10: {
                    n6 = n3 == 61 ? n6 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n3 == 34) {
                        ++n6;
                        n12 = n5 + 1;
                        break;
                    }
                    n6 = 0;
                    break;
                }
                case 12: {
                    if (n3 != 34) break;
                    this.ids[n7] = new String(cArray, n12, n5 - n12);
                    n6 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n3)) {
                        n6 = 0;
                        break;
                    }
                    if (n3 != 61) break;
                    ++n6;
                    break;
                }
                case 14: {
                    n6 = n3 == 34 ? n6 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n3 != 34) break;
                    n6 = 2;
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            ++n5;
        }
        if (n8 < n4) {
            n3 = this.parseMnemonics(cArray, n8, n9, stringBuffer);
            n2 = this.parseMnemonics(cArray, n10, n5, stringBuffer);
            if (n2 == -1) {
                n2 = n3;
            }
            this.mnemonics[n7] = n2;
        } else {
            this.mnemonics[n7] = -1;
        }
        if (this.offsets.length != n7) {
            Point[] pointArray = new Point[n7];
            System.arraycopy(this.offsets, 0, pointArray, 0, n7);
            this.offsets = pointArray;
            String[] stringArray = new String[n7];
            System.arraycopy(this.ids, 0, stringArray, 0, n7);
            this.ids = stringArray;
            int[] nArray = new int[n7 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n7 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n2, int n3, StringBuffer stringBuffer) {
        int n4 = -1;
        int n5 = n2;
        while (n5 < n3) {
            if (cArray[n5] == '&') {
                if (n5 + 1 < n3 && cArray[n5 + 1] == '&') {
                    stringBuffer.append(cArray[n5]);
                    ++n5;
                } else {
                    n4 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n5]);
            }
            ++n5;
        }
        return n4;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (OS.COMCTL32_MAJOR >= 6) {
            boolean bl2 = OS.IsWindowEnabled(this.handle);
            if (string.length() == 0) {
                string = " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
            this.parse(this.text);
            this.enableWidget(bl2);
        } else {
            this.layout.setText(this.parse(this.text));
            this.focusIndex = this.offsets.length > 0 ? 0 : -1;
            this.selection.y = -1;
            this.selection.x = -1;
            int n2 = OS.GetWindowLong(this.handle, -16);
            n2 = this.offsets.length > 0 ? (n2 |= 0x10000) : (n2 &= 0xFFFEFFFF);
            OS.SetWindowLong(this.handle, -16, n2);
            boolean bl3 = OS.IsWindowEnabled(this.handle);
            TextStyle textStyle = new TextStyle(null, bl3 ? this.linkColor : this.disabledColor, null);
            textStyle.underline = true;
            int n3 = 0;
            while (n3 < this.offsets.length) {
                Point point = this.offsets[n3];
                this.layout.setStyle(textStyle, point.x, point.y);
                ++n3;
            }
            TextStyle textStyle2 = new TextStyle(null, null, null);
            textStyle2.underline = true;
            int n4 = 0;
            while (n4 < this.mnemonics.length) {
                int n5 = this.mnemonics[n4];
                if (n5 != -1) {
                    this.layout.setStyle(textStyle2, n5, n5);
                }
                ++n4;
            }
            this.redraw();
        }
    }

    int widgetStyle() {
        int n2 = super.widgetStyle();
        return n2 | 0x10000;
    }

    TCHAR windowClass() {
        return OS.COMCTL32_MAJOR >= 6 ? LinkClass : this.display.windowClass;
    }

    int windowProc() {
        return LinkProc != 0 ? LinkProc : this.display.windowProc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.focusIndex == -1) {
                return lRESULT;
            }
            switch (n2) {
                case 13: 
                case 32: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendEvent(13, event);
                    return lRESULT;
                }
                case 9: {
                    boolean bl2;
                    boolean bl3 = bl2 = OS.GetKeyState(16) >= 0;
                    if (bl2) {
                        if (this.focusIndex >= this.offsets.length - 1) return lRESULT;
                        ++this.focusIndex;
                        this.redraw();
                        return lRESULT;
                    }
                    if (this.focusIndex <= 0) return lRESULT;
                    --this.focusIndex;
                    this.redraw();
                }
                default: {
                    return lRESULT;
                }
            }
        } else {
            switch (n2) {
                case 9: 
                case 13: 
                case 32: {
                    int n4 = this.callWindowProc(this.handle, 256, n2, n3);
                    return new LRESULT(n4);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n2, int n3) {
        boolean bl2;
        int n4;
        int n5;
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n6 = 0;
        if (OS.COMCTL32_MAJOR >= 6) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 1;
            n5 = 0;
            while (OS.SendMessage(this.handle, 1795, 0, lITEM) != 0) {
                if ((lITEM.state & 1) != 0) {
                    n5 = lITEM.iLink;
                }
                ++lITEM.iLink;
            }
            n4 = lITEM.iLink;
            n6 = this.callWindowProc(this.handle, 135, n2, n3);
        } else {
            n5 = this.focusIndex;
            n4 = this.offsets.length;
        }
        if (n4 == 0) {
            return new LRESULT(n6 | 0x100);
        }
        boolean bl3 = bl2 = OS.GetKeyState(16) >= 0;
        if (bl2 && n5 < n4 - 1) {
            return new LRESULT(n6 | 2);
        }
        if (!bl2 && n5 > 0) {
            return new LRESULT(n6 | 2);
        }
        return lRESULT;
    }

    LRESULT WM_GETFONT(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETFONT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = this.callWindowProc(this.handle, 49, n2, n3);
        if (n4 != 0) {
            return new LRESULT(n4);
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            switch (n2) {
                case 9: 
                case 13: 
                case 32: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (OS.COMCTL32_MAJOR < 6) {
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n4 = n3 & 0xFFFF;
            int n5 = n3 >> 16;
            int n6 = this.layout.getOffset(n4, n5, null);
            int n7 = this.selection.x;
            int n8 = this.selection.y;
            this.selection.x = n6;
            this.selection.y = -1;
            if (n7 != -1 && n8 != -1) {
                if (n7 > n8) {
                    int n9 = n7;
                    n7 = n8;
                    n8 = n9;
                }
                Rectangle rectangle = this.layout.getBounds(n7, n8);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            int n10 = 0;
            while (n10 < this.offsets.length) {
                Rectangle[] rectangleArray = this.getRectangles(n10);
                int n11 = 0;
                while (n11 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n11];
                    if (rectangle.contains(n4, n5)) {
                        if (n10 != this.focusIndex) {
                            this.redraw();
                        }
                        this.focusIndex = this.mouseDownIndex = n10;
                        return lRESULT;
                    }
                    ++n11;
                }
                ++n10;
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.mouseDownIndex == -1) {
                return lRESULT;
            }
            int n4 = n3 & 0xFFFF;
            int n5 = n3 >> 16;
            Rectangle[] rectangleArray = this.getRectangles(this.mouseDownIndex);
            int n6 = 0;
            while (n6 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n6];
                if (rectangle.contains(n4, n5)) {
                    Event event = new Event();
                    event.text = this.ids[this.mouseDownIndex];
                    this.sendEvent(13, event);
                    break;
                }
                ++n6;
            }
        }
        this.mouseDownIndex = -1;
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n2, n3);
        if (OS.COMCTL32_MAJOR < 6) {
            int n4 = n3 & 0xFFFF;
            int n5 = n3 >> 16;
            if (OS.GetKeyState(1) < 0) {
                int n6 = this.selection.y;
                this.selection.y = this.layout.getOffset(n4, n5, null);
                if (this.selection.y != n6) {
                    int n7 = this.selection.y;
                    if (n6 > n7) {
                        int n8 = n6;
                        n6 = n7;
                        n7 = n8;
                    }
                    Rectangle rectangle = this.layout.getBounds(n6, n7);
                    this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
            } else {
                int n9 = 0;
                while (n9 < this.offsets.length) {
                    Rectangle[] rectangleArray = this.getRectangles(n9);
                    int n10 = 0;
                    while (n10 < rectangleArray.length) {
                        Rectangle rectangle = rectangleArray[n10];
                        if (rectangle.contains(n4, n5)) {
                            this.setCursor(this.display.getSystemCursor(21));
                            return lRESULT;
                        }
                        ++n10;
                    }
                    ++n9;
                }
                this.setCursor(null);
            }
        }
        return lRESULT;
    }

    LRESULT WM_PAINT(int n2, int n3) {
        if (OS.COMCTL32_MAJOR >= 6) {
            return super.WM_PAINT(n2, n3);
        }
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n4 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n5 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n4 != 0 && n5 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int n2, int n3) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n2, n3);
        if (OS.COMCTL32_MAJOR < 6) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            GCData gCData = new GCData();
            gCData.device = this.display;
            gCData.foreground = this.getForegroundPixel();
            GC gC = GC.win32_new(n2, gCData);
            this.drawWidget(gC, rECT);
            gC.dispose();
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (OS.COMCTL32_MAJOR < 6) {
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT WM_SETFONT(int n2, int n3) {
        if (OS.COMCTL32_MAJOR < 6) {
            this.layout.setFont(Font.win32_new(this.display, n2));
        }
        if (n3 != 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.font = n2;
        return super.WM_SETFONT(this.font, n3);
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (OS.COMCTL32_MAJOR < 6) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.layout.setWidth(rECT.right > 0 ? rECT.right : -1);
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT wmColorChild(int n2, int n3) {
        LRESULT lRESULT = super.wmColorChild(n2, n3);
        if (OS.COMCTL32_MAJOR >= 6 && !OS.IsWindowEnabled(this.handle)) {
            OS.SetTextColor(n2, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            if (lRESULT == null) {
                int n4 = this.getBackgroundPixel();
                OS.SetBkColor(n2, n4);
                int n5 = this.findBrush(n4, 0);
                return new LRESULT(n5);
            }
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        if (OS.COMCTL32_MAJOR >= 6) {
            switch (nMHDR.code) {
                case -4: 
                case -2: {
                    NMLINK nMLINK = new NMLINK();
                    OS.MoveMemory(nMLINK, n3, NMLINK.sizeof);
                    Event event = new Event();
                    event.text = this.ids[nMLINK.iLink];
                    this.sendEvent(13, event);
                }
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }
}

