/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.security.AccessController;
import org.lwjgl.DefaultSysImplementation;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.h;

public final class Sys {
    private static final String JNI_LIBRARY_NAME = "lwjgl";
    private static final String VERSION = "1.1.3";
    static final int JNI_VERSION = 11;
    private static final DefaultSysImplementation implementation$600071fe = Sys.createImplementation$3ff8c763();
    private static final String POSTFIX64BIT = "64";

    private static void doLoadLibrary(String string) {
        AccessController.doPrivileged(new h(string));
    }

    private static void loadLibrary(String string) {
        try {
            Sys.doLoadLibrary(string);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (implementation$600071fe.has64Bit()) {
                try {
                    Sys.doLoadLibrary(string + POSTFIX64BIT);
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    LWJGLUtil.log("Failed to load 64 bit library:" + unsatisfiedLinkError2.getMessage());
                }
            }
            throw unsatisfiedLinkError;
        }
    }

    private static DefaultSysImplementation createImplementation$3ff8c763() {
        String string;
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                string = "org.lwjgl.LinuxSysImplementation";
                break;
            }
            case 3: {
                string = "org.lwjgl.WindowsSysImplementation";
                break;
            }
            case 2: {
                string = "org.lwjgl.MacOSXSysImplementation";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (DefaultSysImplementation)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Sys() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void initialize() {
    }

    public static long getTimerResolution() {
        return implementation$600071fe.getTimerResolution();
    }

    public static long getTime() {
        return implementation$600071fe.getTime() & Long.MAX_VALUE;
    }

    public static void alert(String string, String string2) {
    }

    public static boolean openURL(String string) {
        return implementation$600071fe.openURL(string);
    }

    public static String getClipboard() {
        return implementation$600071fe.getClipboard();
    }

    static {
        Sys.loadLibrary(JNI_LIBRARY_NAME);
        int n2 = implementation$600071fe.getJNIVersion();
        if (n2 != 11) {
            throw new LinkageError("Version mismatch: jar version is '11', native libary version is '" + n2 + "'");
        }
        implementation$600071fe.setDebug(LWJGLUtil.DEBUG);
    }
}

