/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Coordinates;

public class QualifiedCoordinates
extends Coordinates {
    private float horizontalAccuracy;
    private float verticalAccuracy;

    public QualifiedCoordinates(double latitude, double longitude, float altitude, float horizontalAccuracy, float verticalAccuracy) {
        super(latitude, longitude, altitude);
        this.setHorizontalAccuracy(horizontalAccuracy);
        this.setVerticalAccuracy(verticalAccuracy);
    }

    public float getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public void setHorizontalAccuracy(float horizontalAccuracy) {
        if (!Float.isNaN(horizontalAccuracy) && !(horizontalAccuracy >= 0.0f)) {
            throw new IllegalArgumentException("Horizontal accuracy (" + horizontalAccuracy + ") is invalid.");
        }
        this.horizontalAccuracy = horizontalAccuracy;
    }

    public float getVerticalAccuracy() {
        return this.verticalAccuracy;
    }

    public void setVerticalAccuracy(float verticalAccuracy) {
        if (!Float.isNaN(verticalAccuracy) && !(verticalAccuracy >= 0.0f)) {
            throw new IllegalArgumentException("Vertical accuracy (" + verticalAccuracy + ") is invalid.");
        }
        this.verticalAccuracy = verticalAccuracy;
    }

    public String toString() {
        String s = super.toString();
        if (!Float.isNaN(this.horizontalAccuracy)) {
            s = s + " \ufffd" + this.horizontalAccuracy + "mH";
        }
        if (!Float.isNaN(this.verticalAccuracy)) {
            s = s + " \ufffd" + this.verticalAccuracy + "mV";
        }
        return s;
    }
}

