/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;

public class UIManager {
    private static final String INIT_NOT_SET_EXCEPTION = "Must first call UIManager.init";
    private static Theme theme = new Theme();
    private static Display display;
    private static DeviceScreen current;

    public static void init(MIDlet midlet) {
        if (midlet == null) {
            throw new IllegalArgumentException();
        }
        display = Display.getDisplay((MIDlet)midlet);
    }

    public static Theme getTheme() {
        return theme;
    }

    public static void setTheme(Theme theme) {
        if (theme == null) {
            throw new IllegalArgumentException("Cannot set a null theme.");
        }
        UIManager.theme = theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setScreen(DeviceScreen canvas, Displayable screen) {
        if (display == null) {
            throw new IllegalStateException(INIT_NOT_SET_EXCEPTION);
        }
        if (screen == null) {
            throw new IllegalArgumentException();
        }
        Display display = UIManager.display;
        synchronized (display) {
            if (current != null) {
                try {
                    current.hideNotify();
                }
                catch (Throwable t) {
                    Log.warn("Unhandled exception in hideNotify() of " + current, t);
                }
            }
            current = canvas;
            try {
                canvas.showNotify();
            }
            catch (Throwable t) {
                Log.warn("Unhandled exception in showNotify() of " + current, t);
            }
            UIManager.display.setCurrent(screen);
            canvas.repaint();
            if (Log.isDebugEnabled()) {
                Log.debug("Screen switched to " + canvas);
            }
        }
    }

    public static DeviceScreen getScreen() {
        return current;
    }

    public static Display getDisplay() {
        if (display == null) {
            throw new IllegalStateException(INIT_NOT_SET_EXCEPTION);
        }
        return display;
    }
}

