/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.MenuItem;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.MenuOption;

public class Menu
extends Dialog {
    protected DeviceScreen previous;

    public Menu() {
        this.setSpacing(0);
        Theme theme = UIManager.getTheme();
        String rightMenuText = theme.getMenuTextForOK();
        this.setMenuText(null, rightMenuText);
    }

    public Menu(String name, DeviceScreen previous) {
        this();
        this.previous = previous;
        this.setTitle(name);
        this.setPrevious(previous);
    }

    public void setPrevious(DeviceScreen previous) {
        this.previous = previous;
        Theme theme = UIManager.getTheme();
        String leftMenuText = previous == null ? null : theme.getMenuTextForCancel();
        String rightMenuText = theme.getMenuTextForOK();
        this.setMenuText(leftMenuText, rightMenuText);
    }

    public void appendMenuOption(MenuItem option) {
        MenuOption choice = new MenuOption(option);
        this.append(choice);
    }

    public void appendMenuOption(DeviceScreen option) {
        MenuOption choice = new MenuOption(option);
        this.append(choice);
    }

    public void appendMenuOption(String text, DeviceScreen option) {
        MenuOption choice = new MenuOption(text, option);
        this.append(choice);
    }

    public void appendSubmenu(Menu submenu) {
        MenuOption choice = new MenuOption(submenu, true);
        this.append(choice);
    }

    protected void declineNotify() {
        if (this.previous != null) {
            this.previous.show();
        }
        super.declineNotify();
    }

    protected void acceptNotify() {
        int highlighted = this.getSelected();
        this.selection(highlighted);
        super.acceptNotify();
    }

    protected void keyPressed(int key) {
        boolean goToFirst = false;
        boolean goToLast = false;
        if (key == -6) {
            if (this.getSelected() == this.size() - 1) {
                goToFirst = true;
            }
        } else if (key == -1 && this.getSelected() == 0 && this.size() > 1) {
            goToLast = true;
        }
        super.keyPressed(key);
        if (goToFirst) {
            this.setSelected(0);
        } else if (goToLast) {
            this.setSelected(this.size() - 1);
        }
    }

    private void selection(int selection) {
        Component component = this.get(selection);
        if (component instanceof MenuOption) {
            MenuOption chosen = (MenuOption)component;
            this.setSelected(selection);
            chosen.select();
        }
    }
}

