/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;

public class Picture
extends Component {
    private Image image;

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.invalidate();
    }

    public void setImage(String location) throws IOException {
        this.image = Image.createImage((String)location);
        this.invalidate();
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        if (this.image != null) {
            int horizontalAlignment = this.getHorizontalAlignment();
            int anchor = horizontalAlignment | 0x10;
            int y = (height - this.image.getHeight()) / 2;
            int x = horizontalAlignment == 4 ? 0 : (horizontalAlignment == 1 ? width / 2 : width);
            g.drawImage(this.image, x, y, anchor);
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        if (this.image == null) {
            throw new IllegalStateException();
        }
        return new int[]{this.image.getWidth(), this.image.getHeight()};
    }
}

