/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;

final class CanvasWrapper
extends Canvas
implements CommandListener {
    private static final short REPEAT_PERIOD = 200;
    private static boolean blackberry;
    private static boolean ibmJ9;
    private static boolean tao;
    private final DeviceScreen master;
    private Timer keyRepeatTimer = null;
    private boolean highlightLeftMenu;
    private boolean highlightRightMenu;
    private Command lcduiLeftMenuCommand;
    private Command lcduiRightMenuCommand;

    public CanvasWrapper(DeviceScreen master) {
        this.master = master;
        this.setFullScreenMode(true);
        this.setCommandListener(this);
    }

    private synchronized void stopRepeatTimer() {
        if (this.keyRepeatTimer != null) {
            this.keyRepeatTimer.cancel();
            this.keyRepeatTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int key) {
        int translatedKey = this.translateKeyCode(key);
        this.stopRepeatTimer();
        this.master.keyPressed(translatedKey);
        if (translatedKey == -21) {
            if (this.master.hasMenuBar()) {
                this.highlightLeftMenu = true;
                this.repaintMenuBar(true);
            }
            this.master.declineNotify();
        } else if (translatedKey == -22) {
            if (this.master.hasMenuBar()) {
                this.highlightRightMenu = true;
                this.repaintMenuBar(true);
            }
            this.master.acceptNotify();
        }
        CanvasWrapper canvasWrapper = this;
        synchronized (canvasWrapper) {
            this.keyRepeatTimer = new Timer();
            this.keyRepeatTimer.schedule((TimerTask)new KeyRepeater(translatedKey), 200L, 200L);
        }
    }

    protected void keyReleased(int key) {
        this.stopRepeatTimer();
        int translatedKey = this.translateKeyCode(key);
        this.master.keyReleased(translatedKey);
        if (this.master.hasMenuBar()) {
            if (translatedKey == -21) {
                this.highlightLeftMenu = false;
                this.repaintMenuBar(false);
            } else if (translatedKey == -22) {
                this.highlightRightMenu = false;
                this.repaintMenuBar(false);
            }
        }
    }

    private int translateKeyCode(int key) {
        int action;
        if (tao && key == 13) {
            return -8;
        }
        if (key > 6) {
            return key;
        }
        try {
            action = this.getGameAction(key);
        }
        catch (Exception e) {
            return key;
        }
        if (action != 0) {
            return -1 * action;
        }
        if (key == -6 || key == -21 || key == -1) {
            return -21;
        }
        if (key == -7 || key == -22 || key == -4) {
            return -22;
        }
        return key;
    }

    protected void pointerPressed(int x, int y) {
        int titleHeight;
        Theme theme = UIManager.getTheme();
        boolean processed = false;
        if (this.master.hasMenuBar()) {
            int menuHeight = theme.getMenuHeight();
            int menuStart = super.getHeight() - menuHeight;
            if (y > menuStart) {
                int width = super.getWidth();
                if (x < width / 2) {
                    this.master.declineNotify();
                } else {
                    this.master.acceptNotify();
                }
                processed = true;
            }
        }
        boolean hasTitle = this.master.hasTitleBar();
        if (!processed && hasTitle && y < (titleHeight = theme.getTitleHeight())) {
            processed = true;
        }
        if (!processed) {
            int py = y;
            if (hasTitle) {
                py -= theme.getTitleHeight();
            }
            this.master.pointerPressed(x, py);
        }
        super.pointerPressed(x, y);
    }

    protected void pointerDragged(int x, int y) {
        int py = y;
        if (this.master.hasTitleBar()) {
            Theme theme = UIManager.getTheme();
            py -= theme.getTitleHeight();
        }
        this.master.pointerDragged(x, py);
        super.pointerDragged(x, y);
    }

    protected void pointerReleased(int x, int y) {
        int py = y;
        if (this.master.hasTitleBar()) {
            Theme theme = UIManager.getTheme();
            py -= theme.getTitleHeight();
        }
        this.master.pointerReleased(x, py);
        super.pointerReleased(x, y);
    }

    public void setTitle(String title) {
        if (!this.supportsTitleBar()) {
            super.setTitle(title);
        }
    }

    public void setMenuText(String left, String right) {
        if (!this.supportsMenuBar()) {
            int position;
            if (this.lcduiLeftMenuCommand != null) {
                this.removeCommand(this.lcduiLeftMenuCommand);
                this.lcduiLeftMenuCommand = null;
            }
            if (this.lcduiRightMenuCommand != null) {
                this.removeCommand(this.lcduiRightMenuCommand);
                this.lcduiRightMenuCommand = null;
            }
            if (left != null) {
                position = blackberry ? 2 : 1;
                this.lcduiLeftMenuCommand = new Command(left, 3, position);
                this.addCommand(this.lcduiLeftMenuCommand);
            }
            if (right != null) {
                position = blackberry ? 1 : 2;
                this.lcduiRightMenuCommand = new Command(right, 4, position);
                this.addCommand(this.lcduiRightMenuCommand);
                if ((ibmJ9 || tao) && left == null) {
                    this.lcduiLeftMenuCommand = new Command("", 3, 1);
                    this.addCommand(this.lcduiLeftMenuCommand);
                }
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (this.lcduiLeftMenuCommand != null && c == this.lcduiLeftMenuCommand) {
            this.keyPressed(-21);
            this.keyReleased(-21);
        }
        if (this.lcduiRightMenuCommand != null && c == this.lcduiRightMenuCommand) {
            this.keyPressed(-22);
            this.keyReleased(-22);
        }
    }

    public boolean supportsMenuBar() {
        return !blackberry && !ibmJ9 && !tao;
    }

    public boolean supportsTitleBar() {
        return !ibmJ9 && !tao;
    }

    protected void hideNotify() {
        this.stopRepeatTimer();
        this.highlightLeftMenu = false;
        this.highlightRightMenu = false;
        super.hideNotify();
    }

    private void repaintMenuBar(boolean immediate) {
        Theme theme = UIManager.getTheme();
        int menuHeight = theme.getMenuHeight();
        int y = this.getHeight() - menuHeight;
        this.repaint(0, y, this.getWidth(), menuHeight);
        if (immediate) {
            this.serviceRepaints();
        }
    }

    protected void paint(Graphics g) {
        try {
            int y;
            Theme theme = UIManager.getTheme();
            int width = this.getWidth();
            int height = this.getHeight();
            int titleHeight = 0;
            int menuHeight = 0;
            String title = null;
            String leftMenuText = null;
            String rightMenuText = null;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            if (!this.master.isFullScreenMode()) {
                title = this.master.getTitle();
                if (this.master.hasTitleBar()) {
                    titleHeight = theme.getTitleHeight();
                }
                if (this.master.hasMenuBar()) {
                    leftMenuText = this.master.getLeftMenuText();
                    rightMenuText = this.master.getRightMenuText();
                    if (leftMenuText == null) {
                        leftMenuText = "";
                    }
                    if (rightMenuText == null) {
                        rightMenuText = "";
                    }
                    menuHeight = theme.getMenuHeight();
                }
                height = height - titleHeight - menuHeight;
                g.translate(0, titleHeight);
                g.clipRect(0, 0, width, height);
            }
            if (DeviceScreen.intersects(g, 0, 0, width, height)) {
                this.master.paintBackground(g);
                g.setFont(theme.getFont());
                g.setColor(theme.getFontColor());
                this.master.paint(g);
            }
            g.translate(0, -titleHeight);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            if (titleHeight > 0 && DeviceScreen.intersects(g, 0, 0, width, titleHeight)) {
                g.clipRect(0, 0, width, titleHeight);
                this.master.paintTitleBar(g, title, width, titleHeight);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            if (menuHeight > 0 && DeviceScreen.intersects(g, 0, y = this.getHeight() - menuHeight, width, menuHeight)) {
                g.translate(0, y);
                g.clipRect(0, 0, width, menuHeight);
                int menuBackgroundColor = theme.getMenuBarBackgroundColor();
                g.setColor(menuBackgroundColor);
                g.fillRect(0, 0, width, menuHeight);
                this.master.paintMenuBar(g, leftMenuText, this.highlightLeftMenu, rightMenuText, this.highlightRightMenu, width, menuHeight);
                g.translate(0, -y);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        }
        catch (Throwable t) {
            Log.warn("Unhandled exception in paint for " + this.master, t);
        }
    }

    static {
        String platform = System.getProperty("microedition.platform");
        platform = platform.toLowerCase();
        try {
            Class.forName("net.rim.device.api.ui.UiApplication");
            blackberry = true;
        }
        catch (Throwable e) {
            blackberry = false;
        }
        try {
            Class.forName("java.lang.J9VMInternals");
            ibmJ9 = true;
        }
        catch (Throwable e) {
            ibmJ9 = false;
        }
        tao = platform.indexOf("intent") > -1;
    }

    private final class KeyRepeater
    extends TimerTask {
        private int key;

        public KeyRepeater(int key) {
            this.key = key;
        }

        public void run() {
            if (CanvasWrapper.this.master.isShown()) {
                try {
                    CanvasWrapper.this.master.keyRepeated(this.key);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

