/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.CustomFont;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.impl.LWUITImplementation;

public final class Graphics {
    private int xTranslate;
    private int yTranslate;
    private int color;
    private Font current = Font.getDefaultFont();
    private LWUITImplementation impl;
    private Object nativeGraphics;
    private Object[] nativeGraphicsState;

    Graphics(Object object) {
        this.setGraphics(object);
        this.impl = Display.getInstance().getImplementation();
    }

    void setGraphics(Object object) {
        this.nativeGraphics = object;
    }

    Object getGraphics() {
        return this.nativeGraphics;
    }

    public void translate(int n, int n2) {
        if (this.impl.isTranslationSupported()) {
            this.impl.translate(this.nativeGraphics, n, n2);
        } else {
            this.xTranslate += n;
            this.yTranslate += n2;
        }
    }

    public int getTranslateX() {
        if (this.impl.isTranslationSupported()) {
            return this.impl.getTranslateX(this.nativeGraphics);
        }
        return this.xTranslate;
    }

    public int getTranslateY() {
        if (this.impl.isTranslationSupported()) {
            return this.impl.getTranslateY(this.nativeGraphics);
        }
        return this.yTranslate;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = 0xFFFFFF & n;
        this.impl.setColor(this.nativeGraphics, this.color);
    }

    public Font getFont() {
        return this.current;
    }

    public void setFont(Font font) {
        this.current = font;
        if (!(font instanceof CustomFont)) {
            this.impl.setNativeFont(this.nativeGraphics, font.getNativeFont());
        }
    }

    public int getClipX() {
        return this.impl.getClipX(this.nativeGraphics) - this.xTranslate;
    }

    public int getClipY() {
        return this.impl.getClipY(this.nativeGraphics) - this.yTranslate;
    }

    public int getClipWidth() {
        return this.impl.getClipWidth(this.nativeGraphics);
    }

    public int getClipHeight() {
        return this.impl.getClipHeight(this.nativeGraphics);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.impl.clipRect(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.impl.setClip(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.impl.drawLine(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, this.xTranslate + n3, this.yTranslate + n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.impl.fillRect(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.impl.drawRect(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.drawRoundRect(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4, n5, n6);
    }

    public void lighterColor(int n) {
        int n2 = this.getColor();
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        n3 = Math.min(255, n3 + n);
        n4 = Math.min(255, n4 + n);
        n5 = Math.min(255, n5 + n);
        this.setColor(n3 << 16 & 0xFF0000 | n4 << 8 & 0xFF00 | n5 & 0xFF);
    }

    public void darkerColor(int n) {
        int n2 = this.getColor();
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        n3 = Math.max(0, n3 - n);
        n4 = Math.max(0, n4 - n);
        n5 = Math.max(0, n5 - n);
        this.setColor(n3 << 16 & 0xFF0000 | n4 << 8 & 0xFF00 | n5 & 0xFF);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.fillRoundRect(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.fillArc(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4, n5, n6);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.drawArc(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, n3, n4, n5, n6);
    }

    public void drawString(String string, int n, int n2, int n3) {
        if (!(this.current instanceof CustomFont)) {
            this.impl.drawString(this.nativeGraphics, string, n + this.xTranslate, n2 + this.yTranslate);
        } else {
            char[] cArray = string.toCharArray();
            this.current.drawChars(this, cArray, 0, cArray.length, n, n2);
        }
        if ((n3 & 1) != 0) {
            this.drawLine(n, n2 + this.current.getHeight() - 1, n + this.current.stringWidth(string), n2 + this.current.getHeight() - 1);
        }
        if ((n3 & 2) != 0) {
            this.drawLine(n, n2 + this.current.getHeight() / 2, n + this.current.stringWidth(string), n2 + this.current.getHeight() / 2);
        }
        if ((n3 & 4) != 0) {
            this.drawLine(n, n2, n + this.current.stringWidth(string), n2);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, 0);
    }

    public void drawChar(char c, int n, int n2) {
        this.drawString("" + c, n, n2);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        if (!(this.current instanceof CustomFont)) {
            this.drawString(new String(cArray, n, n2), n3, n4);
        } else {
            CustomFont customFont = (CustomFont)this.current;
            customFont.drawChars(this, cArray, n, n2, n3, n4);
        }
    }

    public void drawImage(Image image, int n, int n2) {
        image.drawImage(this, this.nativeGraphics, n, n2);
    }

    void drawImage(Object object, int n, int n2) {
        this.impl.drawImage(this.nativeGraphics, object, n + this.xTranslate, n2 + this.yTranslate);
    }

    void drawImage(Object object, int n, int n2, int n3) {
        if (n3 != 0) {
            this.impl.drawImageRotated(this.nativeGraphics, object, n + this.xTranslate, n2 + this.yTranslate, n3);
        } else {
            this.drawImage(object, n, n2);
        }
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.fillTriangle(this.nativeGraphics, this.xTranslate + n, this.yTranslate + n2, this.xTranslate + n3, this.yTranslate + n4, this.xTranslate + n5, this.yTranslate + n6);
    }

    void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.impl.drawRGB(this.nativeGraphics, nArray, n, n2 + this.xTranslate, n3 + this.yTranslate, n4, n5, bl);
    }

    public void fillRadialGradient(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.fillRadialGradient(this.nativeGraphics, n, n2, n3 + this.xTranslate, n4 + this.yTranslate, n5, n6);
    }

    public void fillRectRadialGradient(int n, int n2, int n3, int n4, int n5, int n6, float f, float f2, float f3) {
        this.impl.fillRectRadialGradient(this.nativeGraphics, n, n2, n3 + this.xTranslate, n4 + this.yTranslate, n5, n6, f, f2, f3);
    }

    public void fillLinearGradient(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.impl.fillLinearGradient(this.nativeGraphics, n, n2, n3 + this.xTranslate, n4 + this.yTranslate, n5, n6, bl);
    }

    public void fillRect(int n, int n2, int n3, int n4, byte by) {
        if (by != 0) {
            int n5 = this.impl.getAlpha(this.nativeGraphics);
            this.impl.setAlpha(this.nativeGraphics, by & 0xFF);
            this.impl.fillRect(this.nativeGraphics, n + this.xTranslate, n2 + this.yTranslate, n3, n4);
            this.impl.setAlpha(this.nativeGraphics, n5);
        }
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        if (!(this.impl.isTranslationSupported() || this.xTranslate == 0 && this.yTranslate == 0)) {
            nArray3 = new int[n];
            nArray4 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            System.arraycopy(nArray2, 0, nArray4, 0, n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                nArray3[n3] = nArray3[n3] + this.xTranslate;
                int n4 = n2++;
                nArray4[n4] = nArray4[n4] + this.yTranslate;
            }
        }
        this.impl.fillPolygon(this.nativeGraphics, nArray3, nArray4, n);
    }

    void drawImageArea(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        image.drawImageArea(this, this.nativeGraphics, n, n2, n3, n4, n5, n6);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        if (!(this.impl.isTranslationSupported() || this.xTranslate == 0 && this.yTranslate == 0)) {
            nArray3 = new int[n];
            nArray4 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            System.arraycopy(nArray2, 0, nArray4, 0, n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                nArray3[n3] = nArray3[n3] + this.xTranslate;
                int n4 = n2++;
                nArray4[n4] = nArray4[n4] + this.yTranslate;
            }
        }
        this.impl.drawPolygon(this.nativeGraphics, nArray3, nArray4, n);
    }

    public boolean isAlphaSupported() {
        return this.impl.isAlphaGlobal();
    }

    public void setAlpha(int n) {
        this.impl.setAlpha(this.nativeGraphics, n);
    }

    public int getAlpha() {
        return this.impl.getAlpha(this.nativeGraphics);
    }

    public boolean isAntiAliasingSupported() {
        return this.impl.isAntiAliasingSupported();
    }

    public boolean isAntiAliasedTextSupported() {
        return this.impl.isAntiAliasedTextSupported();
    }

    public boolean isAntiAliased() {
        return this.impl.isAntiAliased(this.nativeGraphics);
    }

    public void setAntiAliased(boolean bl) {
        this.impl.setAntiAliased(this.nativeGraphics, bl);
    }

    public void setAntiAliasedText(boolean bl) {
        this.impl.setAntiAliasedText(this.nativeGraphics, bl);
    }

    public boolean isAntiAliasedText() {
        return this.impl.isAntiAliasedText(this.nativeGraphics);
    }

    public boolean isAffineSupported() {
        return this.impl.isAffineSupported();
    }

    public void resetAffine() {
        this.impl.resetAffine(this.nativeGraphics);
    }

    public void scale(float f, float f2) {
        this.impl.scale(this.nativeGraphics, f, f2);
    }

    public void rotate(float f) {
        this.impl.rotate(this.nativeGraphics, f);
    }

    public void shear(float f, float f2) {
        this.impl.shear(this.nativeGraphics, f, f2);
    }

    public Object beginNativeGraphicsAccess() {
        if (this.nativeGraphicsState != null) {
            throw new IllegalStateException("beginNativeGraphicsAccess invoked twice in a row");
        }
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        if (this.isAntiAliasedText()) {
            bl2 = Boolean.TRUE;
        }
        if (this.isAntiAliased()) {
            bl = Boolean.TRUE;
        }
        this.nativeGraphicsState = new Object[]{new Integer(this.getTranslateX()), new Integer(this.getTranslateY()), new Integer(this.getColor()), new Integer(this.getAlpha()), new Integer(this.getClipX()), new Integer(this.getClipY()), new Integer(this.getClipWidth()), new Integer(this.getClipHeight()), bl, bl2};
        this.translate(-this.getTranslateX(), -this.getTranslateY());
        this.setAlpha(255);
        this.setClip(0, 0, Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
        return this.nativeGraphics;
    }

    public void endNativeGraphicsAccess() {
        this.translate((Integer)this.nativeGraphicsState[0], (Integer)this.nativeGraphicsState[1]);
        this.setColor((Integer)this.nativeGraphicsState[2]);
        this.setAlpha((Integer)this.nativeGraphicsState[3]);
        this.setClip((Integer)this.nativeGraphicsState[4], (Integer)this.nativeGraphicsState[5], (Integer)this.nativeGraphicsState[6], (Integer)this.nativeGraphicsState[7]);
        this.setAntiAliased((Boolean)this.nativeGraphicsState[8]);
        this.setAntiAliasedText((Boolean)this.nativeGraphicsState[9]);
        this.nativeGraphicsState = null;
    }
}

