/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.Painter;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class TabbedPane
extends Container {
    private Transition transitionRight;
    private Transition transitionLeft;
    private Container contentPane = new Container(new BorderLayout());
    private List tabsList = new List();
    private Hashtable tabsTable = new Hashtable();
    private int tabPlacement = -1;
    private int tPBorder = 1;
    private int lastListX;
    private int lastListY;

    public TabbedPane() {
        this(0);
    }

    public TabbedPane(int n) {
        super(new BorderLayout());
        this.contentPane.setUIID("TabbedPane");
        this.contentPane.getStyle().setBgPainter(new Painter(){

            public void paint(Graphics graphics, Rectangle rectangle) {
                UIManager.getInstance().getLookAndFeel().drawTabbedPaneContentPane(TabbedPane.this, graphics, rectangle, TabbedPane.this.tabsList.getPreferredSize(), TabbedPane.this.tabsList.size(), TabbedPane.this.tabsList.getSelectedIndex(), TabbedPane.this.tabsList.getElementSize(true, true), TabbedPane.this.tabsList.getScrollX(), TabbedPane.this.tabsList.getScrollY());
            }
        });
        super.addComponent("Center", (Component)this.contentPane);
        this.setTabPlacement(n);
        this.tabsList.getUnselectedStyle().setPadding(0, 0, 0, 0);
        this.tabsList.getUnselectedStyle().setMargin(0, 0, 0, 0);
        this.tabsList.getUnselectedStyle().setBorder(null);
        this.tabsList.getSelectedStyle().setPadding(0, 0, 0, 0);
        this.tabsList.getSelectedStyle().setMargin(0, 0, 0, 0);
        this.tabsList.getSelectedStyle().setBorder(null);
        this.tabsList.setListCellRenderer(new TabsRenderer());
        this.tabsList.setItemGap(0);
        this.tabsList.setIsScrollVisible(false);
        this.tabsList.addSelectionListener(new SelectionListener(){

            public void selectionChanged(int n, int n2) {
                if (n == n2) {
                    return;
                }
                Component component = (Component)TabbedPane.this.tabsList.getModel().getItemAt(n2);
                Transition transition = TabbedPane.this.transitionLeft;
                if (n < n2) {
                    transition = TabbedPane.this.transitionRight;
                }
                if (component != null) {
                    if (transition == null || TabbedPane.this.contentPane.getComponentCount() == 0) {
                        TabbedPane.this.contentPane.removeAll();
                        TabbedPane.this.contentPane.addComponent("Center", (Component)TabbedPane.this.tabsTable.get(component));
                        if (TabbedPane.this.isInitialized()) {
                            TabbedPane.this.revalidate();
                        } else {
                            TabbedPane.this.setShouldCalcPreferredSize(true);
                        }
                    } else {
                        TabbedPane.this.contentPane.flushReplace();
                        TabbedPane.this.contentPane.replace(TabbedPane.this.contentPane.getComponentAt(0), (Component)TabbedPane.this.tabsTable.get(component), transition);
                    }
                }
            }
        });
    }

    public boolean animate() {
        boolean bl = super.animate();
        int n = this.tabsList.getScrollX();
        int n2 = this.tabsList.getScrollY();
        if (this.lastListY != n2 || this.lastListX != n) {
            bl = true;
            this.lastListX = n;
            this.lastListY = n2;
        }
        return bl;
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.getComponentForm().registerAnimatedInternal(this);
    }

    public void setTransitionLeft(Transition transition) {
        this.transitionLeft = transition;
    }

    public Transition getTransitionLeft() {
        return this.transitionLeft;
    }

    public void setTransitionRight(Transition transition) {
        this.transitionRight = transition;
    }

    public Transition getTransitionRight() {
        return this.transitionRight;
    }

    public void setFocusable(boolean bl) {
        if (this.tabsList != null) {
            this.tabsList.setFocusable(bl);
        }
        super.setFocusable(bl);
    }

    public void setFocus(boolean bl) {
        if (this.tabsList != null) {
            this.tabsList.setFocus(bl);
        }
    }

    public boolean hasFocus() {
        if (this.tabsList != null) {
            return this.tabsList.hasFocus();
        }
        return super.hasFocus();
    }

    public void addTabsListener(SelectionListener selectionListener) {
        this.tabsList.addSelectionListener(selectionListener);
    }

    public void requestFocus() {
        this.tabsList.requestFocus();
    }

    protected Dimension calcPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.tabsList.size(); ++i) {
            Component component = (Component)this.tabsList.getModel().getItemAt(i);
            Component component2 = (Component)this.tabsTable.get(component);
            if (component2.getPreferredW() > n) {
                n = component2.getPreferredW();
            }
            if (component2.getPreferredH() <= n2) continue;
            n2 = component2.getPreferredH();
        }
        if (this.tabPlacement == 0 || this.tabPlacement == 2) {
            n3 = n;
            n4 = this.tabsList.getPreferredH() + n2;
        } else {
            n3 = this.tabsList.getPreferredW() + n;
            n4 = n2;
        }
        return new Dimension(n3, n4);
    }

    public void setTabPlacement(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement == n) {
            return;
        }
        this.tabPlacement = n;
        this.removeComponent(this.tabsList);
        if (n == 0 || n == 2) {
            this.tabsList.setOrientation(1);
            if (n == 0) {
                super.addComponent("North", (Component)this.tabsList);
            } else if (n == 2) {
                super.addComponent("South", (Component)this.tabsList);
            }
        } else {
            this.tabsList.setOrientation(0);
            if (n == 1) {
                super.addComponent("West", (Component)this.tabsList);
            } else {
                super.addComponent("East", (Component)this.tabsList);
            }
        }
        this.tabsList.setShouldCalcPreferredSize(true);
        this.contentPane.setShouldCalcPreferredSize(true);
        this.revalidate();
    }

    public void addTab(String string, Image image, Component component) {
        this.insertTab(string, image, component, this.tabsList.size());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, this.tabsList.size());
    }

    public void insertTab(String string, Image image, Component component, int n) {
        this.checkIndex(n);
        if (component == null) {
            return;
        }
        Button button = new Button(string != null ? string : "", image);
        ((DefaultListModel)this.tabsList.getModel()).addItemAtIndex(button, n);
        this.tabsTable.put(button, component);
        if (this.tabsList.size() == 1) {
            this.contentPane.addComponent("Center", component);
        }
    }

    public void setTabTitle(String string, Image image, int n) {
        this.checkIndex(n);
        Button button = (Button)this.tabsList.getModel().getItemAt(n);
        button.setText(string);
        button.setIcon(image);
        ((DefaultListModel)this.tabsList.getModel()).setItem(n, button);
    }

    public void removeTabAt(int n) {
        this.checkIndex(n);
        Object object = this.tabsList.getModel().getItemAt(n);
        ((DefaultListModel)this.tabsList.getModel()).removeItem(n);
        this.tabsTable.remove(object);
    }

    public Component getTabComponentAt(int n) {
        this.checkIndex(n);
        return (Component)this.tabsTable.get((Component)this.tabsList.getModel().getItemAt(n));
    }

    private void checkIndex(int n) {
        if (n < 0 || n > this.tabsList.size()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    public int indexOfComponent(Component component) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component2 = (Component)this.tabsList.getModel().getItemAt(i);
            Component component3 = (Component)this.tabsTable.get(component2);
            if (!component.equals(component3)) continue;
            return i;
        }
        return -1;
    }

    public int getTabCount() {
        return this.tabsList.size();
    }

    public int getSelectedIndex() {
        return this.tabsList.getSelectedIndex();
    }

    public void setTabTitlePrototype(String string) {
        this.tabsList.setRenderingPrototype(string);
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "[x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight() + ", tab placement = " + this.tabPlacement + ", tab count = " + this.getTabCount() + ", selected index = " + this.getSelectedIndex() + "]";
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        UIManager.getInstance().getLookAndFeel().drawTabbedPane(graphics, this);
    }

    public void setTabsSelectedStyle(Style style) {
        this.tabsList.setSelectedStyle(style);
    }

    public void setTabsUnselectedStyle(Style style) {
        this.tabsList.setUnselectedStyle(style);
    }

    public void setContentPaneSelectedStyle(Style style) {
        this.contentPane.setSelectedStyle(style);
    }

    public void setContentPaneUnselectedStyle(Style style) {
        this.contentPane.setUnselectedStyle(style);
    }

    public void refreshTheme() {
        Painter painter = this.contentPane.getStyle().getBgPainter();
        super.refreshTheme();
        this.contentPane.getStyle().setBgPainter(painter);
        Enumeration enumeration = this.tabsTable.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            component.refreshTheme();
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public int getTabbedPaneBorderWidth() {
        return this.tPBorder;
    }

    public void setTabbedPaneBorderWidth(int n) {
        this.tPBorder = n;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        if (this.contentPane != null) {
            this.contentPane.getStyle().setPadding(n, n2, n3, n4);
        }
    }

    public void setPadding(int n, int n2) {
        if (this.contentPane != null) {
            this.contentPane.getStyle().setPadding(n, n2);
        }
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.tabsList.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.tabsList.size());
        }
        this.tabsList.setSelectedIndex(n);
    }

    class TabsRenderer
    implements ListCellRenderer {
        TabsRenderer() {
        }

        public Component getListCellRendererComponent(List list, Object object, int n, boolean bl) {
            if (object == null || !(object instanceof Button)) {
                object = new Button("" + object);
            }
            return UIManager.getInstance().getLookAndFeel().getTabbedPaneCell(TabbedPane.this, ((Button)object).getText(), ((Button)object).getIcon(), bl, list.hasFocus(), list.getStyle(), list.getSelectedStyle(), TabbedPane.this.getStyle(), list.getScrollX(), list.getScrollY(), list.getPreferredSize(), TabbedPane.this.contentPane.getBounds().getSize());
        }

        public Component getListFocusComponent(List list) {
            return null;
        }
    }
}

