/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.animations.Timeline;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.plaf.UIManager;

public final class CommonTransitions
extends Transition {
    private Motion motion;
    private Motion motion2;
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_SLIDE = 1;
    private static final int TYPE_FADE = 2;
    private static final int TYPE_FAST_SLIDE = 3;
    private static final int TYPE_TIMELINE = 4;
    private static final int TYPE_SLIDE_AND_FADE = 5;
    public static final int SLIDE_HORIZONTAL = 0;
    public static final int SLIDE_VERTICAL = 1;
    private long startTime;
    private int slideType;
    private int speed;
    private int position;
    private int transitionType;
    private Image buffer;
    private Image secondaryBuffer;
    private Image timeline;
    private static boolean defaultLinearMotion = false;
    private boolean linearMotion = defaultLinearMotion;
    private boolean motionSetManually;
    private RGBImage rgbBuffer;
    private boolean forward;
    private boolean drawDialogMenu;
    private boolean firstFinished;

    private CommonTransitions(int n) {
        this.transitionType = n;
    }

    public static CommonTransitions createEmpty() {
        CommonTransitions commonTransitions = new CommonTransitions(0);
        return commonTransitions;
    }

    public static CommonTransitions createSlideFadeTitle(boolean bl, int n) {
        CommonTransitions commonTransitions = new CommonTransitions(5);
        commonTransitions.forward = bl;
        commonTransitions.speed = n;
        return commonTransitions;
    }

    public static CommonTransitions createFastSlide(int n, boolean bl, int n2) {
        return CommonTransitions.createFastSlide(n, bl, n2, false);
    }

    public static CommonTransitions createSlide(int n, boolean bl, int n2) {
        return CommonTransitions.createSlide(n, bl, n2, false);
    }

    public static CommonTransitions createSlide(int n, boolean bl, int n2, boolean bl2) {
        CommonTransitions commonTransitions = new CommonTransitions(1);
        commonTransitions.slideType = n;
        commonTransitions.forward = bl;
        if (n == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
            commonTransitions.forward = !commonTransitions.forward;
        }
        commonTransitions.speed = n2;
        commonTransitions.position = 0;
        commonTransitions.drawDialogMenu = bl2;
        return commonTransitions;
    }

    public static CommonTransitions createFastSlide(int n, boolean bl, int n2, boolean bl2) {
        CommonTransitions commonTransitions = new CommonTransitions(3);
        commonTransitions.slideType = n;
        commonTransitions.forward = bl;
        if (n == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
            commonTransitions.forward = !commonTransitions.forward;
        }
        commonTransitions.speed = n2;
        commonTransitions.position = 0;
        commonTransitions.drawDialogMenu = bl2;
        return commonTransitions;
    }

    public static CommonTransitions createFade(int n) {
        CommonTransitions commonTransitions = new CommonTransitions(2);
        commonTransitions.speed = n;
        return commonTransitions;
    }

    public static CommonTransitions createTimeline(Image image) {
        CommonTransitions commonTransitions = new CommonTransitions(4);
        commonTransitions.timeline = image;
        commonTransitions.transitionType = 4;
        return commonTransitions;
    }

    private Container getDialogParent(Component component) {
        if (Dialog.isDialogTitleCompatibilityMode()) {
            return ((Dialog)component).getContentPane();
        }
        return ((Dialog)component).getDialogComponent();
    }

    public void initTransition() {
        this.firstFinished = false;
        if (this.transitionType == 0) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        Component component = this.getSource();
        Component component2 = this.getDestination();
        this.position = 0;
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.transitionType == 5) {
            this.motion = this.createMotion(80, 255, this.speed);
            this.motion2 = this.createMotion(0, this.getDestination().getWidth(), this.speed);
            this.motion.start();
            this.motion2.start();
            Container container = ((Form)this.getSource()).getContentPane();
            Container container2 = ((Form)this.getDestination()).getContentPane();
            this.buffer = this.createMutableImage(container.getWidth(), container.getHeight());
            this.paint(this.buffer.getGraphics(), container, -container.getAbsoluteX(), -container.getAbsoluteY(), true);
            this.secondaryBuffer = this.createMutableImage(container2.getWidth(), container2.getHeight());
            this.paint(this.secondaryBuffer.getGraphics(), container2, -container2.getAbsoluteX(), -container2.getAbsoluteY(), true);
            return;
        }
        if (this.buffer == null) {
            this.buffer = this.createMutableImage(n, n2);
        } else if (this.buffer.getWidth() != n || this.buffer.getHeight() != n2) {
            this.buffer = this.createMutableImage(n, n2);
            this.rgbBuffer = null;
            this.motion = null;
        }
        if (this.transitionType == 2) {
            this.motion = this.createMotion(0, 256, this.speed);
            this.motion.start();
            Graphics graphics = this.buffer.getGraphics();
            graphics.translate(-component.getAbsoluteX(), -component.getAbsoluteY());
            if (this.getSource().getParent() != null) {
                this.getSource().getComponentForm().paintComponent(graphics);
            }
            this.getSource().paintBackgrounds(graphics);
            graphics.setClip(0, 0, this.buffer.getWidth() + component.getAbsoluteX(), this.buffer.getHeight() + component.getAbsoluteY());
            this.paint(graphics, this.getDestination(), 0, 0);
            this.rgbBuffer = new RGBImage(this.buffer.getRGBCached(), this.buffer.getWidth(), this.buffer.getHeight());
            this.paint(graphics, this.getSource(), 0, 0);
            graphics.translate(component.getAbsoluteX(), component.getAbsoluteY());
            return;
        }
        if (this.transitionType == 4) {
            Graphics graphics = this.buffer.getGraphics();
            graphics.translate(-component.getAbsoluteX(), -component.getAbsoluteY());
            graphics.setClip(0, 0, this.buffer.getWidth() + component.getAbsoluteX(), this.buffer.getHeight() + component.getAbsoluteY());
            if (this.timeline.getWidth() != this.buffer.getWidth() || this.timeline.getHeight() != this.buffer.getHeight()) {
                this.timeline = this.timeline.scaled(this.buffer.getWidth(), this.buffer.getHeight());
            }
            if (this.timeline instanceof Timeline) {
                ((Timeline)this.timeline).setTime(0);
                ((Timeline)this.timeline).setLoop(false);
                ((Timeline)this.timeline).setAnimationDelay(0);
            }
            this.paint(graphics, this.getDestination(), 0, 0);
            graphics.translate(component.getAbsoluteX(), component.getAbsoluteY());
            return;
        }
        if (this.transitionType == 4) {
            Graphics graphics = this.buffer.getGraphics();
            graphics.translate(-component.getAbsoluteX(), -component.getAbsoluteY());
            graphics.setClip(0, 0, this.buffer.getWidth() + component.getAbsoluteX(), this.buffer.getHeight() + component.getAbsoluteY());
            if (this.timeline.getWidth() != this.buffer.getWidth() || this.timeline.getHeight() != this.buffer.getHeight()) {
                this.timeline = this.timeline.scaled(this.buffer.getWidth(), this.buffer.getHeight());
            }
            if (this.timeline instanceof Timeline) {
                ((Timeline)this.timeline).setTime(0);
                ((Timeline)this.timeline).setLoop(false);
                ((Timeline)this.timeline).setAnimationDelay(0);
            }
            this.paint(graphics, this.getDestination(), 0, 0);
            graphics.translate(component.getAbsoluteX(), component.getAbsoluteY());
            return;
        }
        if (this.transitionType == 1 || this.transitionType == 3) {
            Object object;
            int n3;
            int n4 = 0;
            if (this.slideType == 0) {
                n3 = n;
                if (component2 instanceof Dialog) {
                    n4 = n - this.getDialogParent(component2).getWidth();
                    n4 = this.forward ? (n4 -= this.getDialogParent(component2).getStyle().getMargin(component2.isRTL(), 1)) : (n4 -= this.getDialogParent(component2).getStyle().getMargin(component2.isRTL(), 3));
                } else if (component instanceof Dialog) {
                    n3 = this.getDialogParent(component).getWidth();
                    n3 = this.forward ? (n3 += this.getDialogParent(component).getStyle().getMargin(component.isRTL(), 1)) : (n3 += this.getDialogParent(component).getStyle().getMargin(component.isRTL(), 3));
                }
            } else {
                n3 = n2;
                if (component2 instanceof Dialog) {
                    n4 = n2 - this.getDialogParent(component2).getHeight() - this.getDialogTitleHeight((Dialog)component2);
                    if (this.forward) {
                        n4 -= this.getDialogParent(component2).getStyle().getMargin(false, 2);
                    } else {
                        n4 -= this.getDialogParent(component2).getStyle().getMargin(false, 0);
                        n4 -= ((Dialog)component2).getTitleStyle().getMargin(false, 0);
                        if (!this.drawDialogMenu && ((Dialog)component2).getCommandCount() > 0 && (object = ((Dialog)component2).getSoftButton(0).getParent()) != null) {
                            n4 -= ((Component)object).getHeight();
                        }
                    }
                } else if (component instanceof Dialog) {
                    n3 = this.getDialogParent(component).getHeight() + this.getDialogTitleHeight((Dialog)component);
                    if (this.forward) {
                        n3 += this.getDialogParent(component).getStyle().getMargin(false, 2);
                    } else {
                        n3 += this.getDialogParent(component).getStyle().getMargin(false, 0);
                        n3 += ((Dialog)component).getTitleStyle().getMargin(false, 0);
                        if (((Dialog)component).getCommandCount() > 0 && (object = ((Dialog)component).getSoftButton(0).getParent()) != null) {
                            n3 += ((Component)object).getHeight();
                        }
                    }
                }
            }
            this.motion = this.createMotion(n4, n3, this.speed);
            object = this.buffer.getGraphics();
            if (this.getSource() instanceof Dialog) {
                this.paint((Graphics)object, this.getDestination(), 0, 0);
                if (this.transitionType == 3 && !(component2 instanceof Dialog)) {
                    Dialog dialog = (Dialog)component;
                    this.secondaryBuffer = this.createMutableImage(this.getDialogParent(dialog).getWidth(), this.getDialogParent(dialog).getHeight() + this.getDialogTitleHeight(dialog));
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), dialog);
                }
            } else if (this.getDestination() instanceof Dialog) {
                this.paint((Graphics)object, this.getSource(), 0, 0);
                if (this.transitionType == 3 && !(component instanceof Dialog)) {
                    Dialog dialog = (Dialog)component2;
                    this.secondaryBuffer = this.createMutableImage(this.getDialogParent(dialog).getWidth(), dialog.getContentPane().getParent().getHeight() + this.getDialogTitleHeight(dialog));
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), dialog);
                }
            } else {
                this.paint((Graphics)object, component, -component.getAbsoluteX(), -component.getAbsoluteY());
                if (this.transitionType == 3) {
                    this.secondaryBuffer = this.createMutableImage(component2.getWidth(), component2.getHeight());
                    this.paint(this.secondaryBuffer.getGraphics(), component2, -component2.getAbsoluteX(), -component2.getAbsoluteY());
                }
            }
            this.motion.start();
        }
    }

    private Image createMutableImage(int n, int n2) {
        Display display = Display.getInstance();
        return Image.createImage(Math.min(display.getDisplayWidth(), n), Math.min(display.getDisplayHeight(), n2));
    }

    protected Motion createMotion(int n, int n2, int n3) {
        if (this.motionSetManually) {
            return this.motion;
        }
        if (this.linearMotion) {
            return Motion.createLinearMotion(n, n2, n3);
        }
        return Motion.createSplineMotion(n, n2, n3);
    }

    public boolean animate() {
        if (this.timeline != null) {
            boolean bl = this.timeline.animate();
            return bl;
        }
        if (this.motion == null) {
            return false;
        }
        this.position = this.motion.getValue();
        if (this.firstFinished) {
            return false;
        }
        boolean bl = this.motion.isFinished();
        if (bl && !this.firstFinished) {
            this.firstFinished = true;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        try {
            switch (this.transitionType) {
                case 1: {
                    if (this.slideType == 0) {
                        this.paintSlideAtPosition(graphics, this.position, 0);
                    } else {
                        this.paintSlideAtPosition(graphics, 0, this.position);
                    }
                    return;
                }
                case 3: {
                    if (this.slideType == 0) {
                        this.paintFastSlideAtPosition(graphics, this.position, 0);
                    } else {
                        this.paintFastSlideAtPosition(graphics, 0, this.position);
                    }
                    return;
                }
                case 2: {
                    this.paintAlpha(graphics);
                    return;
                }
                case 4: {
                    Object object = this.timeline.createMask();
                    this.paint(graphics, this.getSource(), 0, 0);
                    graphics.drawImage(this.buffer.applyMask(object), 0, 0);
                    return;
                }
                case 5: {
                    Form form = (Form)this.getSource();
                    Form form2 = (Form)this.getDestination();
                    int n = this.position;
                    int n2 = this.motion2.getValue();
                    int n3 = graphics.getClipX();
                    int n4 = graphics.getClipY();
                    int n5 = graphics.getClipWidth();
                    int n6 = graphics.getClipHeight();
                    graphics.translate(0, form.getTitleArea().getHeight());
                    this.paintFastSlideAtPosition(graphics, n2, 0);
                    graphics.translate(0, -form.getTitleArea().getHeight());
                    graphics.setClip(n3, n4, n5, n6);
                    form.getTitleArea().paintBackground(graphics);
                    this.paintShiftFadeHierarchy(form.getTitleArea(), 255 - n, graphics, false);
                    this.paintShiftFadeHierarchy(form2.getTitleArea(), n, graphics, true);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("An exception occurred during transition paint this might be valid in case of a resize in the middle of a transition");
        }
    }

    private void paintShiftFadeHierarchy(Container container, int n, Graphics graphics, boolean bl) {
        int n2 = container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponentAt(i);
            if (component instanceof Container) {
                this.paintShiftFadeHierarchy((Container)component, n, graphics, bl);
                continue;
            }
            graphics.setAlpha(n);
            Motion motion = this.getComponentShiftMotion(component, bl);
            int n3 = motion.getValue();
            graphics.translate(n3, 0);
            component.paintComponent(graphics, false);
            graphics.translate(-n3, 0);
            graphics.setAlpha(255);
        }
    }

    private Motion getComponentShiftMotion(Component component, boolean bl) {
        Motion motion = (Motion)component.getClientProperty("$shm");
        if (motion == null) {
            int n = this.getDestination().getWidth() - component.getWidth() - component.getAbsoluteX();
            if (this.getDestination().getWidth() - component.getWidth() < 10) {
                n = component.getWidth() / 2 - component.getPreferredW() / 2;
            }
            motion = bl ? (this.forward ? Motion.createSplineMotion(-n, 0, this.speed) : Motion.createSplineMotion(n, 0, this.speed)) : (this.forward ? Motion.createSplineMotion(0, n, this.speed) : Motion.createSplineMotion(0, -n, this.speed));
            motion.start();
            component.putClientProperty("$shm", motion);
        }
        return motion;
    }

    private void paintAlpha(Graphics graphics) {
        if (this.rgbBuffer != null || this.secondaryBuffer != null) {
            Component component = this.getSource();
            int n = component.getWidth();
            int n2 = component.getHeight();
            int n3 = this.position;
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            if (this.secondaryBuffer != null) {
                Component component2 = this.getDestination();
                int n4 = component2.getAbsoluteX();
                int n5 = component2.getAbsoluteY();
                graphics.drawImage(this.buffer, n4, n5);
                graphics.setAlpha(n3);
                graphics.drawImage(this.secondaryBuffer, n4, n5);
                graphics.setAlpha(255);
            } else {
                int n6 = n3 << 24;
                int n7 = n * n2;
                int[] nArray = this.rgbBuffer.getRGB();
                for (int i = 0; i < n7; ++i) {
                    nArray[i] = nArray[i] & 0xFFFFFF | n6;
                }
                Component component3 = this.getDestination();
                int n8 = component3.getAbsoluteX();
                int n9 = component3.getAbsoluteY();
                graphics.drawImage(this.buffer, n8, n9);
                graphics.drawImage(this.rgbBuffer, n8, n9);
            }
        }
    }

    private void removeConstant(Container container) {
        int n = container.getComponentCount();
        container.putClientProperty("$shm", null);
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponentAt(i);
            component.putClientProperty("$shm", null);
            if (!(component instanceof Container)) continue;
            this.removeConstant((Container)component);
        }
    }

    public void cleanup() {
        if (this.transitionType == 5) {
            this.removeConstant((Container)this.getSource());
            this.removeConstant((Container)this.getDestination());
        }
        super.cleanup();
        this.buffer = null;
        this.rgbBuffer = null;
        this.secondaryBuffer = null;
        this.timeline = null;
    }

    private void paintSlideAtPosition(Graphics graphics, int n, int n2) {
        Component component = this.getSource();
        if (component == null) {
            return;
        }
        Component component2 = this.getDestination();
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        if (this.slideType == 0) {
            n4 = 0;
        } else {
            n3 = 0;
        }
        if (this.forward) {
            n3 = -n3;
            n4 = -n4;
        } else {
            n = -n;
            n2 = -n2;
        }
        graphics.setClip(component.getAbsoluteX() + component.getScrollX(), component.getAbsoluteY() + component.getScrollY(), component.getWidth(), component.getHeight());
        if (component instanceof Dialog) {
            graphics.drawImage(this.buffer, 0, 0);
            this.paint(graphics, component, -n, -n2);
            return;
        }
        if (component2 instanceof Dialog) {
            graphics.drawImage(this.buffer, 0, 0);
            this.paint(graphics, component2, -n - n3, -n2 - n4);
            return;
        }
        if (component.getParent() != null) {
            component.paintBackgrounds(graphics);
            this.paint(graphics, component, n, n2);
        } else {
            graphics.drawImage(this.buffer, n, n2);
        }
        this.paint(graphics, component2, n + n3, n2 + n4);
    }

    private void paintFastSlideAtPosition(Graphics graphics, int n, int n2) {
        if (this.secondaryBuffer != null) {
            Component component = this.getSource();
            if (component == null) {
                return;
            }
            Component component2 = this.getDestination();
            int n3 = this.buffer.getWidth();
            int n4 = this.buffer.getHeight();
            if (this.slideType == 0) {
                n4 = 0;
            } else {
                n3 = 0;
            }
            if (this.forward) {
                n3 = -n3;
                n4 = -n4;
            } else {
                n = -n;
                n2 = -n2;
            }
            graphics.setClip(component.getAbsoluteX() + component.getScrollX(), component.getAbsoluteY() + component.getScrollY(), component.getWidth(), component.getHeight());
            if (component instanceof Dialog) {
                graphics.drawImage(this.buffer, 0, 0);
                graphics.drawImage(this.secondaryBuffer, -(n -= this.getDialogParent(component).getX()), -(n2 -= this.getDialogParent(component).getY()));
                return;
            }
            if (component2 instanceof Dialog) {
                graphics.drawImage(this.buffer, 0, 0);
                graphics.drawImage(this.secondaryBuffer, -(n -= this.getDialogParent(component2).getX()) - n3, -(n2 -= this.getDialogParent(component2).getY()) - n4);
                return;
            }
            graphics.drawImage(this.buffer, n, n2);
            graphics.drawImage(this.secondaryBuffer, n + n3, n2 + n4);
        } else {
            this.paintSlideAtPosition(graphics, n, n2);
        }
    }

    private int getDialogTitleHeight(Dialog dialog) {
        if (Dialog.isDialogTitleCompatibilityMode()) {
            return dialog.getTitleComponent().getHeight();
        }
        return 0;
    }

    private void drawDialogCmp(Graphics graphics, Dialog dialog) {
        Container container;
        Painter painter = dialog.getStyle().getBgPainter();
        dialog.getStyle().setBgPainter(null);
        if (Dialog.isDialogTitleCompatibilityMode()) {
            graphics.translate(-dialog.getTitleComponent().getX(), -dialog.getTitleComponent().getY());
            dialog.getTitleComponent().paintComponent(graphics, false);
            graphics.translate(dialog.getTitleComponent().getX(), dialog.getTitleComponent().getY());
        }
        graphics.setClip(0, 0, dialog.getWidth(), dialog.getHeight());
        graphics.translate(-this.getDialogParent(dialog).getX(), -this.getDialogParent(dialog).getY() + this.getDialogTitleHeight(dialog));
        this.getDialogParent(dialog).paintComponent(graphics, false);
        if (this.drawDialogMenu && dialog.getCommandCount() > 0 && (container = dialog.getSoftButton(0).getParent()) != null) {
            graphics.setClip(0, 0, dialog.getWidth(), dialog.getHeight());
            container.paintComponent(graphics, false);
        }
        dialog.getStyle().setBgPainter(painter);
    }

    private void paint(Graphics graphics, Component component, int n, int n2) {
        this.paint(graphics, component, n, n2, false);
    }

    private void paint(Graphics graphics, Component component, int n, int n2, boolean bl) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        if (component instanceof Dialog) {
            if (!(this.transitionType == 2 || this.getSource() instanceof Dialog && this.getDestination() instanceof Dialog && component == this.getDestination())) {
                Container container;
                Painter painter = component.getStyle().getBgPainter();
                component.getStyle().setBgPainter(null);
                graphics.translate(n, n2);
                Dialog dialog = (Dialog)component;
                if (Dialog.isDialogTitleCompatibilityMode()) {
                    graphics.setClip(0, 0, component.getWidth(), component.getHeight());
                    dialog.getTitleComponent().paintComponent(graphics, false);
                }
                graphics.setClip(0, 0, component.getWidth(), component.getHeight());
                this.getDialogParent(dialog).paintComponent(graphics, false);
                graphics.translate(-n, -n2);
                if (this.drawDialogMenu && dialog.getCommandCount() > 0 && (container = dialog.getSoftButton(0).getParent()) != null) {
                    graphics.setClip(0, 0, component.getWidth(), component.getHeight());
                    container.paintComponent(graphics, false);
                }
                graphics.setClip(n3, n4, n5, n6);
                component.getStyle().setBgPainter(painter);
                return;
            }
            component.paintComponent(graphics, bl);
            return;
        }
        graphics.translate(n, n2);
        component.paintComponent(graphics, bl);
        graphics.translate(-n, -n2);
        graphics.setClip(n3, n4, n5, n6);
    }

    public Motion getMotion() {
        return this.motion;
    }

    public void setMotion(Motion motion) {
        this.motionSetManually = true;
        this.motion = motion;
    }

    public Transition copy(boolean bl) {
        CommonTransitions commonTransitions = null;
        switch (this.transitionType) {
            case 4: {
                commonTransitions = CommonTransitions.createTimeline(this.timeline);
                break;
            }
            case 2: {
                commonTransitions = CommonTransitions.createFade(this.speed);
                break;
            }
            case 1: {
                boolean bl2 = this.forward;
                if (this.slideType == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl3 = bl2 = !bl2;
                }
                if (bl) {
                    commonTransitions = CommonTransitions.createSlide(this.slideType, !bl2, this.speed, this.drawDialogMenu);
                    break;
                }
                commonTransitions = CommonTransitions.createSlide(this.slideType, bl2, this.speed, this.drawDialogMenu);
                break;
            }
            case 5: {
                boolean bl4 = this.forward;
                if (UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl5 = bl4 = !bl4;
                }
                if (bl) {
                    commonTransitions = CommonTransitions.createSlideFadeTitle(!bl4, this.speed);
                    break;
                }
                commonTransitions = CommonTransitions.createSlideFadeTitle(bl4, this.speed);
                break;
            }
            case 3: {
                boolean bl6 = this.forward;
                if (this.slideType == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl7 = bl6 = !bl6;
                }
                if (bl) {
                    commonTransitions = CommonTransitions.createFastSlide(this.slideType, !bl6, this.speed, this.drawDialogMenu);
                    break;
                }
                commonTransitions = CommonTransitions.createFastSlide(this.slideType, bl6, this.speed, this.drawDialogMenu);
                break;
            }
            case 0: {
                commonTransitions = CommonTransitions.createEmpty();
            }
        }
        commonTransitions.linearMotion = this.linearMotion;
        return commonTransitions;
    }

    public boolean isLinearMotion() {
        return this.linearMotion;
    }

    public void setLinearMotion(boolean bl) {
        this.linearMotion = bl;
    }

    public static boolean isDefaultLinearMotion() {
        return defaultLinearMotion;
    }

    public static void setDefaultLinearMotion(boolean bl) {
        defaultLinearMotion = bl;
    }
}

