/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.painter;

import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Painter;
import com.sun.lwuit.geom.Rectangle;
import java.util.Vector;

public class PainterChain
implements Painter {
    private Painter[] chain;

    public PainterChain(Painter[] painterArray) {
        this.chain = painterArray;
    }

    public PainterChain(Painter painter) {
        this.chain = new Painter[]{painter};
    }

    public PainterChain addPainter(Painter painter) {
        if (this.chain.length != 0) {
            Painter[] painterArray = new Painter[this.chain.length + 1];
            System.arraycopy(this.chain, 0, painterArray, 0, this.chain.length);
            painterArray[this.chain.length] = painter;
            return new PainterChain(painterArray);
        }
        return new PainterChain(new Painter[]{painter});
    }

    public PainterChain prependPainter(Painter painter) {
        Painter[] painterArray = new Painter[this.chain.length + 1];
        System.arraycopy(this.chain, 1, painterArray, 0, this.chain.length);
        painterArray[0] = painter;
        return new PainterChain(painterArray);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].paint(graphics, rectangle);
        }
    }

    public static void installGlassPane(Form form, Painter painter) {
        Painter painter2 = form.getGlassPane();
        if (painter2 == null) {
            form.setGlassPane(painter);
            return;
        }
        if (painter2 instanceof PainterChain) {
            form.setGlassPane(((PainterChain)painter2).addPainter(painter));
        } else {
            PainterChain painterChain = new PainterChain(new Painter[]{painter2, painter});
            form.setGlassPane(painterChain);
        }
    }

    public Painter[] getChain() {
        return this.chain;
    }

    public static void removeGlassPane(Form form, Painter painter) {
        Painter painter2 = form.getGlassPane();
        if (painter2 == null) {
            return;
        }
        if (painter2 == painter) {
            form.setGlassPane(null);
            return;
        }
        if (painter2 instanceof PainterChain) {
            PainterChain painterChain = (PainterChain)painter2;
            if (painterChain.chain.length == 1) {
                form.setGlassPane(null);
            } else {
                Vector<Painter> vector = new Vector<Painter>();
                for (int i = 0; i < painterChain.chain.length; ++i) {
                    if (painterChain.chain[i] == painter) continue;
                    vector.addElement(painterChain.chain[i]);
                }
                if (vector.size() == 0) {
                    form.setGlassPane(null);
                    return;
                }
                Painter[] painterArray = new Painter[vector.size()];
                for (int i = 0; i < painterArray.length; ++i) {
                    painterArray[i] = (Painter)vector.elementAt(i);
                }
                painterChain.chain = painterArray;
                form.repaint();
            }
        }
    }
}

