/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public class DefaultLookAndFeel
extends LookAndFeel
implements FocusListener {
    private Image[] chkBoxImages = null;
    private Image comboImage = null;
    private Image[] rButtonImages = null;
    private boolean tickWhenFocused = true;

    public void bind(Component component) {
        if (this.tickWhenFocused && component instanceof Label) {
            ((Label)component).addFocusListener(this);
        }
    }

    public void setTickWhenFocused(boolean bl) {
        this.tickWhenFocused = bl;
    }

    public boolean isTickWhenFocused() {
        return this.tickWhenFocused;
    }

    public void setCheckBoxImages(Image image, Image image2) {
        this.setCheckBoxImages(image, image2, image, image2);
    }

    public void setCheckBoxImages(Image image, Image image2, Image image3, Image image4) {
        this.chkBoxImages = image == null || image2 == null ? null : new Image[]{image2, image, image4, image3};
    }

    public void setComboBoxImage(Image image) {
        this.comboImage = image;
    }

    public void setRadioButtonImages(Image image, Image image2) {
        this.rButtonImages = image == null || image2 == null ? null : new Image[]{image2, image};
    }

    public void setRadioButtonImages(Image image, Image image2, Image image3, Image image4) {
        this.rButtonImages = image == null || image2 == null ? null : new Image[]{image2, image, image4, image3};
    }

    public Image[] getRadioButtonImages() {
        return this.rButtonImages;
    }

    public Image[] getCheckBoxImages() {
        return this.chkBoxImages;
    }

    public void drawButton(Graphics graphics, Button button) {
        this.drawComponent(graphics, button, button.getIconFromState(), null, 0);
    }

    public void drawCheckBox(Graphics graphics, Button button) {
        if (this.chkBoxImages != null) {
            Image image = button.isEnabled() ? this.chkBoxImages[button.isSelected() ? 1 : 0] : this.chkBoxImages[button.isSelected() ? 3 : 2];
            this.drawComponent(graphics, button, button.getIconFromState(), image, 0);
        } else {
            Style style = button.getStyle();
            int n = button.getStyle().getFont().getHeight();
            this.drawComponent(graphics, button, button.getIconFromState(), null, n);
            graphics.setColor(style.getFgColor());
            int n2 = style.getBgColor();
            int n3 = n;
            int n4 = DefaultLookAndFeel.scaleCoordinate(12.0f, 16.0f, n3);
            int n5 = button.getX();
            n5 = button.isRTL() ? n5 + button.getWidth() - style.getPadding(button.isRTL(), 1) - n4 : (n5 += style.getPadding(button.isRTL(), 1));
            int n6 = button.getY() + style.getPadding(false, 0) + (button.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2)) / 2 - n / 2;
            graphics.translate(n5, n6);
            int n7 = DefaultLookAndFeel.scaleCoordinate(1.04f, 16.0f, n3);
            int n8 = DefaultLookAndFeel.scaleCoordinate(4.0f, 16.0f, n);
            int n9 = DefaultLookAndFeel.scaleCoordinate(12.0f, 16.0f, n);
            int n10 = this.findDestColor(n2);
            graphics.fillLinearGradient(n2, n10, n7 + 1, n8 + 1, n4 - 2, n9 - 1, false);
            graphics.drawRoundRect(n7, n8, n4, n9, 5, 5);
            if (button.isSelected()) {
                int n11 = graphics.getColor();
                graphics.setColor(0x111111);
                graphics.translate(0, 1);
                DefaultLookAndFeel.fillCheckbox(graphics, n3, n);
                graphics.setColor(n11);
                graphics.translate(0, -1);
                DefaultLookAndFeel.fillCheckbox(graphics, n3, n);
            }
            graphics.translate(-n5, -n6);
        }
    }

    private static void fillCheckbox(Graphics graphics, int n, int n2) {
        int n3 = DefaultLookAndFeel.scaleCoordinate(2.0450494f, 16.0f, n);
        int n4 = DefaultLookAndFeel.scaleCoordinate(9.422772f, 16.0f, n2);
        int n5 = DefaultLookAndFeel.scaleCoordinate(5.8675723f, 16.0f, n);
        int n6 = DefaultLookAndFeel.scaleCoordinate(13.921746f, 16.0f, n2);
        int n7 = DefaultLookAndFeel.scaleCoordinate(5.8675723f, 16.0f, n);
        int n8 = DefaultLookAndFeel.scaleCoordinate(11.0f, 16.0f, n2);
        graphics.fillTriangle(n3, n4, n5, n6, n7, n8);
        n3 = DefaultLookAndFeel.scaleCoordinate(14.38995f, 16.0f, n);
        n4 = DefaultLookAndFeel.scaleCoordinate(0.0f, 16.0f, n2);
        graphics.fillTriangle(n3, n4, n5, n6, n7, n8);
    }

    private static int round(float f) {
        int n = (int)f;
        if (f - (float)n > 0.5f) {
            return n + 1;
        }
        return n;
    }

    private static int scaleCoordinate(float f, float f2, int n) {
        return DefaultLookAndFeel.round(f / f2 * (float)n);
    }

    public void drawLabel(Graphics graphics, Label label) {
        this.drawComponent(graphics, label, label.getIcon(), null, 0);
    }

    public void drawRadioButton(Graphics graphics, Button button) {
        if (this.rButtonImages != null) {
            Image image = button.isEnabled() ? this.rButtonImages[button.isSelected() ? 1 : 0] : this.rButtonImages[button.isSelected() ? 4 : 3];
            this.drawComponent(graphics, button, button.getIconFromState(), image, 0);
        } else {
            Style style = button.getStyle();
            int n = button.getStyle().getFont().getHeight();
            this.drawComponent(graphics, button, button.getIconFromState(), null, n + button.getGap());
            graphics.setColor(style.getFgColor());
            int n2 = button.getX();
            n2 = button.isRTL() ? n2 + button.getWidth() - style.getPadding(button.isRTL(), 1) - n : (n2 += style.getPadding(button.isRTL(), 1));
            int n3 = button.getY();
            graphics.drawArc(n2, n3 += Math.max(0, button.getHeight() / 2 - n / 2), n, n, 0, 360);
            if (button.isSelected()) {
                int n4 = graphics.getColor();
                int n5 = this.findDestColor(n4);
                graphics.fillRadialGradient(n4, n5, n2 + 3, n3 + 3, n - 5, n - 5);
            }
        }
    }

    public void drawComboBox(Graphics graphics, List list) {
        int n = 2;
        Style style = list.getStyle();
        int n2 = style.getPadding(list.isRTL(), 1);
        int n3 = style.getPadding(list.isRTL(), 3);
        this.setFG(graphics, list);
        ListModel listModel = list.getModel();
        ListCellRenderer listCellRenderer = list.getRenderer();
        Object object = listModel.getItemAt(listModel.getSelectedIndex());
        int n4 = this.comboImage != null ? this.comboImage.getWidth() : style.getFont().getHeight();
        int n5 = list.getX() + style.getPadding(false, 0);
        if (list.isRTL()) {
            n5 += n4;
        }
        if (listModel.getSize() > 0) {
            Component component = listCellRenderer.getListCellRendererComponent(list, object, listModel.getSelectedIndex(), list.hasFocus());
            component.setX(n5);
            component.setY(list.getY() + style.getPadding(false, 0));
            component.setWidth(list.getWidth() - n4 - 2 * n3 - n2);
            component.setHeight(list.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2));
            component.paint(graphics);
        }
        graphics.setColor(style.getBgColor());
        int n6 = list.getY();
        int n7 = list.getHeight();
        int n8 = n4 + n;
        int n9 = list.getX();
        n9 = list.isRTL() ? (n9 += n2) : (n9 += list.getWidth() - n4 - n3);
        if (this.comboImage != null) {
            graphics.drawImage(this.comboImage, n9, n6 + n7 / 2 - this.comboImage.getHeight() / 2);
        } else {
            int n10 = graphics.getColor();
            int n11 = this.findDestColor(n10);
            graphics.fillLinearGradient(graphics.getColor(), n11, n9, n6, n8, n7, false);
            graphics.setColor(n10);
            graphics.drawRect(n9, n6, n8, n7 - 1);
            graphics.translate(n9 + 1, n6 + 1);
            graphics.setColor(0x111111);
            int n12 = DefaultLookAndFeel.scaleCoordinate(2.5652082f, 16.0f, --n8);
            int n13 = DefaultLookAndFeel.scaleCoordinate(4.4753666f, 16.0f, --n7);
            int n14 = DefaultLookAndFeel.scaleCoordinate(8.287269f, 16.0f, n8);
            int n15 = DefaultLookAndFeel.scaleCoordinate(10.0f, 16.0f, n7);
            int n16 = DefaultLookAndFeel.scaleCoordinate(13.516078f, 16.0f, n8);
            int n17 = n13;
            graphics.fillTriangle(n12, n13, n14, n15, n16, n17);
            graphics.translate(-1, -1);
            graphics.setColor(style.getFgColor());
            graphics.fillTriangle(n12, n13, n14, n15, n16, n17);
            graphics.translate(-n9, -n6);
        }
    }

    private int findDestColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        if (n2 > 128 && n3 > 128 && n4 > 128) {
            n2 = Math.max(n2 >> 1, 0);
            n3 = Math.max(n3 >> 1, 0);
            n4 = Math.max(n4 >> 1, 0);
        } else {
            if (n == 0) {
                return 0x222222;
            }
            n2 = Math.min(n2 << 1, 255);
            n3 = Math.min(n3 << 1, 255);
            n4 = Math.min(n4 << 1, 255);
        }
        return n2 << 16 & 0xFF0000 | n3 << 8 & 0xFF00 | n4 & 0xFF;
    }

    public void drawList(Graphics graphics, List list) {
    }

    public void drawTextArea(Graphics graphics, TextArea textArea) {
        this.setFG(graphics, textArea);
        int n = textArea.getLines();
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        Font font = textArea.getStyle().getFont();
        int n6 = font.getHeight();
        int n7 = this.reverseAlignForBidi(textArea);
        int n8 = textArea.getStyle().getPadding(textArea.isRTL(), 1);
        int n9 = textArea.getStyle().getPadding(textArea.isRTL(), 3);
        int n10 = textArea.getStyle().getPadding(false, 0);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n11;
            int n12 = textArea.getX() + n8;
            if (Rectangle.intersects(n12, n11 = textArea.getY() + n10 + (textArea.getRowsGap() + n6) * i, textArea.getWidth(), n6, n2, n3, n4, n5)) {
                String string = textArea.getTextAt(i);
                String string2 = "";
                if ((textArea.getConstraint() & 0x10000) != 0) {
                    for (int j = 0; j < string.length(); ++j) {
                        string2 = string2 + "*";
                    }
                } else {
                    string2 = string;
                }
                switch (n7) {
                    case 3: {
                        n12 = textArea.getX() + textArea.getWidth() - n9 - font.stringWidth(string2);
                        break;
                    }
                    case 4: {
                        n12 += (textArea.getWidth() - n8 - n9 - font.stringWidth(string2)) / 2;
                    }
                }
                graphics.drawString(string2, n12, n11, textArea.getStyle().getTextDecoration());
                bl = true;
                continue;
            }
            if (bl) break;
        }
    }

    public Dimension getButtonPreferredSize(Button button) {
        return this.getPreferredSize(button, new Image[]{button.getIcon(), button.getRolloverIcon(), button.getPressedIcon()}, null);
    }

    public Dimension getCheckBoxPreferredSize(Button button) {
        if (button.isToggle()) {
            return this.getButtonPreferredSize(button);
        }
        if (this.chkBoxImages != null) {
            return this.getPreferredSize(button, new Image[]{button.getIcon(), button.getRolloverIcon(), button.getPressedIcon()}, this.chkBoxImages[0]);
        }
        Dimension dimension = this.getPreferredSize(button, new Image[]{button.getIcon(), button.getRolloverIcon(), button.getPressedIcon()}, null);
        int n = button.getStyle().getFont().getHeight();
        dimension.setHeight(Math.max(n, dimension.getHeight()));
        dimension.setWidth(dimension.getWidth() + n + button.getGap());
        return dimension;
    }

    public Dimension getLabelPreferredSize(Label label) {
        return this.getPreferredSize(label, new Image[]{label.getIcon()}, null);
    }

    private Dimension getPreferredSize(Label label, Image[] imageArray, Image image) {
        Object object;
        int n = 0;
        int n2 = 0;
        Style style = label.getStyle();
        int n3 = label.getGap();
        for (int i = 0; i < imageArray.length; ++i) {
            object = imageArray[i];
            if (object == null) continue;
            n = Math.max(n, ((Image)object).getWidth());
            n2 = Math.max(n2, ((Image)object).getHeight());
        }
        String string = label.getText();
        object = style.getFont();
        if (object == null) {
            System.out.println("Missing font for " + label);
            object = Font.getDefaultFont();
        }
        if (string != null && string.length() > 0) {
            switch (label.getTextPosition()) {
                case 1: 
                case 3: {
                    n += ((Font)object).stringWidth(string);
                    n2 = Math.max(n2, ((Font)object).getHeight());
                    break;
                }
                case 0: 
                case 2: {
                    n = Math.max(n, ((Font)object).stringWidth(string));
                    n2 += ((Font)object).getHeight();
                }
            }
        }
        if (image != null) {
            n += image.getWidth() + n3;
            n2 = Math.max(n2, image.getHeight());
        }
        if (imageArray[0] != null && string != null && string.length() > 0) {
            switch (label.getTextPosition()) {
                case 1: 
                case 3: {
                    n += n3;
                    break;
                }
                case 0: 
                case 2: {
                    n2 += n3;
                }
            }
        }
        if (n2 != 0) {
            n2 += style.getPadding(false, 0) + style.getPadding(false, 2);
        }
        if (n != 0) {
            n += style.getPadding(label.isRTL(), 3) + style.getPadding(label.isRTL(), 1);
        }
        if (style.getBorder() != null && label.isVisible()) {
            n = Math.max(style.getBorder().getMinimumWidth(), n);
            n2 = Math.max(style.getBorder().getMinimumHeight(), n2);
        }
        return new Dimension(n, n2);
    }

    public Dimension getListPreferredSize(List list) {
        Dimension dimension = this.getListPreferredSizeImpl(list);
        Style style = list.getStyle();
        if (style.getBorder() != null) {
            dimension.setWidth(Math.max(style.getBorder().getMinimumWidth(), dimension.getWidth()));
            dimension.setHeight(Math.max(style.getBorder().getMinimumHeight(), dimension.getHeight()));
        }
        return dimension;
    }

    private Dimension getListPreferredSizeImpl(List list) {
        int n;
        int n2;
        int n3;
        Style style;
        Object object;
        Object object2;
        int n4 = 0;
        int n5 = 0;
        ListModel listModel = list.getModel();
        int n6 = Math.max(listModel.getSize(), list.getMinElementHeight());
        Object object3 = list.getRenderingPrototype();
        Style style2 = null;
        if (object3 != null) {
            object2 = list.getRenderer();
            object = object2.getListCellRendererComponent(list, object3, 0, false);
            n5 = ((Component)object).getPreferredH();
            n4 = ((Component)object).getPreferredW();
            style2 = ((Component)object).getStyle();
            object = object2.getListCellRendererComponent(list, object3, 0, true);
            style = ((Component)object).getStyle();
            n3 = Math.max(n5, ((Component)object).getPreferredH());
            n2 = Math.max(n4, ((Component)object).getPreferredW());
        } else {
            Object object4;
            int n7 = Math.min(list.getListSizeCalculationSampleCount(), n6);
            object = list.getRenderingPrototype();
            if (listModel.getSize() > 0 && object == null) {
                object = listModel.getItemAt(0);
            }
            ListCellRenderer listCellRenderer = list.getRenderer();
            for (n = 0; n < n7; ++n) {
                object4 = n < listModel.getSize() ? listModel.getItemAt(n) : object;
                Component component = listCellRenderer.getListCellRendererComponent(list, object4, n, false);
                if (component instanceof Container) {
                    component.setShouldCalcPreferredSize(true);
                }
                style2 = component.getStyle();
                n5 = Math.max(n5, component.getPreferredH());
                n4 = Math.max(n4, component.getPreferredW());
            }
            style = style2;
            n3 = n5;
            n2 = n4;
            if (listModel.getSize() > 0) {
                Object object5 = listModel.getItemAt(0);
                object4 = listCellRenderer.getListCellRendererComponent(list, object5, 0, true);
                if (object4 instanceof Container) {
                    ((Component)object4).setShouldCalcPreferredSize(true);
                }
                n3 = Math.max(n5, ((Component)object4).getPreferredH());
                n2 = Math.max(n4, ((Component)object4).getPreferredW());
                style = ((Component)object4).getStyle();
            }
        }
        if (style2 != null) {
            n2 += style.getMargin(false, 1) + style.getMargin(false, 3);
            n3 += style.getMargin(false, 0) + style.getMargin(false, 2);
            n4 += style2.getMargin(false, 1) + style2.getMargin(false, 3);
            n5 += style2.getMargin(false, 0) + style2.getMargin(false, 2);
        }
        object2 = list.getStyle();
        int n8 = ((Style)object2).getPadding(false, 0) + ((Style)object2).getPadding(false, 2);
        int n9 = ((Style)object2).getPadding(false, 3) + ((Style)object2).getPadding(false, 1);
        if (n6 == 0) {
            return new Dimension(n9, n8);
        }
        if (list.getOrientation() > 1) {
            n = list.getStyle().getFont().getHeight() + 2;
            return new Dimension(n + n2 + n9, n3 + n8);
        }
        if (list.getOrientation() == 0) {
            return new Dimension(n2 + n9, n3 + (n5 + list.getItemGap()) * (n6 - 1) + n8);
        }
        return new Dimension(n2 + (n4 + list.getItemGap()) * (n6 - 1) + n9, n3 + n8);
    }

    public Dimension getRadioButtonPreferredSize(Button button) {
        if (button.isToggle()) {
            return this.getButtonPreferredSize(button);
        }
        if (this.rButtonImages != null) {
            return this.getPreferredSize(button, new Image[]{button.getIcon(), button.getRolloverIcon(), button.getPressedIcon()}, this.rButtonImages[0]);
        }
        Dimension dimension = this.getPreferredSize(button, new Image[]{button.getIcon(), button.getRolloverIcon(), button.getPressedIcon()}, null);
        int n = button.getStyle().getFont().getHeight();
        dimension.setHeight(Math.max(n, dimension.getHeight()));
        dimension.setWidth(dimension.getWidth() + n + button.getGap());
        return dimension;
    }

    public Dimension getTextAreaSize(TextArea textArea, boolean bl) {
        int n = 0;
        int n2 = 0;
        Style style = textArea.getStyle();
        Font font = style.getFont();
        n = textArea.getRows() == 1 ? font.stringWidth(textArea.getText()) : font.charWidth(TextArea.getWidestChar()) * textArea.getColumns();
        int n3 = bl ? textArea.getActualRows() : textArea.getLines();
        n2 = (font.getHeight() + textArea.getRowsGap()) * n3;
        int n4 = textArea.getColumns();
        String string = "";
        for (int i = 0; i < n4; ++i) {
            string = string + TextArea.getWidestChar();
        }
        if (n4 > 0) {
            n = Math.max(n, font.stringWidth(string));
        }
        n2 = Math.max(n2, n3 * font.getHeight());
        n += style.getPadding(false, 3) + style.getPadding(false, 1);
        n2 += style.getPadding(false, 0) + style.getPadding(false, 2);
        if (style.getBorder() != null) {
            n = Math.max(style.getBorder().getMinimumWidth(), n);
            n2 = Math.max(style.getBorder().getMinimumHeight(), n2);
        }
        return new Dimension(n, n2);
    }

    private int reverseAlignForBidi(Component component) {
        return this.reverseAlignForBidi(component, component.getStyle().getAlignment());
    }

    private int reverseAlignForBidi(Component component, int n) {
        if (component.isRTL()) {
            switch (n) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return n;
    }

    private void drawComponent(Graphics graphics, Label label, Image image, Image image2, int n) {
        int n2;
        this.setFG(graphics, label);
        int n3 = label.getGap();
        int n4 = 0;
        int n5 = 0;
        String string = label.getText();
        Style style = label.getStyle();
        int n6 = label.getX();
        int n7 = label.getY();
        int n8 = label.getHeight();
        int n9 = label.getWidth();
        boolean bl = label.isRTL();
        int n10 = style.getPadding(bl, 1);
        int n11 = style.getPadding(bl, 3);
        int n12 = style.getPadding(false, 0);
        int n13 = style.getPadding(false, 2);
        Font font = style.getFont();
        int n14 = 0;
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            n14 = font.getHeight();
        }
        if (image2 != null) {
            n4 = image2.getWidth();
            n5 = n7 + n12 + (n8 - n12 - n13) / 2 - n4 / 2;
            n = n4 + n3;
            n2 = n6;
            n2 = bl ? n2 + n9 - n10 - n4 : (n2 += n10);
            graphics.drawImage(image2, n2, n5);
        }
        n2 = n6 + n10 + n;
        int n15 = n7 + n12;
        int n16 = this.reverseAlignForBidi(label, style.getAlignment());
        int n17 = this.reverseAlignForBidi(label, label.getTextPosition());
        if (n16 == 1) {
            switch (n17) {
                case 1: 
                case 3: {
                    n15 += (n8 - (n12 + n13 + Math.max(image != null ? image.getHeight() : 0, n14))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    n15 += (n8 - (n12 + n13 + (image != null ? image.getHeight() + n3 : 0) + n14)) / 2;
                }
            }
        } else if (n16 == 4) {
            switch (n17) {
                case 1: 
                case 3: {
                    n2 += (n9 - (n + n10 + n11 + (image != null ? image.getWidth() + label.getGap() : 0) + font.stringWidth(string))) / 2;
                    n2 = Math.max(n2, n6 + n10 + n);
                    n15 += (n8 - (n12 + n13 + Math.max(image != null ? image.getHeight() : 0, n14))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    n2 += (n9 - (n + n10 + n11 + Math.max(image != null ? image.getWidth() + label.getGap() : 0, font.stringWidth(string)))) / 2;
                    n2 = Math.max(n2, n6 + n10 + n);
                    n15 += (n8 - (n12 + n13 + (image != null ? image.getHeight() + n3 : 0) + n14)) / 2;
                }
            }
        } else if (n16 == 3) {
            switch (n17) {
                case 1: 
                case 3: {
                    n2 = n6 + n9 - n11 - ((image != null ? image.getWidth() + n3 : 0) + font.stringWidth(string));
                    n2 = label.isRTL() ? Math.max(n2 - n, n6 + n10) : Math.max(n2, n6 + n10 + n);
                    n15 += (n8 - (n12 + n13 + Math.max(image != null ? image.getHeight() : 0, n14))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    n2 = n6 + n9 - n11 - Math.max(image != null ? image.getWidth() : 0, font.stringWidth(string));
                    n2 = Math.max(n2, n6 + n10 + n);
                    n15 += (n8 - (n12 + n13 + (image != null ? image.getHeight() + n3 : 0) + n14)) / 2;
                }
            }
        }
        int n18 = n9 - n11 - n10;
        if (image != null && (n17 == 3 || n17 == 1)) {
            n18 -= image.getWidth();
        }
        n18 = image2 != null ? (n18 -= n4) : (n18 -= n);
        if (image == null) {
            this.drawLabelString(graphics, label, string, n2, n15, n18);
        } else {
            int n19 = font.stringWidth(string);
            int n20 = image.getWidth();
            int n21 = image.getHeight();
            switch (n17) {
                case 1: {
                    if (n21 > n14) {
                        int n22 = (n21 - n14) / 2;
                        n19 = this.drawLabelStringValign(graphics, label, string, n2, n15, n22, n21, n18, n14);
                        graphics.drawImage(image, n2 + n19 + n3, n15);
                        break;
                    }
                    int n23 = (n14 - n21) / 2;
                    n19 = this.drawLabelString(graphics, label, string, n2, n15, n18);
                    graphics.drawImage(image, n2 + n19 + n3, n15 + n23);
                    break;
                }
                case 3: {
                    if (n21 > n14) {
                        int n24 = (n21 - n14) / 2;
                        graphics.drawImage(image, n2, n15);
                        this.drawLabelStringValign(graphics, label, string, n2 + n20 + n3, n15, n24, n21, n18, n14);
                        break;
                    }
                    int n25 = (n14 - n21) / 2;
                    graphics.drawImage(image, n2, n15 + n25);
                    this.drawLabelString(graphics, label, string, n2 + n20 + n3, n15, n18);
                    break;
                }
                case 2: {
                    if (n20 > n19) {
                        int n26 = (n20 - n19) / 2;
                        graphics.drawImage(image, n2, n15);
                        this.drawLabelString(graphics, label, string, n2 + n26, n15 + n21 + n3, n18);
                        break;
                    }
                    int n27 = (Math.min(n19, n18) - n20) / 2;
                    graphics.drawImage(image, n2 + n27, n15);
                    this.drawLabelString(graphics, label, string, n2, n15 + n21 + n3, n18);
                    break;
                }
                case 0: {
                    if (n20 > n19) {
                        int n28 = (n20 - n19) / 2;
                        this.drawLabelString(graphics, label, string, n2 + n28, n15, n18);
                        graphics.drawImage(image, n2, n15 + n14 + n3);
                        break;
                    }
                    int n29 = (Math.min(n19, n18) - n20) / 2;
                    this.drawLabelString(graphics, label, string, n2, n15, n18);
                    graphics.drawImage(image, n2 + n29, n15 + n14 + n3);
                }
            }
        }
    }

    private int drawLabelStringValign(Graphics graphics, Label label, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (label.getVerticalAlignment()) {
            case 0: {
                return this.drawLabelString(graphics, label, string, n, n2, n5);
            }
            case 4: {
                return this.drawLabelString(graphics, label, string, n, n2 + n4 / 2 - n6 / 2, n5);
            }
        }
        return this.drawLabelString(graphics, label, string, n, n2 + n3, n5);
    }

    private int drawLabelString(Graphics graphics, Label label, String string, int n, int n2, int n3) {
        Style style = label.getStyle();
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.clipRect(n, n5, n3, n7);
        if (label.isTickerRunning()) {
            if (label.getShiftText() > 0) {
                if (label.getShiftText() > n3) {
                    label.setShiftText(n - label.getX() - style.getFont().stringWidth(string));
                }
            } else if (label.getShiftText() + style.getFont().stringWidth(string) < 0) {
                label.setShiftText(n3);
            }
        }
        int n8 = this.drawLabelText(graphics, label, string, n, n2, n3);
        graphics.setClip(n4, n5, n6, n7);
        return n8;
    }

    protected int drawLabelText(Graphics graphics, Label label, String string, int n, int n2, int n3) {
        Style style = label.getStyle();
        Font font = style.getFont();
        boolean bl = label.isRTL();
        boolean bl2 = label.isTickerRunning();
        int n4 = font.stringWidth(string);
        if ((!bl2 || bl) && n4 > n3 && n3 > 0) {
            if (bl) {
                if (!bl2 && label.isEndsWith3Points()) {
                    String string2 = "...";
                    int n5 = font.stringWidth(string2);
                    graphics.drawString(string2, label.getShiftText() + n, n2, label.getStyle().getTextDecoration());
                    graphics.clipRect(n5 + label.getShiftText() + n, n2, n3 - n5, font.getHeight());
                }
                n = n - n4 + n3;
            } else if (label.isEndsWith3Points()) {
                String string3 = "...";
                int n6 = 1;
                int n7 = font.charWidth('W');
                int n8 = font.stringWidth(string3);
                while (this.fastCharWidthCheck(string, n6, n3 - n8, n7, font)) {
                    ++n6;
                }
                string = string.substring(0, Math.max(1, n6 - 1)) + string3;
                n4 = font.stringWidth(string);
            }
        }
        graphics.drawString(string, label.getShiftText() + n, n2, style.getTextDecoration());
        return Math.min(n4, n3);
    }

    private boolean fastCharWidthCheck(String string, int n, int n2, int n3, Font font) {
        if (n * n3 < n2) {
            return true;
        }
        n = Math.min(string.length(), n);
        return font.substringWidth(string, 0, n) < n2;
    }

    public Dimension getComboBoxPreferredSize(List list) {
        return this.getListPreferredSize(list);
    }

    public void drawTabbedPane(Graphics graphics, TabbedPane tabbedPane) {
    }

    public Component getTabbedPaneCell(final TabbedPane tabbedPane, String string, Image image, final boolean bl, final boolean bl2, final Style style, final Style style2, final Style style3, final int n, final int n2, final Dimension dimension, final Dimension dimension2) {
        Label label = new Label(string){

            public void paint(Graphics graphics) {
                int n6 = tabbedPane.getTabbedPaneBorderWidth();
                int n22 = n6 * 2;
                int n3 = tabbedPane.getTabPlacement();
                if (bl && bl2) {
                    n22 = n6 * 3;
                    this.getStyle().setFgColor(style2.getFgColor());
                } else {
                    this.getStyle().setFgColor(style.getFgColor());
                }
                super.paint(graphics);
                if (!bl) {
                    graphics.setColor(0);
                    graphics.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), (byte)47);
                }
                graphics.setColor(this.getStyle().getFgColor());
                if (n3 == 0 || n3 == 2) {
                    if (n3 == 0) {
                        if (bl) {
                            graphics.fillRect(this.getX(), this.getY() + n6, this.getWidth(), n22);
                        }
                        graphics.setColor(style3.getFgColor());
                        graphics.fillRect(this.getX(), this.getY(), this.getWidth(), n6);
                        graphics.fillRect(this.getX(), this.getY(), n6, this.getHeight());
                    } else {
                        if (bl) {
                            graphics.fillRect(this.getX(), this.getY() + this.getHeight() - n22, this.getWidth(), n22);
                        }
                        graphics.setColor(style3.getFgColor());
                        graphics.fillRect(this.getX(), this.getY() + this.getHeight() - n6, this.getWidth(), n6);
                        graphics.fillRect(this.getX(), this.getY(), n6, this.getHeight());
                    }
                    int n4 = this.getX() - n + this.getWidth();
                    if (n4 == dimension2.getWidth()) {
                        graphics.fillRect(n4 + n - n6, this.getY(), n6, this.getHeight());
                    }
                    if (dimension.getWidth() < dimension2.getWidth() && this.getX() + this.getWidth() == dimension.getWidth()) {
                        graphics.fillRect(this.getX() + this.getWidth() - n6, this.getY(), n6, this.getHeight());
                    }
                } else {
                    if (bl) {
                        graphics.fillRect(this.getX(), this.getY() + n6, this.getWidth(), n22);
                    }
                    graphics.setColor(style3.getFgColor());
                    graphics.fillRect(this.getX(), this.getY(), this.getWidth(), n6);
                    int n5 = this.getY() - n2 + this.getHeight();
                    if (n5 == dimension2.getHeight()) {
                        graphics.fillRect(this.getX(), n5 + n2 - n6, this.getWidth(), n6);
                    }
                    if (dimension.getHeight() < dimension2.getHeight() && this.getY() + this.getHeight() == dimension.getHeight()) {
                        graphics.fillRect(this.getX(), this.getY() + this.getHeight() - n6, this.getWidth(), n6);
                    }
                    if (!tabbedPane.isRTL() && n3 == 1 || tabbedPane.isRTL() && n3 == 3) {
                        graphics.fillRect(this.getX(), this.getY(), n6, this.getHeight());
                    } else {
                        graphics.fillRect(this.getX() + this.getWidth() - n6, this.getY(), n6, this.getHeight());
                    }
                }
            }
        };
        label.setUIID("Tab");
        label.setCellRenderer(true);
        label.getStyle().setBorder(null);
        label.getStyle().setMargin(0, 0, 0, 0);
        label.setIcon(image);
        this.updateCellLook(tabbedPane, label, bl);
        if (bl) {
            style.setBgColor(style.getBgColor());
        }
        label.setAlignment(4);
        return label;
    }

    private void updateCellLook(TabbedPane tabbedPane, Component component, boolean bl) {
        component.getStyle().setFgColor(tabbedPane.getStyle().getFgColor());
        component.getStyle().setBgTransparency(tabbedPane.getStyle().getBgTransparency());
        component.getStyle().setFont(tabbedPane.getStyle().getFont());
    }

    public void drawTabbedPaneContentPane(TabbedPane tabbedPane, Graphics graphics, Rectangle rectangle, Dimension dimension, int n, int n2, Dimension dimension2, int n3, int n4) {
        int n5 = tabbedPane.getTabbedPaneBorderWidth();
        if (n5 < 1) {
            return;
        }
        int n6 = rectangle.getX();
        int n7 = rectangle.getY();
        int n8 = rectangle.getSize().getWidth();
        int n9 = rectangle.getSize().getHeight();
        int n10 = dimension.getWidth();
        int n11 = dimension.getHeight();
        int n12 = dimension2.getWidth();
        int n13 = dimension2.getHeight();
        graphics.setColor(tabbedPane.getStyle().getBgColor());
        graphics.fillRect(n6, n7, n8, n9, tabbedPane.getStyle().getBgTransparency());
        graphics.setColor(tabbedPane.getStyle().getFgColor());
        int n14 = tabbedPane.getTabPlacement();
        if (n14 == 0 || n14 == 2) {
            graphics.fillRect(n6, n7, n5, n9);
            graphics.fillRect(n6 + n8 - n5, n7, n5, n9);
            int n15 = n7;
            if (n14 == 2) {
                n15 = n7 + n9 - n5;
                graphics.fillRect(n6, n7, n8, n5);
            } else {
                graphics.fillRect(n6, n7 + n9 - n5, n8, n5);
            }
            if (tabbedPane.isRTL()) {
                if (n10 < n8) {
                    graphics.fillRect(n6, n15, n8 - n10, n5);
                    for (int i = 0; i < n; ++i) {
                        if (i == n2) continue;
                        graphics.fillRect(n6 - n3 + n8 - n12 * (i + 1), n15, n12 + n5, n5);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (n - 1 - i == n2) continue;
                        graphics.fillRect(n6 - n3 + n12 * i, n15, n12 + n5, n5);
                    }
                }
            } else {
                if (n10 < n8) {
                    graphics.fillRect(n10 - n5, n15, n8 - n10, n5);
                }
                for (int i = 0; i < n; ++i) {
                    if (i == n2) continue;
                    graphics.fillRect(n6 - n3 + n12 * i, n15, n12 + n5, n5);
                }
            }
        } else {
            graphics.fillRect(n6, n7, n8, n5);
            graphics.fillRect(n6, n7 + n9 - n5, n8, n5);
            int n16 = n6;
            if (!tabbedPane.isRTL() && n14 == 3 || tabbedPane.isRTL() && n14 == 1) {
                graphics.fillRect(n6, n7, n5, n9);
                n16 = n6 + n8 - n5;
            } else {
                graphics.fillRect(n6 + n8 - n5, n7, n5, n9);
            }
            if (n11 < n9) {
                graphics.fillRect(n16, n7 + n11 - n5, n5, n9 - n11 + n5);
            }
            for (int i = 0; i < n; ++i) {
                if (i == n2) continue;
                graphics.fillRect(n16, n7 - n4 + n13 * i, n5, n13 + n5);
            }
        }
    }

    protected String getTextFieldString(TextArea textArea) {
        String string;
        String string2 = textArea.getText();
        if (textArea.isSingleLineTextArea()) {
            string = string2;
        } else {
            string = textArea.getTextAt(textArea.getCursorY());
            if (textArea.getCursorPosition() + string.length() < string2.length()) {
                char c = string2.charAt(textArea.getCursorPosition() + string.length());
                if (c == '\n') {
                    string = string + "\n";
                } else if (c == ' ') {
                    string = string + " ";
                }
            }
        }
        String string3 = "";
        if ((textArea.getConstraint() & 0x10000) != 0) {
            if (textArea.isPendingCommit()) {
                if (string.length() > 0) {
                    for (int i = 0; i < string.length() - 1; ++i) {
                        string3 = string3 + "*";
                    }
                    string3 = string3 + string.charAt(string.length() - 1);
                }
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    string3 = string3 + "*";
                }
            }
        } else {
            string3 = string;
        }
        return string3;
    }

    public void drawTextField(Graphics graphics, TextArea textArea) {
        int n;
        int n2;
        this.setFG(graphics, textArea);
        String string = this.getTextFieldString(textArea);
        Style style = textArea.getStyle();
        int n3 = 0;
        int n4 = textArea.getCursorPosition();
        Font font = textArea.getStyle().getFont();
        int n5 = 0;
        int n6 = 0;
        int n7 = this.reverseAlignForBidi(textArea);
        int n8 = 0;
        String string2 = textArea.getInputMode();
        int n9 = font.stringWidth(string2);
        if (textArea.isQwertyInput() || Display.getInstance().isVirtualKeyboardShowing()) {
            string2 = "";
            n9 = 0;
        }
        if (textArea.isSingleLineTextArea()) {
            if (n7 == 1) {
                if (n4 > 0) {
                    n4 = Math.min(string.length(), n4);
                    n6 = font.stringWidth(string.substring(0, n4));
                    n5 = textArea.getX() + style.getPadding(textArea.isRTL(), 1) + n6;
                    if (n9 > 0 && textArea.getInputModeOrder() != null && textArea.getInputModeOrder().length == 1) {
                        n9 = 0;
                    }
                    if (textArea.isEnableInputScroll() && textArea.getWidth() > font.getHeight() * 2 && n5 >= textArea.getWidth() - n9 - style.getPadding(textArea.isRTL(), 1) && n3 + n6 >= textArea.getWidth() - n9 - style.getPadding(textArea.isRTL(), 1) * 2) {
                        n3 = textArea.getWidth() - n9 - style.getPadding(textArea.isRTL(), 1) * 2 - n6 - 1;
                    }
                }
                n8 = textArea.getX() + n3 + style.getPadding(textArea.isRTL(), 1);
            } else {
                n3 = 0;
                n5 = this.getTextFieldCursorX(textArea);
                n2 = textArea.getX() + style.getPadding(false, 1) + n9;
                n = textArea.getX() + textArea.getWidth() - style.getPadding(false, 3);
                if (n5 < n2) {
                    n3 = n2 - n5;
                } else if (n5 > n) {
                    n3 = n - n5;
                }
                n8 = textArea.getX() + textArea.getWidth() - style.getPadding(false, 3) - font.stringWidth(string) + n3;
            }
            graphics.drawString(string, n8, textArea.getY() + style.getPadding(false, 0), textArea.getStyle().getTextDecoration());
        } else {
            this.drawTextArea(graphics, textArea);
        }
        if (n9 > 0 && textArea.getInputModeOrder() != null && textArea.getInputModeOrder().length > 1 && textArea.handlesInput() && textArea.getWidth() / 2 > n9) {
            n2 = textArea.getX() + style.getPadding(textArea.isRTL(), 1);
            if (!textArea.isRTL() && textArea.getStyle().getAlignment() == 1 || textArea.isRTL() && textArea.getStyle().getAlignment() == 3) {
                n2 = n2 + textArea.getWidth() - n9 - style.getPadding(false, 3) - style.getPadding(false, 1);
            }
            graphics.setColor(style.getFgColor());
            n = textArea.getY() + textArea.getScrollY() + textArea.getHeight() - style.getPadding(false, 2) - font.getHeight();
            graphics.fillRect(n2, n, n9, font.getHeight(), (byte)-116);
            graphics.setColor(style.getBgColor());
            graphics.drawString(string2, n2, n);
        }
    }

    private boolean isRTLOrWhitespace(char c) {
        return Display.getInstance().isRTL(c) || c == ' ';
    }

    private int getTextFieldCursorX(TextArea textArea) {
        Style style = textArea.getStyle();
        Font font = style.getFont();
        String string = this.getTextFieldString(textArea);
        String string2 = textArea.getInputMode();
        int n = font.stringWidth(string2);
        if (textArea.isQwertyInput() || Display.getInstance().isVirtualKeyboardShowing()) {
            string2 = "";
            n = 0;
        }
        int n2 = 0;
        int n3 = textArea.getCursorX();
        int n4 = 0;
        int n5 = 0;
        if (this.reverseAlignForBidi(textArea) == 3) {
            if (Display.getInstance().isBidiAlgorithm()) {
                n3 = Display.getInstance().getCharLocation(string, n3 - 1);
                if (n3 == -1) {
                    n2 = font.stringWidth(string);
                } else {
                    string = Display.getInstance().convertBidiLogicalToVisual(string);
                    if (!this.isRTLOrWhitespace(string.charAt(n3))) {
                        ++n3;
                    }
                    n2 = font.stringWidth(string.substring(0, n3));
                }
            }
            int n6 = textArea.getX() + textArea.getWidth() - style.getPadding(textArea.isRTL(), 1) - font.stringWidth(string);
            n4 = n6 + n2;
            n5 = 0;
        } else {
            if (n3 > 0) {
                n3 = Math.min(string.length(), n3);
                n2 = font.stringWidth(string.substring(0, n3));
            }
            n4 = textArea.getX() + style.getPadding(textArea.isRTL(), 1) + n2;
            if (textArea.isSingleLineTextArea() && textArea.getWidth() > font.getHeight() * 2 && n4 >= textArea.getWidth() - n - style.getPadding(textArea.isRTL(), 1) && n5 + n2 >= textArea.getWidth() - n - style.getPadding(false, 1) - style.getPadding(false, 3)) {
                n5 = textArea.getWidth() - n - style.getPadding(false, 1) - style.getPadding(false, 3) - n2 - 1;
            }
        }
        return n4 + n5;
    }

    public Dimension getTextFieldPreferredSize(TextArea textArea) {
        return this.getTextAreaSize(textArea, true);
    }

    public void drawTextFieldCursor(Graphics graphics, TextArea textArea) {
        Style style = textArea.getStyle();
        Font font = style.getFont();
        int n = textArea.getY() + style.getPadding(false, 0) + textArea.getCursorY() * (textArea.getRowsGap() + font.getHeight());
        int n2 = this.getTextFieldCursorX(textArea);
        int n3 = this.reverseAlignForBidi(textArea);
        int n4 = 0;
        if (n3 == 3) {
            String string = textArea.getInputMode();
            int n5 = font.stringWidth(string);
            int n6 = textArea.getX() + style.getPadding(false, 1) + n5;
            if (n2 < n6) {
                n4 = n6 - n2;
            }
        }
        int n7 = graphics.getColor();
        graphics.setColor(style.getFgColor());
        graphics.drawLine(n2 + n4, n, n2 + n4, n + font.getHeight());
        graphics.setColor(n7);
    }

    public void focusGained(Component component) {
        Label label;
        if (component instanceof Label && (label = (Label)component).isTickerEnabled() && label.shouldTickerStart() && Display.getInstance().shouldRenderSelection()) {
            ((Label)component).startTicker(this.getTickerSpeed(), true);
        }
    }

    public void focusLost(Component component) {
        Label label;
        if (component instanceof Label && (label = (Label)component).isTickerRunning()) {
            label.stopTicker();
        }
    }

    public void refreshTheme() {
        Image image;
        Image image2;
        Image image3;
        Image image4;
        super.refreshTheme();
        UIManager uIManager = UIManager.getInstance();
        Image image5 = uIManager.getThemeImageConstant("comboImage");
        if (image5 != null) {
            this.setComboBoxImage(image5);
        }
        if ((image4 = uIManager.getThemeImageConstant("checkBoxCheckedImage")) != null) {
            image3 = uIManager.getThemeImageConstant("checkBoxUncheckedImage");
            if (image3 != null) {
                image2 = uIManager.getThemeImageConstant("checkBoxUncheckDisImage");
                image = uIManager.getThemeImageConstant("checkBoxCheckDisImage");
                if (image == null) {
                    image = image4;
                }
                if (image2 == null) {
                    image2 = image3;
                }
                this.setCheckBoxImages(image4, image3, image, image2);
            }
            if (image3 != null) {
                this.setCheckBoxImages(image4, image3);
            }
        }
        if ((image3 = uIManager.getThemeImageConstant("radioSelectedImage")) != null && (image2 = uIManager.getThemeImageConstant("radioUnselectedImage")) != null) {
            image = uIManager.getThemeImageConstant("radioUnselectedDisImage");
            Image image6 = uIManager.getThemeImageConstant("radioSelectedDisImage");
            if (image == null) {
                image = image2;
            }
            if (image6 == null) {
                image6 = image3;
            }
            this.setRadioButtonImages(image3, image2, image6, image);
        }
    }
}

