/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;
import java.util.Vector;

public class Form
extends Container {
    private Painter glassPane;
    private Container contentPane = new Container(new FlowLayout());
    Container titleArea = new Container(new BorderLayout());
    private Label title = new Label("", "Title");
    private MenuBar menuBar;
    private Component dragged;
    protected boolean focusScrolling;
    static boolean comboLock;
    private Vector internalAnimatableComponents;
    private Vector animatableComponents;
    private Component focused;
    private Vector mediaComponents;
    private Transition transitionInAnimator;
    private Transition transitionOutAnimator;
    private EventDispatcher commandListener;
    private EventDispatcher pointerPressedListeners;
    private EventDispatcher pointerReleasedListeners;
    private EventDispatcher pointerDraggedListeners;
    private Form previousForm;
    boolean tint;
    private int tintColor;
    private Vector focusDownSequence;
    private Vector focusRightSequence;
    private Hashtable keyListeners;
    private Hashtable gameKeyListeners;
    private boolean cyclicFocus = true;
    private int tactileTouchDuration;
    private EventDispatcher showListener;

    public Form() {
        super(new BorderLayout());
        this.setUIID("Form");
        this.setVisible(false);
        Style style = this.getStyle();
        int n = Display.getInstance().getDisplayWidth() - (style.getMargin(this.isRTL(), 1) + style.getMargin(this.isRTL(), 3));
        int n2 = Display.getInstance().getDisplayHeight() - (style.getMargin(false, 0) + style.getMargin(false, 2));
        this.setWidth(n);
        this.setHeight(n2);
        this.setPreferredSize(new Dimension(n, n2));
        this.title.setEndsWith3Points(false);
        this.titleArea.addComponent("Center", (Component)this.title);
        this.titleArea.setUIID("TitleArea");
        this.addComponentToForm("North", this.titleArea);
        this.addComponentToForm("Center", this.contentPane);
        this.contentPane.setUIID("ContentPane");
        this.contentPane.setScrollableY(true);
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.initLaf(lookAndFeel);
        this.focusScrolling = lookAndFeel.isFocusScrolling();
        try {
            this.menuBar = (MenuBar)lookAndFeel.getMenuBarClass().newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.menuBar = new MenuBar();
        }
        this.menuBar.initMenuBar(this);
        this.tintColor = lookAndFeel.getDefaultFormTintColor();
        style.setBgTransparency(255);
    }

    public Container getTitleArea() {
        return this.titleArea;
    }

    public void addShowListener(ActionListener actionListener) {
        if (this.showListener == null) {
            this.showListener = new EventDispatcher();
        }
        this.showListener.addListener(actionListener);
    }

    public void removeShowListener(ActionListener actionListener) {
        if (this.showListener == null) {
            return;
        }
        this.showListener.removeListener(actionListener);
    }

    protected void hideNotify() {
        this.setVisible(false);
    }

    protected void showNotify() {
        this.setVisible(true);
    }

    protected void sizeChanged(int n, int n2) {
    }

    void sizeChangedInternal(int n, int n2) {
        this.sizeChanged(n, n2);
        Style style = this.getStyle();
        this.setSize(new Dimension(n -= style.getMargin(this.isRTL(), 1) + style.getMargin(this.isRTL(), 3), n2 -= style.getMargin(false, 0) + style.getMargin(false, 2)));
        this.setShouldCalcPreferredSize(true);
        this.doLayout();
        this.repaint();
    }

    public void setGlassPane(Painter painter) {
        this.glassPane = painter;
        this.repaint();
    }

    void paintGlassImpl(Graphics graphics) {
        if (this.glassPane != null) {
            int n = graphics.getTranslateX();
            int n2 = graphics.getTranslateY();
            graphics.translate(-n, -n2);
            this.glassPane.paint(graphics, this.getBounds());
            graphics.translate(n, n2);
        }
        this.paintGlass(graphics);
    }

    public Painter getGlassPane() {
        return this.glassPane;
    }

    public void setTitleStyle(Style style) {
        this.title.setUnselectedStyle(style);
    }

    public Label getTitleComponent() {
        return this.title;
    }

    public void setTitleComponent(Label label) {
        this.titleArea.replace(this.title, label);
        this.title = label;
    }

    public void setTitleComponent(Label label, Transition transition) {
        this.titleArea.replace(this.title, label, transition);
        this.title = label;
    }

    public void addKeyListener(int n, ActionListener actionListener) {
        if (this.keyListeners == null) {
            this.keyListeners = new Hashtable();
        }
        this.addKeyListener(n, actionListener, this.keyListeners);
    }

    public void removeKeyListener(int n, ActionListener actionListener) {
        if (this.keyListeners == null) {
            return;
        }
        this.removeKeyListener(n, actionListener, this.keyListeners);
    }

    public void removeGameKeyListener(int n, ActionListener actionListener) {
        if (this.gameKeyListeners == null) {
            return;
        }
        this.removeKeyListener(n, actionListener, this.gameKeyListeners);
    }

    private void addKeyListener(int n, ActionListener actionListener, Hashtable hashtable) {
        Integer n2;
        Vector<ActionListener> vector;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((vector = (Vector<ActionListener>)hashtable.get(n2 = new Integer(n))) == null) {
            vector = new Vector<ActionListener>();
            vector.addElement(actionListener);
            hashtable.put(n2, vector);
            return;
        }
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
        }
    }

    private void removeKeyListener(int n, ActionListener actionListener, Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Integer n2 = new Integer(n);
        Vector vector = (Vector)hashtable.get(n2);
        if (vector == null) {
            return;
        }
        vector.removeElement(actionListener);
        if (vector.size() == 0) {
            hashtable.remove(n2);
        }
    }

    public void addGameKeyListener(int n, ActionListener actionListener) {
        if (this.gameKeyListeners == null) {
            this.gameKeyListeners = new Hashtable();
        }
        this.addKeyListener(n, actionListener, this.gameKeyListeners);
    }

    public int getSoftButtonCount() {
        return this.menuBar.getSoftButtons().length;
    }

    public Button getSoftButton(int n) {
        return this.menuBar.getSoftButtons()[n];
    }

    public Style getMenuStyle() {
        return this.menuBar.getMenuStyle();
    }

    public Style getTitleStyle() {
        return this.title.getStyle();
    }

    Form getPreviousForm() {
        return this.previousForm;
    }

    void initLaf(LookAndFeel lookAndFeel) {
        this.transitionOutAnimator = lookAndFeel.getDefaultFormTransitionOut();
        this.transitionInAnimator = lookAndFeel.getDefaultFormTransitionIn();
    }

    void clearFocusVectors() {
        this.focusDownSequence = null;
        this.focusRightSequence = null;
    }

    void setDraggedComponent(Component component) {
        this.dragged = component;
    }

    synchronized void initFocusRight() {
        if (this.focusRightSequence == null) {
            this.focusRightSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusRightSequence, true);
        }
    }

    synchronized void initFocusDown() {
        if (this.focusDownSequence == null) {
            this.focusDownSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusDownSequence, false);
        }
    }

    private void addSortedComponentRight(Vector vector, Component component) {
        int n = vector.size();
        int n2 = component.getAbsoluteX();
        int n3 = 0;
        boolean bl = this.isRTL();
        Component component2 = this.findScrollableAncestor(component);
        for (int i = 0; i < n; ++i) {
            Component component3 = (Component)vector.elementAt(i);
            Component component4 = this.findScrollableAncestor(component3);
            if (component4 == component2) {
                if (this.isInSameRow(component3, component)) {
                    int n4 = component3.getAbsoluteX();
                    if (!bl && n4 > n2 || bl && n4 < n2) continue;
                    n3 = i + 1;
                    continue;
                }
            } else {
                Component component5 = component2;
                if (component2 == null) {
                    component5 = component;
                }
                Component component6 = component4;
                if (component4 == null) {
                    component6 = component3;
                }
                if (!bl && component6.getAbsoluteX() > component5.getAbsoluteX() || bl && component6.getAbsoluteX() < component5.getAbsoluteX()) continue;
                if (this.isInSameRow(component6, component5)) {
                    n3 = i + 1;
                    continue;
                }
            }
            if (component3.getAbsoluteY() >= component.getAbsoluteY()) continue;
            n3 = i + 1;
        }
        vector.insertElementAt(component, n3);
    }

    private Component findScrollableAncestor(Component component) {
        if ((component = component.getParent()) == null || component.isScrollable()) {
            return component;
        }
        return this.findScrollableAncestor(component);
    }

    private void addSortedComponentDown(Vector vector, Component component) {
        int n = vector.size();
        int n2 = component.getAbsoluteY();
        int n3 = 0;
        boolean bl = this.isRTL();
        Component component2 = this.findScrollableAncestor(component);
        for (int i = 0; i < n; ++i) {
            Component component3 = (Component)vector.elementAt(i);
            Component component4 = this.findScrollableAncestor(component3);
            if (component4 == component2) {
                if (this.isInSameColumn(component3, component)) {
                    int n4 = component3.getAbsoluteY();
                    if (n4 > n2) continue;
                    n3 = i + 1;
                    continue;
                }
            } else {
                Component component5 = component2;
                if (component2 == null) {
                    component5 = component;
                }
                Component component6 = component4;
                if (component4 == null) {
                    component6 = component3;
                }
                if (component6.getAbsoluteY() > component5.getAbsoluteY()) continue;
                if (this.isInSameColumn(component6, component5)) {
                    n3 = i + 1;
                    continue;
                }
            }
            if ((bl || component3.getAbsoluteX() >= component.getAbsoluteX()) && (!bl || component3.getAbsoluteX() <= component.getAbsoluteX())) continue;
            n3 = i + 1;
        }
        vector.insertElementAt(component, n3);
    }

    private boolean isInSameColumn(Component component, Component component2) {
        return Rectangle.intersects(component.getAbsoluteX(), component.getAbsoluteY(), component.getWidth(), Integer.MAX_VALUE, component2.getAbsoluteX(), component2.getAbsoluteY(), component2.getWidth(), component2.getHeight());
    }

    private boolean isInSameRow(Component component, Component component2) {
        return Rectangle.intersects(component.getAbsoluteX(), component.getAbsoluteY(), Integer.MAX_VALUE, component.getHeight(), component2.getAbsoluteX(), component2.getAbsoluteY(), component2.getWidth(), component2.getHeight());
    }

    private void addSortedComponent(Vector vector, Component component, boolean bl) {
        if (bl) {
            this.addSortedComponentRight(vector, component);
        } else {
            this.addSortedComponentDown(vector, component);
        }
    }

    public void setDefaultCommand(Command command) {
        this.menuBar.setDefaultCommand(command);
    }

    public Command getDefaultCommand() {
        return this.menuBar.getDefaultCommand();
    }

    public void setClearCommand(Command command) {
        this.menuBar.setClearCommand(command);
    }

    public Command getClearCommand() {
        return this.menuBar.getClearCommand();
    }

    public void setBackCommand(Command command) {
        this.menuBar.setBackCommand(command);
    }

    public Command getBackCommand() {
        return this.menuBar.getBackCommand();
    }

    private void findAllFocusable(Container container, Vector vector, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponentAt(i);
            if (component instanceof Container && !((Container)component).isBlockFocus()) {
                this.findAllFocusable((Container)component, vector, bl);
            }
            if (!component.isFocusable()) continue;
            this.addSortedComponent(vector, component, bl);
        }
    }

    public Form(String string) {
        this();
        this.title.setText(string);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void setBgImage(Image image) {
        this.getStyle().setBgImage(image);
    }

    public void setLayout(Layout layout) {
        this.contentPane.setLayout(layout);
    }

    public void setTitle(String string) {
        this.title.setText(string);
        if (this.isInitialized() && this.title.isTickerEnabled()) {
            int n = Display.getInstance().getCommandBehavior();
            if (n == 5 || n == 6) {
                this.titleArea.revalidate();
            }
            if (this.title.shouldTickerStart()) {
                this.title.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
            } else if (this.title.isTickerRunning()) {
                this.title.stopTicker();
            }
        }
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void addComponent(Component component) {
        this.contentPane.addComponent(component);
    }

    public void addComponent(Object object, Component component) {
        this.contentPane.addComponent(object, component);
    }

    public void addComponent(int n, Object object, Component component) {
        this.contentPane.addComponent(n, object, component);
    }

    public void addComponent(int n, Component component) {
        this.contentPane.addComponent(n, component);
    }

    public void replace(Component component, Component component2, Transition transition) {
        this.contentPane.replace(component, component2, transition);
    }

    public void replaceAndWait(Component component, Component component2, Transition transition) {
        this.contentPane.replaceAndWait(component, component2, transition);
    }

    public void removeComponent(Component component) {
        this.contentPane.removeComponent(component);
    }

    void addComponentToForm(Object object, Component component) {
        super.addComponent(object, component);
    }

    void removeComponentFromForm(Component component) {
        super.removeComponent(component);
    }

    void registerMediaComponent(Component component) {
        if (this.mediaComponents == null) {
            this.mediaComponents = new Vector();
        }
        if (!this.mediaComponents.contains(component)) {
            this.mediaComponents.addElement(component);
        }
    }

    public final boolean hasMedia() {
        return this.mediaComponents != null && this.mediaComponents.size() > 0;
    }

    void deregisterMediaComponent(Component component) {
        this.mediaComponents.removeElement(component);
    }

    public void registerAnimated(Animation animation) {
        if (this.animatableComponents == null) {
            this.animatableComponents = new Vector();
        }
        if (!this.animatableComponents.contains(animation)) {
            this.animatableComponents.addElement(animation);
        }
        Display.getInstance().notifyDisplay();
    }

    void registerAnimatedInternal(Animation animation) {
        if (this.internalAnimatableComponents == null) {
            this.internalAnimatableComponents = new Vector();
        }
        if (!this.internalAnimatableComponents.contains(animation)) {
            this.internalAnimatableComponents.addElement(animation);
        }
        Display.getInstance().notifyDisplay();
    }

    void deregisterAnimatedInternal(Animation animation) {
        if (this.internalAnimatableComponents != null) {
            this.internalAnimatableComponents.removeElement(animation);
        }
    }

    public void deregisterAnimated(Animation animation) {
        if (this.animatableComponents != null) {
            this.animatableComponents.removeElement(animation);
        }
    }

    int getFocusPosition(Component component) {
        this.initFocusDown();
        return this.focusDownSequence.indexOf(component);
    }

    int getFocusCount() {
        this.initFocusDown();
        return this.focusDownSequence.size();
    }

    void repaintAnimations() {
        if (this.animatableComponents != null) {
            this.loopAnimations(this.animatableComponents, null);
        }
        if (this.internalAnimatableComponents != null) {
            this.loopAnimations(this.internalAnimatableComponents, this.animatableComponents);
        }
    }

    private void loopAnimations(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            Animation animation = (Animation)vector.elementAt(i);
            if (animation == null || vector2 != null && vector2.contains(animation) || !animation.animate()) continue;
            if (animation instanceof Component) {
                Rectangle rectangle = ((Component)animation).getDirtyRegion();
                if (rectangle != null) {
                    Dimension dimension = rectangle.getSize();
                    if (dimension == null) continue;
                    ((Component)animation).repaint(rectangle.getX(), rectangle.getY(), dimension.getWidth(), dimension.getHeight());
                    continue;
                }
                ((Component)animation).repaint();
                continue;
            }
            Display.getInstance().repaint(animation);
        }
    }

    boolean hasAnimations() {
        return this.animatableComponents != null && this.animatableComponents.size() > 0 || this.internalAnimatableComponents != null && this.internalAnimatableComponents.size() > 0;
    }

    public void refreshTheme() {
        if (this.menuBar != null) {
            this.menuBar.refreshTheme();
        }
        if (this.titleArea != null) {
            this.titleArea.refreshTheme();
        }
        super.refreshTheme();
        this.revalidate();
    }

    public void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
    }

    public Transition getTransitionInAnimator() {
        return this.transitionInAnimator;
    }

    public void setTransitionInAnimator(Transition transition) {
        this.transitionInAnimator = transition;
    }

    public Transition getTransitionOutAnimator() {
        return this.transitionOutAnimator;
    }

    public void setTransitionOutAnimator(Transition transition) {
        this.transitionOutAnimator = transition;
    }

    public void addCommandListener(ActionListener actionListener) {
        if (this.commandListener == null) {
            this.commandListener = new EventDispatcher();
        }
        this.commandListener.addListener(actionListener);
    }

    public void removeCommandListener(ActionListener actionListener) {
        this.commandListener.removeListener(actionListener);
    }

    protected void actionCommand(Command command) {
    }

    public void dispatchCommand(Command command, ActionEvent actionEvent) {
        command.actionPerformed(actionEvent);
        if (!actionEvent.isConsumed()) {
            this.actionCommandImpl(command, actionEvent);
        }
    }

    void actionCommandImpl(Command command) {
        this.actionCommandImpl(command, new ActionEvent(command));
    }

    void actionCommandImpl(Command command, ActionEvent actionEvent) {
        if (command == null) {
            return;
        }
        if (comboLock) {
            if (command == this.menuBar.getCancelMenuItem()) {
                this.actionCommand(command);
                return;
            }
            Component component = this.getFocused();
            if (component != null) {
                component.fireClicked();
            }
            return;
        }
        if (command != this.menuBar.getSelectCommand()) {
            if (this.commandListener != null) {
                this.commandListener.fireActionEvent(actionEvent);
                if (actionEvent.isConsumed()) {
                    return;
                }
            }
            this.actionCommand(command);
        } else {
            Component component = this.getFocused();
            if (component != null) {
                component.fireClicked();
            }
        }
    }

    void initFocused() {
        if (this.focused == null) {
            this.setFocused(this.contentPane.findFirstFocusable());
            this.layoutContainer();
            this.initFocusDown();
            if (this.focusDownSequence == null) {
                this.initFocusDown();
                if (this.focusDownSequence.size() > 0) {
                    this.setFocused((Component)this.focusDownSequence.elementAt(0));
                }
            } else if (this.focusDownSequence.size() > 0) {
                this.setFocused((Component)this.focusDownSequence.elementAt(0));
            }
        }
    }

    public void show() {
        this.show(false);
    }

    public void showBack() {
        this.show(true);
    }

    private void show(boolean bl) {
        if (this.transitionOutAnimator == null && this.transitionInAnimator == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initFocused();
        this.onShow();
        this.tint = false;
        Display.getInstance().setCurrent(this, bl);
    }

    void initComponentImpl() {
        super.initComponentImpl();
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.tactileTouchDuration = lookAndFeel.getTactileTouchDuration();
        if (this.title.getText() != null && this.title.shouldTickerStart()) {
            this.title.startTicker(lookAndFeel.getTickerSpeed(), true);
        }
        if (Display.getInstance().isNativeCommands()) {
            Display.getInstance().getImplementation().setNativeCommands(this.menuBar.getCommands());
        }
    }

    public void setSmoothScrolling(boolean bl) {
        if (this.contentPane != null) {
            this.contentPane.setSmoothScrolling(bl);
        }
    }

    public boolean isSmoothScrolling() {
        return this.contentPane.isSmoothScrolling();
    }

    public int getScrollAnimationSpeed() {
        return this.contentPane.getScrollAnimationSpeed();
    }

    public void setScrollAnimationSpeed(int n) {
        this.contentPane.setScrollAnimationSpeed(n);
    }

    protected void onShow() {
    }

    protected void onShowCompleted() {
    }

    void onShowCompletedImpl() {
        this.onShowCompleted();
        if (this.showListener != null) {
            this.showListener.fireActionEvent(new ActionEvent(this));
        }
    }

    void showModal(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Display.getInstance().flushEdt();
        if (this.previousForm == null) {
            this.previousForm = Display.getInstance().getCurrent();
            if (this.previousForm == null) {
                this.previousForm = new Form();
                this.previousForm.show();
            } else if (this.previousForm instanceof Dialog && ((Dialog)(object = (Dialog)this.previousForm)).isDisposed()) {
                this.previousForm = Display.getInstance().getCurrentUpcoming();
            }
            this.previousForm.tint = true;
        }
        object = this.getStyle().getBgPainter();
        if (n > 0 || n2 > 0 || n3 > 0 || n4 > 0) {
            Style style = this.title.getStyle();
            Style style2 = this.contentPane.getUnselectedStyle();
            if (bl) {
                style.setMargin(0, n, false);
                style.setMargin(2, 0, false);
                style.setMargin(1, n3, false);
                style.setMargin(3, n4, false);
                style2.setMargin(0, 0, false);
                style2.setMargin(2, n2, false);
                style2.setMargin(1, n3, false);
                style2.setMargin(3, n4, false);
            } else {
                style.setMargin(0, 0, false);
                style.setMargin(2, 0, false);
                style.setMargin(1, 0, false);
                style.setMargin(3, 0, false);
                style2.setMargin(0, n, false);
                style2.setMargin(2, n2, false);
                style2.setMargin(1, n3, false);
                style2.setMargin(3, n4, false);
            }
            if (object instanceof Component.BGPainter && ((Component.BGPainter)object).getPreviousForm() != null) {
                ((Component.BGPainter)object).setPreviousForm(this.previousForm);
            } else {
                Component.BGPainter bGPainter = (Component)this.new Component.BGPainter(this, (Painter)object);
                this.getStyle().setBgPainter(bGPainter);
                bGPainter.setPreviousForm(this.previousForm);
            }
            this.revalidate();
        }
        this.initFocused();
        if (this.getTransitionOutAnimator() == null && this.getTransitionInAnimator() == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initComponentImpl();
        Display.getInstance().setCurrent(this, bl3);
        this.onShow();
        if (bl2) {
            Display.getInstance().invokeAndBlock(new RunnableWrapper(this, (Painter)object, bl3));
            Display.getInstance().setShowVirtualKeyboard(false);
        }
    }

    void showModal(boolean bl) {
        this.showDialog(true, bl);
    }

    void showDialog(boolean bl, boolean bl2) {
        int n = Display.getInstance().getDisplayHeight() - this.menuBar.getPreferredH() - this.title.getPreferredH();
        int n2 = Display.getInstance().getDisplayWidth();
        int n3 = n / 100 * 20;
        int n4 = n / 100 * 10;
        int n5 = n2 / 100 * 20;
        this.showModal(n3, n4, n5, n5, true, bl, bl2);
    }

    void dispose() {
        this.disposeImpl();
    }

    boolean isDisposed() {
        return false;
    }

    void disposeImpl() {
        if (this.previousForm != null) {
            this.previousForm.tint = false;
            if (this.previousForm instanceof Dialog) {
                if (!((Dialog)this.previousForm).isDisposed()) {
                    Display.getInstance().setCurrent(this.previousForm, false);
                }
            } else {
                Display.getInstance().setCurrent(this.previousForm, false);
            }
            this.previousForm = null;
        }
    }

    boolean isMenu() {
        return false;
    }

    void repaint(Component component) {
        if (this.isVisible()) {
            Display.getInstance().repaint(component);
        }
    }

    public final Form getComponentForm() {
        return this;
    }

    void hideMenu() {
        this.menuBar.unInstallMenuBar();
    }

    void restoreMenu() {
        this.menuBar.installMenuBar();
    }

    public void setFocused(Component component) {
        if (this.focused == component && component != null) {
            this.focused.repaint();
            return;
        }
        Component component2 = this.focused;
        this.focused = component;
        boolean bl = false;
        if (component2 != null && !(bl = this.changeFocusState(component2, false)) && component2.getParent() != null) {
            component2.repaint();
        }
        if (component != null && this.focused == component) {
            boolean bl2 = bl = this.changeFocusState(component, true) || bl;
            if (!bl) {
                component.repaint();
            }
        }
        if (bl) {
            this.revalidate();
        }
    }

    private boolean changeFocusState(Component component, boolean bl) {
        Dimension dimension;
        boolean bl2 = false;
        Style style = component.getSelectedStyle();
        Style style2 = component.getUnselectedStyle();
        if (!style.getFont().equals(style2.getFont()) || style.getPadding(false, 0) != style2.getPadding(false, 0) || style.getPadding(false, 2) != style2.getPadding(false, 2) || style.getPadding(this.isRTL(), 3) != style2.getPadding(this.isRTL(), 3) || style.getPadding(this.isRTL(), 1) != style2.getPadding(this.isRTL(), 1) || style.getMargin(false, 0) != style2.getMargin(false, 0) || style.getMargin(false, 2) != style2.getMargin(false, 2) || style.getMargin(this.isRTL(), 3) != style2.getMargin(this.isRTL(), 3) || style.getMargin(this.isRTL(), 1) != style2.getMargin(this.isRTL(), 1)) {
            bl2 = true;
        }
        int n = 0;
        int n2 = 0;
        if (bl2) {
            dimension = component.getPreferredSize();
            n = dimension.getWidth();
            n2 = dimension.getHeight();
        }
        if (bl) {
            component.setFocus(true);
            component.fireFocusGained();
            this.fireFocusGained(component);
        } else {
            component.setFocus(false);
            component.fireFocusLost();
            this.fireFocusLost(component);
        }
        if (bl2) {
            component.setShouldCalcPreferredSize(true);
            dimension = component.getPreferredSize();
            if (n != dimension.getWidth() || n2 != dimension.getHeight()) {
                component.setShouldCalcPreferredSize(false);
                bl2 = false;
            }
        }
        return bl2;
    }

    public Component getFocused() {
        return this.focused;
    }

    protected void longKeyPress(int n) {
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.longKeyPress(n);
        }
    }

    protected void longPointerPress(int n, int n2) {
        if (this.focused != null && this.focused.contains(n, n2) && this.focused.getComponentForm() == this) {
            this.focused.longPointerPress(n, n2);
        }
    }

    public void keyPressed(int n) {
        int n2 = Display.getInstance().getGameAction(n);
        if (this.menuBar.handlesKeycode(n)) {
            this.menuBar.keyPressed(n);
            return;
        }
        if (this.focused != null) {
            if (this.focused.isEnabled()) {
                this.focused.keyPressed(n);
            }
            if (this.focused == null) {
                this.initFocused();
                return;
            }
            if (this.focused.handlesInput()) {
                return;
            }
            if (this.focused.getComponentForm() == this) {
                if (this.focused != null && this.focused.handlesInput()) {
                    return;
                }
                this.updateFocus(n2);
            } else {
                this.initFocused();
            }
        } else {
            this.initFocused();
            if (this.focused == null) {
                this.contentPane.moveScrollTowards(n2, null);
                return;
            }
        }
    }

    public Layout getLayout() {
        return this.contentPane.getLayout();
    }

    public void keyReleased(int n) {
        Command command;
        int n2 = Display.getInstance().getGameAction(n);
        if (this.menuBar.handlesKeycode(n)) {
            this.menuBar.keyReleased(n);
            return;
        }
        if (this.focused != null && this.focused.getComponentForm() == this && this.focused.isEnabled()) {
            this.focused.keyReleased(n);
        }
        if (n2 == 8 && (command = this.getDefaultCommand()) != null) {
            command.actionPerformed(new ActionEvent(command, n));
            this.actionCommandImpl(command);
        }
        this.fireKeyEvent(this.keyListeners, n);
        this.fireKeyEvent(this.gameKeyListeners, n2);
    }

    private void fireKeyEvent(Hashtable hashtable, int n) {
        Vector vector;
        if (hashtable != null && (vector = (Vector)hashtable.get(new Integer(n))) != null) {
            ActionEvent actionEvent = new ActionEvent(this, n);
            for (int i = 0; i < vector.size(); ++i) {
                ((ActionListener)vector.elementAt(i)).actionPerformed(actionEvent);
                if (!actionEvent.isConsumed()) continue;
                return;
            }
        }
    }

    public void keyRepeated(int n) {
        if (this.focused != null) {
            if (this.focused.isEnabled()) {
                this.focused.keyRepeated(n);
            }
            int n2 = Display.getInstance().getGameAction(n);
            if (!(this.focused == null || this.focused.handlesInput() || n2 != 6 && n2 != 1 && n2 != 2 && n2 != 5)) {
                this.keyPressed(n);
                this.keyReleased(n);
            }
        } else {
            this.keyPressed(n);
            this.keyReleased(n);
        }
    }

    private void tactileTouchVibe(int n, int n2, Component component) {
        if (this.tactileTouchDuration > 0 && component.isTactileTouch(n, n2)) {
            Display.getInstance().vibrate(this.tactileTouchDuration);
        }
    }

    public void pointerPressed(int n, int n2) {
        if (this.pointerPressedListeners != null) {
            this.pointerPressedListeners.fireActionEvent(new ActionEvent(this, n, n2));
        }
        if (this.menuBar.contains(n, n2)) {
            Component component = this.menuBar.getComponentAt(n, n2);
            if (component != null && component.isEnabled()) {
                component.pointerPressed(n, n2);
                this.tactileTouchVibe(n, n2, component);
            }
            return;
        }
        if (n2 >= this.contentPane.getY()) {
            Component component = this.contentPane.getComponentAt(n, n2);
            if (component != null) {
                if (component.hasLead) {
                    Container container = component instanceof Container ? ((Container)component).getLeadParent() : component.getParent().getLeadParent();
                    container.repaint();
                    this.setFocused(container);
                    component.getLeadComponent().pointerPressed(n, n2);
                } else if (component.isEnabled()) {
                    if (component.isFocusable()) {
                        this.setFocused(component);
                    }
                    component.pointerPressed(n, n2);
                    this.tactileTouchVibe(n, n2, component);
                }
            }
        } else {
            Component component = this.titleArea.getComponentAt(n, n2);
            if (component != null && component.isEnabled() && component.isFocusable()) {
                component.pointerPressed(n, n2);
                this.tactileTouchVibe(n, n2, component);
            }
        }
    }

    public void addPointerPressedListener(ActionListener actionListener) {
        if (this.pointerPressedListeners == null) {
            this.pointerPressedListeners = new EventDispatcher();
        }
        this.pointerPressedListeners.addListener(actionListener);
    }

    public void removePointerPressedListener(ActionListener actionListener) {
        if (this.pointerPressedListeners != null) {
            this.pointerPressedListeners.removeListener(actionListener);
        }
    }

    public void addPointerReleasedListener(ActionListener actionListener) {
        if (this.pointerReleasedListeners == null) {
            this.pointerReleasedListeners = new EventDispatcher();
        }
        this.pointerReleasedListeners.addListener(actionListener);
    }

    public void removePointerReleasedListener(ActionListener actionListener) {
        if (this.pointerReleasedListeners != null) {
            this.pointerReleasedListeners.removeListener(actionListener);
        }
    }

    public void addPointerDraggedListener(ActionListener actionListener) {
        if (this.pointerDraggedListeners == null) {
            this.pointerDraggedListeners = new EventDispatcher();
        }
        this.pointerDraggedListeners.addListener(actionListener);
    }

    public void removePointerDraggedListener(ActionListener actionListener) {
        if (this.pointerDraggedListeners != null) {
            this.pointerDraggedListeners.removeListener(actionListener);
        }
    }

    public void pointerDragged(int n, int n2) {
        if (this.pointerDraggedListeners != null) {
            this.pointerDraggedListeners.fireActionEvent(new ActionEvent(this, n, n2));
        }
        if (this.dragged != null) {
            this.dragged.pointerDragged(n, n2);
            return;
        }
        Component component = this.contentPane.getComponentAt(n, n2);
        if (component != null) {
            if (component.isFocusable() && component.isEnabled()) {
                this.setFocused(component);
            }
            component.pointerDragged(n, n2);
            component.repaint();
        }
    }

    public void pointerHoverReleased(int[] nArray, int[] nArray2) {
        if (this.dragged != null) {
            this.dragged.pointerHoverReleased(nArray, nArray2);
            this.dragged = null;
            return;
        }
        Component component = this.contentPane.getComponentAt(nArray[0], nArray2[0]);
        if (component != null) {
            if (component.isFocusable() && component.isEnabled()) {
                this.setFocused(component);
            }
            component.pointerHoverReleased(nArray, nArray2);
            component.repaint();
        }
    }

    public void pointerHoverPressed(int[] nArray, int[] nArray2) {
        Component component = this.contentPane.getComponentAt(nArray[0], nArray2[0]);
        if (component != null) {
            if (component.isFocusable() && component.isEnabled()) {
                this.setFocused(component);
            }
            component.pointerHoverPressed(nArray, nArray2);
            component.repaint();
        }
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        if (this.dragged != null) {
            this.dragged.pointerHover(nArray, nArray2);
            return;
        }
        Component component = this.contentPane.getComponentAt(nArray[0], nArray2[0]);
        if (component != null) {
            if (component.isFocusable() && component.isEnabled()) {
                this.setFocused(component);
            }
            component.pointerHover(nArray, nArray2);
            component.repaint();
        }
    }

    public boolean isSingleFocusMode() {
        this.initFocusDown();
        return this.focusDownSequence.size() == 1;
    }

    public void pointerReleased(int n, int n2) {
        if (this.pointerReleasedListeners != null) {
            this.pointerReleasedListeners.fireActionEvent(new ActionEvent(this, n, n2));
        }
        if (this.dragged == null) {
            if (this.menuBar.contains(n, n2)) {
                Component component = this.menuBar.getComponentAt(n, n2);
                if (component != null && component.isEnabled()) {
                    component.pointerReleased(n, n2);
                }
                return;
            }
            if (n2 >= this.contentPane.getY()) {
                Component component = this.contentPane.getComponentAt(n, n2);
                if (component != null && component.isEnabled()) {
                    if (component.hasLead) {
                        Container container = component instanceof Container ? ((Container)component).getLeadParent() : component.getParent().getLeadParent();
                        container.repaint();
                        this.setFocused(container);
                        component.getLeadComponent().pointerReleased(n, n2);
                    } else if (component.isEnabled()) {
                        if (component.isFocusable()) {
                            this.setFocused(component);
                        }
                        component.pointerReleased(n, n2);
                    }
                }
            } else {
                Component component = this.titleArea.getComponentAt(n, n2);
                if (component != null && component.isEnabled()) {
                    component.pointerReleased(n, n2);
                }
            }
        } else {
            this.dragged.pointerReleased(n, n2);
            this.dragged = null;
        }
    }

    public void setScrollableY(boolean bl) {
        this.getContentPane().setScrollableY(bl);
    }

    public void setScrollableX(boolean bl) {
        this.getContentPane().setScrollableX(bl);
    }

    public int getComponentIndex(Component component) {
        return this.getContentPane().getComponentIndex(component);
    }

    public void addCommand(Command command, int n) {
        this.menuBar.addCommand(command, n);
    }

    public int getCommandCount() {
        return this.menuBar.getCommandCount();
    }

    public Command getCommand(int n) {
        return this.menuBar.getCommand(n);
    }

    public void addCommand(Command command) {
        this.addCommand(command, 0);
    }

    public void removeCommand(Command command) {
        this.menuBar.removeCommand(command);
    }

    public void setCyclicFocus(boolean bl) {
        this.cyclicFocus = bl;
    }

    public boolean isCyclicFocus() {
        return this.cyclicFocus;
    }

    private void updateFocus(int n) {
        Component component = this.getFocused();
        switch (n) {
            case 6: {
                Component component2 = component.getNextFocusDown();
                if (component2 != null && component2.getComponentForm() == this) {
                    component = component2;
                    break;
                }
                this.initFocusDown();
                int n2 = this.focusDownSequence.indexOf(component) + 1;
                if (this.focusDownSequence.size() <= 0) break;
                if (n2 == this.focusDownSequence.size()) {
                    n2 = this.cyclicFocus ? 0 : this.focusDownSequence.size() - 1;
                }
                component = (Component)this.focusDownSequence.elementAt(n2);
                break;
            }
            case 1: {
                Component component3 = component.getNextFocusUp();
                if (component3 != null && component3.getComponentForm() == this) {
                    component = component3;
                    break;
                }
                this.initFocusDown();
                if (this.focusDownSequence.size() <= 0) break;
                int n3 = this.focusDownSequence.indexOf(component) - 1;
                if (n3 < 0) {
                    n3 = this.cyclicFocus ? this.focusDownSequence.size() - 1 : 0;
                }
                component = (Component)this.focusDownSequence.elementAt(n3);
                break;
            }
            case 5: {
                Component component4 = component.getNextFocusRight();
                if (component4 != null && component4.getComponentForm() == this) {
                    component = component4;
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int n4 = this.focusRightSequence.indexOf(component) + 1;
                if (n4 == this.focusRightSequence.size()) {
                    n4 = this.cyclicFocus ? 0 : this.focusRightSequence.size() - 1;
                }
                component = (Component)this.focusRightSequence.elementAt(n4);
                break;
            }
            case 2: {
                Component component5 = component.getNextFocusLeft();
                if (component5 != null && component5.getComponentForm() == this) {
                    component = component5;
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int n5 = this.focusRightSequence.indexOf(component) - 1;
                if (n5 < 0) {
                    n5 = this.cyclicFocus ? this.focusRightSequence.size() - 1 : 0;
                }
                component = (Component)this.focusRightSequence.elementAt(n5);
                break;
            }
            default: {
                return;
            }
        }
        if (this.isFocusScrolling()) {
            this.setFocused(component);
            if (component != null) {
                this.scrollComponentToVisible(component);
            }
        } else if (this.moveScrollTowards(n, component)) {
            this.setFocused(component);
            this.scrollComponentToVisible(component);
        }
    }

    boolean moveScrollTowards(int n, Component component) {
        Component component2 = this.getFocused();
        if (component2 != null) {
            for (Container container = component2 instanceof Container ? (Container)component2 : component2.getParent(); container != null; container = container.getParent()) {
                if (!container.isScrollable()) continue;
                return container.moveScrollTowards(n, component);
            }
        }
        return true;
    }

    public void scrollComponentToVisible(Component component) {
        this.initFocused();
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!container.isScrollable()) continue;
            container.scrollComponentToVisible(component);
            return;
        }
    }

    public void setMenuCellRenderer(ListCellRenderer listCellRenderer) {
        this.menuBar.setMenuCellRenderer(listCellRenderer);
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
    }

    void requestFocus(Component component) {
        if (component.isFocusable() && this.contains(component)) {
            this.scrollComponentToVisible(component);
            this.setFocused(component);
        }
    }

    public void setRTL(boolean bl) {
        super.setRTL(bl);
        this.contentPane.setRTL(bl);
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        super.paint(graphics);
        if (this.tint) {
            graphics.setColor(this.tintColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight(), (byte)(this.tintColor >> 24 & 0xFF));
        }
    }

    public void setScrollable(boolean bl) {
        this.contentPane.setScrollable(bl);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.mediaComponents != null) {
            int n = this.mediaComponents.size();
            for (int i = 0; i < n; ++i) {
                Component component = (Component)this.mediaComponents.elementAt(i);
                component.setVisible(bl);
            }
        }
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int n) {
        this.tintColor = n;
    }

    public void setMenuTransitions(Transition transition, Transition transition2) {
        this.menuBar.setTransitions(transition, transition2);
    }

    protected String paramString() {
        return super.paramString() + ", title = " + this.title + ", visible = " + this.isVisible();
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public boolean isFocusScrolling() {
        return this.focusScrolling;
    }

    public void setFocusScrolling(boolean bl) {
        this.focusScrolling = bl;
    }
}

