/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Tabs
extends Container {
    private Container contentPane = new Container(new TabsLayout());
    private int tabPlacement = -1;
    private Container tabsContainer;
    private ButtonGroup radioGroup = new ButtonGroup();
    private Button selectedTab;
    private boolean swipeActivated = true;
    private ActionListener press;
    private ActionListener drag;
    private ActionListener release;
    private Motion slideToDestMotion;
    private int initialX = -1;
    private int initialY = -1;
    private int lastX = -1;
    private boolean dragStarted = false;
    private int activeComponent = 0;
    private EventDispatcher focusListeners;
    private TabFocusListener focusListener = new TabFocusListener();
    private boolean tabsFillRows;
    private boolean tabsGridLayout;
    private int textPosition = -1;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lcom$sun$lwuit$Image;

    public Tabs() {
        this(0);
    }

    public Tabs(int n) {
        super(new BorderLayout());
        this.contentPane.setUIID("TabbedPane");
        super.addComponent("Center", (Component)this.contentPane);
        this.tabsContainer = new Container();
        this.tabsContainer.setUIID("TabsContainer");
        this.tabsContainer.setScrollVisible(false);
        this.tabsContainer.getStyle().setMargin(0, 0, 0, 0);
        this.tabsFillRows = UIManager.getInstance().isThemeConstant("tabsFillRowsBool", false);
        this.tabsGridLayout = UIManager.getInstance().isThemeConstant("tabsGridBool", false);
        ((FlowLayout)this.tabsContainer.getLayout()).setFillRows(this.tabsFillRows);
        this.setTabPlacement(n);
        this.press = new SwipeListener(0);
        this.drag = new SwipeListener(1);
        this.release = new SwipeListener(2);
        this.setUIID("Tabs");
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.getComponentForm().registerAnimatedInternal(this);
    }

    protected void deinitialize() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.removePointerPressedListener(this.press);
            form.removePointerReleasedListener(this.release);
            form.removePointerDraggedListener(this.drag);
        }
        super.deinitialize();
    }

    protected void initComponent() {
        super.initComponent();
        Form form = this.getComponentForm();
        if (form != null && this.swipeActivated) {
            form.addPointerPressedListener(this.press);
            form.addPointerReleasedListener(this.release);
            form.addPointerDraggedListener(this.drag);
        }
    }

    public boolean animate() {
        boolean bl = super.animate();
        if (this.slideToDestMotion != null && this.swipeActivated) {
            int n;
            int n2 = this.slideToDestMotion.getValue();
            int n3 = this.contentPane.getComponentCount();
            for (n = 0; n < n3; ++n) {
                int n4;
                if (this.isRTL()) {
                    n4 = (n3 - n) * this.contentPane.getWidth();
                    n4 -= (n3 - this.activeComponent) * this.contentPane.getWidth();
                } else {
                    n4 = n * this.contentPane.getWidth();
                    n4 -= this.activeComponent * this.contentPane.getWidth();
                }
                Component component = this.contentPane.getComponentAt(n);
                component.setX(n4 += n2);
            }
            if (this.slideToDestMotion.isFinished()) {
                for (n = 0; n < this.contentPane.getComponentCount(); ++n) {
                    Component component = this.contentPane.getComponentAt(n);
                    component.paintLockRelease();
                }
                this.slideToDestMotion = null;
                this.deregisterAnimatedInternal();
                this.setSelectedIndex(this.activeComponent);
            }
            return true;
        }
        return bl;
    }

    void deregisterAnimatedInternal() {
        Form form;
        if ((this.slideToDestMotion == null || this.slideToDestMotion.isFinished()) && (form = this.getComponentForm()) != null) {
            form.deregisterAnimatedInternal(this);
        }
    }

    public void setTabTextPosition(int n) {
        if (n != 1 && n != 3 && n != 2 && n != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + n);
        }
        this.textPosition = n;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Button button = (Button)this.tabsContainer.getComponentAt(i);
            button.setTextPosition(n);
        }
    }

    public int getTabTextPosition() {
        return this.textPosition;
    }

    public void setTabPlacement(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement == n) {
            return;
        }
        this.tabPlacement = n;
        this.removeComponent(this.tabsContainer);
        if (n == 0 || n == 2) {
            if (this.tabsFillRows) {
                FlowLayout flowLayout = new FlowLayout();
                flowLayout.setFillRows(true);
                this.tabsContainer.setLayout(flowLayout);
            } else if (this.tabsGridLayout) {
                this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
            } else {
                this.tabsContainer.setLayout(new BoxLayout(1));
            }
            this.tabsContainer.setScrollableX(true);
            this.tabsContainer.setScrollableY(false);
            if (n == 0) {
                super.addComponent("North", (Component)this.tabsContainer);
            } else if (n == 2) {
                super.addComponent("South", (Component)this.tabsContainer);
            }
        } else {
            this.tabsContainer.setLayout(new BoxLayout(2));
            this.tabsContainer.setScrollableX(false);
            this.tabsContainer.setScrollableY(true);
            if (n == 1) {
                super.addComponent("West", (Component)this.tabsContainer);
            } else {
                super.addComponent("East", (Component)this.tabsContainer);
            }
        }
        this.initTabsFocus();
        this.tabsContainer.setShouldCalcPreferredSize(true);
        this.contentPane.setShouldCalcPreferredSize(true);
        this.revalidate();
    }

    public void addTab(String string, Image image, Component component) {
        this.insertTab(string, image, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(Button button, Component component) {
        this.insertTab(button, component, this.tabsContainer.getComponentCount());
    }

    public void insertTab(String string, Image image, Component component, int n) {
        RadioButton radioButton = new RadioButton(string != null ? string : "", image);
        radioButton.setToggle(true);
        this.radioGroup.add(radioButton);
        if (this.radioGroup.getButtonCount() == 1) {
            radioButton.setSelected(true);
        }
        if (this.textPosition != -1) {
            radioButton.setTextPosition(this.textPosition);
        }
        this.insertTab(radioButton, component, n);
    }

    public void insertTab(Button button, Component component, int n) {
        this.checkIndex(n);
        if (component == null) {
            return;
        }
        final Button button2 = button;
        button2.setUIID("Tab");
        button2.addFocusListener(this.focusListener);
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Tabs.this.selectedTab != null) {
                    Component component;
                    Tabs.this.selectedTab.setUIID("Tab");
                    Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                    Tabs.this.selectedTab.repaint();
                    int n = Tabs.this.tabsContainer.getComponentIndex(Tabs.this.selectedTab);
                    if (n != -1 && (component = Tabs.this.contentPane.getComponentAt(n)) instanceof Container) {
                        ((Container)component).setBlockFocus(true);
                    }
                }
                Tabs.this.activeComponent = Tabs.this.tabsContainer.getComponentIndex(button2);
                Component component = Tabs.this.contentPane.getComponentAt(Tabs.this.activeComponent);
                if (component instanceof Container) {
                    ((Container)component).setBlockFocus(false);
                }
                Tabs.this.initTabsFocus();
                Tabs.this.selectedTab = button2;
                Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                Tabs.this.tabsContainer.revalidate();
                Tabs.this.tabsContainer.scrollComponentToVisible(Tabs.this.selectedTab);
                Tabs.this.contentPane.revalidate();
            }
        });
        if (component instanceof Container) {
            ((Container)component).setBlockFocus(true);
        }
        this.tabsContainer.addComponent(n, (Component)button2);
        this.contentPane.addComponent(n, component);
        if (this.tabsGridLayout) {
            this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
        }
        if (this.tabsContainer.getComponentCount() == 1) {
            this.selectedTab = (Button)this.tabsContainer.getComponentAt(0);
            if (component instanceof Container) {
                ((Container)component).setBlockFocus(false);
            }
            this.initTabsFocus();
        }
    }

    public void setTabTitle(String string, Image image, int n) {
        this.checkIndex(n);
        Button button = (Button)this.tabsContainer.getComponentAt(n);
        button.setText(string);
        button.setIcon(image);
    }

    public String getTabTitle(int n) {
        this.checkIndex(n);
        return ((Button)this.tabsContainer.getComponentAt(n)).getText();
    }

    public Image getTabIcon(int n) {
        this.checkIndex(n);
        return ((Button)this.tabsContainer.getComponentAt(n)).getIcon();
    }

    public Image getTabSelectedIcon(int n) {
        this.checkIndex(n);
        return ((Button)this.tabsContainer.getComponentAt(n)).getPressedIcon();
    }

    public void setTabSelectedIcon(int n, Image image) {
        this.checkIndex(n);
        ((Button)this.tabsContainer.getComponentAt(n)).setPressedIcon(image);
    }

    public void removeTabAt(int n) {
        this.checkIndex(n);
        Component component = this.tabsContainer.getComponentAt(n);
        this.tabsContainer.removeComponent(component);
        Component component2 = this.contentPane.getComponentAt(n);
        this.contentPane.removeComponent(component2);
        if (this.tabsGridLayout) {
            this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
        }
    }

    public Component getTabComponentAt(int n) {
        this.checkIndex(n);
        return this.contentPane.getComponentAt(n);
    }

    private void checkIndex(int n) {
        if (n < 0 || n > this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    public int indexOfComponent(Component component) {
        return this.contentPane.getComponentIndex(component);
    }

    public int getTabCount() {
        return this.tabsContainer.getComponentCount();
    }

    public int getSelectedIndex() {
        if (this.tabsContainer != null) {
            return this.activeComponent;
        }
        return -1;
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getTabComponentAt(n);
    }

    public void addTabsFocusListener(FocusListener focusListener) {
        if (this.focusListeners == null) {
            this.focusListeners = new EventDispatcher();
        }
        this.focusListeners.addListener(focusListener);
    }

    public void removeTabsFocusListener(FocusListener focusListener) {
        if (this.focusListeners != null) {
            this.focusListeners.removeListener(focusListener);
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "[x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight() + ", tab placement = " + this.tabPlacement + ", tab count = " + this.getTabCount() + ", selected index = " + this.getSelectedIndex() + "]";
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Container getTabsContainer() {
        return this.tabsContainer;
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.tabsContainer.getComponentCount());
        }
        Button button = (Button)this.tabsContainer.getComponentAt(n);
        button.fireClicked();
    }

    public void hideTabs() {
        this.removeComponent(this.tabsContainer);
        this.revalidate();
    }

    public void showTabs() {
        int n = this.tabPlacement;
        this.tabPlacement = -1;
        this.setTabPlacement(n);
        this.revalidate();
    }

    public boolean isSwipeActivated() {
        return this.swipeActivated;
    }

    public void setSwipeActivated(boolean bl) {
        this.swipeActivated = bl;
    }

    private void initTabsFocus() {
        for (int i = 0; i < this.tabsContainer.getComponentCount(); ++i) {
            this.initTabFocus(this.tabsContainer.getComponentAt(i), this.contentPane.getComponentAt(this.activeComponent));
        }
    }

    private void initTabFocus(Component component, Component component2) {
        Component component3 = null;
        if (component2.isFocusable()) {
            component3 = component2;
        }
        if (component2 instanceof Container) {
            component3 = ((Container)component2).findFirstFocusable();
        }
        component.setNextFocusDown(null);
        component.setNextFocusUp(null);
        component.setNextFocusLeft(null);
        component.setNextFocusRight(null);
        if (component3 != null) {
            component3.setNextFocusDown(null);
            component3.setNextFocusUp(null);
            component3.setNextFocusLeft(null);
            component3.setNextFocusRight(null);
            switch (this.tabPlacement) {
                case 0: {
                    component.setNextFocusDown(component3);
                    component3.setNextFocusUp(this.tabsContainer.getComponentAt(this.activeComponent));
                    break;
                }
                case 2: {
                    component.setNextFocusUp(component3);
                    break;
                }
                case 1: {
                    component.setNextFocusRight(component3);
                    component3.setNextFocusLeft(this.tabsContainer.getComponentAt(this.activeComponent));
                    break;
                }
                case 3: {
                    component.setNextFocusLeft(component3);
                    component3.setNextFocusRight(this.tabsContainer.getComponentAt(this.activeComponent));
                }
            }
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"titles", "icons", "selectedIcons"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = Tabs.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Lcom$sun$lwuit$Image == null ? (array$Lcom$sun$lwuit$Image = Tabs.class$("[Lcom.sun.lwuit.Image;")) : array$Lcom$sun$lwuit$Image, array$Lcom$sun$lwuit$Image == null ? (array$Lcom$sun$lwuit$Image = Tabs.class$("[Lcom.sun.lwuit.Image;")) : array$Lcom$sun$lwuit$Image};
    }

    public Object getPropertyValue(String string) {
        if (string.equals("titles")) {
            String[] stringArray = new String[this.getTabCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.getTabTitle(i);
            }
            return stringArray;
        }
        if (string.equals("icons")) {
            Image[] imageArray = new Image[this.getTabCount()];
            for (int i = 0; i < imageArray.length; ++i) {
                imageArray[i] = this.getTabIcon(i);
            }
            return imageArray;
        }
        if (string.equals("selectedIcons")) {
            Image[] imageArray = new Image[this.getTabCount()];
            for (int i = 0; i < imageArray.length; ++i) {
                imageArray[i] = this.getTabSelectedIcon(i);
            }
            return imageArray;
        }
        return null;
    }

    public String setPropertyValue(String string, Object object) {
        if (string.equals("titles")) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < Math.min(this.getTabCount(), stringArray.length); ++i) {
                this.setTabTitle(stringArray[i], this.getTabIcon(i), i);
            }
            return null;
        }
        if (string.equals("icons")) {
            Image[] imageArray = (Image[])object;
            for (int i = 0; i < Math.min(this.getTabCount(), imageArray.length); ++i) {
                this.setTabTitle(this.getTabTitle(i), imageArray[i], i);
            }
            return null;
        }
        if (string.equals("selectedIcons")) {
            Image[] imageArray = (Image[])object;
            for (int i = 0; i < Math.min(this.getTabCount(), imageArray.length); ++i) {
                this.setTabSelectedIcon(i, imageArray[i]);
            }
            return null;
        }
        return super.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SwipeListener
    implements ActionListener {
        private static final int PRESS = 0;
        private static final int DRAG = 1;
        private static final int RELEASE = 2;
        private final int type;
        private boolean blockSwipe;
        private boolean riskySwipe;

        SwipeListener(int n) {
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Tabs.this.getComponentCount() == 0 || !Tabs.this.swipeActivated || Tabs.this.animate()) {
                return;
            }
            int n = actionEvent.getX();
            int n2 = actionEvent.getY();
            switch (this.type) {
                case 0: {
                    this.blockSwipe = false;
                    this.riskySwipe = false;
                    if (Tabs.this.contentPane.contains(n, n2)) {
                        Component component = Tabs.this.contentPane.getComponentAt(n, n2);
                        if (component != null && component != Tabs.this.contentPane) {
                            while (component != null && component != Tabs.this.contentPane) {
                                if (component.shouldBlockSideSwipe()) {
                                    Tabs.this.lastX = -1;
                                    Tabs.this.initialX = -1;
                                    this.blockSwipe = true;
                                    return;
                                }
                                if (component.isScrollable()) {
                                    if (component.isScrollableX()) {
                                        Tabs.this.lastX = -1;
                                        Tabs.this.initialX = -1;
                                        this.blockSwipe = true;
                                        return;
                                    }
                                    this.riskySwipe = true;
                                    break;
                                }
                                component = component.getParent();
                            }
                        }
                        Tabs.this.lastX = n;
                        Tabs.this.initialX = n;
                        Tabs.this.initialY = n2;
                    } else {
                        Tabs.this.lastX = -1;
                        Tabs.this.initialX = -1;
                        Tabs.this.initialY = -1;
                    }
                    Tabs.this.dragStarted = false;
                    break;
                }
                case 1: {
                    int n3;
                    if (this.blockSwipe) {
                        return;
                    }
                    if (!Tabs.this.dragStarted) {
                        if (this.riskySwipe) {
                            if (Math.abs(n - Tabs.this.initialX) < Math.abs(n2 - Tabs.this.initialY)) {
                                return;
                            }
                            Tabs.this.dragStarted = Math.abs(n - Tabs.this.initialX) > Tabs.this.contentPane.getWidth() / 5;
                        } else {
                            Tabs.this.dragStarted = Math.abs(n - Tabs.this.initialX) > Tabs.this.contentPane.getWidth() / 8;
                        }
                    }
                    if (Tabs.this.initialX == -1 || !Tabs.this.contentPane.contains(n, n2) || (n3 = n - Tabs.this.lastX) == 0 || !Tabs.this.dragStarted) break;
                    Tabs.this.lastX += n3;
                    int n4 = Tabs.this.contentPane.getComponentCount();
                    for (int i = 0; i < n4; ++i) {
                        Component component = Tabs.this.contentPane.getComponentAt(i);
                        component.setX(component.getX() + n3);
                        component.paintLock(false);
                    }
                    Tabs.this.repaint();
                    break;
                }
                case 2: {
                    int n5;
                    if (this.blockSwipe) {
                        return;
                    }
                    if (Tabs.this.initialX != -1 && (n5 = n - Tabs.this.initialX) != 0 && Tabs.this.dragStarted) {
                        if (Math.abs(n5) > Tabs.this.contentPane.getWidth() / 2) {
                            if (Tabs.this.isRTL()) {
                                n5 *= -1;
                            }
                            if (n5 > 0) {
                                Tabs.this.activeComponent--;
                                if (Tabs.this.activeComponent < 0) {
                                    Tabs.this.activeComponent = (Tabs.this.activeComponent = 0);
                                }
                            } else {
                                Tabs.this.activeComponent++;
                                if (Tabs.this.activeComponent >= Tabs.this.contentPane.getComponentCount()) {
                                    Tabs.this.activeComponent = Tabs.this.contentPane.getComponentCount() - 1;
                                }
                            }
                        }
                        int n6 = Tabs.this.contentPane.getComponentAt(Tabs.this.activeComponent).getX();
                        int n7 = 0;
                        Tabs.this.slideToDestMotion = Motion.createSplineMotion(n6, n7, 250);
                        Tabs.this.slideToDestMotion.start();
                        Form form = Tabs.this.getComponentForm();
                        if (form != null) {
                            form.registerAnimatedInternal(Tabs.this);
                        }
                    }
                    Tabs.this.lastX = -1;
                    Tabs.this.initialX = -1;
                    Tabs.this.dragStarted = false;
                }
            }
        }
    }

    class TabFocusListener
    implements FocusListener {
        TabFocusListener() {
        }

        public void focusGained(Component component) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(component);
            }
        }

        public void focusLost(Component component) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(component);
            }
        }
    }

    class TabsLayout
    extends Layout {
        TabsLayout() {
        }

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                if (Tabs.this.isRTL()) {
                    n2 = (n - i) * container.getWidth();
                    n2 -= (n - Tabs.this.activeComponent) * container.getWidth();
                } else {
                    n2 = i * container.getWidth();
                    n2 -= Tabs.this.activeComponent * container.getWidth();
                }
                Component component = container.getComponentAt(i);
                component.setX(component.getStyle().getMargin(1) + n2);
                component.setY(component.getStyle().getMargin(0));
                component.setWidth(container.getWidth() - component.getStyle().getMargin(1) - component.getStyle().getMargin(3));
                component.setHeight(container.getHeight() - component.getStyle().getMargin(0) - component.getStyle().getMargin(2));
            }
        }

        public Dimension getPreferredSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            dimension.setWidth(container.getWidth() + container.getStyle().getPadding(false, 1) + container.getStyle().getPadding(false, 3));
            dimension.setHeight(container.getHeight() + container.getStyle().getPadding(false, 0) + container.getStyle().getPadding(false, 2));
            int n = Tabs.this.contentPane.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension dimension2 = Tabs.this.contentPane.getComponentAt(i).getPreferredSizeWithMargin();
                dimension.setWidth(Math.max(dimension2.getWidth(), dimension.getWidth()));
                dimension.setHeight(Math.max(dimension2.getHeight(), dimension.getHeight()));
            }
            return dimension;
        }
    }
}

