/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class TextArea
extends Component {
    private static int defaultMaxSize = 124;
    private static boolean autoDegradeMaxSize = false;
    private static boolean hadSuccessfulEdit = false;
    private int linesToScroll = 1;
    private static final char ENTER_KEY = '\n';
    private String unsupportedChars = "\t\r";
    private static boolean useStringWidth;
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    private int constraint = 0;
    private String text = "";
    private boolean editable = true;
    private int maxSize = defaultMaxSize;
    private int rows = 1;
    private int columns = 3;
    private Vector rowStrings;
    private int widthForRowCalculations = -1;
    private int rowsGap = 2;
    private boolean triggerClose;
    private Vector actionListeners = null;
    private boolean growByContent = true;
    private static char widestChar;
    private boolean singleLineTextArea;
    private int currentRowWidth;
    private Label hintLabel;

    public TextArea(int n, int n2) {
        this("", defaultMaxSize, n, n2, 0);
    }

    public TextArea(int n, int n2, int n3) {
        this("", defaultMaxSize, n, n2, n3);
    }

    public TextArea(String string, int n, int n2) {
        this(string, defaultMaxSize, n, n2, 0);
    }

    public TextArea(String string, int n, int n2, int n3) {
        this(string, defaultMaxSize, n, n2, n3);
    }

    public TextArea(String string, int n) {
        this(string, n, 1, 3, 0);
    }

    public TextArea(String string) {
        this(string, Math.max(defaultMaxSize, string.length()), 1, 3, 0);
    }

    public TextArea() {
        this("");
    }

    private TextArea(String string, int n, int n2, int n3, int n4) {
        this.setUIID("TextArea");
        this.setSelectCommandText(UIManager.getInstance().localize("edit", "Edit"));
        this.maxSize = n;
        this.setText(string);
        this.setConstraint(n4);
        if (n2 <= 0) {
            throw new IllegalArgumentException("rows must be positive");
        }
        if (n3 <= 1 && n2 != 1) {
            throw new IllegalArgumentException("columns must be larger than 1");
        }
        this.rows = n2;
        this.columns = n3;
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(lookAndFeel.isDefaultSmoothScrolling());
    }

    public void setConstraint(int n) {
        this.constraint = n;
    }

    public int getConstraint() {
        return this.constraint;
    }

    public void setWidth(int n) {
        super.setWidth(n);
        this.getRowStrings();
    }

    public void setText(String string) {
        this.text = string != null ? string : "";
        this.setShouldCalcPreferredSize(true);
        if (this.maxSize < this.text.length()) {
            this.maxSize = this.text.length() + 1;
        }
        this.rowStrings = null;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public void keyPressed(int n) {
        super.keyPressed(n);
        int n2 = Display.getInstance().getGameAction(n);
        this.triggerClose = n2 == 8;
        Rectangle rectangle = new Rectangle(this.getScrollX(), this.getScrollY(), this.getWidth(), this.getHeight());
        Font font = this.getStyle().getFont();
        if (n2 == 6) {
            if (this.getScrollY() + this.getHeight() < (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines()) {
                rectangle.setY(rectangle.getY() + (font.getHeight() + this.rowsGap) * this.linesToScroll);
                this.scrollRectToVisible(rectangle, this);
            } else {
                this.setHandlesInput(false);
            }
        } else if (n2 == 1) {
            if (this.getScrollY() > 0) {
                rectangle.setY(Math.max(0, rectangle.getY() - (font.getHeight() + this.rowsGap) * this.linesToScroll));
                this.scrollRectToVisible(rectangle, this);
            } else {
                this.setHandlesInput(false);
            }
        }
        if (n2 == 5 || n2 == 2) {
            this.setHandlesInput(false);
        }
    }

    protected void fireClicked() {
        this.onClick();
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    public void keyReleased(int n) {
        int n2 = Display.getInstance().getGameAction(n);
        if (this.isEditable() && this.triggerClose && (n2 == 8 || this.isEnterKey(n))) {
            this.triggerClose = false;
            this.onClick();
            return;
        }
    }

    public boolean isScrollableY() {
        return this.isFocusable() && this.getScrollDimension().getHeight() > this.getHeight();
    }

    void onClick() {
        if (this.isEditable()) {
            this.editString();
        }
    }

    void editString() {
        if (autoDegradeMaxSize && !hadSuccessfulEdit && this.maxSize > 1024) {
            try {
                Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.maxSize -= 1024;
                TextArea.setDefaultMaxSize(this.maxSize);
                this.editString();
            }
        } else {
            Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
        }
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        this.requestFocus();
    }

    public void pointerHoverReleased(int[] nArray, int[] nArray2) {
        this.requestFocus();
    }

    public void pointerReleased(int n, int n2) {
        if (this.isDragActivated()) {
            super.pointerReleased(n, n2);
        } else {
            super.pointerReleased(n, n2);
            if (this.isEditable()) {
                this.onClick();
            }
        }
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        this.setHandlesInput(this.isScrollableY());
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.setHandlesInput(false);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getActualRows() {
        if (this.growByContent) {
            return Math.max(this.rows, this.getLines());
        }
        return this.rows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int n) {
        this.setShouldCalcPreferredSize(true);
        this.columns = n;
    }

    public void setRows(int n) {
        this.setShouldCalcPreferredSize(true);
        this.rows = n;
    }

    void initComponentImpl() {
        this.getRowStrings();
        super.initComponentImpl();
    }

    private Vector getRowStrings() {
        if (this.rowStrings == null || this.widthForRowCalculations != this.getWidth() - this.getUnselectedStyle().getPadding(false, 3) - this.getUnselectedStyle().getPadding(false, 1)) {
            this.initRowString();
            this.setShouldCalcPreferredSize(true);
        }
        return this.rowStrings;
    }

    public int getLines() {
        Vector vector = this.getRowStrings();
        int n = vector.size();
        return n;
    }

    public String getTextAt(int n) {
        Vector vector = this.getRowStrings();
        int n2 = vector.size();
        if (n2 == 0) {
            return "";
        }
        if (n >= n2) {
            return (String)vector.elementAt(n2 - 1);
        }
        return (String)vector.elementAt(n);
    }

    private int indexOf(char[] cArray, char c, int n, int n2) {
        for (int i = n; i < cArray.length && i < n + n2; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    protected char[] preprocess(String string) {
        return string.toCharArray();
    }

    private int updateRowWidth(char c, Font font) {
        this.currentRowWidth += font.charWidth(c);
        return this.currentRowWidth;
    }

    private boolean fastCharWidthCheck(char[] cArray, int n, int n2, int n3, int n4, Font font) {
        if (n2 * n4 < n3) {
            return true;
        }
        return font.charsWidth(cArray, n, n2 = Math.min(cArray.length, n2)) < n3;
    }

    private synchronized void initRowString() {
        int n;
        Style style = this.getUnselectedStyle();
        this.rowStrings = new Vector();
        this.widthForRowCalculations = this.getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1);
        if (this.isSingleLineTextArea() || this.widthForRowCalculations <= 0) {
            this.rowStrings.addElement(this.getText());
            return;
        }
        if (this.text == null || this.text.equals("")) {
            return;
        }
        char[] cArray = this.preprocess(this.getText());
        int n2 = this.rows;
        if (this.growByContent) {
            n2 = Math.max(n2, this.getLines());
        }
        Font font = style.getFont();
        int n3 = font.charWidth(widestChar);
        Style style2 = this.getSelectedStyle();
        if (style2.getFont() != style.getFont() && (n = style2.getFont().charWidth(widestChar)) > n3) {
            n3 = n;
            font = style2.getFont();
        }
        style = this.getStyle();
        n = style.getPadding(false, 3) + style.getPadding(false, 1);
        int n4 = this.getWidth() - n;
        int n5 = Math.max(1, n4 / n3);
        int n6 = 0;
        int n7 = 0;
        int n8 = n7 + n5;
        int n9 = cArray.length;
        if (n9 / n5 > Math.max(2, n2)) {
            n4 -= UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
            n4 -= n3 / 2;
        }
        String string = this.getUnsupportedChars();
        n8 = Math.max(Math.min(n9 - 1, n8), 0);
        while (n8 < n9) {
            int n10;
            int n11;
            if (n8 > n9) {
                n8 = n9;
            }
            int n12 = -1;
            String string2 = "";
            int n13 = n8;
            if (useStringWidth) {
                String string3 = "";
                for (n11 = n8; n11 < n9 && this.fastCharWidthCheck(cArray, n7, n11 - n7 + 1, n4, n3, font); ++n11) {
                    n10 = cArray[n11];
                    if (font.stringWidth(string3 = string3 + (char)n10) >= n4) break;
                    if (string.indexOf(n10) > -1) {
                        cArray[n11] = 32;
                        n10 = 32;
                    }
                    if (n10 == 32 || n10 == 10) {
                        n12 = n11;
                        if (n10 == 10) break;
                    }
                    ++n13;
                }
            } else {
                int n14;
                this.currentRowWidth = 0;
                if (n8 != n7) {
                    this.currentRowWidth = font.charsWidth(cArray, n7, n8 - n7);
                }
                for (n11 = n8; n11 < n9 && this.updateRowWidth((char)(n14 = cArray[n11]), font) < n4; ++n11) {
                    if (string.indexOf(n14) > -1) {
                        cArray[n11] = 32;
                        n14 = 32;
                    }
                    if (n14 == 32 || n14 == 10) {
                        n12 = n11;
                        if (n14 == 10) break;
                    }
                    ++n13;
                }
            }
            if (n11 == n9 || cArray[n11] == ' ' || cArray[n11] == '\n') {
                n12 = n11;
            }
            if (n12 != -1) {
                int n15 = this.indexOf(cArray, '\n', n7, n12 - n7);
                if (n15 > -1 && n15 < n12) {
                    n12 = n15;
                }
                string2 = new String(cArray, n7, n12 - n7);
                n7 = n12 + 1;
            } else {
                for (n11 = n8; n12 == -1 && n11 >= n7; --n11) {
                    char c = cArray[n11];
                    if (c != ' ' && c != '\n' && c != '\t') continue;
                    n12 = n11;
                    n10 = this.indexOf(cArray, '\n', n7, n11 - n7);
                    if (n10 > -1 && n10 < n12) {
                        n12 = n10;
                    }
                    string2 = new String(cArray, n7, n12 - n7);
                    n7 = n12 + 1;
                }
                if (n12 == -1) {
                    if (n13 <= 0) {
                        n13 = 1;
                    }
                    n12 = n13;
                    string2 = new String(cArray, n7, n12 - n7);
                    n7 = n12;
                }
            }
            this.rowStrings.addElement(string2);
            n8 = n7;
            ++n6;
        }
    }

    public int getRowsGap() {
        return this.rowsGap;
    }

    public void setRowsGap(int n) {
        this.rowsGap = n;
    }

    public void paint(Graphics graphics) {
        UIManager.getInstance().getLookAndFeel().drawTextArea(graphics, this);
        this.paintHint(graphics);
    }

    protected Dimension calcPreferredSize() {
        Label label;
        if (this.shouldShowHint() && (label = this.getHintLabelImpl()) != null) {
            Dimension dimension = UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, true);
            Dimension dimension2 = label.getPreferredSize();
            return new Dimension(dimension.getWidth() + dimension2.getWidth(), dimension.getHeight() + dimension2.getHeight());
        }
        return UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, true);
    }

    protected Dimension calcScrollSize() {
        return UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, false);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        if (!this.actionListeners.contains(actionListener)) {
            this.actionListeners.addElement(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.removeElement(actionListener);
    }

    void fireActionEvent() {
        if (this.actionListeners != null) {
            ActionEvent actionEvent = new ActionEvent(this);
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener actionListener = (ActionListener)this.actionListeners.elementAt(i);
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    void onEditComplete(String string) {
        this.setText(string);
        this.getParent().revalidate();
    }

    public static void setDefaultMaxSize(int n) {
        defaultMaxSize = n;
    }

    public boolean isGrowByContent() {
        return this.growByContent;
    }

    public void setGrowByContent(boolean bl) {
        this.growByContent = bl;
    }

    public static void setAutoDegradeMaxSize(boolean bl) {
        autoDegradeMaxSize = bl;
    }

    public static boolean isAutoDegradeMaxSize() {
        return autoDegradeMaxSize;
    }

    public String getUnsupportedChars() {
        return this.unsupportedChars;
    }

    public void setUnsupportedChars(String string) {
        this.unsupportedChars = string;
    }

    public int getLinesToScroll() {
        return this.linesToScroll;
    }

    public void setLinesToScroll(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("lines to scroll has to be >= 1");
        }
        this.linesToScroll = n;
    }

    public static void setWidestChar(char c) {
        widestChar = c;
    }

    public static char getWidestChar() {
        return widestChar;
    }

    public void setSingleLineTextArea(boolean bl) {
        this.singleLineTextArea = bl;
    }

    public boolean isSingleLineTextArea() {
        return this.singleLineTextArea;
    }

    public void setAlignment(int n) {
        this.getStyle().setAlignment(n);
    }

    public int getAlignment() {
        return this.getStyle().getAlignment();
    }

    public int getAbsoluteAlignment() {
        int n = this.getAlignment();
        if (this.isRTL()) {
            switch (n) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return n;
    }

    public boolean isPendingCommit() {
        return false;
    }

    public int getCursorPosition() {
        return -1;
    }

    public int getCursorY() {
        return -1;
    }

    public int getCursorX() {
        return -1;
    }

    public boolean isQwertyInput() {
        return false;
    }

    public String getInputMode() {
        return null;
    }

    public String[] getInputModeOrder() {
        return null;
    }

    public boolean isEnableInputScroll() {
        return false;
    }

    protected boolean isEnterKey(int n) {
        return n == 10;
    }

    public static void autoDetectWidestChar(String string) {
        Font font = UIManager.getInstance().getComponentStyle("TextArea").getFont();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n2 = font.charWidth(c);
            if (n2 <= n) continue;
            n = n2;
            TextArea.setWidestChar(c);
        }
    }

    public static boolean isUseStringWidth() {
        return useStringWidth;
    }

    public static void setUseStringWidth(boolean bl) {
        useStringWidth = bl;
    }

    public void setHint(String string) {
        super.setHint(string, this.getHintIcon());
    }

    public String getHint() {
        return super.getHint();
    }

    public void setHintIcon(Image image) {
        this.setHint(this.getHint(), image);
    }

    public Image getHintIcon() {
        return super.getHintIcon();
    }

    public void setHint(String string, Image image) {
        super.setHint(string, image);
    }

    Label getHintLabelImpl() {
        return this.hintLabel;
    }

    void setHintLabelImpl(Label label) {
        this.hintLabel = label;
    }

    boolean shouldShowHint() {
        return this.getText().equals("");
    }

    static {
        widestChar = (char)87;
    }
}

