/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Button
extends Label {
    public static final int STATE_ROLLOVER = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_DEFAULT = 2;
    private EventDispatcher dispatcher = new EventDispatcher();
    private int state = 2;
    private Image pressedIcon;
    private Image rolloverIcon;
    private Image rolloverPressedIcon;
    private Image disabledIcon;
    private Command cmd;
    private boolean toggle;

    public Button() {
        this("");
    }

    public Button(String string) {
        this(string, (Image)null);
    }

    public Button(Command command) {
        this(command.getCommandName(), command.getIcon());
        this.addActionListener(command);
        this.cmd = command;
        this.setEnabled(command.isEnabled());
        this.updateCommand();
    }

    private void updateCommand() {
        this.setRolloverIcon(this.cmd.getRolloverIcon());
        this.setDisabledIcon(this.cmd.getDisabledIcon());
        this.setPressedIcon(this.cmd.getPressedIcon());
    }

    public void setCommand(Command command) {
        if (this.cmd != null) {
            this.removeActionListener(this.cmd);
        }
        this.cmd = command;
        this.setText(command.getCommandName());
        this.setIcon(command.getIcon());
        this.setEnabled(command.isEnabled());
        this.updateCommand();
        this.addActionListener(command);
    }

    public Button(Image image) {
        this("", image);
    }

    public Button(String string, Image image) {
        super(string);
        this.setUIID("Button");
        this.setFocusable(true);
        this.setIcon(image);
        this.pressedIcon = image;
        this.rolloverIcon = image;
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.state != 1) {
            this.state = 0;
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.state = 2;
    }

    public int getState() {
        return this.state;
    }

    public Image getPressedIcon() {
        return this.pressedIcon;
    }

    public Image getRolloverPressedIcon() {
        return this.rolloverPressedIcon;
    }

    public void setRolloverPressedIcon(Image image) {
        this.rolloverPressedIcon = image;
    }

    public Image getDisabledIcon() {
        return this.disabledIcon;
    }

    public Image getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Image image) {
        this.rolloverIcon = image;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setPressedIcon(Image image) {
        this.pressedIcon = image;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setDisabledIcon(Image image) {
        this.disabledIcon = image;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form form;
        super.checkAnimation();
        if ((this.pressedIcon != null && this.pressedIcon.isAnimation() || this.rolloverIcon != null && this.rolloverIcon.isAnimation() || this.disabledIcon != null && this.disabledIcon.isAnimation()) && (form = this.getComponentForm()) != null) {
            form.registerAnimated(this);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.dispatcher.addListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.dispatcher.removeListener(actionListener);
    }

    public Image getIconFromState() {
        Image image = this.getIcon();
        if (!this.isEnabled() && this.getDisabledIcon() != null) {
            return this.getDisabledIcon();
        }
        if (this.isToggle() && this.isSelected()) {
            image = this.rolloverPressedIcon;
            if (image == null && (image = this.getPressedIcon()) == null) {
                image = this.getIcon();
            }
            return image;
        }
        switch (this.getState()) {
            case 2: {
                break;
            }
            case 1: {
                image = this.getPressedIcon();
                if (image != null) break;
                image = this.getIcon();
                break;
            }
            case 0: {
                if (!Display.getInstance().shouldRenderSelection() || (image = this.getRolloverIcon()) != null) break;
                image = this.getIcon();
            }
        }
        return image;
    }

    void fireActionEvent(int n, int n2) {
        Object object;
        super.fireActionEvent();
        if (this.cmd != null) {
            Form form;
            object = new ActionEvent(this.cmd, this, n, n2);
            this.dispatcher.fireActionEvent((ActionEvent)object);
            if (!((ActionEvent)object).isConsumed() && (form = this.getComponentForm()) != null) {
                form.actionCommandImpl(this.cmd, (ActionEvent)object);
            }
        } else {
            this.dispatcher.fireActionEvent(new ActionEvent(this, n, n2));
        }
        object = Display.getInstance();
        if (((Display)object).isBuiltinSoundsEnabled()) {
            ((Display)object).playBuiltinSound("press");
        }
    }

    public void pressed() {
        this.state = 1;
        this.repaint();
    }

    public void released() {
        this.released(-1, -1);
    }

    public void released(int n, int n2) {
        this.state = 0;
        this.fireActionEvent(n, n2);
        this.repaint();
    }

    public void keyPressed(int n) {
        if (Display.getInstance().getGameAction(n) == 8) {
            this.pressed();
        }
    }

    public void keyReleased(int n) {
        if (Display.getInstance().getGameAction(n) == 8) {
            this.released();
        }
    }

    public void keyRepeated(int n) {
    }

    protected void fireClicked() {
        this.pressed();
        this.released();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        this.requestFocus();
    }

    public void pointerHoverReleased(int[] nArray, int[] nArray2) {
        this.requestFocus();
    }

    public void pointerPressed(int n, int n2) {
        this.clearDrag();
        this.setDragActivated(false);
        this.pressed();
    }

    public void pointerReleased(int n, int n2) {
        if (this.state == 1) {
            this.released(n, n2);
        }
    }

    protected void dragInitiated() {
        this.state = Display.getInstance().shouldRenderSelection() ? 0 : 2;
        this.repaint();
    }

    public void pointerDragged(int n, int n2) {
        if (Display.getInstance().shouldRenderSelection()) {
            if (this.state != 0) {
                this.state = 0;
                this.repaint();
            }
        } else {
            this.state = 2;
            this.repaint();
        }
        super.pointerDragged(n, n2);
    }

    public void paint(Graphics graphics) {
        UIManager.getInstance().getLookAndFeel().drawButton(graphics, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getButtonPreferredSize(this);
    }

    protected Border getBorder() {
        return this.getStyle().getBorder();
    }

    boolean isPressedStyle() {
        if (this.toggle && this.isSelected()) {
            if (this.hasFocus()) {
                return !Display.getInstance().shouldRenderSelection();
            }
            return true;
        }
        return this.state == 1;
    }

    public Command getCommand() {
        return this.cmd;
    }

    public boolean isSelected() {
        throw new RuntimeException();
    }

    public void setAlignment(int n) {
        super.setAlignment(n);
        this.getPressedStyle().setAlignment(n);
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
        if (bl) {
            this.setUIID("ToggleButton");
        }
    }

    public boolean animate() {
        boolean bl = super.animate();
        if (!this.isEnabled() && this.disabledIcon != null) {
            bl = this.disabledIcon.isAnimation() && this.disabledIcon.animate() || bl;
        } else {
            switch (this.state) {
                case 0: {
                    bl = this.rolloverIcon != null && this.rolloverIcon.isAnimation() && this.rolloverIcon.animate() || bl;
                    break;
                }
                case 1: {
                    bl = this.pressedIcon != null && this.pressedIcon.isAnimation() && this.pressedIcon.animate() || bl;
                }
            }
        }
        return bl;
    }
}

