/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.M3G;
import com.sun.lwuit.animations.Transition;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public final class Transition3D
extends Transition
implements M3G.Callback {
    private static final int FLY_IN = 2;
    private static final int ROTATION = 1;
    private static final int CUBE_ROTATION = 3;
    private static final int STATIC_ROTATION = 4;
    private static final int SWING_IN = 5;
    private static final int VERTICAL_CUBE_ROTATION = 6;
    private int transitionType;
    private World world;
    private long startTime;
    private int duration = 1000;
    private static int maxTextureResolution = -1;
    private boolean rotateRight;
    private boolean highQualityMode;
    private boolean firstFinished;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private boolean firstTime = true;

    private Transition3D(int n) {
        this.transitionType = n;
    }

    public void cleanup() {
        super.cleanup();
        this.world = null;
        try {
            Graphics3D.getInstance().setCamera(null, null);
            Graphics3D.getInstance().resetLights();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.firstTime = true;
    }

    private static void initMaxTexture() {
        maxTextureResolution = M3G.getInstance().getMaxTextureDimension();
    }

    public static void setMaxTextureDimension(int n) {
        maxTextureResolution = n;
    }

    public static Transition3D createRotation(int n, boolean bl) {
        Transition3D.initMaxTexture();
        Transition3D transition3D = new Transition3D(1);
        transition3D.duration = n;
        transition3D.rotateRight = bl;
        return transition3D;
    }

    public static Transition3D createStaticRotation(int n, boolean bl) {
        Transition3D.initMaxTexture();
        Transition3D transition3D = new Transition3D(4);
        transition3D.duration = n;
        transition3D.rotateRight = bl;
        return transition3D;
    }

    public static Transition3D createSwingIn(int n) {
        return Transition3D.createSwingIn(n, true);
    }

    public static Transition3D createSwingIn(int n, boolean bl) {
        Transition3D.initMaxTexture();
        Transition3D transition3D = new Transition3D(5);
        transition3D.duration = n;
        transition3D.rotateRight = bl;
        return transition3D;
    }

    public static Transition3D createCube(int n, boolean bl) {
        Transition3D.initMaxTexture();
        Transition3D transition3D = new Transition3D(3);
        transition3D.duration = n;
        transition3D.rotateRight = bl;
        return transition3D;
    }

    public static Transition3D createVerticalCube(int n, boolean bl) {
        Transition3D.initMaxTexture();
        Transition3D transition3D = new Transition3D(6);
        transition3D.duration = n;
        transition3D.rotateRight = bl;
        return transition3D;
    }

    public static Transition3D createFlyIn(int n) {
        Transition3D.initMaxTexture();
        Transition3D transition3D = new Transition3D(2);
        transition3D.duration = n;
        return transition3D;
    }

    public Transition copy(boolean bl) {
        Transition3D transition3D = new Transition3D(this.transitionType);
        transition3D.duration = this.duration;
        transition3D.rotateRight = bl ? !this.rotateRight : this.rotateRight;
        return transition3D;
    }

    public boolean animate() {
        boolean bl;
        if (this.world == null) {
            return false;
        }
        long l = System.currentTimeMillis();
        int n = (int)(l - this.startTime);
        this.world.animate(n);
        if (this.firstFinished) {
            return false;
        }
        boolean bl2 = bl = n >= this.duration;
        if (bl && !this.firstFinished) {
            this.firstFinished = true;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.world == null) {
            return;
        }
        if (this.firstFinished) {
            this.getDestination().paintComponent(graphics);
            return;
        }
        Component component = this.getSource();
        int n = 0;
        if (component instanceof Dialog) {
            Dialog dialog = (Dialog)component;
            component = dialog.getContentPane();
            n = dialog.getTitleComponent().getHeight();
        } else if (this.getDestination() instanceof Dialog) {
            Dialog dialog = (Dialog)this.getDestination();
            component = dialog.getContentPane();
            n = dialog.getTitleComponent().getHeight();
        } else if (this.firstTime) {
            this.startTime = System.currentTimeMillis();
            this.firstTime = false;
        }
        if (this.firstTime) {
            this.startTime = System.currentTimeMillis();
            this.firstTime = false;
            if (this.getDestination() instanceof Dialog) {
                this.getSource().paintComponent(graphics);
            } else {
                this.getDestination().paintComponent(graphics);
            }
        }
        this.clipY = component.getAbsoluteY() - n;
        this.clipX = component.getAbsoluteX();
        this.clipW = component.getWidth();
        this.clipH = component.getHeight() + n;
        graphics.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
        M3G.getInstance().renderM3G(graphics, false, 2, this);
    }

    public void initTransition() {
        try {
            Component component = this.getSource();
            Component component2 = this.getDestination();
            if (component == null || component2 == null || component.getWidth() < 4 || component.getHeight() < 4 || component2.getWidth() < 4 || component2.getHeight() < 4) {
                return;
            }
            this.firstFinished = false;
            this.world = new World();
            Camera camera = new Camera();
            camera.setPerspective(30.0f, 1.0f, 1.0f, 45.0f);
            Transform transform = new Transform();
            Graphics3D graphics3D = Graphics3D.getInstance();
            graphics3D.setCamera(camera, transform);
            Group group = new Group();
            this.world.addChild((Node)group);
            this.world.setActiveCamera(camera);
            group.addChild((Node)camera);
            Background background = new Background();
            background.setColorClearEnable(true);
            background.setDepthClearEnable(true);
            background.setColor(0xFF000000 | component.getStyle().getBgColor());
            this.world.setBackground(background);
            switch (this.transitionType) {
                case 2: {
                    Mesh mesh = this.createMesh(component2);
                    group.addChild((Node)mesh);
                    this.createFlyIn(mesh, background);
                    break;
                }
                case 3: {
                    Mesh mesh = this.createMesh(component2);
                    this.createCubeRotation(group, mesh, false);
                    break;
                }
                case 6: {
                    Mesh mesh = this.createMesh(component2);
                    this.createCubeRotation(group, mesh, true);
                    break;
                }
                case 1: {
                    Mesh mesh = this.createMesh(component2);
                    group.addChild((Node)mesh);
                    this.createRotation(group, mesh);
                    break;
                }
                case 4: 
                case 5: {
                    Mesh mesh;
                    if (component instanceof Dialog) {
                        mesh = this.createMesh(component);
                        component = component2;
                    } else {
                        mesh = this.createMesh(component2);
                    }
                    this.createStaticRotation(group, mesh, background, component, this.transitionType == 5);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad 3D mode : " + this.transitionType);
                }
            }
            this.world.animate(0);
            this.startTime = System.currentTimeMillis();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.cleanup();
        }
    }

    private void createFlyIn(Mesh mesh, Background background) {
        Object object;
        background.setImage(this.createImage2D(this.getSource()));
        KeyframeSequence keyframeSequence = new KeyframeSequence(10, 3, 176);
        KeyframeSequence keyframeSequence2 = new KeyframeSequence(2, 1, 176);
        keyframeSequence2.setDuration(this.duration);
        keyframeSequence.setDuration(this.duration);
        keyframeSequence2.setKeyframe(0, 0, new float[]{0.1f});
        keyframeSequence2.setKeyframe(1, this.duration, new float[]{1.0f});
        int n = this.duration / 10;
        int n2 = 0;
        float f = -31.0f;
        for (int i = 0; i < 10; ++i) {
            object = new float[]{0.0f, 0.0f, f};
            keyframeSequence.setKeyframe(i, n2, (float[])object);
            f += 3.0f;
            n2 += n;
        }
        AnimationController animationController = new AnimationController();
        object = new AnimationTrack(keyframeSequence, 275);
        mesh.addAnimationTrack(object);
        object.setController(animationController);
        object = new AnimationTrack(keyframeSequence2, 256);
        mesh.addAnimationTrack(object);
        object.setController(animationController);
    }

    private void createCubeRotation(Group group, Mesh mesh, boolean bl) {
        Group group2 = new Group();
        group.addChild((Node)group2);
        Mesh mesh2 = this.createMesh(this.getSource());
        group2.addChild((Node)mesh);
        group2.addChild((Node)mesh2);
        mesh2.setTranslation(0.0f, 0.0f, 1.0f);
        group2.translate(0.0f, 0.0f, -4.7f);
        KeyframeSequence keyframeSequence = new KeyframeSequence(3, 4, 178);
        keyframeSequence.setDuration(this.duration);
        if (!bl) {
            if (this.rotateRight) {
                mesh.setOrientation(270.0f, 0.0f, 1.0f, 0.0f);
                mesh.setTranslation(-1.0f, 0.0f, 0.0f);
            } else {
                mesh.setOrientation(90.0f, 0.0f, 1.0f, 0.0f);
                mesh.setTranslation(1.0f, 0.0f, 0.0f);
            }
            keyframeSequence.setKeyframe(0, 0, this.getYRoation(0.0f));
            if (this.rotateRight) {
                keyframeSequence.setKeyframe(1, this.duration / 2, this.getYRoation(20.0f));
                keyframeSequence.setKeyframe(2, this.duration, this.getYRoation(45.0f));
            } else {
                keyframeSequence.setKeyframe(1, this.duration / 2, this.getYRoation(-20.0f));
                keyframeSequence.setKeyframe(2, this.duration, this.getYRoation(-45.0f));
            }
        } else {
            if (this.rotateRight) {
                mesh.setOrientation(270.0f, 1.0f, 0.0f, 0.0f);
                mesh.setTranslation(0.0f, 1.0f, 0.0f);
            } else {
                mesh.setOrientation(90.0f, 1.0f, 0.0f, 0.0f);
                mesh.setTranslation(0.0f, -1.0f, 0.0f);
            }
            keyframeSequence.setKeyframe(0, 0, this.getXRoationTop(0.0f));
            if (this.rotateRight) {
                keyframeSequence.setKeyframe(1, this.duration / 2, this.getXRoationTop(20.0f));
                keyframeSequence.setKeyframe(2, this.duration, this.getXRoationTop(45.0f));
            } else {
                keyframeSequence.setKeyframe(1, this.duration / 2, this.getXRoationTop(-20.0f));
                keyframeSequence.setKeyframe(2, this.duration, this.getXRoationTop(-45.0f));
            }
        }
        AnimationController animationController = new AnimationController();
        AnimationTrack animationTrack = new AnimationTrack(keyframeSequence, 268);
        group2.addAnimationTrack(animationTrack);
        animationTrack.setController(animationController);
    }

    private void createRotation(Group group, Mesh mesh) {
        Mesh mesh2 = this.createMesh(this.getSource());
        group.addChild((Node)mesh2);
        mesh2.setTranslation(0.0f, 0.0f, -3.79f);
        mesh.setTranslation(0.0f, 0.0f, -3.8f);
        KeyframeSequence keyframeSequence = new KeyframeSequence(3, 4, 178);
        KeyframeSequence keyframeSequence2 = new KeyframeSequence(3, 4, 178);
        keyframeSequence.setDuration(this.duration);
        keyframeSequence2.setDuration(this.duration);
        int n = 45;
        int n2 = 90;
        int n3 = 150;
        int n4 = 180;
        if (this.rotateRight) {
            n = -n;
            n2 = -n2;
            n3 = -n3;
            n4 = -n4;
        }
        keyframeSequence.setKeyframe(0, 0, this.getYRoation(0.0f));
        keyframeSequence.setKeyframe(1, this.duration / 4, this.getYRoation(n));
        keyframeSequence.setKeyframe(2, this.duration / 2, this.getYRoation(n2));
        keyframeSequence2.setKeyframe(0, 0, this.getYRoation(n2));
        keyframeSequence2.setKeyframe(1, this.duration / 2, this.getYRoation(n3));
        keyframeSequence2.setKeyframe(2, this.duration, this.getYRoation(n4));
        AnimationController animationController = new AnimationController();
        AnimationTrack animationTrack = new AnimationTrack(keyframeSequence, 268);
        mesh2.addAnimationTrack(animationTrack);
        animationTrack.setController(animationController);
        animationTrack = new AnimationTrack(keyframeSequence2, 268);
        mesh.addAnimationTrack(animationTrack);
        animationTrack.setController(animationController);
    }

    private void createStaticRotation(Group group, Mesh mesh, Background background, Component component, boolean bl) {
        Mesh mesh2;
        Group group2;
        KeyframeSequence keyframeSequence;
        background.setImage(this.createImage2D(component));
        int n = 90;
        int n2 = 180;
        int n3 = 135;
        AnimationController animationController = new AnimationController();
        if (bl) {
            keyframeSequence = new KeyframeSequence(5, 4, 178);
            keyframeSequence.setDuration(this.duration);
            group2 = new Group();
            group.addChild((Node)group2);
            group2.addChild((Node)mesh);
            if (this.rotateRight) {
                group2.translate(0.0f, 0.8f, -4.0f);
                mesh.translate(0.0f, -0.8f, 0.0f);
            } else {
                group2.translate(0.0f, -0.8f, -4.0f);
                mesh.translate(0.0f, 0.8f, 0.0f);
            }
            int n4 = this.duration / 4;
            if (component == this.getSource()) {
                keyframeSequence.setKeyframe(0, 0, this.getXRoationTop(n));
                keyframeSequence.setKeyframe(1, n4, this.getXRoationTop(n3));
                keyframeSequence.setKeyframe(2, n4 * 2, this.getXRoationTop(n2));
                keyframeSequence.setKeyframe(3, n4 * 3, this.getXRoationTop(n2 + n / 6));
                keyframeSequence.setKeyframe(4, this.duration, this.getXRoationTop(n2));
            } else {
                keyframeSequence.setKeyframe(0, 0, this.getXRoationTop(n2));
                keyframeSequence.setKeyframe(1, n4, this.getXRoationTop(n2 + n / 6));
                keyframeSequence.setKeyframe(2, n4 * 2, this.getXRoationTop(n2));
                keyframeSequence.setKeyframe(3, n4 * 3, this.getXRoationTop(n3));
                keyframeSequence.setKeyframe(4, this.duration, this.getXRoationTop(n));
            }
            mesh2 = group2;
        } else {
            if (this.rotateRight) {
                n = -n;
                n2 = -n2;
                n3 = -n3;
            }
            mesh.setTranslation(0.0f, 0.0f, -3.8f);
            keyframeSequence = new KeyframeSequence(3, 4, 178);
            keyframeSequence.setDuration(this.duration);
            group.addChild((Node)mesh);
            if (component == this.getSource()) {
                keyframeSequence.setKeyframe(0, 0, this.getYRoation(n));
                keyframeSequence.setKeyframe(1, this.duration / 2, this.getYRoation(n3));
                keyframeSequence.setKeyframe(2, this.duration, this.getYRoation(n2));
            } else {
                keyframeSequence.setKeyframe(0, 0, this.getYRoation(n2));
                keyframeSequence.setKeyframe(1, this.duration / 2, this.getYRoation(n3));
                keyframeSequence.setKeyframe(2, this.duration, this.getYRoation(n));
            }
            mesh2 = mesh;
        }
        group2 = new AnimationTrack(keyframeSequence, 268);
        mesh2.addAnimationTrack((AnimationTrack)group2);
        group2.setController(animationController);
    }

    private float[] getYRoation(float f) {
        f = (float)Math.toRadians(f);
        return new float[]{0.0f, (float)Math.sin(f), 0.0f, (float)Math.cos(f)};
    }

    private float[] getXRoationTop(float f) {
        f = (float)Math.toRadians(f);
        return new float[]{(float)Math.sin(f), 0.0f, 0.0f, (float)Math.cos(f)};
    }

    private Image2D createImage2D(Component component) {
        int n;
        int n2;
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        Dialog dialog = null;
        if (this.getSource() instanceof Dialog) {
            dialog = (Dialog)this.getSource();
            n3 = dialog.getContentPane().getWidth();
            n4 = dialog.getContentPane().getHeight() + dialog.getTitleComponent().getHeight();
        } else if (this.getDestination() instanceof Dialog) {
            dialog = (Dialog)this.getDestination();
            n3 = dialog.getContentPane().getWidth();
            n4 = dialog.getContentPane().getHeight() + dialog.getTitleComponent().getHeight();
        }
        if (this.highQualityMode) {
            int n5 = M3G.getInstance().getMaxTextureDimension();
            n2 = Math.min(M3G.closestHigherPowerOf2(n3 - 1), n5);
            n = Math.min(M3G.closestHigherPowerOf2(n4 - 1), n5);
        } else {
            n2 = Math.min(M3G.closestLowerPowerOf2(n3 + 1), maxTextureResolution);
            n = Math.min(M3G.closestLowerPowerOf2(n4 + 1), maxTextureResolution);
        }
        Image image = Image.createImage(n3, n4);
        Graphics graphics = image.getGraphics();
        if (component instanceof Dialog) {
            component = dialog.getContentPane();
            graphics.translate(-component.getAbsoluteX(), -component.getAbsoluteY() + dialog.getTitleComponent().getHeight());
            dialog.getContentPane().paintComponent(graphics, false);
            dialog.getTitleComponent().paintComponent(graphics, false);
        } else {
            if (dialog != null) {
                Container container = dialog.getContentPane();
                graphics.translate(-container.getAbsoluteX(), -container.getAbsoluteY() + dialog.getTitleComponent().getHeight());
            } else {
                graphics.translate(-component.getAbsoluteX(), -component.getAbsoluteY());
            }
            component.paintComponent(graphics);
        }
        image = image.scaled(n2, n);
        return M3G.getInstance().createImage2D(99, image);
    }

    private Mesh createMesh(Component component) {
        Texture2D texture2D = this.createTexture(this.createImage2D(component));
        CompositingMode compositingMode = new CompositingMode();
        compositingMode.setBlending(64);
        compositingMode.setAlphaWriteEnable(true);
        compositingMode.setDepthTestEnable(true);
        Appearance appearance = new Appearance();
        PolygonMode polygonMode = new PolygonMode();
        polygonMode.setPerspectiveCorrectionEnable(true);
        appearance.setPolygonMode(polygonMode);
        appearance.setCompositingMode(compositingMode);
        appearance.setTexture(0, texture2D);
        VertexBuffer vertexBuffer = this.makeGeometry();
        int[] nArray = new int[]{1, 2, 0, 3};
        int[] nArray2 = new int[]{4};
        TriangleStripArray triangleStripArray = new TriangleStripArray(nArray, nArray2);
        Mesh mesh = new Mesh(vertexBuffer, (IndexBuffer)triangleStripArray, appearance);
        return mesh;
    }

    private VertexBuffer makeGeometry() {
        short[] sArray = new short[]{-1, -1, 0, 1, -1, 0, 1, 1, 0, -1, 1, 0};
        VertexArray vertexArray = new VertexArray(sArray.length / 3, 3, 2);
        vertexArray.set(0, sArray.length / 3, sArray);
        short[] sArray2 = new short[]{0, 1, 1, 1, 1, 0, 0, 0};
        VertexArray vertexArray2 = new VertexArray(sArray2.length / 2, 2, 2);
        vertexArray2.set(0, sArray2.length / 2, sArray2);
        VertexBuffer vertexBuffer = new VertexBuffer();
        vertexBuffer.setPositions(vertexArray, 1.0f, null);
        vertexBuffer.setTexCoords(0, vertexArray2, 1.0f, null);
        return vertexBuffer;
    }

    private Texture2D createTexture(Image2D image2D) {
        Texture2D texture2D = new Texture2D(image2D);
        texture2D.setFiltering(210, 210);
        texture2D.setWrapping(240, 240);
        texture2D.setBlending(228);
        return texture2D;
    }

    public void paintM3G(Graphics3D graphics3D) {
        graphics3D.render(this.world);
    }

    public boolean isHighQualityMode() {
        return this.highQualityMode;
    }

    public void setHighQualityMode(boolean bl) {
        this.highQualityMode = bl;
    }
}

