/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.VideoComponent;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.impl.midp.MMAPIPlayer;
import com.sun.lwuit.plaf.UIManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public class GameCanvasImplementation
extends LWUITImplementation {
    private static boolean NOKIA = false;
    private boolean minimized;
    private MIDlet mid;
    private Object currentlyPlayingAudio;
    private static int[] portableKeyCodes;
    private static int[] portableKeyCodeValues;
    private int alpha = 255;
    private int[] rgbArr;
    private int volume = -1;
    private Canvas canvas;
    private static final AlertType[] TYPES;
    static javax.microedition.lcdui.Command CONFIRM_COMMAND;
    private long lastVibrate;
    static javax.microedition.lcdui.Command CANCEL_COMMAND;
    TextBox currentTextBox;
    Component currentTextComponent;
    private boolean flushGraphicsBug;
    static javax.microedition.lcdui.Display display;
    static int[] leftSK;
    static int[] rightSK;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    private static boolean drawNegativeOffsetsInRGB;

    protected Canvas createCanvas() {
        return new C();
    }

    public int getKeyboardType() {
        String string = System.getProperty("com.nokia.keyboard.type");
        if (string != null) {
            if ("None".equalsIgnoreCase(string)) {
                if (this.isTouchDevice()) {
                    return 3;
                }
                return 1;
            }
            if ("PhoneKeypad".equalsIgnoreCase(string)) {
                return 1;
            }
            if ("HalfKeyboard".equalsIgnoreCase(string)) {
                return 4;
            }
            if ("FullKeyboard".equalsIgnoreCase(string)) {
                return 2;
            }
            if ("LimitedKeyboard4x10".equalsIgnoreCase(string)) {
                return 2;
            }
            if ("LimitedKeyboard3x11".equalsIgnoreCase(string)) {
                return 2;
            }
        }
        return super.getKeyboardType();
    }

    public void init(Object object) {
        this.canvas = this.createCanvas();
        this.canvas.setTitle(null);
        this.canvas.setFullScreenMode(!Display.getInstance().isNativeCommands());
        String string = System.getProperty("microedition.platform");
        if (string != null && string.toUpperCase().indexOf("NOKIA") >= 0) {
            this.flushGraphicsBug = false;
            NOKIA = true;
            Display.getInstance().setTransitionYield(1);
        } else {
            this.flushGraphicsBug = true;
            Display.getInstance().setTransitionYield(-1);
        }
        this.mid = (MIDlet)object;
        display = javax.microedition.lcdui.Display.getDisplay((MIDlet)this.mid);
        this.setSoftKeyCodes(this.mid);
    }

    private void setSoftKeyCodes(MIDlet mIDlet) {
        int n;
        this.setKnownSoftKeyCodes();
        try {
            n = this.getGameAction(backSK);
            if (n == 1 || n == 6 || n == 5 || n == 2 || n == 8) {
                backSK = -50000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = this.getGameAction(clearSK);
            if (n == 1 || n == 6 || n == 5 || n == 2 || n == 8) {
                clearSK = -50000;
            }
            if ((n = this.getGameAction(backspaceSK)) == 1 || n == 6 || n == 5 || n == 2 || n == 8) {
                backspaceSK = -50000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = mIDlet.getAppProperty("SoftKey-Right");
        if (string != null && !"".equals(string)) {
            GameCanvasImplementation.rightSK[0] = Integer.valueOf(string);
        }
        if ((string = mIDlet.getAppProperty("SoftKey-Right2")) != null && !"".equals(string)) {
            rightSK = new int[]{rightSK[0], Integer.valueOf(string)};
        }
        if ((string = mIDlet.getAppProperty("SoftKey-Left")) != null && !"".equals(string)) {
            GameCanvasImplementation.leftSK[0] = Integer.valueOf(string);
        }
        if ((string = mIDlet.getAppProperty("SoftKey-Back")) != null && !"".equals(string)) {
            backSK = Integer.valueOf(string);
        }
        if ((string = mIDlet.getAppProperty("SoftKey-Clear")) != null && !"".equals(string)) {
            clearSK = Integer.valueOf(string);
        }
        if ((string = mIDlet.getAppProperty("SoftKey-Backspace")) != null && !"".equals(string)) {
            backspaceSK = Integer.valueOf(string);
        }
        if ((string = mIDlet.getAppProperty("isThirdSoftButtonSupported")) != null && "true".equals(string.toLowerCase().trim())) {
            Display.getInstance().setThirdSoftButton(true);
        }
    }

    private void setKnownSoftKeyCodes() {
        try {
            Class.forName("com.siemens.mp.game.Light");
            GameCanvasImplementation.leftSK[0] = -1;
            GameCanvasImplementation.rightSK[0] = -4;
            clearSK = -12;
            backspaceSK = -12;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.motorola.phonebook.PhoneBookRecord");
                GameCanvasImplementation.leftSK[0] = -21;
                GameCanvasImplementation.rightSK[0] = -22;
                return;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("com.nokia.mid.ui.FullCanvas");
                    GameCanvasImplementation.leftSK[0] = -6;
                    GameCanvasImplementation.rightSK[0] = -7;
                    clearSK = -8;
                    backspaceSK = -8;
                    String string = System.getProperty("microedition.platform");
                    if (string != null && string.toUpperCase().indexOf("NOKIA") >= 0) {
                        backspaceSK = 8;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        Class.forName("net.rim.device.api.system.Application");
                        GameCanvasImplementation.leftSK[0] = 113;
                        rightSK = new int[]{112, 111};
                        clearSK = 8;
                        backspaceSK = 8;
                        return;
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        try {
                            Class.forName("com.mot.iden.util.Base64");
                            clearSK = -5000;
                            backspaceSK = -5000;
                            GameCanvasImplementation.leftSK[0] = -20;
                            GameCanvasImplementation.rightSK[0] = -21;
                            this.setFireValue(-23);
                            return;
                        }
                        catch (Throwable throwable2) {
                            try {
                                Class.forName("mmpp.media.MediaPlayer");
                                clearSK = -204;
                                backspaceSK = -204;
                            }
                            catch (ClassNotFoundException classNotFoundException4) {
                                // empty catch block
                            }
                            try {
                                if (this.canvas.getKeyName(-6).toUpperCase().indexOf("SOFT") >= 0) {
                                    GameCanvasImplementation.leftSK[0] = -6;
                                    GameCanvasImplementation.rightSK[0] = -7;
                                    return;
                                }
                                if (this.canvas.getKeyName(21).toUpperCase().indexOf("SOFT") >= 0) {
                                    GameCanvasImplementation.leftSK[0] = 21;
                                    GameCanvasImplementation.rightSK[0] = 22;
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boolean bl = false;
                            boolean bl2 = false;
                            for (int i = -127; i < 127; ++i) {
                                if (bl && bl2) {
                                    return;
                                }
                                try {
                                    if (this.canvas.getKeyName(i).toUpperCase().indexOf("SOFT") < 0) continue;
                                    if (this.canvas.getKeyName(i).indexOf("1") >= 0) {
                                        GameCanvasImplementation.leftSK[0] = i;
                                        bl = true;
                                    }
                                    if (this.canvas.getKeyName(i).indexOf("2") < 0) continue;
                                    GameCanvasImplementation.rightSK[0] = i;
                                    bl2 = true;
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    void setFireValue(int n) {
        try {
            this.getKeyCode(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameCanvasImplementation.portableKeyCodeValues[4] = n;
    }

    public void vibrate(int n) {
        long l = System.currentTimeMillis();
        if (l > this.lastVibrate) {
            this.lastVibrate = l + (long)(n * 3);
            display.vibrate(n);
        }
    }

    public void flashBacklight(int n) {
        display.flashBacklight(n);
    }

    public int getDisplayWidth() {
        return this.canvas.getWidth();
    }

    public int getDisplayHeight() {
        return this.canvas.getHeight();
    }

    public void editString(Component component, int n, int n2, String string) {
        UIManager uIManager = UIManager.getInstance();
        CONFIRM_COMMAND = new javax.microedition.lcdui.Command(uIManager.localize("ok", "OK"), 4, 1);
        CANCEL_COMMAND = new javax.microedition.lcdui.Command(uIManager.localize("cancel", "Cancel"), 3, 2);
        this.currentTextBox = new TextBox("", "", n, 0);
        this.currentTextBox.setCommandListener((CommandListener)this.canvas);
        this.currentTextBox.addCommand(CONFIRM_COMMAND);
        this.currentTextBox.addCommand(CANCEL_COMMAND);
        this.currentTextComponent = component;
        this.currentTextBox.setMaxSize(n);
        this.currentTextBox.setString(string);
        this.currentTextBox.setConstraints(n2);
        display.setCurrent((Displayable)this.currentTextBox);
        ((C)this.canvas).setDone(false);
        Display.getInstance().invokeAndBlock((C)this.canvas);
    }

    public void saveTextEditingState() {
        if (this.currentTextBox != null) {
            String string = this.currentTextBox.getString();
            Display.getInstance().onEditingComplete(this.currentTextComponent, string);
            this.currentTextBox = null;
            ((C)this.canvas).setDone(true);
        }
    }

    public void setFlashGraphicsBug(boolean bl) {
        this.flushGraphicsBug = bl;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    public void flushGraphics(int n, int n2, int n3, int n4) {
        Form form = this.getCurrentForm();
        if (!this.flushGraphicsBug || form != null && form.hasMedia()) {
            ((C)this.canvas).flushGraphics(n, n2, n3, n4);
        } else {
            ((C)this.canvas).flushGraphics();
        }
    }

    public void flushGraphics() {
        ((C)this.canvas).flushGraphics();
    }

    public void getRGB(Object object, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        ((Image)object).getRGB(nArray, n, n4, n2, n3, n4, n5);
    }

    public Object createImage(int[] nArray, int n, int n2) {
        return Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
    }

    public Object createImage(String string) throws IOException {
        return Image.createImage((String)string);
    }

    public Object createImage(InputStream inputStream) throws IOException {
        return Image.createImage((InputStream)inputStream);
    }

    public Object createMutableImage(int n, int n2, int n3) {
        Image image = Image.createImage((int)n, (int)n2);
        if (n3 != -1) {
            javax.microedition.lcdui.Graphics graphics = image.getGraphics();
            graphics.setColor(n3);
            graphics.fillRect(0, 0, n, n2);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
        return image;
    }

    public Object createImage(byte[] byArray, int n, int n2) {
        return Image.createImage((byte[])byArray, (int)n, (int)n2);
    }

    public int getImageWidth(Object object) {
        return ((Image)object).getWidth();
    }

    public int getImageHeight(Object object) {
        return ((Image)object).getHeight();
    }

    public Object scale(Object object, int n, int n2) {
        Image image = (Image)object;
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        if (n3 == n && n4 == n2) {
            return image;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n * n2];
        this.scaleArray(image, n3, n4, n2, n, nArray, nArray2);
        return this.createImage(nArray2, n, n2);
    }

    private void scaleArray(Image image, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = (n2 << 16) / n3;
        int n6 = (n << 16) / n4;
        int n7 = n6 / 2;
        int n8 = n5 / 2;
        for (int i = 0; i < n3; ++i) {
            int n9 = n8 >> 16;
            this.getRGB(image, nArray, 0, 0, n9, n, 1);
            for (int j = 0; j < n4; ++j) {
                int n10 = n7 >> 16;
                int n11 = j + i * n4;
                if (n11 >= 0 && n11 < nArray2.length && n10 < nArray.length) {
                    nArray2[n11] = nArray[n10];
                }
                n7 += n6;
            }
            n8 += n5;
            n7 = n6 / 2;
        }
    }

    public void drawImageRotated(Object object, Object object2, int n, int n2, int n3) {
        int n4;
        Image image = (Image)object2;
        switch (n3 % 360) {
            case 0: {
                this.drawImage(object, object2, n, n2);
                return;
            }
            case 90: {
                n4 = 5;
                break;
            }
            case 180: {
                n4 = 3;
                break;
            }
            case 270: {
                n4 = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value for drawImageRotated: " + n3);
            }
        }
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), n4, n, n2, 20);
    }

    public boolean isRotationDrawingSupported() {
        return true;
    }

    public int getSoftkeyCount() {
        return 2;
    }

    public int[] getSoftkeyCode(int n) {
        if (n == 0) {
            return leftSK;
        }
        if (n == 1) {
            return rightSK;
        }
        return null;
    }

    public int getClearKeyCode() {
        return clearSK;
    }

    public int getBackspaceKeyCode() {
        return backspaceSK;
    }

    public int getBackKeyCode() {
        return backSK;
    }

    public int getGameAction(int n) {
        try {
            if (n >= 48) {
                return 0;
            }
            if (portableKeyCodes != null) {
                for (int i = 0; i < portableKeyCodeValues.length; ++i) {
                    if (portableKeyCodeValues[i] != n) continue;
                    return portableKeyCodes[i];
                }
            }
            return this.canvas.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    public int getKeyCode(int n) {
        int n2;
        if (portableKeyCodes == null) {
            portableKeyCodes = new int[]{6, 2, 5, 1, 8};
            portableKeyCodeValues = new int[5];
            n2 = -500;
            int n3 = 0;
            while (n3 < portableKeyCodeValues.length) {
                --n2;
                try {
                    if (this.canvas.getGameAction(n2) != 0) {
                        continue;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                GameCanvasImplementation.portableKeyCodeValues[n3] = n2;
                ++n3;
            }
        }
        for (n2 = 0; n2 < portableKeyCodes.length; ++n2) {
            if (portableKeyCodes[n2] != n) continue;
            return portableKeyCodeValues[n2];
        }
        return 0;
    }

    public boolean isTouchDevice() {
        return this.canvas.hasPointerEvents();
    }

    public void setNativeFont(Object object, Object object2) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.setFont(this.font(object2));
    }

    public int getClipX(Object object) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        return graphics.getClipX();
    }

    public int getClipY(Object object) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        return graphics.getClipY();
    }

    public int getClipWidth(Object object) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        return graphics.getClipWidth();
    }

    public int getClipHeight(Object object) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        return graphics.getClipHeight();
    }

    public void setClip(Object object, int n, int n2, int n3, int n4) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.setClip(n, n2, n3, n4);
    }

    public void clipRect(Object object, int n, int n2, int n3, int n4) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.clipRect(n, n2, n3, n4);
    }

    public void drawLine(Object object, int n, int n2, int n3, int n4) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawLine(n, n2, n3, n4);
    }

    public void fillRect(Object object, int n, int n2, int n3, int n4) {
        if (this.isAlphaGlobal()) {
            javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
            graphics.fillRect(n, n2, n3, n4);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            return;
        }
        if (this.alpha == 0) {
            return;
        }
        if (this.alpha == 255) {
            javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
            graphics.fillRect(n, n2, n3, n4);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        } else {
            int n5;
            int n6 = this.alpha << 24;
            int n7 = this.getColor(object) & 0xFFFFFF;
            n7 |= n6;
            if (this.rgbArr == null || this.rgbArr.length < n3) {
                this.rgbArr = new int[n3];
            }
            for (n5 = 0; n5 < n3; ++n5) {
                this.rgbArr[n5] = n7;
            }
            n5 = n;
            int n8 = n2;
            if (n5 < 0 && n5 + n3 > 0) {
                n3 = n5 + n3;
                n5 = 0;
            }
            if (n3 < 0) {
                return;
            }
            int n9 = this.getClipY(object);
            int n10 = this.getClipHeight(object);
            int n11 = n10 + n9;
            for (int i = 0; i < n4; ++i) {
                int n12;
                if (n5 < 0 || n8 + i < 0 || (n12 = n8 + i) < n9 || n12 > n11) continue;
                this.drawRGB(object, this.rgbArr, 0, n5, n12, n3, 1, true);
            }
        }
    }

    public void drawRect(Object object, int n, int n2, int n3, int n4) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawRect(n, n2, n3, n4);
    }

    public void drawRoundRect(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void drawArc(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void setColor(Object object, int n) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.setColor(n);
    }

    public int getColor(Object object) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        return graphics.getColor();
    }

    public void setAlpha(Object object, int n) {
        this.alpha = n;
    }

    public int getAlpha(Object object) {
        return this.alpha;
    }

    public void drawString(Object object, String string, int n, int n2) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawString(string, n, n2, 20);
    }

    public void drawImage(Object object, Object object2, int n, int n2) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.drawImage((Image)object2, n, n2, 20);
    }

    public void fillTriangle(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        graphics.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    public void drawRGB(Object object, int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        javax.microedition.lcdui.Graphics graphics = (javax.microedition.lcdui.Graphics)object;
        int n6 = n2;
        int n7 = n3;
        if (n6 >= 0 && n7 >= 0) {
            graphics.drawRGB(nArray, n, n4, n6, n7, n4, n5, bl);
            return;
        }
        if (drawNegativeOffsetsInRGB) {
            try {
                graphics.drawRGB(nArray, n, n4, n6, n7, n4, n5, bl);
                return;
            }
            catch (RuntimeException runtimeException) {
                drawNegativeOffsetsInRGB = false;
            }
        }
        if (n6 < 0 && n6 + n4 > 0 && n4 < nArray.length) {
            for (int i = 1; i <= nArray.length / n4; ++i) {
                n = -n6 + n4 * (i - 1);
                if (++n7 < 0) continue;
                graphics.drawRGB(nArray, n, n4 + n6, 0, n7, n4 + n6, 1, bl);
            }
        }
    }

    public Object getVideoControl(Object object) {
        VideoControl videoControl = (VideoControl)((Player)object).getControl("VideoControl");
        videoControl.initDisplayMode(1, (Object)this.canvas);
        return videoControl;
    }

    public int numAlphaLevels() {
        return display.numAlphaLevels();
    }

    public int numColors() {
        return display.numColors();
    }

    public void playDialogSound(int n) {
        if (--n >= 0 && n < TYPES.length) {
            TYPES[n].playSound(display);
        }
    }

    public void confirmControlView() {
        if (display == null) {
            throw new IllegalStateException("First call Display.setDisplay(javax.microedition.lcdui.Display d) method");
        }
        if (display.getCurrent() != this.canvas || !this.canvas.isShown()) {
            this.setCurrent((Displayable)this.canvas);
        }
    }

    private void setCurrent(Displayable displayable) {
        if (display == null) {
            throw new IllegalStateException("First call Display.setDisplay(javax.microedition.lcdui.Display d) method");
        }
        if (!this.minimized) {
            if (displayable instanceof Canvas) {
                ((Canvas)displayable).setFullScreenMode(!Display.getInstance().isNativeCommands());
            }
            display.setCurrent(displayable);
        }
    }

    public Object getNativeGraphics() {
        return ((C)this.canvas).getGraphics();
    }

    public Object getNativeGraphics(Object object) {
        return ((Image)object).getGraphics();
    }

    public void translate(Object object, int n, int n2) {
    }

    public int getTranslateX(Object object) {
        return 0;
    }

    public int getTranslateY(Object object) {
        return 0;
    }

    public int charsWidth(Object object, char[] cArray, int n, int n2) {
        if (NOKIA) {
            return this.font(object).stringWidth(new String(cArray, n, n2));
        }
        return this.font(object).charsWidth(cArray, n, n2);
    }

    public int stringWidth(Object object, String string) {
        return this.font(object).stringWidth(string);
    }

    public int charWidth(Object object, char c) {
        return this.font(object).charWidth(c);
    }

    public int getHeight(Object object) {
        return this.font(object).getHeight();
    }

    public Object createFont(int n, int n2, int n3) {
        return Font.getFont((int)n, (int)n2, (int)n3);
    }

    public Object getDefaultFont() {
        return Font.getDefaultFont();
    }

    public int getFace(Object object) {
        return this.font(object).getFace();
    }

    public int getSize(Object object) {
        return this.font(object).getSize();
    }

    public int getStyle(Object object) {
        return this.font(object).getStyle();
    }

    private Font font(Object object) {
        if (object == null) {
            return (Font)this.getDefaultFont();
        }
        return (Font)object;
    }

    public VideoComponent createVideoPeer(String string) throws IOException {
        try {
            Player player = Manager.createPlayer((String)string);
            player.realize();
            return new MIDPVideoComponent(player);
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            throw new IOException(mediaException.toString());
        }
    }

    public VideoComponent createVideoPeer(InputStream inputStream, String string) throws IOException {
        try {
            Player player = Manager.createPlayer((InputStream)inputStream, (String)string);
            player.realize();
            return new MIDPVideoComponent(player);
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            throw new IOException(mediaException.toString());
        }
    }

    private VideoControl getVideoControl(VideoComponent videoComponent) {
        VideoControl videoControl = (VideoControl)videoComponent.getClientProperty("VideoControl");
        if (videoControl != null) {
            return videoControl;
        }
        videoControl = (VideoControl)((Player)videoComponent.getNativePeer()).getControl("VideoControl");
        videoControl.initDisplayMode(1, (Object)this.canvas);
        videoComponent.putClientProperty("VideoControl", videoControl);
        return videoControl;
    }

    public Object createVideoComponent(Object object) {
        if (((Player)object).getState() < 200) {
            throw new IllegalArgumentException("player must be in a realized state");
        }
        return this.getVideoControl(object);
    }

    public int getVideoWidth(Object object) {
        return ((VideoControl)object).getSourceWidth();
    }

    public int getVideoHeight(Object object) {
        return ((VideoControl)object).getSourceHeight();
    }

    public void setVideoVisible(Object object, boolean bl) {
        ((VideoControl)object).setVisible(bl);
    }

    public void startVideo(Object object, Object object2) {
        try {
            ((VideoControl)object2).setVisible(true);
            ((Player)object).start();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void stopVideo(Object object, Object object2) {
        try {
            ((Player)object).stop();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void setVideoLoopCount(Object object, int n) {
        ((Player)object).setLoopCount(n);
    }

    public long getMediaTime(Object object) {
        return ((Player)object).getMediaTime();
    }

    public long setMediaTime(Object object, long l) {
        try {
            return ((Player)object).setMediaTime(l);
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            throw new RuntimeException(mediaException.toString());
        }
    }

    public void paintVideo(Component component, boolean bl, Object object, Object object2, Object object3) {
        try {
            VideoControl videoControl = (VideoControl)object2;
            if (bl) {
                videoControl.setDisplayLocation(0, 0);
                videoControl.setDisplaySize(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
            } else {
                videoControl.setDisplayLocation(component.getAbsoluteX(), component.getAbsoluteY());
                int n = component.getWidth();
                int n2 = component.getHeight();
                if (videoControl.getDisplayWidth() != n || videoControl.getDisplayHeight() != n2) {
                    videoControl.setDisplaySize(n, n2);
                }
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public boolean minimizeApplication() {
        try {
            this.minimized = true;
            display.setCurrent(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public void restoreMinimizedApplication() {
        try {
            this.minimized = false;
            display.setCurrent((Displayable)this.canvas);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void showNativeScreen(Object object) {
        display.setCurrent((Displayable)object);
    }

    public void setNativeCommands(Vector vector) {
        this.canvas.setFullScreenMode(!Display.getInstance().isNativeCommands());
        ((C)this.canvas).setCommands(vector);
    }

    public void exitApplication() {
        this.mid.notifyDestroyed();
    }

    public String getProperty(String string, String string2) {
        String string3;
        if ("AppName".equals(string)) {
            return this.mid.getAppProperty("MIDlet-Name");
        }
        if ("AppVersion".equals(string)) {
            return this.mid.getAppProperty("MIDlet-Version");
        }
        if ("Platform".equals(string)) {
            return System.getProperty("microedition.platform");
        }
        if ("OS".equals(string)) {
            return "J2ME";
        }
        if ("IMEI".equals(string)) {
            string3 = null;
            string3 = System.getProperty("phone.imei");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.nokia.IMEI");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.nokia.mid.imei");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.sonyericsson.imei");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("IMEI");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.motorola.IMEI");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.samsung.imei");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.siemens.imei");
            if (string3 != null) {
                return string3;
            }
            string3 = System.getProperty("com.lge.imei");
            if (string3 != null) {
                return string3;
            }
        }
        if ((string3 = this.mid.getAppProperty(string)) == null) {
            return string2;
        }
        return string3;
    }

    public void execute(String string) {
        try {
            this.mid.platformRequest(string);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            connectionNotFoundException.printStackTrace();
        }
    }

    public void playBuiltinSound(String string) {
        if (!this.playUserSound(string)) {
            if (string.equals("alarm")) {
                AlertType.ALARM.playSound(display);
                return;
            }
            if (string.equals("confirmation")) {
                AlertType.CONFIRMATION.playSound(display);
                return;
            }
            if (string.equals("error")) {
                AlertType.ERROR.playSound(display);
                return;
            }
            if (string.equals("info")) {
                AlertType.INFO.playSound(display);
                return;
            }
            if (string.equals("warning")) {
                AlertType.WARNING.playSound(display);
                return;
            }
        }
    }

    protected void playNativeBuiltinSound(Object object) {
        try {
            try {
                Object object2 = this.createAudio(new ByteArrayInputStream((byte[])object), "audio/mpeg", null);
                this.playAudio(object2);
            }
            catch (Exception exception) {
                Object object3 = this.createAudio(new ByteArrayInputStream((byte[])object), "audio/mp3", null);
                this.playAudio(object3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isBuiltinSoundAvailable(String string) {
        if (string.equals("alarm")) {
            return true;
        }
        if (string.equals("confirmation")) {
            return true;
        }
        if (string.equals("error")) {
            return true;
        }
        if (string.equals("info")) {
            return true;
        }
        if (string.equals("warning")) {
            return true;
        }
        return super.isBuiltinSoundAvailable(string);
    }

    public Object createAudio(String string, Runnable runnable) throws IOException {
        return MMAPIPlayer.createAudio(string, runnable);
    }

    public Object createAudio(InputStream inputStream, String string, Runnable runnable) throws IOException {
        return MMAPIPlayer.createAudio(inputStream, string, runnable);
    }

    public void cleanupAudio(Object object) {
        ((MMAPIPlayer)object).cleanupAudio();
    }

    public void playAudio(Object object) {
        ((MMAPIPlayer)object).playAudio();
    }

    public void pauseAudio(Object object) {
        ((MMAPIPlayer)object).pauseAudio();
    }

    public int getAudioTime(Object object) {
        return ((MMAPIPlayer)object).getAudioTime();
    }

    public void setAudioTime(Object object, int n) {
        ((MMAPIPlayer)object).setAudioTime(n);
    }

    public int getAudioDuration(Object object) {
        return ((MMAPIPlayer)object).getAudioDuration();
    }

    public void setVolume(int n) {
        MMAPIPlayer.setVolume(n);
    }

    public int getVolume() {
        return MMAPIPlayer.getVolume();
    }

    static {
        TYPES = new AlertType[]{AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR, AlertType.INFO, AlertType.WARNING};
        leftSK = new int[]{-6};
        rightSK = new int[]{-7};
        backSK = -11;
        clearSK = -8;
        backspaceSK = -8;
        drawNegativeOffsetsInRGB = true;
    }

    class MIDPVideoComponent
    extends VideoComponent {
        private boolean fullscreen;

        MIDPVideoComponent(Player player) {
            super(player);
            this.putClientProperty("Player", player);
        }

        public int getMediaDuration() {
            return (int)(((Player)this.getNativePeer()).getDuration() / 1000L);
        }

        public boolean isPlaying() {
            return ((Player)this.getNativePeer()).getState() == 400;
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            GameCanvasImplementation.this.getVideoControl(this).setVisible(bl);
        }

        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    VideoControl videoControl = GameCanvasImplementation.this.getVideoControl(this);
                    if (this.isFullScreen()) {
                        videoControl.setDisplayLocation(0, 0);
                        videoControl.setDisplaySize(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                    } else {
                        videoControl.setDisplayLocation(this.getAbsoluteX(), this.getAbsoluteY());
                        int n = this.getWidth();
                        int n2 = this.getHeight();
                        if (videoControl.getDisplayWidth() != n || videoControl.getDisplayHeight() != n2) {
                            videoControl.setDisplaySize(n, n2);
                        }
                    }
                }
                catch (MediaException mediaException) {
                    mediaException.printStackTrace();
                }
            }
        }

        protected Dimension calcPreferredSize() {
            VideoControl videoControl = GameCanvasImplementation.this.getVideoControl(this);
            return new Dimension(videoControl.getDisplayWidth(), videoControl.getDisplayHeight());
        }

        public void start() {
            try {
                GameCanvasImplementation.this.getVideoControl(this).setVisible(true);
                ((Player)this.getNativePeer()).start();
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
                throw new RuntimeException(mediaException.toString());
            }
        }

        public void stop() {
            try {
                ((Player)this.getNativePeer()).stop();
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
                throw new RuntimeException(mediaException.toString());
            }
        }

        public void setLoopCount(int n) {
            ((Player)this.getNativePeer()).setLoopCount(n);
        }

        public int getMediaTimeMS() {
            return (int)(((Player)this.getNativePeer()).getMediaTime() / 1000L);
        }

        public int setMediaTimeMS(int n) {
            try {
                return (int)(((Player)this.getNativePeer()).setMediaTime((long)(n * 1000)) / 1000L);
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
                throw new RuntimeException(mediaException.toString());
            }
        }

        public void setFullScreen(boolean bl) {
            this.fullscreen = bl;
            this.repaint();
        }

        public boolean isFullScreen() {
            return this.fullscreen;
        }
    }

    private class C
    extends GameCanvas
    implements CommandListener,
    Runnable {
        private boolean done;
        private javax.microedition.lcdui.Command[] currentCommands;
        private javax.microedition.lcdui.Graphics gfx;

        public void setCommands(Vector vector) {
            if (this.currentCommands != null) {
                for (int i = 0; i < this.currentCommands.length; ++i) {
                    this.removeCommand(this.currentCommands[i]);
                }
            }
            this.setCommandListener(this);
            this.currentCommands = new javax.microedition.lcdui.Command[vector.size()];
            Command command = null;
            if (Display.getInstance().getCurrent() != null) {
                command = Display.getInstance().getCurrent().getBackCommand();
            }
            for (int i = 0; i < this.currentCommands.length; ++i) {
                Command command2 = (Command)vector.elementAt(i);
                this.currentCommands[i] = command2 == command ? new MIDP2LWUITCommand(command2, 2, i + 1) : (i == 0 ? new MIDP2LWUITCommand(command2, 4, i + 1) : new MIDP2LWUITCommand(command2, i + 1));
                this.addCommand(this.currentCommands[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.done) {
                Object object = GameCanvasImplementation.this.getDisplayLock();
                synchronized (object) {
                    try {
                        GameCanvasImplementation.this.getDisplayLock().wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDone(boolean bl) {
            this.done = bl;
            Object object = GameCanvasImplementation.this.getDisplayLock();
            synchronized (object) {
                GameCanvasImplementation.this.getDisplayLock().notify();
            }
        }

        public void commandAction(javax.microedition.lcdui.Command command, Displayable displayable) {
            if (displayable == GameCanvasImplementation.this.currentTextBox) {
                display.setCurrent((Displayable)GameCanvasImplementation.this.canvas);
                if (command == CONFIRM_COMMAND) {
                    String string = GameCanvasImplementation.this.currentTextBox.getString();
                    Display.getInstance().onEditingComplete(GameCanvasImplementation.this.currentTextComponent, string);
                }
                GameCanvasImplementation.this.currentTextBox = null;
                ((C)GameCanvasImplementation.this.canvas).setDone(true);
            } else if (command instanceof MIDP2LWUITCommand) {
                final Command command2 = ((MIDP2LWUITCommand)command).internal;
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        Display.getInstance().getCurrent().dispatchCommand(command2, new ActionEvent(command2));
                    }
                });
            }
        }

        C() {
            super(false);
        }

        public javax.microedition.lcdui.Graphics getGraphics() {
            if (this.gfx == null) {
                this.gfx = super.getGraphics();
            }
            return this.gfx;
        }

        protected void keyPressed(int n) {
            GameCanvasImplementation.this.keyPressed(n);
        }

        protected void keyReleased(int n) {
            GameCanvasImplementation.this.keyReleased(n);
        }

        protected void pointerDragged(int n, int n2) {
            GameCanvasImplementation.this.pointerDragged(n, n2);
        }

        protected void pointerPressed(int n, int n2) {
            GameCanvasImplementation.this.pointerPressed(n, n2);
        }

        protected void pointerReleased(int n, int n2) {
            GameCanvasImplementation.this.pointerReleased(n, n2);
        }

        protected void sizeChanged(int n, int n2) {
            GameCanvasImplementation.this.sizeChanged(n, n2);
        }

        protected void hideNotify() {
            GameCanvasImplementation.this.hideNotify();
        }

        protected void showNotify() {
            GameCanvasImplementation.this.showNotify();
        }

        class MIDP2LWUITCommand
        extends javax.microedition.lcdui.Command {
            Command internal;

            public MIDP2LWUITCommand(Command command, int n) {
                super(command.getCommandName(), 1, n);
                this.internal = command;
            }

            public MIDP2LWUITCommand(Command command, int n, int n2) {
                super(command.getCommandName(), n, n2);
                this.internal = command;
            }
        }
    }
}

