/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.DirectGraphics;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DirectGraphicsImplemented
implements DirectGraphics {
    private Graphics my_g = null;

    protected DirectGraphicsImplemented(Graphics g2) {
        this.my_g = g2;
    }

    public void setARGBColor(int argbColor) {
        this.my_g.setColor(argbColor);
    }

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        this.my_g.setColor(argbColor);
        this.my_g.drawLine(x1, y1, x2, y2);
        this.my_g.drawLine(x2, y2, x3, y3);
        this.my_g.drawLine(x3, y3, x1, y1);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        this.drawTriangle(x1, y1, x2, y2, x3, y3, argbColor);
    }

    public void drawPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        this.my_g.setColor(argbColor);
        int i2 = 0;
        while (i2 < nPoints - 1) {
            this.my_g.drawLine(xPoints[xOffset + i2], yPoints[yOffset + i2], xPoints[xOffset + i2 + 1], yPoints[yOffset + i2 + 1]);
            ++i2;
        }
    }

    public void fillPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        this.drawPolygon(xPoints, xOffset, yPoints, yOffset, nPoints, argbColor);
    }

    public int getNativePixelFormat() {
        return 888;
    }

    public int getAlphaComponent() {
        return 0;
    }

    public void drawImage(Image img, int x, int y, int anchor, int manipulation) {
        this.my_g.drawImage(img, x, y, anchor);
    }

    public void drawPixels(int[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        int i2 = x;
        while (i2 < x + width) {
            int j2 = y;
            while (j2 < y + height) {
                this.my_g.setColor(pixels[offset + (i2 - x) + (j2 - y) * scanlength]);
                this.my_g.drawLine(i2, j2, i2, j2);
                ++j2;
            }
            ++i2;
        }
    }

    public void drawPixels(short[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        if (format == 4444) {
            int i2 = x;
            while (i2 < x + width) {
                int j2 = y;
                while (j2 < y + height) {
                    if ((pixels[offset + (i2 - x) + (j2 - y) * scanlength] & 0xF000) != 0) {
                        int pixel_888 = 0xF0 & pixels[offset + (i2 - x) + (j2 - y) * scanlength] << 4;
                        pixel_888 |= 0xF000 & pixels[offset + (i2 - x) + (j2 - y) * scanlength] << 8;
                        this.my_g.setColor(pixel_888 |= 0xF00000 & pixels[offset + (i2 - x) + (j2 - y) * scanlength] << 12);
                        this.my_g.drawLine(i2, j2, i2, j2);
                    }
                    ++j2;
                }
                ++i2;
            }
        }
    }

    public void drawPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        this.my_g.drawLine(x, y, width, height);
    }

    public void getPixels(int[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
    }

    public void getPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int format) {
    }

    public void getPixels(short[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
    }
}

