/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class PNG {
    static int[] crcTable = null;

    public static Image toImage(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) {
        try {
            byte[] png = PNG.toPNG(width, height, alpha, red, green, blue);
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static byte[] toPNG(Image i) throws IOException {
        int w = i.getWidth();
        int h = i.getHeight();
        int[] rgbData = new int[w * h];
        i.getRGB(rgbData, 0, w, 0, 0, w, h);
        return PNG.toPNG(w, h, rgbData);
    }

    public static byte[] toPNG(int width, int height, int[] argb) throws IOException {
        int n1 = argb.length;
        byte[] a2 = new byte[n1];
        byte[] r = new byte[n1];
        byte[] g2 = new byte[n1];
        byte[] b = new byte[n1];
        for (int i = 0; i < n1; ++i) {
            a2[i] = (byte)(argb[i] >> 24);
            r[i] = (byte)(argb[i] >> 16 & 0xFF);
            g2[i] = (byte)(argb[i] >> 8 & 0xFF);
            b[i] = (byte)(argb[i] & 0xFF);
        }
        return PNG.toPNG(width, height, a2, r, g2, b);
    }

    public static byte[] toPNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = PNG.createHeaderChunk(width, height);
        byte[] data = PNG.createDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = PNG.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    public static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return PNG.toChunk("IHDR", baos.toByteArray());
    }

    public static byte[] createDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        for (int y2 = 0; y2 < height; ++y2) {
            raw[dest++] = 0;
            for (int x2 = 0; x2 < width; ++x2) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
            }
        }
        return PNG.toChunk("IDAT", PNG.toZLIB(raw));
    }

    public static byte[] createTrailerChunk() throws IOException {
        return PNG.toChunk("IEND", new byte[0]);
    }

    public static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        chunk.write(bid);
        chunk.write(raw);
        int crc = -1;
        crc = PNG.updateCRC(crc, bid);
        crc = PNG.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    public static void createCRCTable() {
        crcTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k2 = 0; k2 < 8; ++k2) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            PNG.crcTable[i] = c;
        }
    }

    public static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            PNG.createCRCTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static byte[] toZLIB(byte[] raw) throws IOException {
        return ZLIB.toZLIB(raw);
    }
}

