/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.FocusListener;
import java.util.Vector;

final class EventDispatcher
implements Runnable {
    private Vector listeners;
    private Object[] pending;
    private Object pendingEvent;

    EventDispatcher() {
    }

    public synchronized void addListener(Object listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removeListener(Object listener) {
        this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataChangeEvent(int index, int type) {
        DataChangedListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new DataChangedListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (DataChangedListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireDataChangeSync(array, type, index);
        } else {
            this.pending = array;
            this.pendingEvent = new int[]{type, index};
            Display.getInstance().callSeriallyAndWait(this);
        }
    }

    private void fireDataChangeSync(DataChangedListener[] array, int type, int index) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].dataChanged(type, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireActionEvent(ActionEvent ev) {
        ActionListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new ActionListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (ActionListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireActionSync(array, ev);
        } else {
            this.pending = array;
            this.pendingEvent = ev;
            Display.getInstance().callSeriallyAndWait(this);
        }
    }

    private void fireActionSync(ActionListener[] array, ActionEvent ev) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].actionPerformed(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFocus(Component c) {
        FocusListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new FocusListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (FocusListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireFocusSync(array, c);
        } else {
            this.pending = array;
            this.pendingEvent = c;
            Display.getInstance().callSeriallyAndWait(this);
        }
    }

    private void fireFocusSync(FocusListener[] array, Component c) {
        if (c.hasFocus()) {
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter].focusGained(c);
            }
        } else {
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter].focusLost(c);
            }
        }
    }

    public final void run() {
        if (!Display.getInstance().isEdt()) {
            throw new IllegalStateException("This method should not be invoked by external code!");
        }
        if (this.pending instanceof ActionListener[]) {
            this.fireActionSync((ActionListener[])this.pending, (ActionEvent)this.pendingEvent);
            return;
        }
        if (this.pending instanceof FocusListener[]) {
            this.fireFocusSync((FocusListener[])this.pending, (Component)this.pendingEvent);
            return;
        }
        if (this.pending instanceof DataChangedListener[]) {
            this.fireDataChangeSync((DataChangedListener[])this.pending, ((int[])this.pendingEvent)[0], ((int[])this.pendingEvent)[1]);
            return;
        }
    }
}

