/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class Label
extends Component {
    private String text = "";
    private Image icon;
    private int align = 1;
    private int valign = 2;
    private int textPosition = 3;
    private String id = "Label";
    private int gap = 2;
    private int shiftText = 0;
    private boolean tickerRunning = false;
    private boolean tickerEnabled = true;
    private long tickerStartTime;
    private long tickerDelay;
    private boolean rightToLeft;
    private boolean endsWith3Points = true;

    public Label(String text) {
        this.text = text;
        this.localize();
        this.setFocusable(false);
    }

    Label(String text, String uiid) {
        this.text = text;
        this.localize();
        this.setFocusable(false);
        this.id = uiid;
        Style s = UIManager.getInstance().getComponentStyle(uiid);
        s.setBgPainter(this.getStyle().getBgPainter());
        this.setStyle(s);
        this.setAlignment(4);
    }

    public Label() {
        this("");
    }

    public Label(Image icon) {
        this("");
        this.icon = icon;
    }

    public int getBaselineResizeBehavior() {
        switch (this.valign) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    public void setText(String text) {
        this.text = text;
        this.localize();
        this.setShouldCalcPreferredSize(true);
        this.repaint();
    }

    private void localize() {
        Object o;
        Hashtable t = UIManager.getInstance().getResourceBundle();
        if (t != null && this.text != null && (o = t.get(this.text)) != null) {
            this.text = (String)o;
        }
    }

    void initComponentImpl() {
        LookAndFeel lf;
        super.initComponentImpl();
        if (this.hasFocus() && (lf = UIManager.getInstance().getLookAndFeel()) instanceof DefaultLookAndFeel) {
            ((DefaultLookAndFeel)lf).focusGained(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(Image icon) {
        if (this.icon == icon) {
            return;
        }
        this.icon = icon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form parent;
        super.checkAnimation();
        if (this.icon != null && this.icon.isAnimation() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setAlignment(int align) {
        if (align != 4 && align != 3 && align != 1) {
            throw new IllegalArgumentException("Alignment can't be set to " + align);
        }
        this.align = align;
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 4 && valign != 0 && valign != 2) {
            throw new IllegalArgumentException("Alignment can't be set to " + valign);
        }
        this.valign = valign;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setTextPosition(int textPosition) {
        if (textPosition != 1 && textPosition != 3 && textPosition != 2 && textPosition != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + textPosition);
        }
        this.textPosition = textPosition;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    protected String getUIID() {
        if (this.id == null) {
            return "Label";
        }
        return this.id;
    }

    protected String paramString() {
        return super.paramString() + ", text = " + this.getText() + ", gap = " + this.gap;
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawLabel(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getLabelPreferredSize(this);
    }

    public int getShiftText() {
        return this.shiftText;
    }

    public void setShiftText(int shiftText) {
        this.shiftText = shiftText;
    }

    public void startTicker(long delay, boolean rightToLeft) {
        if (!this.tickerEnabled) {
            return;
        }
        if (!this.isCellRenderer()) {
            Form parent = this.getComponentForm();
            if (parent == null) {
                throw new IllegalArgumentException("This method cannot be called before the Label is fully initialized");
            }
            parent.registerAnimated(this);
        }
        this.tickerStartTime = System.currentTimeMillis();
        this.tickerDelay = delay;
        this.tickerRunning = true;
        this.rightToLeft = rightToLeft;
    }

    public void stopTicker() {
        this.tickerRunning = false;
        this.setShiftText(0);
    }

    public boolean isTickerRunning() {
        return this.tickerRunning;
    }

    public void setTickerEnabled(boolean tickerEnabled) {
        this.tickerEnabled = tickerEnabled;
    }

    public boolean isTickerEnabled() {
        return this.tickerEnabled;
    }

    public void setEndsWith3Points(boolean endsWith3Points) {
        this.endsWith3Points = endsWith3Points;
    }

    public boolean isEndsWith3Points() {
        return this.endsWith3Points;
    }

    public boolean animate() {
        boolean animateTicker = false;
        if (this.tickerRunning && this.tickerStartTime + this.tickerDelay < System.currentTimeMillis()) {
            this.tickerStartTime = System.currentTimeMillis();
            this.shiftText = this.rightToLeft ? (this.shiftText -= 2) : (this.shiftText += 2);
            animateTicker = true;
        }
        boolean val = this.icon != null && this.icon.isAnimation() && ((Animation)((Object)this.icon)).animate();
        boolean parent = super.animate();
        return val || parent || animateTicker;
    }
}

