/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.automation;

import com.sun.lwuit.CheckBox;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.automation.DebugImplementation;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.ImplementationFactory;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DebugController {
    private ScriptStore store;
    public static final int EDT_VIOLATION_IGNORE = 0;
    public static final int EDT_VIOLATION_WARN = 1;
    public static final int EDT_VIOLATION_RUNTIME_EXCEPTION = 2;
    public static final int SHORTCUT_START_RECORDING = 0;
    public static final int SHORTCUT_FINISH_RECORDING = 1;
    public static final int SHORTCUT_SCRIPT_MANAGER = 2;
    public static final int SHORTCUT_ASSERTION_MANAGER = 3;
    private static DebugController INSTANCE = new DebugController();
    static final byte ASSERT_TITLE = 50;
    static final byte ASSERT_FOCUS_LABEL_TEXT = 51;
    static final byte ASSERT_FOCUS_CLASS_TYPE = 52;
    static final byte ASSERT_NO_EXCEPTIONS = 53;
    static final byte ASSERT_FOCUS_COLORS = 54;

    public static DebugController getInstance() {
        return INSTANCE;
    }

    private static void init() {
        final ImplementationFactory old = ImplementationFactory.getInstance();
        ImplementationFactory.setInstance(new ImplementationFactory(){

            public LWUITImplementation createImplementation() {
                return new DebugImplementation(old.createImplementation());
            }
        });
    }

    public static void init(Object midlet) {
        DebugController.init();
        Display.init(midlet);
    }

    public static void init(Object midlet, ScriptStore store) {
        DebugController.init();
        Display.init(midlet);
        INSTANCE.setScriptStore(store);
        INSTANCE.setShortcut(49, true, 0);
        INSTANCE.setShortcut(50, true, 3);
        INSTANCE.setShortcut(51, true, 1);
        INSTANCE.setShortcut(52, true, 2);
    }

    public void pressPointer(int x, int y) {
        Display.getInstance().pointerPressed(new int[]{x}, new int[]{y});
    }

    public void releasePointer(int x, int y) {
        Display.getInstance().pointerReleased(new int[]{x}, new int[]{y});
    }

    public void dragPointer(int x, int y) {
        Display.getInstance().pointerDragged(new int[]{x}, new int[]{y});
    }

    public void pressKey(int keyCode) {
        Display.getInstance().keyPressed(keyCode);
    }

    public void releaseKey(int keyCode) {
        Display.getInstance().keyReleased(keyCode);
    }

    public void setPlaybackSpeed(float ratio) {
        DebugImplementation.instance.setPlaybackSpeed(ratio);
    }

    public void startRecording() {
        DebugImplementation.instance.startRecording();
    }

    public Script finishRecording() {
        Script s = DebugImplementation.instance.finishRecording();
        TextField title = new TextField(30);
        title.setReplaceMenu(false);
        Command ok = new Command("OK");
        Command cancel = new Command("Cancel");
        String old = Dialog.getDefaultDialogPosition();
        Dialog.setDefaultDialogPosition("Center");
        Command response = Dialog.show("Script Title", title, new Command[]{ok, cancel});
        Dialog.setDefaultDialogPosition(old);
        if (response == ok) {
            s.setTitle(title.getText());
            return s;
        }
        return null;
    }

    public void runScript(final Script script) {
        if (Display.getInstance().isEdt()) {
            new Thread(){

                public void run() {
                    DebugImplementation.instance.playScript(script);
                }
            }.start();
            return;
        }
        DebugImplementation.instance.playScript(script);
    }

    public Throwable fetchEDTException() {
        return DebugImplementation.instance.fetchEDTException();
    }

    public int getEdtMode() {
        return DebugImplementation.instance.getEdtMode();
    }

    public void setEdtMode(int edtMode) {
        DebugImplementation.instance.setEdtMode(edtMode);
    }

    public Image takeScreenshot() {
        Form f = Display.getInstance().getCurrent();
        Image i = Image.createImage(f.getWidth(), f.getHeight());
        f.paintComponent(i.getGraphics());
        return i;
    }

    public void setScriptStore(ScriptStore store) {
        this.store = store;
    }

    private void showScriptManager() {
        try {
            final List scriptList = new List(this.store.getStoredScriptNameList());
            scriptList.setFixedSelection(1);
            Command close = new Command("Close"){

                public void actionPerformed(ActionEvent ev) {
                    ((Dialog)Display.getInstance().getCurrent()).dispose();
                }
            };
            Command editor = new Command("Edit"){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        String s = (String)scriptList.getSelectedItem();
                        Script script = DebugController.this.store.loadScript(s);
                        DebugController.this.editScript(script);
                    }
                    catch (IOException ioErr) {
                        DebugController.handleScriptIOException(ioErr);
                    }
                }
            };
            Command delete = new Command("Delete"){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        String s = (String)scriptList.getSelectedItem();
                        if (s != null && Dialog.show("Delete Script", "Are you sure you want to delete " + s + "?", "OK", "Cancel")) {
                            DebugController.this.store.deleteScript(s);
                        }
                    }
                    catch (IOException ioErr) {
                        DebugController.handleScriptIOException(ioErr);
                    }
                }
            };
            Command rename = new Command("Rename"){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        String s = (String)scriptList.getSelectedItem();
                        if (s != null) {
                            TextField name = new TextField(s, 30);
                            name.setReplaceMenu(false);
                            Command ok = new Command("OK");
                            Command cancel = new Command("Cancel");
                            String old = Dialog.getDefaultDialogPosition();
                            Dialog.setDefaultDialogPosition("Center");
                            if (Dialog.show("Rename", name, new Command[]{ok, cancel}) == ok) {
                                Script script = DebugController.this.store.loadScript(s);
                                DebugController.this.store.deleteScript(s);
                                script.setTitle(name.getText());
                                DebugController.this.store.storeScript(script);
                            }
                            Dialog.setDefaultDialogPosition(old);
                        }
                    }
                    catch (IOException ioErr) {
                        DebugController.handleScriptIOException(ioErr);
                    }
                }
            };
            Command play = new Command("Play"){

                public void actionPerformed(ActionEvent ev) {
                    ((Dialog)Display.getInstance().getCurrent()).dispose();
                    new Thread(){

                        public void run() {
                            try {
                                String s = (String)scriptList.getSelectedItem();
                                if (s != null) {
                                    Script script = DebugController.this.store.loadScript(s);
                                    DebugController.this.runScript(script);
                                }
                                DebugController.this.showScriptManager();
                            }
                            catch (IOException ioErr) {
                                DebugController.handleScriptIOException(ioErr);
                            }
                        }
                    }.start();
                }
            };
            Dialog prompt = new Dialog("Scripts");
            prompt.setScrollable(false);
            prompt.addCommand(close);
            prompt.addCommand(play);
            prompt.addCommand(rename);
            prompt.addCommand(delete);
            prompt.addCommand(editor);
            prompt.setLayout(new BorderLayout());
            prompt.addComponent("Center", (Component)scriptList);
            prompt.setAutoDispose(false);
            prompt.show();
        }
        catch (IOException ioErr) {
            DebugController.handleScriptIOException(ioErr);
        }
    }

    public void editScript(final Script s) {
        final boolean[] modified = new boolean[1];
        final Form previous = Display.getInstance().getCurrent();
        Form scriptEditor = new Form("Editor");
        scriptEditor.setLayout(new BorderLayout());
        final List scriptContent = new List(s.data);
        scriptContent.setListCellRenderer(new DefaultListCellRenderer(){
            private Container selection;
            private Label[] labels = new Label[]{new Label(), new Label(), new Label(), new Label(), new Label()};
            {
                this.selection = new Container();
                for (int iter = 0; iter < this.labels.length; ++iter) {
                    this.selection.addComponent(this.labels[iter]);
                    this.labels[iter].getStyle().setBgTransparency(0);
                }
            }

            public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                Script.Instruction instruction = (Script.Instruction)value;
                if (isSelected) {
                    this.labels[0].setText(Script.Instruction.getType(instruction.type));
                    for (int iter = 0; iter < instruction.data.length; ++iter) {
                        this.labels[1 + iter].setText(instruction.getEntryAsText(s, iter));
                    }
                    return this.selection;
                }
                String text = Script.Instruction.getType(instruction.type);
                for (int iter = 0; iter < instruction.data.length; ++iter) {
                    text = text + ", " + instruction.data[iter];
                }
                return super.getListCellRendererComponent(list, text, index, isSelected);
            }
        });
        scriptEditor.addComponent("Center", (Component)scriptContent);
        scriptEditor.addCommand(new Command("Back"){

            public void actionPerformed(ActionEvent ev) {
                if (modified[0] && !Dialog.show("Script Modified", "You have some unsaved changes in your script do you want to discard those changes?", "Discard", "Cancel")) {
                    return;
                }
                previous.show();
            }
        });
        scriptEditor.addCommand(new Command("Save"){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DebugController.this.store.storeScript(s);
                    modified[0] = false;
                }
                catch (IOException ex) {
                    DebugController.handleScriptIOException(ex);
                }
            }
        });
        scriptEditor.addCommand(new Command("Save As..."){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TextField title = new TextField(30);
                    title.setReplaceMenu(false);
                    Command ok = new Command("OK");
                    Command cancel = new Command("Cancel");
                    Command response = Dialog.show("Save As", title, new Command[]{ok, cancel});
                    if (response == ok && DebugController.this.overwriteTest(title.getText())) {
                        s.setTitle(title.getText());
                        DebugController.this.store.storeScript(s);
                        modified[0] = false;
                    }
                }
                catch (IOException ex) {
                    DebugController.handleScriptIOException(ex);
                }
            }
        });
        scriptEditor.addCommand(new Command("Edit"){

            public void actionPerformed(ActionEvent ev) {
                Script.Instruction i = DebugController.this.editInstruction((Script.Instruction)scriptContent.getSelectedItem());
                if (i != null) {
                    int offset = scriptContent.getSelectedIndex();
                    ((DefaultListModel)scriptContent.getModel()).setItem(offset, i);
                    s.data.setElementAt(i, offset);
                    modified[0] = true;
                }
            }
        });
        scriptEditor.addCommand(new Command("Add"){

            public void actionPerformed(ActionEvent ev) {
                Script.Instruction i = DebugController.this.editInstruction(null);
                if (i != null) {
                    int offset = scriptContent.getSelectedIndex();
                    s.data.insertElementAt(i, offset);
                    scriptContent.setModel(new DefaultListModel(s.data));
                    modified[0] = true;
                }
            }
        });
        scriptEditor.addCommand(new Command("Move To..."){

            public void actionPerformed(ActionEvent ev) {
                TextField position = new TextField(30);
                position.setInputMode("123");
                position.setReplaceMenu(false);
                Command ok = new Command("OK");
                Command cancel = new Command("Cancel");
                int oldOffset = scriptContent.getSelectedIndex();
                position.setText("" + oldOffset);
                Command response = Dialog.show("Move To...", position, new Command[]{ok, cancel});
                if (response == ok) {
                    int offset = Integer.parseInt(position.getText());
                    if (offset > -1 && offset <= scriptContent.getModel().getSize()) {
                        Object o = s.data.elementAt(oldOffset);
                        s.data.removeElementAt(oldOffset);
                        s.data.insertElementAt(o, offset);
                        scriptContent.setModel(new DefaultListModel(s.data));
                    }
                    modified[0] = true;
                }
            }
        });
        scriptEditor.addCommand(new Command("Delete"){

            public void actionPerformed(ActionEvent ev) {
                int i = scriptContent.getSelectedIndex();
                if (i >= 0 && Dialog.show("Delete", "Are you sure you want to delete this instruction?", "Yes", "No")) {
                    scriptContent.getModel().removeItem(i);
                    s.data.removeElementAt(i);
                    modified[0] = true;
                }
            }
        });
        scriptEditor.show();
    }

    private Script.Instruction editInstruction(Script.Instruction i) {
        String title = "Edit";
        if (i == null) {
            title = "Add";
        }
        Dialog editor = new Dialog(title);
        editor.setLayout(new GridLayout(5, 2));
        ComboBox type = new ComboBox(Script.Instruction.TYPES_NAMES);
        type.addSelectionListener(new SelectionListener(){

            public void selectionChanged(int oldSelected, int newSelected) {
                int size = Script.Instruction.size(Script.Instruction.TYPES_VALUE[newSelected]);
            }
        });
        editor.addComponent(new Label("Type"));
        editor.addComponent(type);
        Command ok = new Command("OK");
        Command cancel = new Command("Cancel");
        editor.addCommand(ok);
        editor.addCommand(cancel);
        if (editor.showDialog() == ok) {
            // empty if block
        }
        return null;
    }

    private static void handleScriptIOException(IOException ioErr) {
        ioErr.printStackTrace();
        Dialog.show("Script", "A Script Storage Error Error Occurred: " + ioErr, "OK", null);
    }

    private void showAssertionManager(Script s) {
        DebugImplementation.instance.pauseScript();
        Form currentForm = Display.getInstance().getCurrent();
        Vector<Assertion> assertionsVector = new Vector<Assertion>();
        class Assertion {
            public int type;
            public String text;
            public boolean selected;

            Assertion(int type, String text) {
                this.type = type;
                this.text = text;
            }
        }
        assertionsVector.addElement(new Assertion(53, "No Exception Occurred"));
        assertionsVector.addElement(new Assertion(50, "Title Is: " + currentForm.getTitle()));
        if (currentForm.getFocused() != null) {
            assertionsVector.addElement(new Assertion(52, "Focus is: " + currentForm.getFocused().getClass().getName()));
            assertionsVector.addElement(new Assertion(54, "Focus Colors Identical"));
            if (currentForm.getFocused() instanceof Label) {
                assertionsVector.addElement(new Assertion(51, "Focus Text: " + ((Label)currentForm.getFocused()).getText()));
            }
        }
        final List assertions = new List(assertionsVector);
        assertions.setFixedSelection(1);
        class Renderer
        extends Container
        implements ListCellRenderer {
            private CheckBox check = new CheckBox();
            private TextArea content = new TextArea(3, 30);
            private Label focus = new Label();

            public Renderer() {
                this.setLayout(new BorderLayout());
                Container checkArea = new Container();
                checkArea.addComponent(this.check);
                this.check.setPreferredSize(new Dimension(15, 15));
                this.check.getStyle().setPadding(4, 0, 0, 0);
                this.check.getStyle().setMargin(0, 0, 0, 0);
                this.check.getStyle().setBgTransparency(0);
                this.addComponent("West", (Component)checkArea);
                this.addComponent("Center", (Component)this.content);
                this.content.setIsScrollVisible(false);
                this.content.getStyle().setBorder(null);
                this.content.getStyle().setBgTransparency(0);
            }

            public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                Assertion a = (Assertion)value;
                this.check.setSelected(a.selected);
                this.check.setFocus(isSelected);
                this.content.setFocus(isSelected);
                this.content.setText(a.text);
                return this;
            }

            public Component getListFocusComponent(List list) {
                return this.focus;
            }
        }
        assertions.setListCellRenderer(new Renderer());
        assertions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Assertion a = (Assertion)assertions.getSelectedItem();
                a.selected = !a.selected;
            }
        });
        Dialog dialog = new Dialog("Assertions");
        dialog.setScrollable(false);
        dialog.addCommand(new Command("OK"));
        dialog.setLayout(new BorderLayout());
        dialog.addComponent("Center", (Component)assertions);
        dialog.showPacked("Center", true);
        block7: for (int iter = 0; iter < assertionsVector.size(); ++iter) {
            Assertion a = (Assertion)assertionsVector.elementAt(iter);
            if (!a.selected) continue;
            switch (a.type) {
                case 53: {
                    s.assertNoExceptions();
                    continue block7;
                }
                case 50: {
                    s.assertTitle();
                    continue block7;
                }
                case 52: {
                    s.assertFocusClassType();
                    continue block7;
                }
                case 54: {
                    s.assertFocusColors();
                    continue block7;
                }
                case 51: {
                    s.assertFocusLabelText();
                }
            }
        }
        DebugImplementation.instance.resumeScript();
    }

    public void setShortcut(int keyCode, boolean longPress, final int feature) {
        if (this.store == null) {
            Dialog.show("Shortcut", "No script store is defined, shortcuts wouldn't be very useful", "OK", null);
            return;
        }
        DebugImplementation.instance.bindShortcut(keyCode, longPress, new Runnable(){

            public void run() {
                try {
                    switch (feature) {
                        case 1: {
                            Script result = DebugController.this.finishRecording();
                            if (result == null || !DebugController.this.overwriteTest(result)) break;
                            DebugController.this.store.storeScript(result);
                            break;
                        }
                        case 0: {
                            DebugController.this.startRecording();
                            break;
                        }
                        case 2: {
                            DebugController.this.showScriptManager();
                            break;
                        }
                        case 3: {
                            Script s = DebugImplementation.instance.getCurrentRecording();
                            if (s == null) break;
                            DebugController.this.showAssertionManager(s);
                        }
                    }
                }
                catch (IOException ioErr) {
                    DebugController.handleScriptIOException(ioErr);
                }
            }
        });
    }

    public static void storeScript(OutputStream o, Script s) throws IOException {
        s.store(o);
    }

    public static Script loadScript(InputStream o) throws IOException {
        Script s = new Script();
        s.load(o);
        return s;
    }

    public static byte[] scriptToBytes(Script s) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            DebugController.storeScript(bo, s);
            bo.close();
            return bo.toByteArray();
        }
        catch (IOException ex) {
            DebugController.handleScriptIOException(ex);
            return null;
        }
    }

    public static Script scriptFromBytes(byte[] bytes) {
        try {
            Script s = new Script();
            s.load(new ByteArrayInputStream(bytes));
            return s;
        }
        catch (IOException ex) {
            DebugController.handleScriptIOException(ex);
            return null;
        }
    }

    private boolean containsScript(String name) throws IOException {
        if (this.store != null) {
            ListModel names = this.store.getStoredScriptNameList();
            int nameCount = names.getSize();
            for (int iter = 0; iter < nameCount; ++iter) {
                if (!names.getItemAt(iter).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean overwriteTest(Script s) throws IOException {
        while (!this.overwriteTest(s.getTitle())) {
            TextField name = new TextField(s.getTitle(), 30);
            name.setReplaceMenu(false);
            Command ok = new Command("OK");
            Command cancel = new Command("Cancel");
            String old = Dialog.getDefaultDialogPosition();
            Dialog.setDefaultDialogPosition("Center");
            if (Dialog.show("Save As...", name, new Command[]{ok, cancel}) != ok) {
                Dialog.setDefaultDialogPosition(old);
                return false;
            }
            Dialog.setDefaultDialogPosition(old);
            s.setTitle(name.getText());
        }
        return true;
    }

    private boolean overwriteTest(String name) throws IOException {
        return !this.containsScript(name) || !Dialog.show("Script Exists", "The script " + name + " already exists, do you want to overwrite it?", "Cancel", "Overwrite");
    }

    public static interface ScriptStore {
        public ListModel getStoredScriptNameList() throws IOException;

        public void storeScript(Script var1) throws IOException;

        public Script loadScript(String var1) throws IOException;

        public void deleteScript(String var1) throws IOException;
    }

    public static class Script {
        private Vector data = new Vector();
        private String title;
        private Vector constantPool = new Vector();
        private Hashtable gamekeyMap = new Hashtable();
        private int displayWidth;
        private int displayHeight;

        Script() {
        }

        public String getTitle() {
            return this.title;
        }

        void setTitle(String title) {
            this.title = title;
        }

        void store(OutputStream s) throws IOException {
            int iter;
            DataOutputStream d = new DataOutputStream(s);
            d.writeUTF(this.title);
            d.writeInt(this.displayWidth);
            d.writeInt(this.displayHeight);
            d.writeInt(this.data.size());
            for (iter = 0; iter < this.data.size(); ++iter) {
                ((Instruction)this.data.elementAt(iter)).write(d);
            }
            d.writeInt(this.constantPool.size());
            for (iter = 0; iter < this.constantPool.size(); ++iter) {
                d.writeUTF((String)this.constantPool.elementAt(iter));
            }
            d.writeInt(this.gamekeyMap.size());
            Enumeration e = this.gamekeyMap.keys();
            for (int iter2 = 0; iter2 < this.gamekeyMap.size(); ++iter2) {
                Integer key = (Integer)e.nextElement();
                d.writeInt(key);
                d.writeInt((Integer)this.gamekeyMap.get(key));
            }
        }

        Hashtable startScript() {
            this.displayWidth = Display.getInstance().getDisplayWidth();
            this.displayHeight = Display.getInstance().getDisplayHeight();
            return this.gamekeyMap;
        }

        void execute(float speed) {
            long startTime = System.currentTimeMillis();
            for (int iter = 0; iter < this.data.size(); ++iter) {
                ((Instruction)this.data.elementAt(iter)).execute(this, startTime, speed);
            }
        }

        void load(InputStream s) throws IOException {
            int iter;
            this.data.removeAllElements();
            this.constantPool.removeAllElements();
            this.gamekeyMap.clear();
            DataInputStream d = new DataInputStream(s);
            this.title = d.readUTF();
            this.displayWidth = d.readInt();
            this.displayHeight = d.readInt();
            int size = d.readInt();
            for (iter = 0; iter < size; ++iter) {
                this.data.addElement(Instruction.read(d));
            }
            size = d.readInt();
            for (iter = 0; iter < size; ++iter) {
                this.constantPool.addElement(d.readUTF());
            }
            size = d.readInt();
            for (iter = 0; iter < size; ++iter) {
                this.gamekeyMap.put(new Integer(d.readInt()), new Integer(d.readInt()));
            }
        }

        void pushKeyEvent(int time, int type, int key) {
            this.data.addElement(Instruction.createTimeStampActualTime(time));
            if (type == 4) {
                this.data.addElement(Instruction.createKeyPressedEvent(key));
            } else {
                this.data.addElement(Instruction.createKeyReleaseEvent(key));
            }
        }

        void pushPointerEvent(int time, int type, int x, int y) {
            this.data.addElement(Instruction.createTimeStampActualTime(time));
            switch (type) {
                case 1: {
                    this.data.addElement(Instruction.createPointerPressEvent(x, y));
                    break;
                }
                case 2: {
                    this.data.addElement(Instruction.createPointerReleasedEvent(x, y));
                    break;
                }
                default: {
                    this.data.addElement(Instruction.createPointerDraggedEvent(x, y));
                }
            }
        }

        void popKey() {
            this.data.removeElementAt(this.data.size() - 1);
        }

        int storeInPool(String value) {
            int index = this.constantPool.indexOf(value);
            if (index < 0) {
                this.constantPool.addElement(value);
                index = this.constantPool.indexOf(value);
            }
            return index;
        }

        void assertTitle() {
            this.data.addElement(Instruction.createAssertTitle(this));
        }

        void assertFocusLabelText() {
            this.data.addElement(Instruction.createAssertLabel(this));
        }

        void assertFocusClassType() {
            this.data.addElement(Instruction.createAssertFocusClassType(this));
        }

        void assertNoExceptions() {
            this.data.addElement(Instruction.createAssertNoException());
        }

        void assertFocusColors() {
            this.data.addElement(Instruction.createAssertFocusColors(this));
        }

        static class Instruction {
            private static final byte TIME_STAMP = -1;
            private static final byte POINTER_PRESSED = 1;
            private static final byte POINTER_RELEASED = 2;
            private static final byte POINTER_DRAGGED = 3;
            private static final byte KEY_PRESSED = 4;
            private static final byte KEY_RELEASED = 5;
            private static final byte GAME_KEY_PRESS = 6;
            private static final byte GAME_KEY_RELEASE = 7;
            private static final byte SOFT_LEFT_PRESS = 8;
            private static final byte SOFT_RIGHT_PRESS = 9;
            private static final byte SOFT_LEFT_RELEASE = 10;
            private static final byte SOFT_RIGHT_RELEASE = 11;
            static final int[] TYPES_VALUE = new int[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 50, 51, 52, 53, 54};
            static final String[] TYPES_NAMES = new String[]{"TIME_STAMP", "POINTER_PRESSED", "POINTER_RELEASED", "POINTER_DRAGGED", "KEY_PRESSED", "KEY_RELEASED", "GAME_KEY_PRESS", "GAME_KEY_RELEASE", "SOFT_LEFT_PRESS", "SOFT_RIGHT_PRESS", "SOFT_LEFT_RELEASE", "SOFT_RIGHT_RELEASE", "ASSERT_TITLE", "ASSERT_FOCUS_LABEL_TEXT", "ASSERT_FOCUS_CLASS_TYPE", "ASSERT_NO_EXCEPTIONS", "ASSERT_FOCUS_COLORS"};
            private byte type;
            private int[] data;

            static String getType(int type) {
                for (int iter = 0; iter < TYPES_VALUE.length; ++iter) {
                    if (TYPES_VALUE[iter] != type) continue;
                    return TYPES_NAMES[iter];
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }

            private Instruction(byte type, int[] data) {
                this.type = type;
                this.data = data;
            }

            private void assertString(Script parentScript, String s) {
                String constant = (String)parentScript.constantPool.elementAt(this.data[0]);
                Log.p("script: assert " + s + " == " + constant, 1);
                if (constant == null && s == null) {
                    return;
                }
                if (!constant.equals(s)) {
                    throw new RuntimeException("Assertion failed: " + constant + " != " + s);
                }
            }

            public static Instruction createTimeStamp(long startTime) {
                return new Instruction(-1, new int[]{(int)(System.currentTimeMillis() - startTime)});
            }

            public static Instruction createTimeStampActualTime(long time) {
                return new Instruction(-1, new int[]{(int)time});
            }

            public static Instruction createPointerPressEvent(int x, int y) {
                return new Instruction(1, new int[]{x, y});
            }

            public static Instruction createPointerReleasedEvent(int x, int y) {
                return new Instruction(2, new int[]{x, y});
            }

            public static Instruction createPointerDraggedEvent(int x, int y) {
                return new Instruction(3, new int[]{x, y});
            }

            public static Instruction createKeyPressedEvent(int code) {
                if (code == DebugImplementation.instance.getSoftkeyCode(0)[0]) {
                    return new Instruction(8, new int[0]);
                }
                if (code == DebugImplementation.instance.getSoftkeyCode(1)[0]) {
                    return new Instruction(9, new int[0]);
                }
                int game = Display.getInstance().getGameAction(code);
                if (game != 0) {
                    return new Instruction(6, new int[]{game});
                }
                return new Instruction(4, new int[]{code});
            }

            public static Instruction createKeyReleaseEvent(int code) {
                if (code == DebugImplementation.instance.getSoftkeyCode(0)[0]) {
                    return new Instruction(10, new int[0]);
                }
                if (code == DebugImplementation.instance.getSoftkeyCode(1)[0]) {
                    return new Instruction(11, new int[0]);
                }
                int game = Display.getInstance().getGameAction(code);
                if (game != 0) {
                    return new Instruction(7, new int[]{game});
                }
                return new Instruction(5, new int[]{code});
            }

            String getEntryAsText(Script parent, int offset) {
                if (offset == 0 && (this.type == 50 || this.type == 51 || this.type == 52)) {
                    return (String)parent.constantPool.elementAt(this.data[offset]);
                }
                return "" + this.data[offset];
            }

            void setEntryText(Script parent, int offset, String text) {
                if (offset == 0 && (this.type == 50 || this.type == 51 || this.type == 52)) {
                    parent.constantPool.setElementAt(text, offset);
                }
                this.data[offset] = Integer.parseInt(text);
            }

            public static Instruction createAssertTitle(Script s) {
                return new Instruction(50, new int[]{s.storeInPool(Display.getInstance().getCurrent().getTitle())});
            }

            public static Instruction createAssertLabel(Script s) {
                String t = ((Label)Display.getInstance().getCurrent().getFocused()).getText();
                return new Instruction(51, new int[]{s.storeInPool(t)});
            }

            public static Instruction createAssertFocusClassType(Script s) {
                String t = Display.getInstance().getCurrent().getFocused().getClass().getName();
                return new Instruction(52, new int[]{s.storeInPool(t)});
            }

            public static Instruction createAssertNoException() {
                return new Instruction(53, new int[0]);
            }

            public static Instruction createAssertFocusColors(Script s) {
                Style style = Display.getInstance().getCurrent().getFocused().getStyle();
                return new Instruction(54, new int[]{style.getFgColor(), style.getFgSelectionColor(), style.getBgColor(), style.getBgSelectionColor()});
            }

            public void execute(Script parentScript, long startTime, float speedRatio) {
                DebugImplementation d = DebugImplementation.instance;
                switch (this.type) {
                    case -1: {
                        int timeForNext = (int)((long)this.data[0] - (System.currentTimeMillis() - startTime));
                        timeForNext = (int)((float)timeForNext * speedRatio);
                        if (timeForNext <= 0) break;
                        try {
                            Thread.sleep(timeForNext);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case 4: {
                        Log.p("script: keyPressed(" + this.data[0] + ")", 1);
                        d.keyPressed(this.data[0]);
                        break;
                    }
                    case 5: {
                        Log.p("script: keyReleased(" + this.data[0] + ")", 1);
                        d.keyReleased(this.data[0]);
                        break;
                    }
                    case 6: {
                        Log.p("script: game keyPressed(" + this.data[0] + ")", 1);
                        d.keyPressed(Display.getInstance().getKeyCode(this.data[0]));
                        break;
                    }
                    case 7: {
                        Log.p("script: game keyReleased(" + this.data[0] + ")", 1);
                        d.keyReleased(Display.getInstance().getKeyCode(this.data[0]));
                        break;
                    }
                    case 8: {
                        Log.p("script: soft left keyPressed()", 1);
                        d.keyPressed(DebugImplementation.instance.getSoftkeyCode(0)[0]);
                        break;
                    }
                    case 10: {
                        Log.p("script: soft left keyReleased()", 1);
                        d.keyReleased(DebugImplementation.instance.getSoftkeyCode(1)[0]);
                        break;
                    }
                    case 9: {
                        Log.p("script: soft right keyPressed()", 1);
                        d.keyPressed(DebugImplementation.instance.getSoftkeyCode(0)[0]);
                        break;
                    }
                    case 11: {
                        Log.p("script: soft right keyReleased()", 1);
                        d.keyReleased(DebugImplementation.instance.getSoftkeyCode(1)[0]);
                        break;
                    }
                    case 1: {
                        Log.p("script: pointerPressed(" + this.data[0] + ", " + this.data[1] + ")", 1);
                        d.pointerPressed(this.data[0], this.data[1]);
                        break;
                    }
                    case 2: {
                        Log.p("script: pointerReleased(" + this.data[0] + ", " + this.data[1] + ")", 1);
                        d.pointerReleased(this.data[0], this.data[1]);
                        break;
                    }
                    case 3: {
                        Log.p("script: pointerDragged(" + this.data[0] + ", " + this.data[1] + ")", 1);
                        d.pointerDragged(this.data[0], this.data[1]);
                        break;
                    }
                    case 50: {
                        this.assertString(parentScript, Display.getInstance().getCurrent().getTitle());
                        break;
                    }
                    case 52: {
                        this.assertString(parentScript, Display.getInstance().getCurrent().getFocused().getClass().getName());
                        break;
                    }
                    case 51: {
                        this.assertString(parentScript, ((Label)Display.getInstance().getCurrent().getFocused()).getText());
                        break;
                    }
                    case 53: {
                        Throwable t = d.fetchEDTException();
                        if (t == null) break;
                        throw new RuntimeException("Assertion failed exception was thrown: " + t);
                    }
                    case 54: {
                        Log.p("script: assert colors", 1);
                        Style s = Display.getInstance().getCurrent().getFocused().getStyle();
                        if (this.data[0] == s.getFgColor() && this.data[1] == s.getBgColor() && this.data[2] == s.getFgSelectionColor() && this.data[3] == s.getBgSelectionColor()) break;
                        throw new RuntimeException("Color Assertion failed");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid script unrecognized command: " + this.type);
                    }
                }
            }

            public void write(DataOutputStream o) throws IOException {
                o.writeByte(this.type);
                for (int iter = 0; iter < this.data.length; ++iter) {
                    o.writeInt(this.data[iter]);
                }
            }

            static Instruction read(DataInputStream i) throws IOException {
                byte type = i.readByte();
                int[] data = new int[Instruction.size(type)];
                for (int iter = 0; iter < data.length; ++iter) {
                    data[iter] = i.readInt();
                }
                return new Instruction(type, data);
            }

            public int size() {
                return Instruction.size(this.type);
            }

            private static int size(int type) {
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 53: {
                        return 0;
                    }
                    case 54: {
                        return 4;
                    }
                }
                return 1;
            }
        }
    }
}

