/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.geom;

import com.sun.lwuit.geom.Dimension;

public class Rectangle {
    private int x;
    private int y;
    private Dimension size;

    public Rectangle() {
        this.size = new Dimension();
    }

    public Rectangle(int x, int y, Dimension size) {
        this.x = x;
        this.y = y;
        this.size = size;
    }

    public Rectangle(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.size = new Dimension(w, h);
    }

    public Rectangle(Rectangle rect) {
        this(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        return "x = " + this.x + " y = " + this.y + " size = " + this.size;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean contains(Rectangle rect) {
        return this.contains(rect.x, rect.y, rect.size.getWidth(), rect.size.getHeight());
    }

    public boolean contains(int rX, int rY, int rWidth, int rHeight) {
        return this.x <= rX && this.y <= rY && this.x + this.size.getWidth() >= rX + rWidth && this.y + this.size.getHeight() >= rY + rHeight;
    }

    public boolean contains(int rX, int rY) {
        return this.x <= rX && this.y <= rY && this.x + this.size.getWidth() >= rX && this.y + this.size.getHeight() >= rY;
    }

    public boolean intersects(int x, int y, int width, int height) {
        int tw = this.size.getWidth();
        int th = this.size.getHeight();
        return Rectangle.intersects(this.x, this.y, tw, th, x, y, width, height);
    }

    public boolean intersects(Rectangle rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
    }

    public static boolean intersects(int tx, int ty, int tw, int th, int x, int y, int width, int height) {
        int rw = width;
        int rh = height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int rx = x;
        int ry = y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }
}

