/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class DefaultListCellRenderer
extends Label
implements ListCellRenderer {
    private boolean showNumbers;
    private int selectionTransparency = 100;

    public DefaultListCellRenderer() {
        super("");
        this.setCellRenderer(true);
        this.setEndsWith3Points(false);
        this.showNumbers = true;
    }

    public DefaultListCellRenderer(boolean showNumbers) {
        this();
        this.showNumbers = showNumbers;
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        if (this.showNumbers) {
            Object o;
            String text = "" + value;
            Hashtable t = UIManager.getInstance().getResourceBundle();
            if (t != null && value != null && (o = t.get(value.toString())) != null) {
                text = (String)o;
            }
            this.setText("" + (index + 1) + ". " + text);
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("null");
        }
        if (isSelected) {
            this.setFocus(true);
            this.getStyle().setBgTransparency(this.selectionTransparency);
        } else {
            this.setFocus(false);
            this.getStyle().setBgTransparency(0);
        }
        if (value instanceof Command) {
            this.setIcon(((Command)value).getIcon());
        }
        return this;
    }

    public Component getListFocusComponent(List list) {
        this.setText("");
        this.setIcon(null);
        this.setFocus(true);
        this.getStyle().setBgTransparency(this.selectionTransparency);
        return this;
    }

    public void repaint() {
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public int getSelectionTransparency() {
        return this.selectionTransparency;
    }

    public void setSelectionTransparency(int selectionTransparency) {
        this.selectionTransparency = selectionTransparency;
    }
}

