/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Display;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.list.ListModel;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultListModel
implements ListModel {
    private Vector items;
    private Vector dataListeners = new Vector();
    private Vector selectionListeners = new Vector();
    private int selectedIndex = 0;

    public DefaultListModel() {
        this.items = new Vector();
    }

    public DefaultListModel(Vector items) {
        this.items = items;
    }

    public DefaultListModel(Object[] items) {
        this.items = DefaultListModel.createVector(items);
    }

    private static Vector createVector(Object[] items) {
        if (items == null) {
            items = new Object[]{""};
        }
        Vector<Object> vec = new Vector<Object>(items.length);
        for (int iter = 0; iter < items.length; ++iter) {
            vec.addElement(items[iter]);
        }
        return vec;
    }

    public Object getItemAt(int index) {
        if (index < this.getSize() && index >= 0) {
            return this.items.elementAt(index);
        }
        return null;
    }

    public int getSize() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void addItem(Object item) {
        this.items.addElement(item);
        this.fireDataChangedEvent(1, this.items.size());
    }

    public void setItem(int index, Object item) {
        this.items.setElementAt(item, index);
        this.fireDataChangedEvent(2, index);
    }

    public void addItemAtIndex(Object item, int index) {
        if (index <= this.items.size()) {
            this.items.insertElementAt(item, index);
            this.fireDataChangedEvent(1, index);
        }
    }

    public void removeItem(int index) {
        if (index < this.getSize() && index >= 0) {
            this.items.removeElementAt(index);
            if (index != 0) {
                this.setSelectedIndex(index - 1);
            }
            this.fireDataChangedEvent(0, index);
        }
    }

    public void removeAll() {
        while (this.getSize() > 0) {
            this.removeItem(0);
        }
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        this.fireSelectionEvent(oldIndex, this.selectedIndex);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.dataListeners.addElement(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListeners.removeElement(l);
    }

    private void fireDataChangedEvent(final int status, final int index) {
        if (!Display.getInstance().isEdt()) {
            Display.getInstance().callSeriallyAndWait(new Runnable(){

                public void run() {
                    DefaultListModel.this.fireDataChangedEvent(status, index);
                }
            });
            return;
        }
        for (int iter = 0; iter < this.dataListeners.size(); ++iter) {
            DataChangedListener l = (DataChangedListener)this.dataListeners.elementAt(iter);
            l.dataChanged(status, index);
        }
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.addElement(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.removeElement(l);
    }

    private void fireSelectionEvent(int oldIndex, int newIndex) {
        Enumeration listenersEnum = this.selectionListeners.elements();
        while (listenersEnum.hasMoreElements()) {
            SelectionListener l = (SelectionListener)listenersEnum.nextElement();
            l.selectionChanged(oldIndex, newIndex);
        }
    }
}

