/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.plaf.Border;
import java.util.Enumeration;
import java.util.Vector;

public class Style {
    public static final String BG_COLOR = "bgColor";
    public static final String FG_COLOR = "fgColor";
    public static final String BG_IMAGE = "bgImage";
    public static final String BG_SELECTION_COLOR = "bgSelectionColor";
    public static final String FG_SELECTION_COLOR = "fgSelectionColor";
    public static final String FONT = "font";
    public static final String SCALED_IMAGE = "scaledImage";
    public static final String TRANSPARENCY = "transparency";
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String PADDING = "padding";
    private int fgColor = 0;
    private int bgColor = 0xFFFFFF;
    private int bgSelectionColor = 0xCCFFCC;
    private int fgSelectionColor = 0xFFCCCC;
    private Font font = Font.getDefaultFont();
    private Image bgImage;
    private int[] padding = new int[4];
    private int[] margin = new int[4];
    private byte transparency = (byte)-1;
    private Painter bgPainter;
    private Border border = null;
    private boolean scaleImage = true;
    private short modifiedFlag;
    private static final short FG_COLOR_MODIFIED = 1;
    private static final short BG_COLOR_MODIFIED = 2;
    private static final short FG_SELECTION_MODIFIED = 4;
    private static final short BG_SELECTION_MODIFIED = 8;
    private static final short FONT_MODIFIED = 16;
    private static final short BG_IMAGE_MODIFIED = 32;
    private static final short SCALE_IMAGE_MODIFIED = 64;
    private static final short TRANSPARENCY_MODIFIED = 128;
    private static final short PADDING_MODIFIED = 256;
    private static final short MARGIN_MODIFIED = 512;
    private static final short BORDER_MODIFIED = 1024;
    private Vector listeners;

    public Style() {
        this.setPadding(3, 3, 3, 3);
        this.setMargin(2, 2, 2, 2);
        this.modifiedFlag = 0;
    }

    public Style(Style style) {
        this(style.getFgColor(), style.getBgColor(), style.getFgSelectionColor(), style.getBgSelectionColor(), style.getFont(), style.getBgTransparency(), style.getBgImage(), style.isScaleImage());
        this.setPadding(style.getPadding(0), style.getPadding(2), style.getPadding(1), style.getPadding(3));
        this.setMargin(style.getMargin(0), style.getMargin(2), style.getMargin(1), style.getMargin(3));
        this.setBorder(style.getBorder());
        this.modifiedFlag = 0;
    }

    public Style(int fgColor, int bgColor, int fgSelectionColor, int bgSelectionColor, Font f, byte transparency) {
        this(fgColor, bgColor, fgSelectionColor, bgSelectionColor, f, transparency, null, false);
    }

    public Style(int fgColor, int bgColor, int fgSelectionColor, int bgSelectionColor, Font f, byte transparency, Image im, boolean scaledImage) {
        this();
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.font = f;
        this.bgSelectionColor = bgSelectionColor;
        this.fgSelectionColor = fgSelectionColor;
        this.transparency = transparency;
        this.scaleImage = scaledImage;
        this.bgImage = im;
    }

    public void merge(Style style) {
        short tmp = this.modifiedFlag;
        if ((this.modifiedFlag & 1) == 0) {
            this.setFgColor(style.getFgColor());
        }
        if ((this.modifiedFlag & 2) == 0) {
            this.setBgColor(style.getBgColor());
        }
        if ((this.modifiedFlag & 0x20) == 0) {
            this.setBgImage(style.getBgImage());
        }
        if ((this.modifiedFlag & 0x10) == 0) {
            this.setFont(style.getFont());
        }
        if ((this.modifiedFlag & 8) == 0) {
            this.setBgSelectionColor(style.getBgSelectionColor());
        }
        if ((this.modifiedFlag & 4) == 0) {
            this.setFgSelectionColor(style.getFgSelectionColor());
        }
        if ((this.modifiedFlag & 0x40) == 0) {
            this.setScaleImage(style.isScaleImage());
        }
        if ((this.modifiedFlag & 0x80) == 0) {
            this.setBgTransparency(style.getBgTransparency());
        }
        if ((this.modifiedFlag & 0x100) == 0) {
            this.setPadding(style.getPadding(0), style.getPadding(2), style.getPadding(1), style.getPadding(3));
        }
        if ((this.modifiedFlag & 0x200) == 0) {
            this.setMargin(style.getMargin(0), style.getMargin(2), style.getMargin(1), style.getMargin(3));
        }
        if ((this.modifiedFlag & 0x400) == 0) {
            this.setBorder(style.getBorder());
        }
        this.modifiedFlag = tmp;
    }

    public boolean isModified() {
        return this.modifiedFlag != 0;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBgColor(int bgColor) {
        this.setBgColor(bgColor, false);
    }

    public void setBgImage(Image bgImage) {
        this.setBgImage(bgImage, false);
    }

    public void setFgColor(int fgColor) {
        this.setFgColor(fgColor, false);
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public int getBgSelectionColor() {
        return this.bgSelectionColor;
    }

    public void setBgSelectionColor(int bgSelectionColor) {
        this.setBgSelectionColor(bgSelectionColor, false);
    }

    public int getFgSelectionColor() {
        return this.fgSelectionColor;
    }

    public void setFgSelectionColor(int fgSelectionColor) {
        this.setFgSelectionColor(fgSelectionColor, false);
    }

    public boolean isScaleImage() {
        return this.scaleImage;
    }

    public void setScaleImage(boolean scaleImage) {
        this.setScaleImage(scaleImage, false);
    }

    public byte getBgTransparency() {
        if (this.bgImage != null && (this.bgImage.isAnimation() || this.bgImage.isOpaque())) {
            return -1;
        }
        return this.transparency;
    }

    public void setBgTransparency(byte transparency) {
        this.setBgTransparency(transparency & 0xFF, false);
    }

    public void setBgTransparency(int transparency) {
        this.setBgTransparency(transparency, false);
    }

    public void setPadding(int top, int bottom, int left, int right) {
        if (top < 0 || left < 0 || right < 0 || bottom < 0) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        this.padding[0] = top;
        this.padding[2] = bottom;
        this.padding[1] = left;
        this.padding[3] = right;
        this.modifiedFlag = (short)(this.modifiedFlag | 0x100);
        this.firePropertyChanged(PADDING);
    }

    public void setPadding(int orientation, int gap) {
        this.setPadding(orientation, gap, false);
    }

    public void setMargin(int top, int bottom, int left, int right) {
        if (top < 0 || left < 0 || right < 0 || bottom < 0) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        this.margin[0] = top;
        this.margin[2] = bottom;
        this.margin[1] = left;
        this.margin[3] = right;
        this.modifiedFlag = (short)(this.modifiedFlag | 0x200);
        this.firePropertyChanged(MARGIN);
    }

    public void setMargin(int orientation, int gap) {
        this.setMargin(orientation, gap, false);
    }

    public int getPadding(int orientation) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        return this.padding[orientation];
    }

    public int getMargin(int orientation) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        return this.margin[orientation];
    }

    public void setBgColor(int bgColor, boolean override) {
        this.bgColor = bgColor;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 2);
        }
        this.firePropertyChanged(BG_COLOR);
    }

    public void setBgImage(Image bgImage, boolean override) {
        this.bgImage = bgImage;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x20);
        }
        this.firePropertyChanged(BG_IMAGE);
    }

    public void setFgColor(int fgColor, boolean override) {
        this.fgColor = fgColor;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 1);
        }
        this.firePropertyChanged(FG_COLOR);
    }

    public void setFont(Font font, boolean override) {
        this.font = font;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x10);
        }
        this.firePropertyChanged(FONT);
    }

    public void setBgSelectionColor(int bgSelectionColor, boolean override) {
        this.bgSelectionColor = bgSelectionColor;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 8);
        }
        this.firePropertyChanged(BG_SELECTION_COLOR);
    }

    public void setFgSelectionColor(int fgSelectionColor, boolean override) {
        this.fgSelectionColor = fgSelectionColor;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 4);
        }
        this.firePropertyChanged(FG_SELECTION_COLOR);
    }

    public void setScaleImage(boolean scaleImage, boolean override) {
        this.scaleImage = scaleImage;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x40);
        }
        this.firePropertyChanged(SCALED_IMAGE);
    }

    public void setBgTransparency(int transparency, boolean override) {
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("valid values are between 0-255");
        }
        this.transparency = (byte)transparency;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x80);
        }
        this.firePropertyChanged(TRANSPARENCY);
    }

    public void setPadding(int orientation, int gap, boolean override) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (gap < 0) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        this.padding[orientation] = gap;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x100);
        }
        this.firePropertyChanged(PADDING);
    }

    public void setMargin(int orientation, int gap, boolean override) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (gap < 0) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        this.margin[orientation] = gap;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x200);
        }
        this.firePropertyChanged(MARGIN);
    }

    private void firePropertyChanged(String propertName) {
        if (this.listeners == null) {
            return;
        }
        Enumeration enums = this.listeners.elements();
        while (enums.hasMoreElements()) {
            StyleListener l = (StyleListener)enums.nextElement();
            l.styleChanged(propertName, this);
        }
    }

    public void addStyleListener(StyleListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public void removeStyleListener(StyleListener l) {
        if (this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    void resetModifiedFlag() {
        this.modifiedFlag = 0;
    }

    public void setBorder(Border border) {
        this.border = border;
        this.modifiedFlag = (short)(this.modifiedFlag | 0x400);
        this.firePropertyChanged(BORDER);
    }

    public void setBorder(Border border, boolean override) {
        this.border = border;
        if (!override) {
            this.modifiedFlag = (short)(this.modifiedFlag | 0x400);
        }
        this.firePropertyChanged(BORDER);
    }

    public Border getBorder() {
        return this.border;
    }

    public Painter getBgPainter() {
        return this.bgPainter;
    }

    public void setBgPainter(Painter bgPainter) {
        this.bgPainter = bgPainter;
    }
}

