/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class Dialog
extends Form {
    private boolean disposed;
    public static final int TYPE_ALARM = 1;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_INFO = 4;
    public static final int TYPE_WARNING = 5;
    private long time;
    private Command lastCommandPressed;
    private boolean menu;
    private String dialogUIID;
    private String dialogTitleUIID;
    private int dialogType;
    private int top = -1;
    private int bottom;
    private int left;
    private int right;
    private boolean includeTitle;
    private static String defaultDialogPosition;
    private boolean autoDispose = true;
    private boolean modal = true;
    private static int defaultDialogType;

    public Dialog(String title) {
        this();
        this.setTitle(title);
    }

    public Dialog() {
        this("Dialog", "DialogTitle");
    }

    Dialog(String dialogUIID, String dialogTitleUIID) {
        this.dialogUIID = dialogUIID;
        this.dialogTitleUIID = dialogTitleUIID;
        this.setDialogStyle(UIManager.getInstance().getComponentStyle(dialogUIID));
        this.setTitleStyle(UIManager.getInstance().getComponentStyle(dialogTitleUIID));
        super.getStyle().setBgTransparency(0);
        super.getStyle().setBgImage(null);
        this.setSmoothScrolling(false);
        this.deregisterAnimated(this);
    }

    public void setDialogStyle(Style style) {
        this.getContentPane().setStyle(style);
    }

    public Style getDialogStyle() {
        return this.getContentPane().getStyle();
    }

    void initLaf(LookAndFeel laf) {
        this.setTransitionOutAnimator(laf.getDefaultDialogTransitionOut());
        this.setTransitionInAnimator(laf.getDefaultDialogTransitionIn());
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle) {
        return this.show(top, bottom, left, right, includeTitle, true);
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle, boolean modal) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.includeTitle = includeTitle;
        this.setDisposed(false);
        this.modal = modal;
        super.showModal(top, bottom, left, right, includeTitle, modal);
        return this.lastCommandPressed;
    }

    public void setTimeout(long time) {
        this.time = System.currentTimeMillis() + time;
        super.registerAnimated(this);
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText) {
        return Dialog.show(title, text, type, icon, okText, cancelText, 0L);
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText, long timeout) {
        Command okCommand = new Command(okText);
        Command[] cmds = cancelText != null ? new Command[]{new Command(cancelText), okCommand} : new Command[]{okCommand};
        return Dialog.show(title, text, okCommand, cmds, type, icon, timeout) == okCommand;
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, defaultCommand, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout, transition);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Object o;
        Hashtable h = UIManager.getInstance().getResourceBundle();
        if (h != null && text != null && (o = h.get(text)) != null) {
            text = (String)o;
        }
        TextArea t = new TextArea(text, 3, 30);
        t.setStyle(UIManager.getInstance().getComponentStyle("DialogBody"));
        t.setEditable(false);
        return Dialog.show(title, t, defaultCommand, cmds, type, icon, timeout, transition);
    }

    public static boolean show(String title, String text, String okText, String cancelText) {
        return Dialog.show(title, text, 4, null, okText, cancelText);
    }

    public static Command show(String title, Component body, Command[] cmds) {
        return Dialog.show(title, body, cmds, 4, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon) {
        return Dialog.show(title, body, cmds, type, icon, 0L);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, body, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, body, null, cmds, type, icon, timeout, transition);
    }

    public static Command show(String title, Component body, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Dialog dialog = new Dialog(title);
        dialog.dialogType = type;
        dialog.setTransitionInAnimator(transition);
        dialog.setTransitionOutAnimator(transition);
        dialog.lastCommandPressed = null;
        if (cmds != null) {
            for (int iter = 0; iter < cmds.length; ++iter) {
                dialog.addCommand(cmds[iter]);
            }
        }
        dialog.setLayout(new BorderLayout());
        dialog.addComponent("Center", body);
        if (icon != null) {
            dialog.addComponent("East", (Component)new Label(icon));
        }
        if (timeout != 0L) {
            dialog.setTimeout(timeout);
        }
        if (body.isScrollable()) {
            dialog.setScrollable(false);
        }
        dialog.show();
        return dialog.lastCommandPressed;
    }

    protected void onShow() {
        if (this.dialogType > 0) {
            Display.getInstance().playDialogSound(this.dialogType);
        }
    }

    public void show() {
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, this.modal);
        } else if (this.modal) {
            if (defaultDialogPosition == null) {
                super.showModal();
            } else {
                this.showPacked(defaultDialogPosition, true);
            }
        } else {
            this.showModeless();
        }
    }

    public void showModeless() {
        this.modal = false;
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, false);
        } else if (defaultDialogPosition == null) {
            this.showDialog(false);
        } else {
            this.showPacked(defaultDialogPosition, false);
        }
    }

    public Command showPacked(String position, boolean modal) {
        int height = Display.getInstance().getDisplayHeight();
        int width = Display.getInstance().getDisplayWidth();
        Container contentPane = this.getContentPane();
        Label title = this.getTitleComponent();
        Style contentPaneStyle = contentPane.getStyle();
        Style titleStyle = title.getStyle();
        Container menuBar = this.getSoftButton(0).getParent();
        int menuHeight = 0;
        if (menuBar != null) {
            Style menuStyle = menuBar.getStyle();
            menuHeight = menuBar.getPreferredH() + menuStyle.getMargin(0) + menuStyle.getMargin(2);
        }
        int prefHeight = contentPane.getPreferredH() + contentPaneStyle.getMargin(0) + contentPaneStyle.getMargin(2) + title.getPreferredH() + titleStyle.getMargin(0) + titleStyle.getMargin(2) + menuHeight;
        int prefWidth = contentPane.getPreferredW() + contentPaneStyle.getMargin(1) + contentPaneStyle.getMargin(3);
        prefWidth = Math.min(prefWidth, width);
        prefHeight = Math.min(prefHeight, height - (title.getPreferredH() + titleStyle.getMargin(0) + titleStyle.getMargin(2) + menuHeight));
        int topBottom = (height - prefHeight) / 2;
        int leftRight = (width - prefWidth) / 2;
        if (position.equals("Center")) {
            this.show(topBottom, topBottom, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("East")) {
            this.show(topBottom, topBottom, width - prefWidth, 0, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("West")) {
            this.show(topBottom, topBottom, 0, width - prefWidth, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("North")) {
            this.show(0, height - prefHeight, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("South")) {
            this.show(height - prefHeight, 0, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        throw new IllegalArgumentException("Unknown position: " + position);
    }

    public void dispose() {
        this.setDisposed(true);
        if (!this.menu) {
            super.dispose();
        }
    }

    public void refreshTheme() {
        Container content = this.getContentPane();
        content.refreshTheme(this.dialogUIID);
        Style titleStyle = this.getTitleStyle();
        if (titleStyle.isModified()) {
            titleStyle.merge(UIManager.getInstance().getComponentStyle(this.dialogTitleUIID));
        } else {
            this.setTitleStyle(UIManager.getInstance().getComponentStyle(this.dialogTitleUIID));
        }
        int size = content.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component cmp = content.getComponentAt(i);
            cmp.refreshTheme();
        }
    }

    public Command showDialog() {
        this.lastCommandPressed = null;
        this.show();
        return this.lastCommandPressed;
    }

    protected void actionCommand(Command cmd) {
        this.lastCommandPressed = cmd;
        if (this.menu || this.autoDispose && cmd.isDisposesDialog()) {
            this.dispose();
        }
    }

    public boolean animate() {
        if (this.time != 0L && System.currentTimeMillis() >= this.time) {
            this.time = 0L;
            this.dispose();
        }
        return false;
    }

    protected void sizeChanged(int w, int h) {
        Form frm = this.getPreviousForm();
        while (frm instanceof Dialog) {
            frm = frm.getPreviousForm();
        }
        frm.setSize(new Dimension(w, h));
        frm.setShouldCalcPreferredSize(true);
        frm.doLayout();
        super.sizeChanged(w, h);
    }

    boolean isMenu() {
        return this.menu;
    }

    void setMenu(boolean menu) {
        this.menu = menu;
    }

    void addSelectCommand() {
        if (!this.menu) {
            super.addSelectCommand();
        }
    }

    boolean isDisposed() {
        return this.disposed;
    }

    void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    public static void setDefaultDialogPosition(String p) {
        defaultDialogPosition = p;
    }

    public static String getDefaultDialogPosition() {
        return defaultDialogPosition;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public static void setDefaultDialogType(int d) {
        defaultDialogType = d;
    }

    public static int getDefaultDialogType() {
        return defaultDialogType;
    }

    static {
        defaultDialogType = 4;
    }
}

