/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class TextArea
extends Component {
    private static int defaultMaxSize = 124;
    private static boolean autoDegradeMaxSize = false;
    private static boolean hadSuccessfulEdit = false;
    private int linesToScroll = 1;
    private String unsupportedChars = "\t\r";
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    private int constraint = 0;
    private String text = "";
    private boolean editable = true;
    private int maxSize = defaultMaxSize;
    private int rows = 1;
    private int columns = 1;
    private static String id = "TextArea";
    private Vector rowStrings;
    private int widthForRowCalculations = -1;
    private int rowsGap = 2;
    private boolean triggerClose;
    private Vector actionListeners = null;
    private boolean growByContent = true;
    private static char widestChar = (char)87;

    public TextArea(int rows, int columns) {
        this("", defaultMaxSize, rows, columns, 0);
    }

    public TextArea(int rows, int columns, int constraint) {
        this("", defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, defaultMaxSize, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int constraint) {
        this(text, defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int maxSize) {
        this(text, maxSize, 1, 1, 0);
    }

    public TextArea(String text) {
        this(text, Math.max(defaultMaxSize, text.length()), 1, 1, 0);
    }

    public TextArea() {
        this("");
    }

    private TextArea(String text, int maxSize, int rows, int columns, int constraint) {
        this.maxSize = maxSize;
        this.setText(text);
        this.setConstraint(constraint);
        this.rows = rows;
        this.columns = columns;
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
    }

    public void setConstraint(int constraint) {
        this.constraint = constraint;
    }

    public int getConstraint() {
        return this.constraint;
    }

    public void setText(String t) {
        this.text = t != null ? t : "";
        this.setShouldCalcPreferredSize(true);
        if (this.maxSize < this.text.length()) {
            this.maxSize = this.text.length() + 1;
        }
        this.setScrollX(0);
        this.setScrollY(0);
        this.rowStrings = null;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        int action = Display.getInstance().getGameAction(keyCode);
        this.triggerClose = action == 8;
        Rectangle rect = new Rectangle(this.getScrollX(), this.getScrollY(), this.getWidth(), this.getHeight());
        Font textFont = this.getStyle().getFont();
        if (action == 6) {
            if (this.getScrollY() + this.getHeight() < (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines()) {
                rect.setY(rect.getY() + (textFont.getHeight() + this.rowsGap) * this.linesToScroll);
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        } else if (action == 1) {
            if (this.getScrollY() > 0) {
                rect.setY(Math.max(0, rect.getY() - (textFont.getHeight() + this.rowsGap) * this.linesToScroll));
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        }
    }

    protected void fireClicked() {
        this.onClick();
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    public void keyReleased(int keyCode) {
        int action = Display.getInstance().getGameAction(keyCode);
        if (this.isEditable() && this.triggerClose && action == 8) {
            this.triggerClose = false;
            this.onClick();
            return;
        }
    }

    public boolean isScrollableY() {
        return (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines() > this.getHeight();
    }

    protected void paintScrollbarY(Graphics g) {
        int prefH = (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines();
        float offset = (float)this.getScrollY() / (float)prefH;
        float block = (float)this.getHeight() / (float)prefH;
        UIManager.getInstance().getLookAndFeel().drawVerticalScroll(g, this, offset, block);
    }

    void onClick() {
        if (this.isEditable()) {
            this.editString();
        }
    }

    void editString() {
        if (autoDegradeMaxSize && !hadSuccessfulEdit && this.maxSize > 1024) {
            try {
                Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
            }
            catch (IllegalArgumentException err) {
                this.maxSize -= 1024;
                TextArea.setDefaultMaxSize(this.maxSize);
                this.editString();
            }
        } else {
            Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
        }
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.isEditable()) {
            this.onClick();
        }
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        this.setHandlesInput(this.isScrollableY());
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.setHandlesInput(false);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        this.setShouldCalcPreferredSize(true);
        this.columns = columns;
    }

    public void setRows(int rows) {
        this.setShouldCalcPreferredSize(true);
        this.rows = rows;
    }

    protected String getUIID() {
        return id;
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.getRowStrings();
        if (this.growByContent && this.rows < this.rowStrings.size()) {
            this.rows = this.rowStrings.size();
            this.setShouldCalcPreferredSize(true);
        }
    }

    private Vector getRowStrings() {
        if (this.rowStrings == null || this.widthForRowCalculations != this.getWidth()) {
            this.initRowString();
            this.setShouldCalcPreferredSize(true);
        }
        return this.rowStrings;
    }

    public int getLines() {
        Vector v = this.getRowStrings();
        v.trimToSize();
        int retVal = v.size();
        if (this.growByContent) {
            this.rows = Math.max(this.rows, retVal);
        }
        return retVal;
    }

    public String getTextAt(int line) {
        Vector rowsV = this.getRowStrings();
        return (String)rowsV.elementAt(line);
    }

    private int indexOf(char[] t, char c, int offset, int length) {
        for (int iter = offset; iter < t.length && iter < offset + length; ++iter) {
            if (t[iter] != c) continue;
            return iter;
        }
        return -1;
    }

    private boolean fastCharWidthCheck(char[] chrs, int off, int length, int width, int charWidth, Font f) {
        if (length * charWidth < width) {
            return true;
        }
        return f.charsWidth(chrs, off, length) < width;
    }

    protected char[] preprocess(String text) {
        return text.toCharArray();
    }

    private void initRowString() {
        this.rowStrings = new Vector();
        this.widthForRowCalculations = this.getWidth();
        if (this.rows == 1) {
            this.rowStrings.addElement(this.getText());
            return;
        }
        if (this.text == null || this.text.equals("")) {
            return;
        }
        char[] text = this.preprocess(this.getText());
        Style style = this.getStyle();
        Font font = style.getFont();
        int charWidth = font.charWidth(widestChar);
        int textAreaWidth = this.getWidth() - style.getPadding(3) - style.getPadding(1) - style.getMargin(3) - style.getMargin(1);
        if (textAreaWidth <= 0) {
            textAreaWidth = Math.min(10, this.columns) * charWidth;
        }
        int minCharactersInRow = Math.max(1, textAreaWidth / charWidth);
        int rowIndex = 0;
        int from = 0;
        int to = from + minCharactersInRow;
        int textLength = text.length;
        if (textLength / minCharactersInRow > Math.max(2, this.rows)) {
            textAreaWidth -= UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
        }
        String unsupported = this.getUnsupportedChars();
        to = Math.max(Math.min(textLength - 1, to), 0);
        while (to < textLength) {
            int i;
            if (to > textLength) {
                to = textLength;
            }
            int spaceIndex = -1;
            String rowText = "";
            int maxLength = to;
            for (i = to; i < textLength && this.fastCharWidthCheck(text, from, i - from, textAreaWidth, charWidth, font); ++i) {
                char c = text[i];
                if (unsupported.indexOf(c) > -1) {
                    text[i] = 32;
                }
                if (c == ' ' || c == '\n') {
                    spaceIndex = i;
                    if (c == '\n') break;
                }
                ++maxLength;
            }
            if (i == textLength || text[i] == ' ' || text[i] == '\n') {
                spaceIndex = i;
            }
            if (spaceIndex != -1) {
                int newLine = this.indexOf(text, '\n', from, spaceIndex - from);
                if (newLine > -1 && newLine < spaceIndex) {
                    spaceIndex = newLine;
                }
                rowText = new String(text, from, spaceIndex - from);
                from = spaceIndex + 1;
            } else {
                for (i = to; spaceIndex == -1 && i >= from; --i) {
                    char chr = text[i];
                    if (chr != ' ' && chr != '\n' && chr != '\t') continue;
                    spaceIndex = i;
                    int newLine = this.indexOf(text, '\n', from, i - from);
                    if (newLine > -1 && newLine < spaceIndex) {
                        spaceIndex = newLine;
                    }
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex + 1;
                }
                if (spaceIndex == -1) {
                    if (maxLength <= 0) {
                        maxLength = 1;
                    }
                    spaceIndex = maxLength;
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex;
                }
            }
            this.rowStrings.addElement(rowText);
            to = from;
            ++rowIndex;
        }
    }

    public int getRowsGap() {
        return this.rowsGap;
    }

    public void setRowsGap(int rowsGap) {
        this.rowsGap = rowsGap;
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawTextArea(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getTextAreaPreferredSize(this);
    }

    public void addActionListener(ActionListener a) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        if (!this.actionListeners.contains(a)) {
            this.actionListeners.addElement(a);
        }
    }

    public void removeActionListener(ActionListener a) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.removeElement(a);
    }

    void fireActionEvent() {
        if (this.actionListeners != null) {
            ActionEvent evt = new ActionEvent(this);
            for (int iter = 0; iter < this.actionListeners.size(); ++iter) {
                ActionListener a = (ActionListener)this.actionListeners.elementAt(iter);
                a.actionPerformed(evt);
            }
        }
    }

    void onEditComplete(String text) {
        this.setText(text);
    }

    public static void setDefaultMaxSize(int value) {
        defaultMaxSize = value;
    }

    public boolean isGrowByContent() {
        return this.growByContent;
    }

    public void setGrowByContent(boolean growByContent) {
        this.growByContent = growByContent;
    }

    public static void setAutoDegradeMaxSize(boolean value) {
        autoDegradeMaxSize = value;
    }

    public static boolean isAutoDegradeMaxSize() {
        return autoDegradeMaxSize;
    }

    public String getUnsupportedChars() {
        return this.unsupportedChars;
    }

    public void setUnsupportedChars(String unsupportedChars) {
        this.unsupportedChars = unsupportedChars;
    }

    public int getLinesToScroll() {
        return this.linesToScroll;
    }

    public void setLinesToScroll(int linesToScroll) {
        if (linesToScroll < 1) {
            throw new IllegalArgumentException("lines to scroll has to be >= 1");
        }
        this.linesToScroll = linesToScroll;
    }

    public static void setWidestChar(char widestC) {
        widestChar = widestC;
    }
}

