/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.plaf.Style;

public class Border {
    private static Border defaultBorder = Border.createEtchedRaised(131586, 0xBBBBBB);
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_LINE = 1;
    private static final int TYPE_ROUNDED = 2;
    private static final int TYPE_ROUNDED_PRESSED = 3;
    private static final int TYPE_ETCHED_LOWERED = 4;
    private static final int TYPE_ETCHED_RAISED = 5;
    private static final int TYPE_BEVEL_RAISED = 6;
    private static final int TYPE_BEVEL_LOWERED = 7;
    private static final int TYPE_IMAGE = 8;
    int type;
    Image[] images;
    boolean themeColors;
    int colorA;
    int colorB;
    int colorC;
    int colorD;
    int thickness;
    int arcWidth;
    int arcHeight;
    Border pressedBorder;
    Border focusBorder;
    private static Border empty;

    public static Border getEmpty() {
        if (empty == null) {
            empty = new Border();
        }
        return empty;
    }

    public static Border createEmpty() {
        return new Border();
    }

    public static Border createImageBorder(Image top, Image bottom, Image left, Image right, Image topLeft, Image topRight, Image bottomLeft, Image bottomRight, Image background) {
        Border b = new Border();
        b.type = 8;
        b.images = new Image[]{top, bottom, left, right, topLeft, topRight, bottomLeft, bottomRight, background};
        return b;
    }

    public static Border createImageBorder(Image top, Image topLeft, Image background) {
        Border b = new Border();
        b.type = 8;
        b.images = new Image[]{top, top.rotate(180), top.rotate(270), top.rotate(90), topLeft, topLeft.rotate(90), topLeft.rotate(270), topLeft.rotate(180), background};
        return b;
    }

    public static Border createLineBorder(int thickness) {
        Border b = new Border();
        b.type = 1;
        b.themeColors = true;
        b.thickness = thickness;
        return b;
    }

    public static Border createLineBorder(int thickness, int color) {
        Border b = new Border();
        b.type = 1;
        b.themeColors = false;
        b.thickness = thickness;
        b.colorA = color;
        return b;
    }

    public static Border createRoundBorder(int arcWidth, int arcHeight) {
        Border b = new Border();
        b.type = 2;
        b.themeColors = true;
        b.arcHeight = arcHeight;
        b.arcWidth = arcWidth;
        return b;
    }

    public static Border createRoundBorder(int arcWidth, int arcHeight, int color) {
        Border b = new Border();
        b.type = 2;
        b.themeColors = false;
        b.colorA = color;
        b.arcHeight = arcHeight;
        b.arcWidth = arcWidth;
        return b;
    }

    public static Border createEtchedLowered() {
        Border b = new Border();
        b.type = 4;
        b.themeColors = true;
        return b;
    }

    public static Border createEtchedLowered(int highlight, int shadow) {
        Border b = new Border();
        b.type = 4;
        b.themeColors = false;
        b.colorA = shadow;
        b.colorB = highlight;
        return b;
    }

    public static Border createEtchedRaised() {
        Border b = new Border();
        b.type = 5;
        b.themeColors = true;
        return b;
    }

    public static Border createEtchedRaised(int highlight, int shadow) {
        Border b = new Border();
        b.type = 5;
        b.themeColors = false;
        b.colorA = highlight;
        b.colorB = shadow;
        return b;
    }

    public boolean isBackgroundPainter() {
        return this.type == 2 || this.type == 3 || this.type == 8 && this.images[8] != null;
    }

    public static Border createBevelLowered() {
        Border b = new Border();
        b.type = 7;
        b.themeColors = true;
        return b;
    }

    public static Border createBevelLowered(int highlightOuter, int highlightInner, int shadowOuter, int shadowInner) {
        Border b = new Border();
        b.type = 7;
        b.themeColors = false;
        b.colorA = highlightOuter;
        b.colorB = highlightInner;
        b.colorC = shadowOuter;
        b.colorD = shadowInner;
        return b;
    }

    public static Border createBevelRaised() {
        Border b = new Border();
        b.type = 6;
        b.themeColors = true;
        return b;
    }

    public static Border createBevelRaised(int highlightOuter, int highlightInner, int shadowOuter, int shadowInner) {
        Border b = new Border();
        b.type = 6;
        b.themeColors = false;
        b.colorA = highlightOuter;
        b.colorB = highlightInner;
        b.colorC = shadowOuter;
        b.colorD = shadowInner;
        return b;
    }

    public void setPressedInstance(Border pressed) {
        this.pressedBorder = pressed;
    }

    public void setFocusedInstance(Border focused) {
        this.focusBorder = focused;
    }

    public Border getFocusedInstance() {
        if (this.focusBorder != null) {
            return this.focusBorder;
        }
        return this;
    }

    public Border getPressedInstance() {
        if (this.pressedBorder != null) {
            return this.pressedBorder;
        }
        return this;
    }

    public Border createPressedVersion() {
        if (this.pressedBorder != null) {
            return this.pressedBorder;
        }
        switch (this.type) {
            case 1: {
                return Border.createLineBorder(this.thickness + 1, this.colorA);
            }
            case 4: {
                Border b = Border.createEtchedRaised(this.colorA, this.colorB);
                b.themeColors = this.themeColors;
                return b;
            }
            case 5: {
                Border b = Border.createEtchedLowered(this.colorA, this.colorB);
                b.themeColors = this.themeColors;
                return b;
            }
            case 6: {
                Border b = Border.createBevelLowered(this.colorA, this.colorB, this.colorC, this.colorD);
                b.themeColors = this.themeColors;
                return b;
            }
            case 7: {
                Border b = Border.createBevelRaised(this.colorA, this.colorB, this.colorC, this.colorD);
                b.themeColors = this.themeColors;
                return b;
            }
            case 2: {
                Border b = Border.createRoundBorder(this.arcWidth, this.arcHeight, this.colorA);
                b.themeColors = this.themeColors;
                b.type = 3;
                return b;
            }
            case 3: {
                Border b = Border.createRoundBorder(this.arcWidth, this.arcHeight, this.colorA);
                b.themeColors = this.themeColors;
                return b;
            }
        }
        return this;
    }

    public void paintBorderBackground(Graphics g, Component c) {
        int originalColor = g.getColor();
        int x = c.getX();
        int y = c.getY();
        int width = c.getWidth();
        int height = c.getHeight();
        switch (this.type) {
            case 3: {
                ++x;
                ++y;
                width -= 2;
                height -= 2;
            }
            case 2: {
                --width;
                --height;
                Style s = c.getStyle();
                if (s.getBgImage() != null) {
                    Image i = Image.createImage(width, height);
                    Graphics imageG = i.getGraphics();
                    imageG.setColor(0);
                    imageG.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
                    int[] rgb = i.getRGB();
                    int transColor = rgb[0];
                    int[] imageRGB = s.getBgImage().scaled(width, height).getRGB();
                    for (int iter = 0; iter < rgb.length; ++iter) {
                        if (rgb[iter] != transColor) continue;
                        imageRGB[iter] = 0;
                    }
                    g.drawImage(new RGBImage(imageRGB, width, height), x, y);
                    break;
                }
                int foreground = g.getColor();
                if (c.hasFocus()) {
                    g.setColor(s.getBgSelectionColor());
                } else {
                    g.setColor(s.getBgColor());
                }
                if (s.getBgTransparency() == -1) {
                    g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
                } else if (g.isAlphaSupported()) {
                    int alpha = g.getAlpha();
                    g.setAlpha(s.getBgTransparency() & 0xFF);
                    g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
                    g.setAlpha(alpha);
                } else if (s.getBgTransparency() != 0) {
                    int[] imageRgb;
                    Graphics imageG;
                    Image i = Image.createImage(width, height);
                    if (g.getColor() != 0xFFFFFF) {
                        imageG = i.getGraphics();
                        imageG.setColor(g.getColor());
                        imageG.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
                        imageRgb = i.getRGB();
                    } else {
                        imageG = i.getGraphics();
                        imageG.setColor(0);
                        imageG.fillRect(0, 0, width, height);
                        imageG.setColor(g.getColor());
                        imageG.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
                        imageRgb = i.getRGB();
                    }
                    int removeColor = imageRgb[0];
                    int size = width * height;
                    int alphaInt = (s.getBgTransparency() & 0xFF) << 24 & 0xFF000000;
                    for (int iter = 0; iter < size; ++iter) {
                        if (removeColor == imageRgb[iter]) {
                            imageRgb[iter] = 0;
                            continue;
                        }
                        if ((imageRgb[iter] & 0xFF000000) == 0) continue;
                        imageRgb[iter] = imageRgb[iter] & 0xFFFFFF | alphaInt;
                    }
                    g.drawImage(new RGBImage(imageRgb, width, height), x, y);
                }
                g.setColor(foreground);
                break;
            }
            case 8: {
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipWidth = g.getClipWidth();
                int clipHeight = g.getClipHeight();
                Image topLeft = this.images[4];
                Image topRight = this.images[5];
                Image bottomLeft = this.images[6];
                Image center = this.images[8];
                g.clipRect(x += topLeft.getWidth(), y += topLeft.getHeight(), width -= topLeft.getWidth() + topRight.getWidth(), height -= topLeft.getHeight() + bottomLeft.getHeight());
                if (center != null) {
                    int centerWidth = center.getWidth();
                    int centerHeight = center.getHeight();
                    for (int xCount = x; xCount < x + width; xCount += centerWidth) {
                        for (int yCount = y; yCount < y + height; yCount += centerHeight) {
                            g.drawImage(center, xCount, yCount);
                        }
                    }
                }
                Image top = this.images[0];
                Image bottom = this.images[1];
                Image left = this.images[2];
                Image right = this.images[3];
                Image bottomRight = this.images[7];
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                x = c.getX();
                y = c.getY();
                width = c.getWidth();
                height = c.getHeight();
                g.drawImage(topLeft, x, y);
                g.drawImage(bottomLeft, x, y + height - bottomLeft.getHeight());
                g.drawImage(topRight, x + width - topRight.getWidth(), y);
                g.drawImage(bottomRight, x + width - bottomRight.getWidth(), y + height - bottomRight.getHeight());
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                this.drawImageBorderLine(g, topLeft, topRight, top, x, y, width);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                this.drawImageBorderLine(g, bottomLeft, bottomRight, bottom, x, y + height - bottom.getHeight(), width);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                this.drawImageBorderColumn(g, topLeft, bottomLeft, left, x, y, height);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                this.drawImageBorderColumn(g, topRight, bottomRight, right, x + width - left.getWidth(), y, height);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        }
        g.setColor(originalColor);
    }

    public void paint(Graphics g, Component c) {
        int originalColor = g.getColor();
        int x = c.getX();
        int y = c.getY();
        int width = c.getWidth();
        int height = c.getHeight();
        if (!this.themeColors) {
            g.setColor(this.colorA);
        }
        switch (this.type) {
            case 1: {
                --width;
                --height;
                for (int iter = 0; iter < this.thickness; ++iter) {
                    g.drawRect(x + iter, y + iter, width, height);
                    width -= 2;
                    height -= 2;
                }
                break;
            }
            case 3: {
                ++x;
                ++y;
                width -= 2;
                height -= 2;
            }
            case 2: {
                g.drawRoundRect(x, y, --width, --height, this.arcWidth, this.arcHeight);
                break;
            }
            case 4: 
            case 5: {
                g.drawRect(x, y, width - 2, height - 2);
                if (this.themeColors) {
                    if (this.type == 4) {
                        g.lighterColor(40);
                    } else {
                        g.darkerColor(40);
                    }
                } else {
                    g.setColor(this.colorB);
                }
                g.drawLine(x + 1, y + height - 3, x + 1, y + 1);
                g.drawLine(x + 1, y + 1, x + width - 3, y + 1);
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                g.drawLine(x + width - 1, y + height - 1, x + width - 1, y);
                break;
            }
            case 6: {
                if (this.themeColors) {
                    g.setColor(this.getBackgroundColor(c));
                    g.lighterColor(50);
                } else {
                    g.setColor(this.colorA);
                }
                g.drawLine(x, y, x, y + height - 2);
                g.drawLine(x + 1, y, x + width - 2, y);
                if (this.themeColors) {
                    g.darkerColor(25);
                } else {
                    g.setColor(this.colorB);
                }
                g.drawLine(x + 1, y + 1, x + 1, y + height - 3);
                g.drawLine(x + 2, y + 1, x + width - 3, y + 1);
                if (this.themeColors) {
                    g.darkerColor(50);
                } else {
                    g.setColor(this.colorC);
                }
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
                if (this.themeColors) {
                    g.darkerColor(25);
                } else {
                    g.setColor(this.colorD);
                }
                g.drawLine(x + 1, y + height - 2, x + width - 2, y + height - 2);
                g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 3);
                break;
            }
            case 7: {
                if (this.themeColors) {
                    g.setColor(this.getBackgroundColor(c));
                    g.darkerColor(50);
                } else {
                    g.setColor(this.colorD);
                }
                g.drawLine(x, y, x, y + height - 1);
                g.drawLine(x + 1, y, x + width - 1, y);
                if (this.themeColors) {
                    g.lighterColor(25);
                } else {
                    g.setColor(this.colorC);
                }
                g.drawLine(x + 1, y + 1, x + 1, y + height - 2);
                g.drawLine(x + 2, y + 1, x + width - 2, y + 1);
                if (this.themeColors) {
                    g.lighterColor(50);
                } else {
                    g.setColor(this.colorC);
                }
                g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
                g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 2);
                if (this.themeColors) {
                    g.lighterColor(25);
                } else {
                    g.setColor(this.colorA);
                }
                g.drawLine(x + 2, y + height - 2, x + width - 2, y + height - 2);
                g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 3);
                break;
            }
        }
        g.setColor(originalColor);
    }

    private int getBackgroundColor(Component c) {
        if (c.hasFocus()) {
            return c.getStyle().getBgSelectionColor();
        }
        return c.getStyle().getBgColor();
    }

    private void drawImageBorderLine(Graphics g, Image left, Image right, Image center, int x, int y, int width) {
        int currentWidth = width - right.getWidth();
        if (currentWidth > 0) {
            int destX = (x += left.getWidth()) + currentWidth;
            g.clipRect(x, y, currentWidth - left.getWidth(), center.getHeight());
            int centerWidth = center.getWidth();
            while (x < destX) {
                g.drawImage(center, x, y);
                x += centerWidth;
            }
        }
    }

    private void drawImageBorderColumn(Graphics g, Image top, Image bottom, Image center, int x, int y, int height) {
        int currentHeight = height - bottom.getHeight();
        if (currentHeight > 0) {
            int destY = (y += top.getHeight()) + currentHeight;
            g.clipRect(x, y, center.getWidth(), currentHeight - top.getHeight());
            int centerHeight = center.getHeight();
            while (y < destY) {
                g.drawImage(center, x, y);
                y += centerHeight;
            }
        }
    }

    public static void setDefaultBorder(Border border) {
        defaultBorder = border;
    }

    public static Border getDefaultBorder() {
        return defaultBorder;
    }
}

