/*
 * Decompiled with CFR 0.152.
 */
import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.animations.Transition3D;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.Resources;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.midlet.MIDlet;

public class BeerCounter
extends MIDlet
implements ActionListener {
    private Form mMainForm;
    private Form mSettingsForm;
    private Form mPriceForm;
    private Form previous;
    private Button button1;
    private Button button2;
    private Button current;
    private int iCount = 0;
    private int iOldCount = 0;
    private static final Command CMD_EXIT = new Command(LocalizationSupport.getMessage("EXIT"));
    private static final Command CMD_RESET = new Command(LocalizationSupport.getMessage("RESET"));
    private static final Command CMD_ABOUT = new Command(LocalizationSupport.getMessage("ABOUT"));
    private static final Command CMD_DEC = new Command(LocalizationSupport.getMessage("DECREMENT"));
    private static final Command CMD_SHOW = new Command(LocalizationSupport.getMessage("CONSUMPTION"));
    private static final Command CMD_DELETE = new Command(LocalizationSupport.getMessage("DELETE"));
    private static final Command CMD_BACK = new Command(LocalizationSupport.getMessage("BACK"));
    private static final Command CMD_EMPTY = new Command("");
    private static final Command CMD_DONE = new Command(LocalizationSupport.getMessage("DONE"));
    private static final Command CMD_PRICE_INPUT = new Command(LocalizationSupport.getMessage("PRICE_INPUT"));
    private static final Command CMD_SETTINGS = new Command(LocalizationSupport.getMessage("SETTINGS"));
    private static final Command CMD_OK = new Command(LocalizationSupport.getMessage("OK"), true);
    private final String DBHistory;
    private final String DBSession;
    private String mStrTime;
    private String mCurrency;
    private float mUnitPrice;
    private String mStrSettings = "";
    private int p1;
    private int p2;
    private int p3 = 0;
    private Label mTimeLabel = new Label();
    private Label mPriceLabel = new Label();
    private Label mUnitPriceLabel = new Label();
    private CheckBox cbTime;
    private CheckBox cbPrice;
    private RadioButton rbEur;
    private RadioButton rbUsd;
    private RadioButton rbGbp;
    private RadioButton rbYen;
    private RadioButton rbNo;
    private Image imageForm = null;

    public BeerCounter() {
        this.DBHistory = "bc_1";
        this.DBSession = "bc_2";
    }

    public void startApp() {
        Display.init(this);
        RecordManager rm = new RecordManager();
        String[] strSession = new String[5];
        rm.openRecStore("bc_2");
        strSession = rm.retrieveSession();
        rm.closeRecStore();
        try {
            Resources r = Resources.open("/res/beercounter.res");
            r.getTheme("BCTheme");
            UIManager.getInstance().setThemeProps(r.getTheme("BCTheme"));
            this.imageForm = Image.createImage("/res/wood_bg.jpg");
        }
        catch (IOException ex) {
            System.out.println("Couldn't load theme.");
            ex.printStackTrace();
        }
        this.iCount = 0;
        DateTime date = new DateTime();
        this.mStrTime = date.getTime();
        this.mUnitPrice = 0.0f;
        this.p3 = 0;
        this.p2 = 0;
        this.p1 = 0;
        this.mCurrency = " ";
        if (!strSession[0].equals("empty")) {
            this.iCount = Integer.parseInt(strSession[0]);
            this.mStrTime = strSession[1];
            this.mUnitPrice = Float.parseFloat(strSession[2]);
            int iUnitPriceWhole = (int)(this.mUnitPrice * 100.0f);
            int lenOfStr = Integer.toString(iUnitPriceWhole).length();
            if (iUnitPriceWhole != 0) {
                this.p1 = Integer.parseInt(Integer.toString(iUnitPriceWhole).substring(0, lenOfStr - 2));
                this.p2 = Integer.parseInt(Integer.toString(iUnitPriceWhole).substring(lenOfStr - 2, lenOfStr - 1));
                this.p3 = Integer.parseInt(Integer.toString(iUnitPriceWhole).substring(lenOfStr - 1, lenOfStr));
            }
            this.mStrSettings = strSession[3];
            String strCurrency = strSession[4];
            if (strCurrency.equals("EUR")) {
                this.setCurrency("\u20ac");
            } else if (strCurrency.equals("GBP")) {
                this.setCurrency("\u00a3");
            } else if (strCurrency.equals("USD")) {
                this.setCurrency("$");
            } else if (strCurrency.equals("JPY")) {
                this.setCurrency("\u00a5");
            } else {
                this.setCurrency(" ");
            }
        }
        this.createSettingsForm();
        this.createMainForm();
        this.mMainForm.show();
        this.createPriceForm();
    }

    private void createMainForm() {
        this.mMainForm = new Form();
        StyleManager sm = new StyleManager();
        this.mMainForm.setLayout(new BorderLayout());
        this.mMainForm.setStyle(sm.getMyStyle(0));
        this.mMainForm.setTitleStyle(sm.getMyStyle(0));
        this.mMainForm.setSoftButtonStyle(sm.getMyStyle("medium", 0));
        Font font = Font.createSystemFont(0, 1, 8);
        this.mMainForm.getMenuStyle().setFont(font);
        this.mMainForm.getMenuStyle().setBgImage(this.imageForm);
        this.button1 = this.createButton();
        this.button2 = this.createButton();
        this.current = this.button1;
        this.mMainForm.setBgImage(this.imageForm);
        this.mMainForm.addComponent("Center", (Component)this.button1);
        Container labelBar = new Container(new BoxLayout(1));
        this.mTimeLabel.setStyle(sm.getMyStyle("medium", 0));
        this.mPriceLabel.setStyle(sm.getMyStyle("medium", 0));
        labelBar.addComponent(this.mTimeLabel);
        labelBar.addComponent(this.mPriceLabel);
        this.setTimeAndPriceLabels();
        this.mMainForm.addComponent("South", (Component)labelBar);
        this.mMainForm.addCommand(CMD_EXIT);
        this.mMainForm.addCommand(CMD_ABOUT);
        this.mMainForm.addCommand(CMD_SETTINGS);
        this.mMainForm.addCommand(CMD_SHOW);
        this.mMainForm.addCommand(CMD_DEC);
        this.mMainForm.addCommand(CMD_RESET);
        this.mMainForm.setCommandListener(this);
    }

    private Button createButton() {
        Button button = new Button();
        StyleManager sm = new StyleManager();
        button.setText(Integer.toString(this.iCount));
        button.setFocusable(true);
        button.setBorderPainted(false);
        button.setAlignment(4);
        sm.getClass();
        button.setStyle(sm.getButtonStyle(1123417, this.getPicName()));
        button.addActionListener(this);
        return button;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String strCurrency) {
        this.mCurrency = strCurrency;
    }

    private void createPriceForm() {
        StyleManager sm = new StyleManager();
        this.mPriceForm = new Form(LocalizationSupport.getMessage("PRICE_INPUT"));
        this.mPriceForm.setTransitionOutAnimator(Transition3D.createCube(1000, false));
        this.mPriceForm.setLayout(new BorderLayout());
        this.mPriceForm.setBgImage(this.imageForm);
        Style style = this.mPriceForm.getStyle();
        sm.getClass();
        style.setBgColor(0);
        this.mPriceForm.setTitleStyle(sm.getMyStyle(0));
        this.mPriceForm.setSoftButtonStyle(sm.getMyStyle("medium", 0));
        Container priceContainer = new Container(new GridLayout(5, 3));
        priceContainer.setStyle(sm.getMyStyle(0));
        final Label PriceLabel1 = new Label("  " + Integer.toString(this.p1) + "    " + LocalizationSupport.getMessage("DECIMAL_SEP"));
        final Label PriceLabel2 = new Label(Integer.toString(this.p2));
        final Label PriceLabel3 = new Label(Integer.toString(this.p3));
        PriceLabel1.setStyle(sm.getMyStyle(0));
        PriceLabel2.setStyle(sm.getMyStyle(0));
        PriceLabel3.setStyle(sm.getMyStyle(0));
        final PriceControlButton ButtonUp1 = new PriceControlButton("up", "euro");
        ButtonUp1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.p1 = ButtonUp1.Up(BeerCounter.this.p1);
                PriceLabel1.setText("  " + Integer.toString(BeerCounter.this.p1) + "    " + LocalizationSupport.getMessage("DECIMAL_SEP"));
            }
        });
        final PriceControlButton ButtonUp2 = new PriceControlButton("up", "cent");
        ButtonUp2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.p2 = ButtonUp2.Up(BeerCounter.this.p2);
                PriceLabel2.setText(Integer.toString(BeerCounter.this.p2));
            }
        });
        final PriceControlButton ButtonUp3 = new PriceControlButton("up", "cent");
        ButtonUp3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.p3 = ButtonUp3.Up(BeerCounter.this.p3);
                PriceLabel3.setText(Integer.toString(BeerCounter.this.p3));
            }
        });
        final PriceControlButton ButtonDown1 = new PriceControlButton("down", "euro");
        ButtonDown1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.p1 = ButtonDown1.Down(BeerCounter.this.p1);
                PriceLabel1.setText("  " + Integer.toString(BeerCounter.this.p1) + "    " + LocalizationSupport.getMessage("DECIMAL_SEP"));
            }
        });
        final PriceControlButton ButtonDown2 = new PriceControlButton("down", "cent");
        ButtonDown2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.p2 = ButtonDown2.Down(BeerCounter.this.p2);
                PriceLabel2.setText(Integer.toString(BeerCounter.this.p2));
            }
        });
        final PriceControlButton ButtonDown3 = new PriceControlButton("down", "cent");
        ButtonDown3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.p3 = ButtonDown3.Down(BeerCounter.this.p3);
                PriceLabel3.setText(Integer.toString(BeerCounter.this.p3));
            }
        });
        this.mPriceForm.addComponent("North", (Component)new MyLabel(" "));
        priceContainer.addComponent(ButtonUp1);
        priceContainer.addComponent(ButtonUp2);
        priceContainer.addComponent(ButtonUp3);
        priceContainer.addComponent(PriceLabel1);
        priceContainer.addComponent(PriceLabel2);
        priceContainer.addComponent(PriceLabel3);
        priceContainer.addComponent(ButtonDown1);
        priceContainer.addComponent(ButtonDown2);
        priceContainer.addComponent(ButtonDown3);
        this.mPriceForm.addComponent("Center", (Component)priceContainer);
        this.mPriceForm.addCommand(CMD_EMPTY);
        this.mPriceForm.addCommand(CMD_DONE);
        this.mPriceForm.setCommandListener(this);
    }

    private void createSettingsForm() {
        StyleManager sm = new StyleManager();
        this.mSettingsForm = new Form(LocalizationSupport.getMessage("SETTINGS"));
        this.mSettingsForm.setTransitionOutAnimator(Transition3D.createCube(1000, true));
        this.mSettingsForm.setLayout(new BoxLayout(2));
        this.mSettingsForm.setTitleStyle(sm.getMyStyle(0));
        this.mSettingsForm.setStyle(sm.getMyStyle());
        this.mSettingsForm.setSoftButtonStyle(sm.getMyStyle("medium", 0));
        this.mSettingsForm.setBgImage(this.imageForm);
        this.cbTime = new CheckBox(LocalizationSupport.getMessage("CB_TIME"));
        this.cbPrice = new CheckBox(LocalizationSupport.getMessage("CB_PRICE"));
        this.cbTime.setStyle(sm.getMyStyle("medium", 0));
        this.cbPrice.setStyle(sm.getMyStyle("medium", 0));
        if (this.mStrSettings.equals("TP")) {
            this.cbTime.setSelected(true);
            this.cbPrice.setSelected(true);
        } else if (this.mStrSettings.equals("T")) {
            this.cbTime.setSelected(true);
            this.cbPrice.setSelected(false);
        } else if (this.mStrSettings.equals("P")) {
            this.cbTime.setSelected(false);
            this.cbPrice.setSelected(true);
        } else {
            this.cbTime.setSelected(false);
            this.cbPrice.setSelected(false);
        }
        this.mUnitPriceLabel.setStyle(sm.getMyStyle("medium", 0));
        this.rbEur = new RadioButton("\u20ac");
        this.rbUsd = new RadioButton("$");
        this.rbGbp = new RadioButton("\u00a3");
        this.rbYen = new RadioButton("\u00a5");
        this.rbNo = new RadioButton(LocalizationSupport.getMessage("NO_CUR"));
        this.rbEur.setStyle(sm.getMyStyle("medium", 0));
        this.rbGbp.setStyle(sm.getMyStyle("medium", 0));
        this.rbUsd.setStyle(sm.getMyStyle("medium", 0));
        this.rbYen.setStyle(sm.getMyStyle("medium", 0));
        this.rbNo.setStyle(sm.getMyStyle("medium", 0));
        if (this.getCurrency().equals("\u20ac")) {
            this.rbEur.setSelected(true);
        } else if (this.getCurrency().equals("$")) {
            this.rbUsd.setSelected(true);
        } else if (this.getCurrency().equals("\u00a3")) {
            this.rbGbp.setSelected(true);
        } else if (this.getCurrency().equals("\u00a5")) {
            this.rbYen.setSelected(true);
        } else {
            this.rbNo.setSelected(true);
        }
        this.mSettingsForm.addComponent(new MyLabel(" "));
        this.mSettingsForm.addComponent(this.cbTime);
        this.mSettingsForm.addComponent(this.cbPrice);
        this.mSettingsForm.addComponent(this.mUnitPriceLabel);
        this.mSettingsForm.addComponent(new MyLabel(" "));
        this.mSettingsForm.addComponent(new MyLabel(LocalizationSupport.getMessage("CURRENCY") + ":"));
        this.mSettingsForm.addComponent(this.rbEur);
        this.mSettingsForm.addComponent(this.rbUsd);
        this.mSettingsForm.addComponent(this.rbGbp);
        this.mSettingsForm.addComponent(this.rbYen);
        this.mSettingsForm.addComponent(this.rbNo);
        ButtonGroup groupCurrency = new ButtonGroup();
        groupCurrency.add(this.rbEur);
        groupCurrency.add(this.rbUsd);
        groupCurrency.add(this.rbGbp);
        groupCurrency.add(this.rbYen);
        groupCurrency.add(this.rbNo);
        this.rbEur.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.setCurrency("\u20ac");
                BeerCounter.this.setTimeAndPriceLabels();
            }
        });
        this.rbUsd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.setCurrency("$");
                BeerCounter.this.setTimeAndPriceLabels();
            }
        });
        this.rbGbp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.setCurrency("\u00a3");
                BeerCounter.this.setTimeAndPriceLabels();
            }
        });
        this.rbYen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.setCurrency("\u00a5");
                BeerCounter.this.setTimeAndPriceLabels();
            }
        });
        this.rbNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeerCounter.this.setCurrency(" ");
                BeerCounter.this.setTimeAndPriceLabels();
            }
        });
        this.mSettingsForm.addCommand(CMD_PRICE_INPUT);
        this.mSettingsForm.addCommand(CMD_DONE);
        this.mSettingsForm.setCommandListener(this);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.saveSession();
    }

    public void saveSession() {
        String strCbSel = null;
        strCbSel = this.cbTime.isSelected() && this.cbPrice.isSelected() ? "TP" : (this.cbTime.isSelected() ? "T" : (this.cbPrice.isSelected() ? "P" : "0"));
        String strCurSel = null;
        strCurSel = this.rbEur.isSelected() ? "EUR" : (this.rbUsd.isSelected() ? "USD" : (this.rbGbp.isSelected() ? "GBP" : (this.rbYen.isSelected() ? "JPY" : "0")));
        RecordManager rm = new RecordManager();
        rm.deleteRecStore("bc_2");
        rm.openRecStore("bc_2");
        String[] str = new String[]{Integer.toString(this.iCount), this.mStrTime, Float.toString(this.mUnitPrice), strCbSel, strCurSel};
        rm.saveSession(str);
        rm.closeRecStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFile(String path, byte[] data) {
        Connection c = null;
        OutputStream os = null;
        try {
            c = Connector.open((String)("file:///" + path), (int)3);
            FileConnection fc = (FileConnection)c;
            if (!fc.exists()) {
                fc.create();
            } else {
                fc.truncate(0L);
            }
            os = fc.openOutputStream();
            os.write(data);
            os.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Form currentForm = Display.getInstance().getCurrent();
        Transition3D transi = null;
        RecordManager rm = new RecordManager();
        StyleManager sm = new StyleManager();
        boolean bCountChange = false;
        if (ae.getCommand() == CMD_EXIT) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (ae.getCommand() == CMD_RESET) {
            if (this.iCount > 0) {
                this.iOldCount = this.iCount;
                this.iCount = 0;
                transi = Transition3D.createRotation(800, false);
                rm.openRecStore("bc_1");
                rm.writeRecord(this.iCount);
                rm.closeRecStore();
                bCountChange = true;
            }
        } else if (ae.getCommand() == CMD_DEC) {
            if (this.iCount > 0) {
                this.iOldCount = this.iCount--;
                transi = Transition3D.createRotation(800, false);
                rm.openRecStore("bc_1");
                rm.writeRecord(this.iCount);
                rm.closeRecStore();
                bCountChange = true;
            }
        } else if (ae.getCommand() == CMD_SHOW) {
            this.previous = currentForm;
            Form mLogForm = new Form(LocalizationSupport.getMessage("CONSUMPTION"));
            currentForm.setTransitionOutAnimator(Transition3D.createCube(1000, false));
            mLogForm.setTransitionOutAnimator(Transition3D.createCube(1000, true));
            mLogForm.setLayout(new BoxLayout(2));
            mLogForm.setTitleStyle(sm.getMyStyle(0));
            mLogForm.setStyle(sm.getMyStyle());
            mLogForm.setSoftButtonStyle(sm.getMyStyle("medium", 0));
            Font font = Font.createSystemFont(0, 1, 8);
            mLogForm.getMenuStyle().setFont(font);
            mLogForm.getMenuStyle().setBgImage(this.imageForm);
            mLogForm.setBgImage(this.imageForm);
            mLogForm.setScrollable(true);
            rm.openRecStore("bc_1");
            if (rm.getNumRecords() > 0) {
                mLogForm.addCommand(CMD_DELETE);
            } else {
                mLogForm.addCommand(CMD_EMPTY);
            }
            StyleManager styleManager = new StyleManager();
            String[] strArray = new String[9];
            int j = rm.getNumRecords();
            for (int i = 1; i <= rm.getNumRecords(); ++i) {
                strArray = rm.readRecords(i);
                Label textLabel = new Label();
                textLabel.setFocusable(true);
                textLabel.setAlignment(1);
                textLabel.setStyle(styleManager.getMyStyle("small", 0));
                textLabel.setText(strArray[0] + " " + strArray[1] + "." + strArray[2] + "." + strArray[3] + " " + strArray[5] + ":" + strArray[6] + ":" + strArray[7] + ": " + strArray[8]);
                mLogForm.addComponent(textLabel);
            }
            rm.closeRecStore();
            mLogForm.addCommand(CMD_BACK);
            mLogForm.setCommandListener(this);
            mLogForm.show();
        } else if (ae.getCommand() == CMD_BACK) {
            this.mUnitPrice = Float.parseFloat(Integer.toString(this.p1) + "." + Integer.toString(this.p2) + Integer.toString(this.p3));
            this.setTimeAndPriceLabels();
            this.previous.show();
        } else if (ae.getCommand() == CMD_PRICE_INPUT) {
            this.previous = currentForm;
            currentForm.setTransitionOutAnimator(Transition3D.createCube(1000, true));
            this.mPriceForm.show();
        } else if (ae.getCommand() == CMD_DONE && currentForm == this.mPriceForm) {
            this.mUnitPrice = Float.parseFloat(Integer.toString(this.p1) + "." + Integer.toString(this.p2) + Integer.toString(this.p3));
            this.setTimeAndPriceLabels();
            this.previous.show();
        } else if (ae.getCommand() == CMD_SETTINGS) {
            this.previous = currentForm;
            currentForm.setTransitionOutAnimator(Transition3D.createCube(1000, true));
            this.mUnitPrice = Float.parseFloat(Integer.toString(this.p1) + "." + Integer.toString(this.p2) + Integer.toString(this.p3));
            this.setTimeAndPriceLabels();
            this.mSettingsForm.show();
        } else if (ae.getCommand() == CMD_DONE && currentForm == this.mSettingsForm) {
            currentForm.setTransitionOutAnimator(Transition3D.createCube(1000, false));
            this.setTimeAndPriceLabels();
            this.mMainForm.show();
        } else if (ae.getCommand() == CMD_ABOUT) {
            Dialog.show(LocalizationSupport.getMessage("ABOUT"), this.getAppProperty("MIDlet-Name") + "\n" + this.getAppProperty("MIDlet-Version") + "\nEmail: beercounter@arcor.de", new Command[]{CMD_OK}, 4, null, 0L, (Transition)CommonTransitions.createSlide(0, true, 1000));
        } else if (ae.getCommand() == CMD_DELETE) {
            rm.deleteRecStore("bc_1");
            this.iCount = 0;
            bCountChange = true;
            this.previous.show();
        } else {
            this.iOldCount = this.iCount++;
            transi = Transition3D.createRotation(800, true);
            rm.openRecStore("bc_1");
            rm.writeRecord(this.iCount);
            rm.closeRecStore();
            bCountChange = true;
        }
        if (bCountChange) {
            DateTime date = new DateTime();
            this.mStrTime = date.getTime();
            if (this.current == this.button1) {
                Display.getInstance().vibrate(100);
                this.button1.setText(Integer.toString(this.iOldCount));
                this.button2.setText(Integer.toString(this.iCount));
                this.mMainForm.replace(this.button1, this.button2, transi);
                this.setTimeAndPriceLabels();
                this.current = this.button2;
            } else {
                Display.getInstance().vibrate(100);
                this.button2.setText(Integer.toString(this.iOldCount));
                this.button1.setText(Integer.toString(this.iCount));
                this.mMainForm.replace(this.button2, this.button1, transi);
                this.setTimeAndPriceLabels();
                this.current = this.button1;
            }
            this.saveSession();
        }
    }

    private String getPicName() {
        String strPicName = "/res/bc_mat.png";
        return strPicName;
    }

    private void setTimeAndPriceLabels() {
        if (this.cbTime.isSelected()) {
            this.mTimeLabel.setText(DateTime.getDayShort(Integer.parseInt(String.valueOf(this.mStrTime.charAt(0)))) + " " + this.mStrTime.charAt(1) + this.mStrTime.charAt(2) + ":" + this.mStrTime.charAt(3) + this.mStrTime.charAt(4));
        } else {
            this.mTimeLabel.setText("");
        }
        if (this.cbPrice.isSelected() && this.mUnitPrice * (float)this.iCount > 0.0f) {
            float totalPrice = this.mUnitPrice * (float)this.iCount;
            totalPrice = (int)((double)(totalPrice * 100.0f) + 0.5) / 100;
            if (LocalizationSupport.getMessage("CUR_POS").equals("0")) {
                this.mPriceLabel.setText(" " + this.getCurrency() + Float.toString(totalPrice).replace('.', LocalizationSupport.getMessage("DECIMAL_SEP").charAt(0)));
            } else {
                this.mPriceLabel.setText(" " + Float.toString(totalPrice).replace('.', LocalizationSupport.getMessage("DECIMAL_SEP").charAt(0)) + " " + this.getCurrency());
            }
        } else {
            this.mPriceLabel.setText("");
        }
        if (LocalizationSupport.getMessage("CUR_POS").equals("0")) {
            this.mUnitPriceLabel.setText("   " + LocalizationSupport.getMessage("UNIT_PRICE") + ": " + this.getCurrency() + Float.toString(this.mUnitPrice).replace('.', LocalizationSupport.getMessage("DECIMAL_SEP").charAt(0)));
        } else {
            this.mUnitPriceLabel.setText("   " + LocalizationSupport.getMessage("UNIT_PRICE") + ": " + Float.toString(this.mUnitPrice).replace('.', LocalizationSupport.getMessage("DECIMAL_SEP").charAt(0)) + " " + this.getCurrency());
        }
    }

    private class PriceControlButton
    extends Button {
        String strImgY = "";
        String strImgB = "";
        String strImgG = "";
        String mstrType = "";

        public PriceControlButton(String strDirection, String strType) {
            this.mstrType = strType;
            StyleManager sm = new StyleManager();
            this.setStyle(sm.getPriceButtonStyle());
            if (strDirection.equals("up")) {
                this.strImgY = "/res/yellow/32/object_08.png";
                this.strImgB = "/res/blue/32/object_08.png";
                this.strImgG = "/res/green/32/object_08.png";
            }
            if (strDirection.equals("down")) {
                this.strImgY = "/res/yellow/32/object_09.png";
                this.strImgB = "/res/blue/32/object_09.png";
                this.strImgG = "/res/green/32/object_09.png";
            }
            try {
                Image imgY = Image.createImage(this.strImgY);
                Image imgB = Image.createImage(this.strImgB);
                Image imgG = Image.createImage(this.strImgG);
                this.setIcon(imgY);
                this.setRolloverIcon(imgB);
                this.setPressedIcon(imgG);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public int Up(int iValue) {
            iValue = this.mstrType.equals("cent") && iValue == 9 || this.mstrType.equals("euro") && iValue == 999 ? 0 : ++iValue;
            return iValue;
        }

        public int Down(int iValue) {
            if (iValue == 0) {
                if (this.mstrType.equals("cent")) {
                    iValue = 9;
                } else if (this.mstrType.equals("euro")) {
                    iValue = 999;
                }
            } else {
                --iValue;
            }
            return iValue;
        }
    }

    private class MyLabel
    extends Label {
        public MyLabel(String str) {
            StyleManager sm = new StyleManager();
            this.setStyle(sm.getMyStyle("medium", 0));
            this.setText(str);
        }
    }
}

