/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.ImplementationFactory;
import com.sun.lwuit.impl.LWUITImplementation;
import java.util.Enumeration;
import java.util.Vector;

public final class Display {
    static final int POINTER_PRESSED = 1;
    static final int POINTER_RELEASED = 2;
    static final int POINTER_DRAGGED = 3;
    static final int POINTER_HOVER = 8;
    static final int KEY_PRESSED = 4;
    static final int KEY_RELEASED = 5;
    static final int KEY_LONG_PRESSED = 6;
    private static final int SIZE_CHANGED = 7;
    private Graphics lwuitGraphics;
    private boolean touchScreen;
    private int framerateLock = 20;
    private boolean lightMode;
    public static final int GAME_FIRE = 8;
    public static final int GAME_LEFT = 2;
    public static final int GAME_RIGHT = 5;
    public static final int GAME_UP = 1;
    public static final int GAME_DOWN = 6;
    public static final int KEY_POUND = 35;
    private static final Display INSTANCE = new Display();
    static int transitionDelay = -1;
    private LWUITImplementation impl;
    private Vector pendingSerialCalls = new Vector();
    private Thread edt;
    private Vector animationQueue;
    private boolean thirdSoftButton = false;
    private boolean editingText;
    public static final int SHOW_DURING_EDIT_IGNORE = 1;
    public static final int SHOW_DURING_EDIT_EXCEPTION = 2;
    public static final int SHOW_DURING_EDIT_ALLOW_DISCARD = 3;
    public static final int SHOW_DURING_EDIT_ALLOW_SAVE = 4;
    public static final int SHOW_DURING_EDIT_SET_AS_NEXT = 5;
    private int showDuringEdit;
    static final Object lock = new Object();
    private Vector inputEvents = new Vector();
    private boolean keyRepeatCharged;
    private boolean longPressCharged;
    private int longPressInterval = 1000;
    private long nextKeyRepeatEvent;
    private int keyRepeatValue;
    private int keyRepeatInitialIntervalTime = 800;
    private int keyRepeatNextIntervalTime = 10;
    private boolean block = false;
    private int dragActivationCounter = 0;
    private boolean processingSerialCalls;
    long time;
    private int lastKeyPressed;

    private Display() {
    }

    Vector getAnimationQueue() {
        return this.animationQueue;
    }

    public static void init(Object m) {
        if (Display.INSTANCE.impl == null) {
            Display.INSTANCE.impl = ImplementationFactory.getInstance().createImplementation();
            Display.INSTANCE.impl.setDisplayLock(lock);
            Display.INSTANCE.lwuitGraphics = new Graphics(Display.INSTANCE.impl.getNativeGraphics());
            Display.INSTANCE.impl.setLWUITGraphics(Display.INSTANCE.lwuitGraphics);
            Display.INSTANCE.impl.init(m);
            if (Display.INSTANCE.impl.getSoftkeyCount() > 0) {
                Form.leftSK = Display.INSTANCE.impl.getSoftkeyCode(0)[0];
                if (Display.INSTANCE.impl.getSoftkeyCount() > 1) {
                    Form.rightSK = Display.INSTANCE.impl.getSoftkeyCode(1)[0];
                    if (Display.INSTANCE.impl.getSoftkeyCode(1).length > 1) {
                        Form.rightSK2 = Display.INSTANCE.impl.getSoftkeyCode(1)[1];
                    }
                }
                Form.backSK = Display.INSTANCE.impl.getBackKeyCode();
                Form.backspaceSK = Display.INSTANCE.impl.getBackspaceKeyCode();
                Form.clearSK = Display.INSTANCE.impl.getClearKeyCode();
            }
            int width = INSTANCE.getDisplayWidth();
            int height = INSTANCE.getDisplayHeight();
            int colors = INSTANCE.numColors();
            boolean bl = Display.INSTANCE.lightMode = colors > 65536 && (long)(width * height * 30) > Runtime.getRuntime().totalMemory();
            if (Display.INSTANCE.edt == null) {
                Display.INSTANCE.touchScreen = Display.INSTANCE.impl.isTouchDevice();
                Display.INSTANCE.edt = new Thread("EDT"){

                    public void run() {
                        INSTANCE.mainEDTLoop();
                    }
                };
                Display.INSTANCE.edt.setPriority(6);
                Display.INSTANCE.edt.start();
            }
        }
    }

    public static Display getInstance() {
        return INSTANCE;
    }

    LWUITImplementation getImplementation() {
        return this.impl;
    }

    public void setFramerate(int rate) {
        this.framerateLock = 1000 / rate;
    }

    public void vibrate(int duration) {
        this.impl.vibrate(duration);
    }

    public void flashBacklight(int duration) {
        this.impl.flashBacklight(duration);
    }

    void blockEvents(boolean block) {
        this.block = block;
    }

    public void setShowDuringEditBehavior(int showDuringEdit) {
        this.showDuringEdit = showDuringEdit;
    }

    public int getShowDuringEditBehavior() {
        return this.showDuringEdit;
    }

    public int getFrameRate() {
        return 1000 / this.framerateLock;
    }

    public boolean isEdt() {
        return this.edt == Thread.currentThread();
    }

    void playDialogSound(int type) {
        this.impl.playDialogSound(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable r) {
        if (this.isEdt()) {
            throw new IllegalStateException("Call serially must never be invoked from the EDT");
        }
        Object object = lock;
        synchronized (object) {
            this.pendingSerialCalls.addElement(r);
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable r) {
        RunnableWrapper c = new RunnableWrapper(r, 0);
        this.callSerially(c);
        Object object = lock;
        synchronized (object) {
            while (!c.isDone()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException err) {}
            }
        }
    }

    void flushEdt() {
        while (!this.shouldEDTSleepNoFormAnimation()) {
            this.edtLoopImpl();
        }
        while (this.animationQueue != null && this.animationQueue.size() > 0) {
            this.edtLoopImpl();
        }
    }

    private void restoreMenu(Form f) {
        if (f != null) {
            f.restoreMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTransitionAnimation() {
        Animation ani = (Animation)this.animationQueue.elementAt(0);
        if (!ani.animate()) {
            this.animationQueue.removeElementAt(0);
            if (ani instanceof Transition) {
                Form source = (Form)((Transition)ani).getSource();
                this.restoreMenu(source);
                if (this.animationQueue.size() > 0) {
                    ani = (Animation)this.animationQueue.elementAt(0);
                    if (ani instanceof Transition) {
                        ((Transition)ani).initTransition();
                    }
                } else {
                    Form f = (Form)((Transition)ani).getDestination();
                    this.restoreMenu(f);
                    if (source == null || source == this.impl.getCurrentForm() || source == this.getCurrent()) {
                        this.setCurrentForm(f);
                    }
                    ((Transition)ani).cleanup();
                }
                return;
            }
        }
        ani.paint(this.lwuitGraphics);
        this.impl.flushGraphics();
        if (transitionDelay > 0) {
            try {
                Object source = lock;
                synchronized (source) {
                    lock.wait(transitionDelay);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainEDTLoop() {
        block16: {
            try {
                Object object = lock;
                synchronized (object) {
                    while (this.impl.getCurrentForm() == null) {
                        if (this.shouldEDTSleep()) {
                            lock.wait();
                        }
                        if (this.animationQueue != null && this.animationQueue.size() > 0) {
                            this.paintTransitionAnimation();
                            continue;
                        }
                        this.processSerialCalls();
                    }
                }
            }
            catch (Throwable err) {
                err.printStackTrace();
                if (this.impl.handleEDTException(err)) break block16;
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        while (true) {
            try {
                while (true) {
                    if (this.shouldEDTSleep()) {
                        Object err = lock;
                        synchronized (err) {
                            lock.wait();
                        }
                    }
                    this.edtLoopImpl();
                }
            }
            catch (Throwable err) {
                err.printStackTrace();
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void edtLoopImpl() {
        block10: {
            try {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(Math.max(1L, (long)this.framerateLock - this.time));
                        break block10;
                    }
                }
                this.paintTransitionAnimation();
                return;
            }
            catch (InterruptedException ignor) {
                ignor.printStackTrace();
            }
        }
        long currentTime = System.currentTimeMillis();
        while (this.inputEvents.size() > 0 && !this.block) {
            int[] i = (int[])this.inputEvents.elementAt(0);
            this.inputEvents.removeElementAt(0);
            this.handleEvent(i);
        }
        this.lwuitGraphics.setGraphics(this.impl.getNativeGraphics());
        this.impl.paintDirty();
        Form current = this.impl.getCurrentForm();
        current.repaintAnimations();
        if (!this.block) {
            long t = System.currentTimeMillis();
            if (this.keyRepeatCharged && this.nextKeyRepeatEvent <= t) {
                current.keyRepeated(this.keyRepeatValue);
                this.nextKeyRepeatEvent = t + (long)this.keyRepeatNextIntervalTime;
            }
            if (this.longPressCharged && (long)this.longPressInterval <= t) {
                this.longPressCharged = false;
                current.longKeyPress(this.keyRepeatValue);
            }
        }
        this.processSerialCalls();
        this.time = System.currentTimeMillis() - currentTime;
    }

    boolean hasNoSerialCallsPending() {
        return this.pendingSerialCalls.size() == 0;
    }

    public void onEditingComplete(Component c, String text) {
        c.onEditComplete(text);
        c.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSerialCalls() {
        this.processingSerialCalls = true;
        int size = this.pendingSerialCalls.size();
        if (size > 0) {
            int iter;
            Runnable[] array = new Runnable[size];
            for (iter = 0; iter < size; ++iter) {
                array[iter] = (Runnable)this.pendingSerialCalls.elementAt(iter);
            }
            this.pendingSerialCalls.removeAllElements();
            for (iter = 0; iter < size; ++iter) {
                array[iter].run();
            }
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
        this.processingSerialCalls = false;
    }

    boolean isProcessingSerialCalls() {
        return this.processingSerialCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndBlock(Runnable r) {
        if (this.isEdt()) {
            Object object = lock;
            synchronized (object) {
                RunnableWrapper w = new RunnableWrapper(r, 1);
                Thread t = new Thread(w);
                t.start();
                while (t.isAlive()) {
                    try {
                        lock.wait(this.framerateLock);
                        this.edtLoopImpl();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (w.getErr() != null) {
                    throw w.getErr();
                }
            }
        } else {
            r.run();
        }
    }

    public boolean isTouchScreenDevice() {
        return this.touchScreen;
    }

    public void setTouchScreenDevice(boolean touchScreen) {
        this.touchScreen = touchScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Form newForm) {
        if (this.edt == null) {
            throw new IllegalStateException("Initialize must be invoked before setCurrent!");
        }
        if (this.editingText) {
            switch (this.showDuringEdit) {
                case 3: {
                    break;
                }
                case 4: {
                    this.impl.saveTextEditingState();
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Show during edit");
                }
                case 1: {
                    return;
                }
                case 5: {
                    this.impl.setCurrentForm(newForm);
                    return;
                }
            }
        }
        if (!this.isEdt()) {
            this.callSerially(new RunnableWrapper(newForm, null));
            return;
        }
        Form current = this.impl.getCurrentForm();
        if (current != null) {
            current.hidePopups();
            if (current.isInitialized()) {
                current.deinitializeImpl();
            }
        }
        if (!newForm.isInitialized()) {
            newForm.initComponentImpl();
        }
        newForm.setShouldCalcPreferredSize(true);
        newForm.layoutContainer();
        Object object = lock;
        synchronized (object) {
            Transition t;
            Object o;
            boolean transitionExists = false;
            if (this.animationQueue != null && this.animationQueue.size() > 0 && (o = this.animationQueue.lastElement()) instanceof Transition) {
                current = (Form)((Transition)o).getDestination();
                this.impl.setCurrentForm(current);
            }
            if (current != null && current instanceof Dialog && ((Dialog)current).isMenu()) {
                t = current.getTransitionOutAnimator();
                if (t != null && ((Dialog)current).getPreviousForm() != null) {
                    this.initTransition(t.copy(), current, ((Dialog)current).getPreviousForm());
                }
                current = ((Dialog)current).getPreviousForm();
                this.impl.setCurrentForm(current);
            }
            if (newForm != current && (current != null && current.getTransitionOutAnimator() != null || newForm.getTransitionInAnimator() != null)) {
                if (this.animationQueue == null) {
                    this.animationQueue = new Vector();
                }
                if (current != null && !(newForm instanceof Dialog)) {
                    t = current.getTransitionOutAnimator();
                    if (current != null && t != null) {
                        this.initTransition(t.copy(), current, newForm);
                        transitionExists = true;
                    }
                }
                if (current != null && !(current instanceof Dialog) && (t = newForm.getTransitionInAnimator()) != null) {
                    this.initTransition(t.copy(), current, newForm);
                    transitionExists = true;
                }
            }
            lock.notify();
            if (!transitionExists) {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    this.setCurrentForm(newForm);
                } else {
                    t = CommonTransitions.createEmpty();
                    this.initTransition(t, current, newForm);
                }
            }
        }
    }

    private void initTransition(Transition transition, Form source, Form dest) {
        dest.setVisible(true);
        transition.init(source, dest);
        this.animationQueue.addElement(transition);
        if (this.animationQueue.size() == 1) {
            transition.initTransition();
        }
    }

    void setCurrentForm(Form newForm) {
        Form current = this.impl.getCurrentForm();
        if (current != null) {
            current.setVisible(false);
        }
        current = newForm;
        this.impl.setCurrentForm(current);
        current.setVisible(true);
        this.impl.confirmControlView();
        int w = current.getWidth();
        int h = current.getHeight();
        if (this.isEdt() && (w != this.impl.getDisplayWidth() || h != this.impl.getDisplayHeight())) {
            current.setSize(new Dimension(this.impl.getDisplayWidth(), this.impl.getDisplayHeight()));
            current.setShouldCalcPreferredSize(true);
            current.layoutContainer();
        }
        this.lastKeyPressed = 0;
        this.repaint(current);
    }

    public void setFlashGraphicsBug(boolean flushGraphicsBug) {
    }

    public void setTransitionYield(int transitionD) {
        transitionDelay = transitionD;
    }

    void editString(Component cmp, int maxSize, int constraint, String text) {
        this.editingText = true;
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.impl.editString(cmp, maxSize, constraint, text);
        this.editingText = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInputEvent(int[] ev) {
        Object object = lock;
        synchronized (object) {
            this.inputEvents.addElement(ev);
            lock.notify();
        }
    }

    private int[] createPointerEvent(int[] x, int[] y, int eventType) {
        if (x.length == 1) {
            return new int[]{eventType, x[0], y[0]};
        }
        int[] arr = new int[1 + x.length * 2];
        arr[0] = eventType;
        int arrayOffset = 1;
        for (int iter = 0; iter < x.length; ++iter) {
            arr[arrayOffset] = x[iter];
            arr[++arrayOffset] = y[iter];
            ++arrayOffset;
        }
        return arr;
    }

    private int[] createKeyEvent(int keyCode, boolean pressed) {
        if (pressed) {
            return new int[]{4, keyCode};
        }
        return new int[]{5, keyCode};
    }

    public void keyPressed(int keyCode) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createKeyEvent(keyCode, true));
        this.keyRepeatCharged = true;
        this.longPressCharged = true;
        this.keyRepeatValue = keyCode;
        this.nextKeyRepeatEvent = System.currentTimeMillis() + (long)this.keyRepeatInitialIntervalTime;
        this.lastKeyPressed = keyCode;
    }

    public void keyReleased(int keyCode) {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        if (keyCode != this.lastKeyPressed) {
            return;
        }
        this.addInputEvent(this.createKeyEvent(keyCode, false));
    }

    void keyRepeatedInternal(int keyCode) {
    }

    public void pointerDragged(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        ++this.dragActivationCounter;
        if (this.dragActivationCounter < 7) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 3));
    }

    public void pointerHover(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 8));
    }

    public void pointerPressed(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 1));
    }

    public void pointerReleased(int[] x, int[] y) {
        this.dragActivationCounter = 0;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 2));
    }

    public void sizeChanged(int w, int h) {
        Form current = this.impl.getCurrentForm();
        if (current == null) {
            return;
        }
        if (w == current.getWidth() && h == current.getHeight()) {
            return;
        }
        this.addInputEvent(this.createSizeChangedEvent(w, h));
    }

    private int[] createSizeChangedEvent(int w, int h) {
        return new int[]{7, w, h};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldEDTSleepNoFormAnimation() {
        Object object = lock;
        synchronized (object) {
            return this.inputEvents.size() == 0 && this.hasNoSerialCallsPending() && !this.keyRepeatCharged;
        }
    }

    private void handleEvent(int[] ev) {
        switch (ev[0]) {
            case 4: {
                this.impl.getCurrentForm().keyPressed(ev[1]);
                break;
            }
            case 5: {
                this.impl.getCurrentForm().keyReleased(ev[1]);
                break;
            }
            case 1: {
                this.impl.getCurrentForm().pointerPressed(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 2: {
                this.impl.getCurrentForm().pointerReleased(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 3: {
                this.impl.getCurrentForm().pointerDragged(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 8: {
                this.impl.getCurrentForm().pointerHover(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 7: {
                this.impl.getCurrentForm().sizeChanged(ev[1], ev[2]);
            }
        }
    }

    private int[] pointerEvent(int off, int[] event) {
        int[] peX = new int[event.length / 2];
        int offset = 0;
        for (int iter = off; iter < event.length; iter += 2) {
            peX[offset] = event[iter];
            ++offset;
        }
        return peX;
    }

    boolean shouldEDTSleep() {
        Form current = this.impl.getCurrentForm();
        return !(current != null && current.hasAnimations() || this.animationQueue != null && this.animationQueue.size() != 0 || this.inputEvents.size() != 0 || this.impl.hasPendingPaints() || !this.hasNoSerialCallsPending() || this.keyRepeatCharged);
    }

    Object getVideoControl(Object player) {
        return this.impl.getVideoControl(player);
    }

    Form getCurrentInternal() {
        return this.impl.getCurrentForm();
    }

    Form getCurrentUpcoming() {
        Form upcoming = null;
        if (this.animationQueue != null) {
            Enumeration e = this.animationQueue.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof Transition)) continue;
                upcoming = (Form)((Transition)o).getDestination();
            }
        }
        if (upcoming == null) {
            return this.getCurrent();
        }
        return upcoming;
    }

    public Form getCurrent() {
        Form current = this.impl.getCurrentForm();
        if (current != null && current instanceof Dialog && ((Dialog)current).isMenu()) {
            Form p = current.getPreviousForm();
            if (p != null) {
                return p;
            }
            Enumeration e = this.animationQueue.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof Transition)) continue;
                return (Form)((Transition)o).getDestination();
            }
        }
        return current;
    }

    public int numAlphaLevels() {
        return this.impl.numAlphaLevels();
    }

    public int numColors() {
        return this.impl.numColors();
    }

    public boolean isLightMode() {
        return this.lightMode;
    }

    public void setLightMode(boolean lightMode) {
        this.lightMode = lightMode;
    }

    public int getDisplayWidth() {
        return this.impl.getDisplayWidth();
    }

    public int getDisplayHeight() {
        return this.impl.getDisplayHeight();
    }

    void repaint(Animation cmp) {
        this.impl.repaint(cmp);
    }

    public int getGameAction(int keyCode) {
        return this.impl.getGameAction(keyCode);
    }

    public int getKeyCode(int gameAction) {
        return this.impl.getKeyCode(gameAction);
    }

    public void setSoftkeyCodes(int left, int right, int clear, int back) {
    }

    public boolean isThirdSoftButton() {
        return this.thirdSoftButton;
    }

    public void setThirdSoftButton(boolean thirdSoftButton) {
        this.thirdSoftButton = thirdSoftButton;
    }
}

