/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Calendar;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.EventDispatcher;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.UIManager;
import java.util.Date;

class MonthView
extends Component {
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    private long selectedDay;
    private EventDispatcher dispatcher = new EventDispatcher();
    private EventDispatcher dataChangeListeners = new EventDispatcher();
    private Calendar parent;

    public MonthView(long time, Calendar parent) {
        this.selectedDay = time;
        this.parent = parent;
    }

    protected String getUIID() {
        return "MonthView";
    }

    void focusGainedInternal() {
        this.setHandlesInput(true);
    }

    public void setHandlesInput(boolean b) {
        Form f = this.getComponentForm();
        if (f != null) {
            super.setHandlesInput(b || f.isSingleFocusMode());
        } else {
            super.setHandlesInput(b);
        }
    }

    public void keyReleased(int keyCode) {
        boolean right = true;
        boolean down = true;
        if (Display.getInstance().getGameAction(keyCode) != 8) {
            if (this.handlesInput()) {
                switch (Display.getInstance().getGameAction(keyCode)) {
                    case 1: {
                        down = false;
                    }
                    case 6: {
                        this.upDown(down);
                        break;
                    }
                    case 2: {
                        right = false;
                    }
                    case 5: {
                        this.leftRight(right);
                    }
                }
            }
            this.parent.componentChanged();
        } else {
            this.setHandlesInput(!this.handlesInput());
            if (this.handlesInput()) {
                this.fireActionEvent();
            } else {
                this.parent.componentChanged();
            }
        }
        this.repaint();
    }

    private void upDown(boolean down) {
        this.selectedDay += (long)(down ? 1 : -1) * 604800000L;
        this.dataChangeListeners.fireDataChangeEvent(0, 2);
    }

    private void leftRight(boolean forward) {
        this.selectedDay += (long)(forward ? 1 : -1) * 86400000L;
        this.dataChangeListeners.fireDataChangeEvent(0, 2);
    }

    public long getSelectedDay() {
        return this.selectedDay;
    }

    public void setSelectedDay(long day) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(new Date(this.selectedDay));
        int yearOld = cal.get(1);
        int monthOld = cal.get(2);
        int dayOld = cal.get(5);
        cal.setTime(new Date(day));
        int yearNew = cal.get(1);
        int monthNew = cal.get(2);
        int dayNew = cal.get(5);
        if (yearNew != yearOld || monthNew != monthOld || dayNew != dayOld) {
            this.selectedDay = day;
            this.repaint();
        }
    }

    public int getDayOfMonth() {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(new Date(this.selectedDay));
        return cal.get(5);
    }

    public int getMonth() {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(new Date(this.selectedDay));
        return cal.get(2);
    }

    public int getYear() {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(new Date(this.selectedDay));
        return cal.get(1);
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public void addDataChangeListener(DataChangedListener l) {
        this.dataChangeListeners.addListener(l);
    }

    public void removeDataChangeListener(DataChangedListener l) {
        this.dataChangeListeners.removeListener(l);
    }

    protected void fireActionEvent() {
        this.parent.componentChanged();
        super.fireActionEvent();
        this.dispatcher.fireActionEvent(new ActionEvent(this.parent));
    }

    public void pointerReleased(int x, int y) {
        this.setHandlesInput(true);
        this.setSelectedDay(UIManager.getInstance().getLookAndFeel().findDayAt(x, y, (Calendar)this.getParent(), this));
        this.fireActionEvent();
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawMonthView(g, (Calendar)this.getParent(), this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getMonthViewPreferredSize(this);
    }
}

