/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

public class Motion {
    private static final int LINEAR = 0;
    private static final int SPLINE = 1;
    private static final int FRICTION = 2;
    private int motionType;
    private int sourceValue;
    private int destinationValue;
    private int duration;
    private long startTime;
    private float initVelocity;
    private float friction;

    protected Motion(int sourceValue, int destinationValue, int duration) {
        this.sourceValue = sourceValue;
        this.destinationValue = destinationValue;
        this.duration = duration;
    }

    protected Motion(int sourceValue, float initVelocity, float friction) {
        this.sourceValue = sourceValue;
        this.initVelocity = initVelocity;
        this.friction = friction;
        this.duration = (int)(Math.abs(initVelocity) / friction);
    }

    public static Motion createLinearMotion(int sourceValue, int destinationValue, int duration) {
        Motion l = new Motion(sourceValue, destinationValue, duration);
        l.motionType = 0;
        return l;
    }

    public static Motion createSplineMotion(int sourceValue, int destinationValue, int duration) {
        Motion spline = new Motion(sourceValue, destinationValue, duration);
        spline.motionType = 1;
        return spline;
    }

    public static Motion createFrictionMotion(int sourceValue, float initVelocity, float friction) {
        Motion frictionMotion = new Motion(sourceValue, initVelocity, friction);
        frictionMotion.motionType = 2;
        return frictionMotion;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean isFinished() {
        return System.currentTimeMillis() > (long)this.duration + this.startTime;
    }

    private int getSplineValue() {
        if (this.isFinished()) {
            return this.destinationValue;
        }
        float totalTime = this.duration;
        float currentTime = (int)(System.currentTimeMillis() - this.startTime);
        currentTime = Math.min(currentTime, totalTime);
        int p = Math.abs(this.destinationValue - this.sourceValue);
        float centerTime = totalTime / 2.0f;
        float l = (float)p / (centerTime * centerTime);
        int x = this.sourceValue < this.destinationValue ? (currentTime > centerTime ? this.sourceValue + (int)(l * (-centerTime * centerTime + 2.0f * centerTime * currentTime - currentTime * currentTime / 2.0f)) : this.sourceValue + (int)(l * currentTime * currentTime / 2.0f)) : ((currentTime = totalTime - currentTime) > centerTime ? this.destinationValue + (int)(l * (-centerTime * centerTime + 2.0f * centerTime * currentTime - currentTime * currentTime / 2.0f)) : this.destinationValue + (int)(l * currentTime * currentTime / 2.0f));
        return x;
    }

    public int getValue() {
        if (this.motionType == 1) {
            return this.getSplineValue();
        }
        if (this.motionType == 2) {
            return this.getFriction();
        }
        return this.getLinear();
    }

    private int getLinear() {
        if (this.isFinished()) {
            return this.destinationValue;
        }
        float totalTime = this.duration;
        float currentTime = (int)(System.currentTimeMillis() - this.startTime);
        int dis = this.destinationValue - this.sourceValue;
        int val = (int)((float)this.sourceValue + currentTime / totalTime * (float)dis);
        if (this.destinationValue < this.sourceValue) {
            return Math.max(this.destinationValue, val);
        }
        return Math.min(this.destinationValue, val);
    }

    private int getFriction() {
        int time = (int)(System.currentTimeMillis() - this.startTime);
        int retVal = 0;
        retVal = (int)(Math.abs(this.initVelocity) * (float)time - this.friction * ((float)time * (float)time / 2.0f));
        if (this.initVelocity < 0.0f) {
            retVal *= -1;
        }
        return retVal += this.sourceValue;
    }

    public int getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(int sourceValue) {
        this.sourceValue = sourceValue;
    }

    protected long getStartTime() {
        return this.startTime;
    }
}

