// ==UserScript==
// @name		Plugsome Bar
// @version		1.02
// @date		2008-05-30
// @author		Joo Eiras
// ==/UserScript==

/*
* Copyright (c) 2008, Joo Eiras
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of the <organization> nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY JOO EIRAS ''AS IS'' AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL JOO EIRAS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
	Plugsome Bar
	
	This script is an utility that add a small toolbar to plugins in webpages.
	The toolbar by default has 3 buttons:
	 - the 1st button is a Reload button which reload the plugin content
	 - the 2nd button is a link to the external file that the plugin loaded.
	   Somefiles might get special treatment, like in youtube. Instead of linking
	   to youtube's media player swf, the script links to the video file.
	 - the 3rd button is a X which if clicked closes the toolbar, and if 
	   double-clicked removes the toolbar and plugin from the page. 
	   The space that the plugin occupied is preserved though.
	
	If the toolbar is attached to a Flash file, then you get two extra button s:
	a play and a pause button. Note however, that play and pause might not pause/resume
	plyback in all flash files. This is due to the file's internal structure, and the
	way content is layed out in the Flash's timeline.
	
	History:
	1.02 - 2008-06-11
	  * Option to show toolbar when plugins are disabled
	  * Added Quicktime and window media player controls toolbar
	
	1.01 - 2008-06-02
	  * Fixed problem which duplicated tht toolbar when pressing "Replace"
	  * Override Opera bug - PluginInitialized not fired when there's no script element in page
	  * Useless toolbars are removed from PlugsomeToolbar.AllToolbars
	  
	1.0 - 2008-05-30	
	  * Initial release
	  
*/
(function(){
	/* Config */
	var showIfPluginsDisabled = false;
	var youtubeHightQuality = false;

	/* rest of script */
	var script_version = '1.02';
	
	var urlHandlers = {};
	urlHandlers['youtube.']=function(object, link){
		var fv = object.getAttribute('flashvars');
		if( fv ){
			var vidarg='',targ='';
			fv.replace(/[\?&](video_id|t)=([^&]+)/g,function($0,$1,$2){
				switch(String($1).toLowerCase()){
				case 'video_id':vidarg = $2;break;
				case 't': targ = $2;break;
				};
			});
			if( vidarg && targ ){
				link.href = 'http://www.youtube.com/get_video?video_id='+vidarg+'&t='+targ+(youtubeHightQuality?'&fmt=18':'');
				return true;
			};
		};
	};
	
	var pluginHandlers = [
		{	//flash
			supports:function(o){
				return (o.getAttribute('type')||'').indexOf("shockwave")>=0 ||
					(o.getAttribute('data')||'').match(/\.swf([\?#].*)?$/) ||
					(o.getAttribute('src')||'').match(/\.swf([\?#].*)?$/);
			},
			play:function(o){
				o.Play();
			},
			stop:function(o){
				o.StopPlay();
			}
		},
		{	//quicktime
			supports:function(o){
				return (o.getAttribute('type')||'').indexOf("quicktime")>=0 ||
					(o.getAttribute('data')||'').match(/\.mov([\?#].*)?$/) ||
					(o.getAttribute('src')||'').match(/\.mov([\?#].*)?$/);
			},
			play:function(o){
				o.Play();
			},
			stop:function(o){
				o.Stop();
			}
		},
		{	//wmv
			supports:function(o){
				return (o.getAttribute('type')||'').indexOf("oleobject")>=0 ||
					(o.getAttribute('type')||'').indexOf("wmv")>=0 ||
					(o.getAttribute('type')||'').indexOf("ms-video")>=0 ||
					(o.getAttribute('data')||'').match(/\.wmv([\?#].*)?$/) ||
					(o.getAttribute('src')||'').match(/\.wmv([\?#].*)?$/);
			},
			play:function(o){
				try{
					o.controls.Play()
				}catch(ex){
					o.Play();
				}
			},
			stop:function(o){
				try{
					o.controls.Stop()
				}catch(ex){
					o.Stop();
				}
			}
		}
	];
	pluginHandlers.verify=function(o){
		for(var k=0,p;p=this[k];k++)
			if( p.supports(o) )
				return p;
		return null;
	};
	
	function removeFromArray(ar,el){
		var r = [];
		for(var k=0,gap=0;k<ar.length;k++){
			if(gap>0)
				ar[k-gap]=ar[k];
			if(ar[k]==el)
				gap++;
		};
		ar.length=ar.length-gap;
		return ar;
	};
		
	function isNodeAncestorOrSelfOf(ancestor,node){
		if( ancestor && node )
			do{
				if(node == ancestor)
					return true;
			}while(node=node.parentNode);
		return false;
	};
	function get_y(obj){
		var y = 0;
		if(obj)
			do{
				y += obj.offsetTop;
			}while(obj=obj.offsetParent);
		return y;
	}
	function get_x(obj){
		var x = 0;
		if(obj)
			do{
				x += obj.offsetLeft;
			}while(obj=obj.offsetParent);
		return x;
	}
	function fillObjectLink(o, link){
		var host = location.host, linkhref;
		//youtube
		for(var h in urlHandlers){
			if( host.indexOf(h)>=0 ){
				if( urlHandlers[h](o,link) )
					return true;
			}
		}
		return fillObjectLinkFallback(o, link);
		
	};
	function fillObjectLinkFallback(o, link){
		//generic treatment
		linkhref = o.getAttribute('data')||o.getAttribute('src')||
			(o.getAttribute('type')&&o.getAttribute('type').indexOf('java')>=0?o.getAttribute('archive'):'');
		if( linkhref ){
			link.href = linkhref;
			return true;
		};
		var names=['movie','data','src','code','filename','url'];
		for(var m=0,n;n=names[m];m++){
			link = o.selectSingleNode('param[translate(@name,"'+n.toUpperCase()+'","'+n+'")='+
				'translate("'+n+'","'+n.toUpperCase()+'","'+n+'")][@value]');
			if( link ){
				link.href = link.getAttribute('value');
				return true;
			};
		};
		return false;
	};
		
	var clones = [];
	function resetPositions(){
		for(var k=0,m;k<clones.length;k++){
			if( m=clones[k] ){
				var o = m.__object;
				if( o && o.parentNode ){
					m.style.top =(get_y(o)-m.offsetHeight)+'px!important';
					m.style.left = get_x(o)+'px!important';
				}
				else if( m && m.parentNode ){
					//if object is deleted from document, then remove toolbar
					removeMenu(m);
				}
			};
		};
	};
	function removeMenu(m){
		removeFromArray(clones,m);
		if(m&&m.parentNode)
			m.parentNode.removeChild(m);
	};
	
	var def_styles = 'border:steelblue thin solid!important;vertical-align:middle!important;text-align:center!important;'+
		'background-color:white!important;padding:0!important;margin:0!important;display:inline-block!important;'+
		'font-family:sans-serif!important;font-weight:bold!important;color:steelblue!important;height:100%!important;'+
		'font-size:10px!important;text-decoration:underline!important;width:48px!important;box-sizing:border-box!important;';
		
	function patchObject(o,data){
		if( !o || o.nodeType!=1 )
			return;
		var is_plugin = pluginHandlers.verify(o);
		if(!data.template){
			data.fragment = document.createDocumentFragment();
			
			var template = data.template = document.createElement('plugsometoolbar');
			template.style='border:white thin solid!important;padding:0!important;margin:0!important;position:absolute!important;width:122px!important;'+
				'font-size:10px!important;z-index:9999!important;height:18px!important;box-sizing:border-box!important;opacity:0.08!important';
			template.innerHTML = '<button style="'+def_styles+'">Reload</button>'+
				'<a style="'+def_styles+'color:gray!important;">No link</a>'+
				'<button title="Click to close, double-click to delete." style="'+def_styles+
					';font-size:110%!important;width:24px!important">X</button>';
		}
		if( is_plugin && !data.media_template){
			var lazy = document.createElement('y');
			lazy.innerHTML += 
				'<button title="Click to pause" style="'+def_styles+';width:48px!important">Pause</button>'+
				'<button title="Click to play" style="'+def_styles+';width:48px!important">Play</button>';
			var template = data.media_template = document.createDocumentFragment();
			while(lazy.firstChild){
				template.appendChild(lazy.firstChild);
			}
		}
		var menu = data.template.cloneNode(true);
			
		clones.push(menu);
		menu.__object = o;
		o.__plugin_menu = menu;

		menu.onmouseover=function(e){
			resetPositions();
			this.style.opacity='1!important';
		};
		menu.onmouseout=function(e){
			if(!isNodeAncestorOrSelfOf(this,e.relatedTarget))
			this.style.opacity='0.08!important';
		};
		menu.firstChild.onclick=function(){
			var o = this.parentNode.__object;
			var ns = o.nextSibling;
			var p = o.parentNode;
			o.outerHTML = o.outerHTML;
			
			o = (ns ? ns.previousSibling : p.lastChild);
			this.parentNode.__object = o;
			o.__plugin_menu = this.parentNode;
		}
		var closeButton = menu.getElementsByTagName('button')[1];
		closeButton.ondblclick=function(){
			this.__clicking = false;
			var o = this.parentNode.__object;
			if( o ){ o.outerHTML = o.outerHTML.replace(/(src|data|value|archive|type)=(["'])[^"']*\2/g,''); }
			removeMenu(this.parentNode);
		};
		closeButton.onclick=function(){
			this.__clicking = true;
			setTimeout(function(obj){
				if(obj.__clicking){
					removeMenu(obj.parentNode);
				}
			},250,this);
		};
			
		if( is_plugin ){
			var mediacontrols = data.media_template.cloneNode(true);
			
			var pauseButton = mediacontrols.childNodes[0];
			var playButton = mediacontrols.childNodes[1];
			
			menu.appendChild(mediacontrols);
			menu.style.width='218px!important';
			menu.pluginControl = is_plugin;
			
			pauseButton.onclick=function(){
				var m = this.parentNode;
				var c = m.pluginControl;
				var o = m.__object;
				c.stop(o);
			};
			playButton.onclick=function(){
				var m = this.parentNode;
				var c = m.pluginControl;
				var o = m.__object;
				c.play(o);
			};
		};
		
		var link=menu.childNodes[1];
		if( fillObjectLink(o,link) ){
			link.style.color='steelblue!important';
			link.textContent='Link';
		};
		
		data.fragment.appendChild(menu);
	};
	
	var addResizeListener = function(){
		addEventListener('resize',resetPositions,false);
		addResizeListener = function(){};
	};
	var data = {template:null,fragment:null};
	if( opera ){
		opera.addEventListener('PluginInitialized',function(e){
			if(e.element.__plugin_menu){
				//object is patched, must abort
				return;
			};
			patchObject(e.element,data);
			if(data.fragment){
				document.documentElement.appendChild(data.fragment);
				resetPositions();
				
				addResizeListener();
			}
		},false);
		
		opera.PlugsomeToolbar = {
			version: script_version,
			URLHandlers: urlHandlers,
			URLHandlerFallback: fillObjectLinkFallback,
			AllToolbars: clones
		};
	}
	
	addEventListener('load',function(){
		if( (!opera || document.scripts.length==0) && (showIfPluginsDisabled ? 1 : navigator.plugins.length) ){
			var k=0;
			for(var o,os=document.selectNodes('//object[@type and @data] | //embed[not(ancestor::object[@type and @data]) and @type and @src]');o=os[k];k++){
				setTimeout(patchObject,k*50,o,data);
			};
			if( k>0 ){
				setTimeout(function(){
					if(data.fragment)
						document.documentElement.appendChild(data.fragment);
					resetPositions();
				},k*50);				
				addResizeListener();
			}
		}
	},false);
	
})( window.opera );









