/*
 * Decompiled with CFR 0.152.
 */
package rheise.jftpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.file.FileConnection;
import myutil.StringTokenizer;
import rheise.jftpd.CommandException;
import rheise.jftpd.PassiveConnector;
import rheise.jftpd.Representation;
import rheise.jftpd.Server;
import rheise.jftpd.ServerDTP;
import rheise.jftpd.TransmissionMode;

public class ServerPI
implements Runnable {
    private SocketConnection clientSocket;
    private InputStream reader;
    private PrintStream writer;
    private ServerDTP dtp;
    private String username;
    private String password;
    private String validUser;
    private String validPassword;
    private String baseDir = "";
    private String currentDir = "/";
    private String fromName = "";
    char[] cbuf = new char[1024];
    int bufcount = 0;
    int nread = 0;

    public ServerPI(SocketConnection socketConnection, String string, String string2, String string3) throws IOException {
        this.baseDir = string;
        this.clientSocket = socketConnection;
        this.reader = socketConnection.openInputStream();
        this.validUser = string2;
        this.validPassword = string3;
        this.writer = new PrintStream(socketConnection.openOutputStream());
        this.dtp = new ServerDTP(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.clientLoop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.clientSocket.close();
                this.reader.close();
                this.writer.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String readLine(InputStream inputStream) throws IOException {
        String string = "";
        int n = inputStream.read();
        while (n != -1 && (char)n != '\r' && (char)n != '\n') {
            string = string + (char)n;
            n = inputStream.read();
        }
        if ((char)n == '\r') {
            n = inputStream.read();
        }
        if (n == -1 && string.length() == 0) {
            return null;
        }
        return string;
    }

    private void clientLoop() throws Exception {
        this.reply(220, "MobShareFTP server (Version 0.1) ready.");
        String string = null;
        while ((string = this.readLine(this.reader)) != null) {
            Server.debugOutput("Command received: " + string);
            Server.alert(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken().toLowerCase();
            try {
                int n = this.handleCommand(string2, string, stringTokenizer);
                if (n != 221) continue;
                return;
            }
            catch (CommandException commandException) {
                this.reply(commandException.getCode(), commandException.getText());
            }
            catch (NoSuchElementException noSuchElementException) {
                this.reply(500, "'" + string + "': command not understood.");
            }
            catch (Exception exception) {
                Server.debugOutput(exception.toString());
                Server.alert(exception.toString());
                this.reply(500, "'" + string + "': Unknown error; " + exception.getMessage());
            }
        }
    }

    private int handleCommand(String string, String string2, StringTokenizer stringTokenizer) throws CommandException {
        int n = 0;
        if ((string = string.toLowerCase()).equals("user")) {
            n = this.handle_user(string2, stringTokenizer);
        } else if (string.equals("pass")) {
            n = this.handle_pass(string2, stringTokenizer);
        } else if (string.equals("acct")) {
            n = this.handle_acct(string2, stringTokenizer);
        } else if (string.equals("cwd")) {
            n = this.handle_cwd(string2, stringTokenizer);
        } else if (string.equals("cdup")) {
            n = this.handle_cdup(string2, stringTokenizer);
        } else if (string.equals("smnt")) {
            n = this.handle_smnt(string2, stringTokenizer);
        } else if (string.equals("quit")) {
            n = this.handle_quit(string2, stringTokenizer);
        } else if (string.equals("rein")) {
            n = this.handle_rein(string2, stringTokenizer);
        } else if (string.equals("port")) {
            n = this.handle_port(string2, stringTokenizer);
        } else if (string.equals("pasv")) {
            n = this.handle_pasv(string2, stringTokenizer);
        } else if (string.equals("type")) {
            n = this.handle_type(string2, stringTokenizer);
        } else if (string.equals("stru")) {
            n = this.handle_stru(string2, stringTokenizer);
        } else if (string.equals("mode")) {
            n = this.handle_mode(string2, stringTokenizer);
        } else if (string.equals("retr")) {
            n = this.handle_retr(string2, stringTokenizer);
        } else if (string.equals("stor")) {
            n = this.handle_stor(string2, stringTokenizer);
        } else if (string.equals("stou")) {
            n = this.handle_stou(string2, stringTokenizer);
        } else if (string.equals("appe")) {
            n = this.handle_appe(string2, stringTokenizer);
        } else if (string.equals("allo")) {
            n = this.handle_allo(string2, stringTokenizer);
        } else if (string.equals("rest")) {
            n = this.handle_rest(string2, stringTokenizer);
        } else if (string.equals("rnfr")) {
            n = this.handle_rnfr(string2, stringTokenizer);
        } else if (string.equals("rnto")) {
            n = this.handle_rnto(string2, stringTokenizer);
        } else if (string.equals("abor")) {
            n = this.handle_abor(string2, stringTokenizer);
        } else if (string.equals("dele")) {
            n = this.handle_dele(string2, stringTokenizer);
        } else if (string.equals("rmd")) {
            n = this.handle_rmd(string2, stringTokenizer);
        } else if (string.equals("mkd")) {
            n = this.handle_mkd(string2, stringTokenizer);
        } else if (string.equals("pwd")) {
            n = this.handle_pwd(string2, stringTokenizer);
        } else if (string.equals("list")) {
            n = this.handle_list(string2, stringTokenizer);
        } else if (string.equals("nlst")) {
            n = this.handle_nlst(string2, stringTokenizer);
        } else if (string.equals("site")) {
            n = this.handle_site(string2, stringTokenizer);
        } else if (string.equals("syst")) {
            n = this.handle_syst(string2, stringTokenizer);
        } else if (string.equals("stat")) {
            n = this.handle_stat(string2, stringTokenizer);
        } else if (string.equals("help")) {
            n = this.handle_help(string2, stringTokenizer);
        } else if (string.equals("noop")) {
            n = this.handle_noop(string2, stringTokenizer);
        } else if (string.equals("size")) {
            this.handle_size(string2, stringTokenizer);
        } else if (string.equals("mdtm")) {
            n = this.handle_mdtm(string2, stringTokenizer);
        } else {
            n = 500;
            this.reply(500, "'" + string + "': command not understood.");
        }
        return n;
    }

    public int handle_user(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.username = stringTokenizer.nextToken();
        if (this.username.equalsIgnoreCase("anonymous") && !this.validUser.equalsIgnoreCase("anonymous")) {
            throw new CommandException(530, "Anonymous connection is not allowed.");
        }
        return this.reply(331, "Password required for " + this.username + ".");
    }

    public int handle_pass(String string, StringTokenizer stringTokenizer) throws CommandException {
        if (this.username == null) {
            throw new CommandException(503, "Login with USER first.");
        }
        String string2 = null;
        string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        this.password = string2;
        if (!this.validUser.equalsIgnoreCase("anonymous") && !string2.equals(this.validPassword)) {
            throw new CommandException(530, "Login incorrect.");
        }
        return this.reply(230, "User " + this.username + " logged in.");
    }

    public int handle_acct(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_cwd(String string, StringTokenizer stringTokenizer) throws CommandException {
        String string2;
        String string3;
        this.checkLogin();
        try {
            string2 = string3 = string.substring(4);
        }
        catch (Exception exception) {
            throw new CommandException(550, "No directory specified");
        }
        string2 = this.resolvePath(string2);
        if (!string2.equals("/")) {
            string2 = string2 + "/";
        }
        Server.debugOutput("Changing directory to " + string2);
        FileConnection fileConnection = null;
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(string2)));
            }
            catch (IOException iOException) {
                throw new CommandException(550, string3 + ": could not open directory. Error:" + iOException);
            }
            if (!fileConnection.exists()) {
                throw new CommandException(550, string3 + ": no such directory");
            }
            if (!fileConnection.isDirectory()) {
                throw new CommandException(550, string3 + ": not a directory");
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        this.currentDir = string2;
        return this.reply(250, "CWD command successful.");
    }

    public int handle_cdup(String string, StringTokenizer stringTokenizer) throws CommandException {
        stringTokenizer = new StringTokenizer("..");
        string = "cwd ..";
        return this.handle_cwd(string, stringTokenizer);
    }

    public int handle_smnt(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_quit(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.username = null;
        this.password = null;
        return this.reply(221, "Goodbye.");
    }

    public int handle_rein(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        this.username = null;
        this.password = null;
        this.currentDir = "/";
        this.dtp = new ServerDTP(this);
        return this.reply(220, "Service ready for new user.");
    }

    public int handle_port(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        String string7 = string3 + "." + string4 + "." + string5 + "." + string6;
        int n3 = n << 8 | n2;
        this.dtp.setDataPort(string7, n3);
        this.dtp.setMode(true);
        return this.reply(200, "PORT command successful.");
    }

    public int handle_pasv(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        PassiveConnector passiveConnector = new PassiveConnector();
        String string2 = passiveConnector.getAddress();
        if (passiveConnector == null) {
            throw new CommandException(425, "Cannot open passive connection.");
        }
        int n = passiveConnector.getPort();
        stringTokenizer = new StringTokenizer(string2, ".");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + stringTokenizer.nextToken() + ",";
        }
        int n2 = n >> 8;
        int n3 = n - (n2 << 8);
        string3 = string3 + Integer.toString(n2) + "," + Integer.toString(n3);
        this.dtp.setMode(false);
        this.dtp.setPassiveConnector(passiveConnector);
        passiveConnector.start();
        return this.reply(227, "Entering passive mode (" + string3 + ")");
    }

    public int handle_type(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = stringTokenizer.nextToken().toUpperCase();
        if (string2.length() != 1) {
            throw new CommandException(500, "TYPE: invalid argument '" + string2 + "'");
        }
        char c = string2.charAt(0);
        Representation representation = Representation.get(c);
        if (representation == null) {
            throw new CommandException(500, "TYPE: invalid argument '" + string2 + "'");
        }
        this.dtp.setRepresentation(representation);
        return this.reply(200, "Type set to " + string2);
    }

    public int handle_stru(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = stringTokenizer.nextToken().toUpperCase();
        try {
            if (string2.length() != 1) {
                throw new Exception();
            }
            char c = string2.charAt(0);
            switch (c) {
                case 'F': {
                    this.dtp.setDataStructure(c);
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        }
        catch (Exception exception) {
            throw new CommandException(500, "STRU: invalid argument '" + string2 + "'");
        }
        return this.reply(200, "STRU " + string2 + " ok.");
    }

    public int handle_mode(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = stringTokenizer.nextToken().toUpperCase();
        if (string2.length() != 1) {
            throw new CommandException(500, "MODE: invalid argument '" + string2 + "'");
        }
        char c = string2.charAt(0);
        TransmissionMode transmissionMode = TransmissionMode.get(c);
        if (transmissionMode == null) {
            throw new CommandException(500, "MODE: invalid argument '" + string2 + "'");
        }
        this.dtp.setTransmissionMode(transmissionMode);
        return this.reply(200, "MODE " + string2 + " ok.");
    }

    public int handle_retr(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = null;
        try {
            string2 = string.substring(5);
        }
        catch (Exception exception) {
            throw new CommandException(501, string + " No filename given");
        }
        string2 = this.createNativePath(string2);
        return this.dtp.sendFile(string2);
    }

    public int handle_stor(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = null;
        try {
            string2 = string.substring(5);
        }
        catch (Exception exception) {
            throw new CommandException(501, string + "No filename given");
        }
        string2 = this.createNativePath(string2);
        return this.dtp.receiveFile(string2);
    }

    public int handle_stou(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_appe(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_allo(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_rest(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_rnfr(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        this.fromName = this.resolvePath(string.substring(5));
        return this.reply(350, "Requested file action pending further information.");
    }

    public int handle_rnto(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        if (this.fromName.equals(" ")) {
            throw new CommandException(500, "RNTO not correctly preceded by RNFR");
        }
        String string2 = this.resolvePath(string.substring(5));
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.fromName, "/");
        StringTokenizer stringTokenizer3 = new StringTokenizer(string2, "/");
        String string3 = "";
        while (stringTokenizer2.hasMoreTokens() && stringTokenizer3.hasMoreTokens()) {
            String string4 = stringTokenizer2.nextToken();
            string3 = stringTokenizer3.nextToken();
            if (!stringTokenizer3.hasMoreTokens() || string3.equals(string4)) continue;
            throw new CommandException(553, "Can only rename, not move files");
        }
        if (stringTokenizer2.hasMoreTokens() || stringTokenizer3.hasMoreTokens()) {
            throw new CommandException(553, "Can only rename, not move files");
        }
        FileConnection fileConnection = null;
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(this.fromName)));
            }
            catch (Exception exception) {
                throw new CommandException(500, "'" + string + "': Cannot open file; " + exception.getMessage());
            }
            if (!fileConnection.exists()) {
                throw new CommandException(503, "Cannot find the file which has to be renamed.");
            }
            try {
                fileConnection.rename(string3);
            }
            catch (IOException iOException) {
                throw new CommandException(553, "'" + string + "': Cannot rename file; " + iOException.getMessage());
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (Exception exception) {}
            this.fromName = "";
        }
        return this.reply(250, "Requested file action okay, file renamed");
    }

    public int handle_abor(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_dele(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = string.substring(5);
        String string3 = this.resolvePath(string2);
        FileConnection fileConnection = null;
        Server.debugOutput("Deleting file: " + this.createNativePath(string3));
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(string3)), (int)3);
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": could not open file, " + iOException);
            }
            if (!fileConnection.exists()) {
                throw new CommandException(550, string2 + ": file does not exist");
            }
            try {
                fileConnection.delete();
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": could not delete file; " + iOException.getMessage());
            }
            catch (Exception exception) {
                throw new CommandException(550, string2 + ": Unknown error; " + exception.getMessage());
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return this.reply(250, "DELE command successful.");
    }

    public int handle_rmd(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = string.substring(4);
        String string3 = this.resolvePath(string2);
        FileConnection fileConnection = null;
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(string3)));
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": could not open directory; " + iOException.getMessage());
            }
            if (!fileConnection.exists()) {
                throw new CommandException(550, string2 + ": directory does not exist");
            }
            if (!fileConnection.isDirectory()) {
                throw new CommandException(550, string2 + ": not a directory");
            }
            try {
                fileConnection.delete();
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": could not remove directory");
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return this.reply(250, "RMD command successful.");
    }

    public int handle_mkd(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = string.substring(4);
        String string3 = this.resolvePath(string2);
        FileConnection fileConnection = null;
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(string3)));
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": could not create file; " + iOException.getMessage());
            }
            if (fileConnection.exists()) {
                throw new CommandException(550, string2 + ": file exists");
            }
            try {
                fileConnection.mkdir();
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": directory could not be created");
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return this.reply(257, "\"" + string3 + "\" directory created");
    }

    public int handle_pwd(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        System.out.println(this.currentDir);
        return this.reply(257, "\"" + this.currentDir + "\"");
    }

    public int handle_list(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = null;
        string2 = stringTokenizer.hasMoreTokens() ? string.substring(5) : this.currentDir;
        return this.dtp.sendList(this.createNativePath(string2));
    }

    public int handle_nlst(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = null;
        string2 = stringTokenizer.hasMoreTokens() ? string.substring(5) : this.currentDir;
        string2 = this.createNativePath(string2);
        return this.dtp.sendNameList(string2);
    }

    public int handle_site(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_syst(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        return this.reply(215, "UNIX - I mean Java.");
    }

    public int handle_stat(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': command not supported.");
    }

    public int handle_help(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + string + "': NO HELP FOR YOU!");
    }

    public int handle_noop(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        return this.reply(200, "NOOP command successful.");
    }

    public int handle_size(String string, StringTokenizer stringTokenizer) throws CommandException {
        long l;
        this.checkLogin();
        String string2 = string.substring(5);
        String string3 = this.resolvePath(string2);
        FileConnection fileConnection = null;
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(string3)));
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": unable to open file, " + iOException);
            }
            if (!fileConnection.exists()) {
                throw new CommandException(550, string2 + ": no such file");
            }
            if (fileConnection.isDirectory()) {
                throw new CommandException(550, string2 + ": not a plain file");
            }
            Representation representation = this.dtp.getRepresentation();
            try {
                l = representation.sizeOf(fileConnection);
            }
            catch (IOException iOException) {
                throw new CommandException(550, iOException.getMessage());
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return this.reply(213, "" + l);
    }

    public int handle_mdtm(String string, StringTokenizer stringTokenizer) throws CommandException {
        this.checkLogin();
        String string2 = string.substring(5);
        String string3 = this.resolvePath(string2);
        FileConnection fileConnection = null;
        String string4 = "";
        try {
            try {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.createNativePath(string3)));
            }
            catch (IOException iOException) {
                throw new CommandException(550, string2 + ": unable to open file, " + iOException);
            }
            if (!fileConnection.exists()) {
                throw new CommandException(550, string2 + ": no such file");
            }
            Date date = new Date(fileConnection.lastModified());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            int n4 = calendar.get(11);
            int n5 = calendar.get(12);
            int n6 = calendar.get(13);
            string4 = this.zeropad(n, 4) + this.zeropad(n2, 2) + this.zeropad(n3, 2) + this.zeropad(n4, 2) + this.zeropad(n5, 2) + this.zeropad(n6, 2);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return this.reply(213, string4);
    }

    private String zeropad(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    int reply(int n, String string) {
        String string2 = n + " " + string;
        this.writer.println(string2);
        this.writer.flush();
        Server.alert(string2);
        Server.debugOutput("Reply sendt: " + string2);
        return n;
    }

    String createNativePath(String string) {
        String string2 = null;
        string2 = string.charAt(0) == '/' ? this.baseDir + string : this.baseDir + this.currentDir + string;
        return string2;
    }

    String resolvePath(String string) {
        CharSequence charSequence;
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = this.currentDir + string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Stack<CharSequence> stack = new Stack<CharSequence>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (((String)charSequence).equals("..")) {
                if (stack.empty()) continue;
                stack.pop();
                continue;
            }
            if (((String)charSequence).equals(".")) continue;
            stack.push(charSequence);
        }
        charSequence = new StringBuffer("/");
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            ((StringBuffer)charSequence).append(enumeration.nextElement());
            System.out.println("hamllo");
            if (!enumeration.hasMoreElements()) continue;
            ((StringBuffer)charSequence).append("/");
        }
        return ((StringBuffer)charSequence).toString();
    }

    void checkLogin() throws CommandException {
        if (this.password == null) {
            throw new CommandException(530, "Please login with USER and PASS.");
        }
        if (!(this.validUser.equalsIgnoreCase("anonymous") || this.validUser.equalsIgnoreCase(this.username) && this.validPassword.equals(this.password))) {
            throw new CommandException(530, "Please login with USER and PASS.");
        }
    }
}

