/*
 * Decompiled with CFR 0.152.
 */
import com.samsung.util.Vibration;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class MobileChessCanvas
extends Canvas {
    private MobileChess McMidlet;
    private MobileChessBoard McBoard;
    private MobileChessSave McSave;
    private MobileChessAgent McAgent;
    private MobileChessMessage McMessage;
    private MobileChessAnykey McAnykey;
    private MobileChessAnimation McAnimation;
    private MobileChessAudio McAudio;
    private byte GameMode;
    private byte MenuMode;
    public byte LevelMode;
    private byte PlayMode;
    private byte PlayerMode;
    public byte MessageMode;
    private byte AnimationMode;
    private Image BackBuf;
    private Graphics BackG;
    private int CanvasWidth;
    private int CanvasHeight;
    private int KeyCode;
    private int KeyCode2;
    private byte CurrentMenuNum;
    private boolean StateVibration;
    private boolean StateSound;
    private int CursorPos;
    private int CursorPosPrev;
    private int[] MoveList;
    private boolean[] PathList;
    private Timer MessageTimer;
    private int PieceMove;
    private int PieceMovePos;
    private Image ImageTitle;
    private Image ImageBoard;
    private Image ImageMenu;
    private Image ImageMode;
    private Image ImageLevel;
    private Image ImageOption;
    private Image ImageHelp;
    private Image ImageOnStart;
    private Image ImageOn1vs2;
    private Image ImageOn1vsCom;
    private Image ImageOnContinue;
    private Image ImageOnHelp;
    private Image ImageOnOption;
    private Image ImageOnEasy;
    private Image ImageOnNormal;
    private Image ImageOnHard;
    private Image ImageOnOk;
    private Image ImageOnSound;
    private Image ImageOnVibration;
    private Image ImageOffSound;
    private Image ImageOffVibration;
    private Image ImageWK;
    private Image ImageWQ;
    private Image ImageWR;
    private Image ImageWB;
    private Image ImageWN;
    private Image ImageWP;
    private Image ImageBK;
    private Image ImageBQ;
    private Image ImageBR;
    private Image ImageBB;
    private Image ImageBN;
    private Image ImageBP;
    private Image ImageBalloon;
    private Image ImageBalloon2;
    private Image ImageMBishop;
    private Image ImageMKing;
    private Image ImageMKnight;
    private Image ImageMNothing;
    private Image ImageMPawn;
    private Image ImageMQueen;
    private Image ImageMRook;
    private Image ImageSCheck;
    private Image ImageSCMate;
    private Image ImageSDraw;
    private Image ImageSThinking;
    private static final byte MODE_LOGO = 28;
    private static final byte MODE_TITLE = 0;
    private static final byte MODE_MENU = 1;
    private static final byte MODE_MODE = 31;
    private static final byte MODE_OPTION = 2;
    private static final byte MODE_LEVEL = 3;
    private static final byte MODE_PLAY = 4;
    private static final byte MODE_END = 5;
    private static final byte MODE_START = 32;
    private static final byte MODE_1PVSCOM = 6;
    private static final byte MODE_1PVS2P = 7;
    private static final byte MODE_CONTINUE = 8;
    private static final byte MODE_HELP = 17;
    public static final byte MODE_HARD = 9;
    public static final byte MODE_NORMAL = 10;
    public static final byte MODE_EASY = 11;
    private static final byte MODE_TURNPLAYER = 12;
    private static final byte MODE_TURNAGENT = 13;
    private static final byte MODE_PLAYINIT = 14;
    private static final byte MODE_PLAYERGRAPPIECE = 15;
    private static final byte MODE_PLAYERRELEASEPIECE = 16;
    public static final byte MODE_MESSAGENONE = 17;
    public static final byte MODE_MESSAGECHECK = 20;
    public static final byte MODE_MESSAGECMATE = 21;
    public static final byte MODE_MESSAGEDRAW = 22;
    public static final byte MODE_MESSAGETHINK = 23;
    public static final byte MODE_ANION = 24;
    public static final byte MODE_ANIOFF = 25;
    public static final byte MODE_ANYKEYON = 26;
    public static final byte MODE_ANYKEYOFF = 27;
    public static final byte MODE_LOGOON = 29;
    public static final byte MODE_LOGOOFF = 30;
    private static final int STARTCURSORPOS = 41;
    private static final int BOARDX = 4;
    private static final int BOARDY = 35;
    private static final byte[][] BOARDPOSX = new byte[][]{{9, 22, 34, 47, 60, 73, 86, 98, 112}, {8, 21, 34, 47, 60, 73, 86, 99, 112}, {7, 21, 33, 47, 60, 73, 87, 99, 113}, {6, 20, 33, 46, 60, 74, 87, 100, 114}, {5, 19, 32, 46, 60, 74, 88, 101, 115}, {4, 18, 32, 46, 60, 74, 88, 102, 116}, {2, 17, 31, 46, 60, 74, 89, 103, 118}, {1, 16, 31, 45, 60, 75, 89, 104, 119}, {0, 15, 30, 45, 60, 75, 90, 105, 120}};
    private static final byte[] BOARDPOSY = new byte[]{0, 11, 22, 34, 46, 59, 72, 86, 100};
    public static final int KEY_CANCEL = -8;

    public MobileChessCanvas(MobileChess mobileChess) {
        this.McMidlet = mobileChess;
        this.McBoard = new MobileChessBoard();
        this.McSave = new MobileChessSave();
        this.setFullScreenMode(true);
        this.GameMode = 0;
        this.KeyCode = -999;
        this.KeyCode2 = -999;
        this.StateVibration = false;
        this.StateSound = true;
        this.CursorPos = 41;
        this.PlayMode = (byte)14;
        this.PlayerMode = (byte)15;
        this.MessageMode = (byte)17;
        this.AnimationMode = (byte)25;
        this.MoveList = null;
        this.PathList = new boolean[144];
        this.CanvasWidth = 128;
        this.CanvasHeight = 160;
        this.BackBuf = Image.createImage((int)this.CanvasWidth, (int)this.CanvasHeight);
        this.BackG = this.BackBuf.getGraphics();
        this.LoadMenuImage();
        this.MessageTimer = new Timer();
        this.McAnykey = new MobileChessAnykey();
        this.MessageTimer.schedule((TimerTask)this.McAnykey, 4000L, 4000L);
        this.ShowTitle();
        if (this.StateSound) {
            this.McAudio = new MobileChessAudio("/title.mmf");
        }
        this.GameLoop();
    }

    public void DestroyGame() {
    }

    public void keyPressed(int n) {
        this.KeyCode = this.getGameAction(n);
        this.KeyCode2 = n;
        this.GameLoop();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.BackBuf, 0, 0, 20);
    }

    public void LoadMenuImage() {
        this.ImageBoard = null;
        this.ImageWK = null;
        this.ImageWQ = null;
        this.ImageWR = null;
        this.ImageWB = null;
        this.ImageWN = null;
        this.ImageWP = null;
        this.ImageBK = null;
        this.ImageBQ = null;
        this.ImageBR = null;
        this.ImageBB = null;
        this.ImageBN = null;
        this.ImageBP = null;
        this.ImageBalloon = null;
        this.ImageBalloon2 = null;
        this.ImageMBishop = null;
        this.ImageMKing = null;
        this.ImageMKnight = null;
        this.ImageMNothing = null;
        this.ImageMPawn = null;
        this.ImageMQueen = null;
        this.ImageMRook = null;
        this.ImageSCheck = null;
        this.ImageSCMate = null;
        this.ImageSDraw = null;
        this.ImageSThinking = null;
        System.gc();
        try {
            this.ImageTitle = Image.createImage((String)"/title.png");
            this.ImageMenu = Image.createImage((String)"/menu.png");
            this.ImageMode = Image.createImage((String)"/mode.png");
            this.ImageLevel = Image.createImage((String)"/level.png");
            this.ImageOption = Image.createImage((String)"/option.png");
            this.ImageHelp = Image.createImage((String)"/help.png");
            this.ImageOnStart = Image.createImage((String)"/on_start.png");
            this.ImageOn1vs2 = Image.createImage((String)"/on_1vs2.png");
            this.ImageOn1vsCom = Image.createImage((String)"/on_1vsc.png");
            this.ImageOnContinue = Image.createImage((String)"/on_cont.png");
            this.ImageOnHelp = Image.createImage((String)"/on_help.png");
            this.ImageOnOption = Image.createImage((String)"/on_option.png");
            this.ImageOnEasy = Image.createImage((String)"/on_easy.png");
            this.ImageOnNormal = Image.createImage((String)"/on_normal.png");
            this.ImageOnHard = Image.createImage((String)"/on_hard.png");
            this.ImageOnOk = Image.createImage((String)"/on_ok.png");
            this.ImageOnSound = Image.createImage((String)"/on_sound.png");
            this.ImageOnVibration = Image.createImage((String)"/on_vibration.png");
            this.ImageOffSound = Image.createImage((String)"/off_sound.png");
            this.ImageOffVibration = Image.createImage((String)"/off_vibration.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void LoadPlayImage() {
        this.ImageTitle = null;
        this.ImageMenu = null;
        this.ImageMode = null;
        this.ImageLevel = null;
        this.ImageOption = null;
        this.ImageHelp = null;
        this.ImageOnStart = null;
        this.ImageOn1vs2 = null;
        this.ImageOn1vsCom = null;
        this.ImageOnContinue = null;
        this.ImageOnHelp = null;
        this.ImageOnOption = null;
        this.ImageOnEasy = null;
        this.ImageOnNormal = null;
        this.ImageOnHard = null;
        this.ImageOnOk = null;
        this.ImageOnSound = null;
        this.ImageOnVibration = null;
        this.ImageOffSound = null;
        this.ImageOffVibration = null;
        System.gc();
        try {
            this.ImageBoard = Image.createImage((String)"/board.png");
            this.ImageWK = Image.createImage((String)"/wk.png");
            this.ImageWQ = Image.createImage((String)"/wq.png");
            this.ImageWR = Image.createImage((String)"/wr.png");
            this.ImageWB = Image.createImage((String)"/wb.png");
            this.ImageWN = Image.createImage((String)"/wn.png");
            this.ImageWP = Image.createImage((String)"/wp.png");
            this.ImageBK = Image.createImage((String)"/bk.png");
            this.ImageBQ = Image.createImage((String)"/bq.png");
            this.ImageBR = Image.createImage((String)"/br.png");
            this.ImageBB = Image.createImage((String)"/bb.png");
            this.ImageBN = Image.createImage((String)"/bn.png");
            this.ImageBP = Image.createImage((String)"/bp.png");
            this.ImageBalloon = Image.createImage((String)"/balloon.png");
            this.ImageBalloon2 = Image.createImage((String)"/balloon2.png");
            this.ImageMBishop = Image.createImage((String)"/m_bishop.png");
            this.ImageMKing = Image.createImage((String)"/m_king.png");
            this.ImageMKnight = Image.createImage((String)"/m_knight.png");
            this.ImageMNothing = Image.createImage((String)"/m_nothing.png");
            this.ImageMPawn = Image.createImage((String)"/m_pawn.png");
            this.ImageMQueen = Image.createImage((String)"/m_queen.png");
            this.ImageMRook = Image.createImage((String)"/m_rook.png");
            this.ImageSCheck = Image.createImage((String)"/s_check.png");
            this.ImageSCMate = Image.createImage((String)"/s_cmate.png");
            this.ImageSDraw = Image.createImage((String)"/s_draw.png");
            this.ImageSThinking = Image.createImage((String)"/s_thinking.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void GameLoop() {
        switch (this.GameMode) {
            case 0: {
                this.ShowTitle();
                break;
            }
            case 1: {
                this.ShowMenu();
                break;
            }
            case 2: {
                this.ShowOption();
                break;
            }
            case 17: {
                this.ShowHelp();
                break;
            }
            case 31: {
                this.ShowMode();
                break;
            }
            case 3: {
                this.ShowLevel();
                break;
            }
            case 4: {
                this.PlayLoop();
                break;
            }
        }
        this.repaint();
        this.KeyCode = -999;
        this.KeyCode2 = -999;
    }

    public void ShowTitle() {
        this.BackG.drawImage(this.ImageTitle, 0, 0, 20);
    }

    public void ShowMenu() {
        this.BackG.drawImage(this.ImageTitle, 0, 0, 20);
        this.BackG.drawImage(this.ImageMenu, 14, 41, 20);
        if (this.KeyCode == 1 || this.KeyCode2 == 50) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum - 1);
            if (this.CurrentMenuNum < 1) {
                this.CurrentMenuNum = (byte)4;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 6 || this.KeyCode2 == 56) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum + 1);
            if (this.CurrentMenuNum > 4) {
                this.CurrentMenuNum = 1;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 8 || this.KeyCode2 == 53) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
            switch (this.CurrentMenuNum) {
                case 1: {
                    this.GameMode = (byte)31;
                    this.CurrentMenuNum = 1;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.ShowMode();
                    return;
                }
                case 2: {
                    if (!this.McSave.Load()) break;
                    this.MenuMode = this.McSave.MenuMode;
                    this.LevelMode = this.McSave.LevelMode;
                    this.McBoard.Moves = this.McSave.Moves;
                    this.McBoard.Status = this.McSave.Status;
                    this.McBoard.A = this.McSave.A;
                    this.McBoard.OldMove = this.McSave.OldMove;
                    this.McBoard.UndoInf = this.McSave.UndoInf;
                    this.GameMode = (byte)4;
                    this.PlayMode = (byte)14;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.CursorPos = this.McBoard.GetPrevCursorPos();
                    if (this.CursorPos == -1) {
                        this.CursorPos = 41;
                    }
                    if (this.McBoard.Status == 0) {
                        this.MessageMode = (byte)21;
                    } else if (this.McBoard.Status == 2) {
                        this.MessageMode = (byte)22;
                    }
                    this.PlayLoop();
                    return;
                }
                case 3: {
                    this.GameMode = (byte)17;
                    this.CurrentMenuNum = 1;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.ShowHelp();
                    return;
                }
                case 4: {
                    this.GameMode = (byte)2;
                    this.CurrentMenuNum = 1;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.ShowOption();
                    return;
                }
            }
        }
        if (this.CurrentMenuNum == 1) {
            this.BackG.drawImage(this.ImageOnStart, 32, 64, 20);
        }
        if (this.CurrentMenuNum == 2) {
            this.BackG.drawImage(this.ImageOnContinue, 32, 80, 20);
        }
        if (this.CurrentMenuNum == 3) {
            this.BackG.drawImage(this.ImageOnHelp, 32, 96, 20);
        }
        if (this.CurrentMenuNum == 4) {
            this.BackG.drawImage(this.ImageOnOption, 32, 112, 20);
        }
    }

    public void ShowOption() {
        this.BackG.drawImage(this.ImageTitle, 0, 0, 20);
        this.BackG.drawImage(this.ImageOption, 14, 41, 20);
        if (this.KeyCode == 1 || this.KeyCode2 == 50) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum - 1);
            if (this.CurrentMenuNum < 1) {
                this.CurrentMenuNum = (byte)3;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 6 || this.KeyCode2 == 56) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum + 1);
            if (this.CurrentMenuNum > 3) {
                this.CurrentMenuNum = 1;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 8 || this.KeyCode2 == 53) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
            switch (this.CurrentMenuNum) {
                case 1: {
                    boolean bl = this.StateSound = !this.StateSound;
                    if (!this.StateSound) break;
                    this.StateVibration = false;
                    break;
                }
                case 2: {
                    boolean bl = this.StateVibration = !this.StateVibration;
                    if (!this.StateVibration) break;
                    this.StateSound = false;
                    break;
                }
                case 3: {
                    this.GameMode = 1;
                    this.CurrentMenuNum = 1;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.ShowMenu();
                    return;
                }
            }
        } else if (this.KeyCode2 == -8) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
            this.GameMode = 1;
            this.CurrentMenuNum = 1;
            this.KeyCode = -999;
            this.KeyCode2 = -999;
            this.ShowMenu();
            return;
        }
        if (this.CurrentMenuNum == 1) {
            this.BackG.drawImage(this.ImageOnSound, 39, 56, 20);
        }
        if (this.CurrentMenuNum == 2) {
            this.BackG.drawImage(this.ImageOnVibration, 39, 85, 20);
        }
        if (this.CurrentMenuNum == 3) {
            this.BackG.drawImage(this.ImageOnOk, 39, 119, 20);
        }
        if (!this.StateSound) {
            this.BackG.drawImage(this.ImageOffSound, 55, 70, 20);
        }
        if (!this.StateVibration) {
            this.BackG.drawImage(this.ImageOffVibration, 55, 99, 20);
        }
    }

    public void ShowHelp() {
        this.BackG.drawImage(this.ImageTitle, 0, 0, 20);
        this.BackG.drawImage(this.ImageHelp, 4, 13, 20);
        if (this.KeyCode != -999 || this.KeyCode2 != -999) {
            this.GameMode = 1;
            this.CurrentMenuNum = 1;
            this.KeyCode = -999;
            this.KeyCode2 = -999;
            this.ShowMenu();
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
        }
    }

    public void ShowMode() {
        this.BackG.setColor(0xFFFFFF);
        this.BackG.fillRect(0, 0, this.CanvasWidth, this.CanvasHeight);
        this.BackG.drawImage(this.ImageTitle, 0, 0, 20);
        this.BackG.drawImage(this.ImageMode, 14, 41, 20);
        if (this.KeyCode == 1 || this.KeyCode2 == 50) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum - 1);
            if (this.CurrentMenuNum < 1) {
                this.CurrentMenuNum = (byte)2;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 6 || this.KeyCode2 == 56) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum + 1);
            if (this.CurrentMenuNum > 2) {
                this.CurrentMenuNum = 1;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 8 || this.KeyCode2 == 53) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
            switch (this.CurrentMenuNum) {
                case 1: {
                    this.MenuMode = (byte)6;
                    this.GameMode = (byte)3;
                    this.CurrentMenuNum = 1;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.ShowLevel();
                    return;
                }
                case 2: {
                    this.MenuMode = (byte)7;
                    this.GameMode = (byte)4;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.PlayLoop();
                    return;
                }
            }
        } else if (this.KeyCode2 == -8) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
            this.GameMode = 1;
            this.CurrentMenuNum = 1;
            this.KeyCode = -999;
            this.KeyCode2 = -999;
            this.ShowMenu();
            return;
        }
        if (this.CurrentMenuNum == 1) {
            this.BackG.drawImage(this.ImageOn1vsCom, 40, 76, 20);
        }
        if (this.CurrentMenuNum == 2) {
            this.BackG.drawImage(this.ImageOn1vs2, 40, 98, 20);
        }
    }

    public void ShowLevel() {
        this.BackG.setColor(0xFFFFFF);
        this.BackG.fillRect(0, 0, this.CanvasWidth, this.CanvasHeight);
        this.BackG.drawImage(this.ImageTitle, 0, 0, 20);
        this.BackG.drawImage(this.ImageLevel, 14, 41, 20);
        if (this.KeyCode == 1 || this.KeyCode2 == 50) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum - 1);
            if (this.CurrentMenuNum < 1) {
                this.CurrentMenuNum = (byte)3;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else if (this.KeyCode == 6 || this.KeyCode2 == 56) {
            this.CurrentMenuNum = (byte)(this.CurrentMenuNum + 1);
            if (this.CurrentMenuNum > 3) {
                this.CurrentMenuNum = 1;
            }
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/select.mmf");
            }
        } else {
            if (this.KeyCode == 8 || this.KeyCode2 == 53) {
                if (this.StateSound) {
                    this.McAudio = new MobileChessAudio("/button.mmf");
                }
                switch (this.CurrentMenuNum) {
                    case 1: {
                        this.LevelMode = (byte)11;
                        break;
                    }
                    case 2: {
                        this.LevelMode = (byte)10;
                        break;
                    }
                    case 3: {
                        this.LevelMode = (byte)9;
                    }
                }
                this.GameMode = (byte)4;
                this.KeyCode = -999;
                this.KeyCode2 = -999;
                this.PlayLoop();
                return;
            }
            if (this.KeyCode2 == -8) {
                if (this.StateSound) {
                    this.McAudio = new MobileChessAudio("/button.mmf");
                }
                this.GameMode = (byte)31;
                this.CurrentMenuNum = 1;
                this.KeyCode = -999;
                this.KeyCode2 = -999;
                this.ShowMode();
                return;
            }
        }
        if (this.CurrentMenuNum == 1) {
            this.BackG.drawImage(this.ImageOnEasy, 38, 68, 20);
        }
        if (this.CurrentMenuNum == 2) {
            this.BackG.drawImage(this.ImageOnNormal, 38, 87, 20);
        }
        if (this.CurrentMenuNum == 3) {
            this.BackG.drawImage(this.ImageOnHard, 38, 106, 20);
        }
    }

    public void PlayLoop() {
        switch (this.PlayMode) {
            case 14: {
                this.PlayInit();
                break;
            }
            case 12: {
                this.TurnPlayer();
                break;
            }
        }
        if (this.GameMode == 4) {
            this.DrawScreen();
        }
    }

    public void PlayInit() {
        this.LoadPlayImage();
        this.PlayMode = (byte)12;
    }

    public void TurnPlayer() {
        int n;
        block39: {
            block38: {
                boolean bl = false;
                if (this.AnimationMode != 25) {
                    return;
                }
                if (this.KeyCode2 == 35 || this.KeyCode2 == -8 || this.MessageMode == 21 || this.MessageMode == 22) {
                    if (this.StateSound) {
                        this.McAudio = new MobileChessAudio("/button.mmf");
                    }
                    this.GameMode = 0;
                    this.KeyCode = -999;
                    this.KeyCode2 = -999;
                    this.CursorPos = 41;
                    this.PlayMode = (byte)14;
                    this.PlayerMode = (byte)15;
                    this.MessageMode = (byte)17;
                    this.MoveList = null;
                    this.PathList = new boolean[144];
                    this.McBoard.Setup();
                    this.LoadMenuImage();
                    this.MessageTimer = new Timer();
                    this.McAnykey = new MobileChessAnykey();
                    this.MessageTimer.schedule((TimerTask)this.McAnykey, 4000L, 4000L);
                    this.ShowTitle();
                    if (this.StateSound) {
                        this.McAudio = new MobileChessAudio("/title.mmf");
                    }
                }
                if (this.MessageMode != 17) {
                    return;
                }
                if ((this.KeyCode == 1 || this.KeyCode2 == 50) && this.CursorPos < 106) {
                    this.CursorPos += 12;
                } else if ((this.KeyCode == 6 || this.KeyCode2 == 56) && this.CursorPos > 33) {
                    this.CursorPos -= 12;
                } else if ((this.KeyCode == 2 || this.KeyCode2 == 52) && this.CursorPos % 12 > 2) {
                    --this.CursorPos;
                } else if ((this.KeyCode == 5 || this.KeyCode2 == 54) && this.CursorPos % 12 < 9) {
                    ++this.CursorPos;
                } else if (this.KeyCode2 == 49 && this.CursorPos < 106 && this.CursorPos % 12 > 2) {
                    this.CursorPos += 11;
                } else if (this.KeyCode2 == 51 && this.CursorPos < 106 && this.CursorPos % 12 < 9) {
                    this.CursorPos += 13;
                } else if (this.KeyCode2 == 55 && this.CursorPos > 33 && this.CursorPos % 12 > 2) {
                    this.CursorPos -= 13;
                } else if (this.KeyCode2 == 57 && this.CursorPos > 33 && this.CursorPos % 12 < 9) {
                    this.CursorPos -= 11;
                }
                if (this.KeyCode != 8 && this.KeyCode2 != 53 || this.PlayerMode != 15) break block38;
                if (this.StateSound) {
                    this.McAudio = new MobileChessAudio("/pgrab.mmf");
                }
                if (this.McBoard.GetSide(this.CursorPos) != this.McBoard.GetSide()) break block39;
                if (this.MoveList == null) {
                    this.MoveList = this.McBoard.ListOfMoves();
                }
                this.CursorPosPrev = this.CursorPos;
                n = 0;
                while (n < 144) {
                    this.PathList[n] = false;
                    ++n;
                }
                n = this.MoveList[0];
                while (n > 0) {
                    if (MobileChessBoard.MoveFrom(this.MoveList[n]) == this.CursorPos) {
                        this.PathList[MobileChessBoard.MoveTo((int)this.MoveList[n])] = true;
                        bl = true;
                    }
                    --n;
                }
                if (!bl) break block39;
                this.PlayerMode = (byte)16;
                break block39;
            }
            if ((this.KeyCode == 8 || this.KeyCode2 == 53) && this.PlayerMode == 16) {
                if (this.PathList[this.CursorPos]) {
                    n = this.MoveList[0];
                    while (n > 0) {
                        if (MobileChessBoard.MoveFrom(this.MoveList[n]) == this.CursorPosPrev) {
                            if (MobileChessBoard.MoveTo(this.MoveList[n]) == this.CursorPos) {
                                this.StartPieceAnimation(MobileChessBoard.MoveFrom(this.MoveList[n]), MobileChessBoard.MoveTo(this.MoveList[n]));
                                this.AnimationMode = (byte)24;
                                this.PieceMove = this.McBoard.A[MobileChessBoard.MoveFrom(this.MoveList[n])];
                                this.McBoard.A[MobileChessBoard.MoveFrom((int)this.MoveList[n])] = -1;
                                this.PieceMovePos = this.MoveList[n];
                                break;
                            }
                        }
                        --n;
                    }
                    this.MoveList = null;
                } else {
                    this.PlayerMode = (byte)15;
                }
                n = 0;
                while (n < 144) {
                    this.PathList[n] = false;
                    ++n;
                }
            }
        }
        if (this.KeyCode2 == 42) {
            int n2;
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/button.mmf");
            }
            if ((n2 = this.McBoard.VisualUndoMove()) == -1) {
                this.CursorPos = 41;
            } else if (n2 != -2) {
                this.CursorPos = n2;
            }
            this.MoveList = null;
            n = 0;
            while (n < 144) {
                this.PathList[n] = false;
                ++n;
            }
        }
    }

    public void TurnAgent() {
        this.StartPieceAnimation(MobileChessBoard.MoveFrom(this.McAgent.BestMove), MobileChessBoard.MoveTo(this.McAgent.BestMove));
        this.AnimationMode = (byte)24;
        this.PieceMove = this.McBoard.A[MobileChessBoard.MoveFrom(this.McAgent.BestMove)];
        this.McBoard.A[MobileChessBoard.MoveFrom((int)this.McAgent.BestMove)] = -1;
        this.PieceMovePos = this.McAgent.BestMove;
        this.MessageMode = (byte)17;
        this.McAgent = null;
    }

    public void DrawScreen() {
        int n;
        int n2;
        int n3;
        boolean bl = true;
        this.BackG.drawImage(this.ImageBoard, 0, 0, 20);
        if (this.PlayerMode == 16) {
            int n4 = 0;
            while (n4 < 144) {
                if (this.PathList[n4]) {
                    n3 = n4 % 12 - 2;
                    n2 = n4 / 12 - 2;
                    this.DrawSquare(n3, n2);
                }
                ++n4;
            }
            n3 = this.CursorPosPrev % 12 - 2;
            n2 = this.CursorPosPrev / 12 - 2;
            this.DrawSquare(n3, n2);
        }
        if (this.PlayMode == 12 && this.MessageMode == 17) {
            n3 = this.CursorPos % 12 - 2;
            n2 = this.CursorPos / 12 - 2;
            this.DrawFillSquare(n3, n2);
        }
        if (this.PlayMode == 12) {
            n3 = this.CursorPos % 12 - 2;
            n2 = this.CursorPos / 12 - 2;
            n = this.McBoard.GetPiece(n3 + 2 + 12 * (n2 + 2)) + this.McBoard.GetSide(n3 + 2 + 12 * (n2 + 2));
            switch (n) {
                case 14: 
                case 15: {
                    this.BackG.drawImage(this.ImageMKing, 73, 7, 20);
                    break;
                }
                case 12: 
                case 13: {
                    this.BackG.drawImage(this.ImageMQueen, 73, 7, 20);
                    break;
                }
                case 10: 
                case 11: {
                    this.BackG.drawImage(this.ImageMBishop, 73, 7, 20);
                    break;
                }
                case 6: 
                case 7: {
                    this.BackG.drawImage(this.ImageMRook, 73, 7, 20);
                    break;
                }
                case 8: 
                case 9: {
                    this.BackG.drawImage(this.ImageMKnight, 73, 7, 20);
                    break;
                }
                case 2: 
                case 3: {
                    this.BackG.drawImage(this.ImageMPawn, 73, 7, 20);
                    break;
                }
                default: {
                    this.BackG.drawImage(this.ImageMNothing, 73, 7, 20);
                }
            }
        }
        n3 = 0;
        while (n3 < 8) {
            n2 = 7;
            while (n2 >= 0) {
                n = this.McBoard.GetPiece(n3 + 2 + 12 * (n2 + 2)) + this.McBoard.GetSide(n3 + 2 + 12 * (n2 + 2));
                int n5 = n3;
                int n6 = 7 - n2;
                int n7 = BOARDPOSX[n6 + 1][n5] + (BOARDPOSX[n6 + 1][n5 + 1] - BOARDPOSX[n6 + 1][n5]) / 2 - 7;
                int n8 = BOARDPOSY[n6] + (BOARDPOSY[n6 + 1] - BOARDPOSY[n6]) / 2 - 20;
                switch (n) {
                    case 14: {
                        this.BackG.drawImage(this.ImageWK, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 12: {
                        this.BackG.drawImage(this.ImageWQ, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 6: {
                        this.BackG.drawImage(this.ImageWR, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 10: {
                        this.BackG.drawImage(this.ImageWB, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 8: {
                        this.BackG.drawImage(this.ImageWN, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 2: {
                        this.BackG.drawImage(this.ImageWP, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 15: {
                        this.BackG.drawImage(this.ImageBK, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 13: {
                        this.BackG.drawImage(this.ImageBQ, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 7: {
                        this.BackG.drawImage(this.ImageBR, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 11: {
                        this.BackG.drawImage(this.ImageBB, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 9: {
                        this.BackG.drawImage(this.ImageBN, 4 + n7, 35 + n8, 20);
                        break;
                    }
                    case 3: {
                        this.BackG.drawImage(this.ImageBP, 4 + n7, 35 + n8, 20);
                    }
                }
                --n2;
            }
            ++n3;
        }
        if (this.MessageMode != 17) {
            if (this.McBoard.GetSide() == 0 && this.MessageMode == 23) {
                this.BackG.drawImage(this.ImageBalloon, 28, 69, 20);
            } else if (this.McBoard.GetSide() == 1 && this.MessageMode == 23) {
                this.BackG.drawImage(this.ImageBalloon2, 28, 62, 20);
            } else if (this.McBoard.GetSide() == 0 && this.MessageMode != 23) {
                this.BackG.drawImage(this.ImageBalloon2, 28, 62, 20);
            } else if (this.McBoard.GetSide() == 1 && this.MessageMode != 23) {
                this.BackG.drawImage(this.ImageBalloon, 28, 69, 20);
            }
            switch (this.MessageMode) {
                case 20: {
                    this.BackG.drawImage(this.ImageSCheck, 37, 74, 20);
                    break;
                }
                case 21: {
                    this.BackG.drawImage(this.ImageSCMate, 37, 74, 20);
                    break;
                }
                case 22: {
                    this.BackG.drawImage(this.ImageSDraw, 37, 74, 20);
                    break;
                }
                case 23: {
                    this.BackG.drawImage(this.ImageSThinking, 37, 74, 20);
                }
            }
        }
        if (this.AnimationMode == 24) {
            switch (this.McAnimation.Piece) {
                case 14: {
                    this.BackG.drawImage(this.ImageWK, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 12: {
                    this.BackG.drawImage(this.ImageWQ, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 6: {
                    this.BackG.drawImage(this.ImageWR, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 10: {
                    this.BackG.drawImage(this.ImageWB, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 8: {
                    this.BackG.drawImage(this.ImageWN, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 2: {
                    this.BackG.drawImage(this.ImageWP, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 15: {
                    this.BackG.drawImage(this.ImageBK, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 13: {
                    this.BackG.drawImage(this.ImageBQ, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 7: {
                    this.BackG.drawImage(this.ImageBR, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 11: {
                    this.BackG.drawImage(this.ImageBB, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 9: {
                    this.BackG.drawImage(this.ImageBN, this.McAnimation.X1, this.McAnimation.Y1, 20);
                    break;
                }
                case 3: {
                    this.BackG.drawImage(this.ImageBP, this.McAnimation.X1, this.McAnimation.Y1, 20);
                }
            }
        }
    }

    public void DrawSquare(int n, int n2) {
        n2 = 7 - n2;
        if (this.McBoard.GetSide() == 0) {
            this.BackG.setColor(0x99CCFF);
        } else {
            this.BackG.setColor(0xFF6666);
        }
        this.BackG.drawLine(4 + BOARDPOSX[n2][n], 35 + BOARDPOSY[n2], 4 + BOARDPOSX[n2][n + 1] - 1, 35 + BOARDPOSY[n2]);
        this.BackG.drawLine(4 + BOARDPOSX[n2 + 1][n], 35 + BOARDPOSY[n2 + 1] - 1, 4 + BOARDPOSX[n2 + 1][n + 1] - 1, 35 + BOARDPOSY[n2 + 1] - 1);
        this.BackG.drawLine(4 + BOARDPOSX[n2][n], 35 + BOARDPOSY[n2], 4 + BOARDPOSX[n2 + 1][n], 35 + BOARDPOSY[n2 + 1] - 1);
        this.BackG.drawLine(4 + BOARDPOSX[n2][n + 1] - 1, 35 + BOARDPOSY[n2], 4 + BOARDPOSX[n2 + 1][n + 1] - 1, 35 + BOARDPOSY[n2 + 1] - 1);
    }

    public void DrawFillSquare(int n, int n2) {
        n2 = 7 - n2;
        if (this.McBoard.GetSide() == 0) {
            this.BackG.setColor(0x99CCFF);
        } else {
            this.BackG.setColor(0xFF6666);
        }
        int n3 = BOARDPOSX[n2 + 1][n] + (BOARDPOSX[n2 + 1][n + 1] - BOARDPOSX[n2 + 1][n]) / 2 - 7;
        int n4 = BOARDPOSY[n2] + (BOARDPOSY[n2 + 1] - BOARDPOSY[n2]) / 2 - 7;
        this.BackG.fillRect(4 + n3, 35 + n4, 14, 14);
    }

    public void StartPieceAnimation(int n, int n2) {
        int n3 = n % 12 - 2;
        int n4 = 7 - (n / 12 - 2);
        int n5 = n2 % 12 - 2;
        int n6 = 7 - (n2 / 12 - 2);
        int n7 = 4 + BOARDPOSX[n4 + 1][n3] + (BOARDPOSX[n4 + 1][n3 + 1] - BOARDPOSX[n4 + 1][n3]) / 2 - 7;
        int n8 = 35 + BOARDPOSY[n4] + (BOARDPOSY[n4 + 1] - BOARDPOSY[n4]) / 2 - 20;
        int n9 = 4 + BOARDPOSX[n6 + 1][n5] + (BOARDPOSX[n6 + 1][n5 + 1] - BOARDPOSX[n6 + 1][n5]) / 2 - 7;
        int n10 = 35 + BOARDPOSY[n6] + (BOARDPOSY[n6 + 1] - BOARDPOSY[n6]) / 2 - 20;
        int n11 = this.McBoard.GetPiece(n) + this.McBoard.GetSide(n);
        this.McAnimation = new MobileChessAnimation(this, n7, n8, n9, n10, n11);
    }

    public void EndPieceAnimation() {
        this.McAnimation = null;
        if (this.StateSound) {
            this.McAudio = new MobileChessAudio("/prelease.mmf");
        }
        if (this.McBoard.A[MobileChessBoard.MoveTo(this.PieceMovePos)] != -1) {
            if (this.StateSound) {
                // empty if block
            }
            if (this.StateVibration) {
                Vibration.start((int)1, (int)1);
            }
        }
        this.McBoard.A[MobileChessBoard.MoveFrom((int)this.PieceMovePos)] = this.PieceMove;
        this.McBoard.VisualDoMove(this.PieceMovePos);
        this.CursorPos = MobileChessBoard.MoveTo(this.PieceMovePos);
        if (this.McBoard.Status == 1) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/check.mmf");
            }
            this.MessageMode = (byte)20;
            this.MessageTimer = new Timer();
            this.McMessage = new MobileChessMessage();
            this.MessageTimer.schedule((TimerTask)this.McMessage, 2000L, 2000L);
        } else if (this.McBoard.Status == 0) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/cmate.mmf");
            }
            this.MessageMode = (byte)21;
        } else if (this.McBoard.Status == 2) {
            if (this.StateSound) {
                this.McAudio = new MobileChessAudio("/draw.mmf");
            }
            this.MessageMode = (byte)22;
        }
        if (this.MenuMode == 7) {
            this.PlayerMode = (byte)15;
        } else if (this.MenuMode == 6) {
            this.PlayerMode = (byte)15;
            if (this.PlayMode == 12 && this.McBoard.Status != 0 && this.McBoard.Status != 2) {
                this.McAgent = new MobileChessAgent(this.McBoard, this);
                this.PlayMode = (byte)13;
                if (this.McBoard.Status != 1) {
                    this.MessageMode = (byte)23;
                }
            } else if (this.PlayMode == 13) {
                this.PlayMode = (byte)12;
                if (this.McBoard.Status != 0 && this.McBoard.Status != 2 && this.McBoard.Status != 1) {
                    this.MessageMode = (byte)17;
                }
            }
        }
        this.AnimationMode = (byte)25;
        this.DrawScreen();
        this.repaint();
        if (this.McAgent == null && this.McAnimation == null && this.McBoard.GetSide() == 0) {
            this.McSave.Save(this.MenuMode, this.LevelMode, this.McBoard.Moves, this.McBoard.Status, this.McBoard.A, this.McBoard.OldMove, this.McBoard.UndoInf);
        }
    }

    class MobileChessMessage
    extends TimerTask {
        MobileChessMessage() {
        }

        public void run() {
            if (MobileChessCanvas.this.MessageMode == 20) {
                MobileChessCanvas.this.MessageMode = MobileChessCanvas.this.PlayMode == 13 ? (byte)23 : (byte)17;
            } else if (MobileChessCanvas.this.MessageMode == 21 || MobileChessCanvas.this.MessageMode == 22) {
                // empty if block
            }
            MobileChessCanvas.this.DrawScreen();
            MobileChessCanvas.this.repaint();
            MobileChessCanvas.this.MessageTimer.cancel();
            MobileChessCanvas.this.McMessage.cancel();
        }
    }

    class MobileChessAnykey
    extends TimerTask {
        MobileChessAnykey() {
        }

        public void run() {
            MobileChessCanvas.this.GameMode = (byte)1;
            MobileChessCanvas.this.CurrentMenuNum = (byte)1;
            MobileChessCanvas.this.KeyCode = -999;
            MobileChessCanvas.this.KeyCode2 = -999;
            MobileChessCanvas.this.MessageTimer.cancel();
            MobileChessCanvas.this.McAnykey.cancel();
            MobileChessCanvas.this.ShowMenu();
            MobileChessCanvas.this.repaint();
        }
    }
}

