/*
 * Decompiled with CFR 0.152.
 */
class MobileChessAgent
extends Thread {
    MobileChessBoard McBoardOriginal;
    MobileChessBoard McBoardCopy;
    MobileChessCanvas McCanvas;
    static int MinLevel;
    static int MaxLevel;
    static final int HIGH = 65534;
    static final int SUPERHIGH = 65535;
    static final int ABOVEALL = 65536;
    static int[] PawnScore;
    public int BestMove;

    MobileChessAgent(MobileChessBoard mobileChessBoard, MobileChessCanvas mobileChessCanvas) {
        MobileChessAgent.MakePawnTable();
        this.McBoardOriginal = mobileChessBoard;
        this.McCanvas = mobileChessCanvas;
        switch (this.McCanvas.LevelMode) {
            case 11: {
                MinLevel = 1;
                MaxLevel = 1;
                break;
            }
            case 10: {
                MinLevel = 1;
                MaxLevel = 4;
                break;
            }
            case 9: {
                MinLevel = 1;
                MaxLevel = 7;
            }
        }
        this.start();
    }

    public void run() {
        this.DoMove();
    }

    static void MakePawnTable() {
        if (PawnScore != null) {
            return;
        }
        PawnScore = new int[144];
        int n = 0;
        while (n < 144) {
            MobileChessAgent.PawnScore[n] = 100 + 5 * ((n - 2) / 12);
            ++n;
        }
        int n2 = 0;
        while (n2 < 12) {
            MobileChessAgent.PawnScore[96 + n2] = 240;
            MobileChessAgent.PawnScore[84 + n2] = 160;
            ++n2;
        }
        MobileChessAgent.PawnScore[79] = 180;
        MobileChessAgent.PawnScore[76] = 180;
        MobileChessAgent.PawnScore[67] = 180;
        MobileChessAgent.PawnScore[64] = 180;
    }

    void DoMove() {
        this.McBoardCopy = new MobileChessBoard(this.McBoardOriginal);
        int[] nArray = this.McBoardCopy.ListOfMoves();
        int n = -1;
        int n2 = -65535;
        int n3 = 1;
        while (n3 <= nArray[0]) {
            Thread.yield();
            this.McBoardCopy.DoMove(nArray[n3]);
            int n4 = -this.FullSearch(-65535, -n2, 1);
            this.McBoardCopy.UndoMove();
            if (n4 > n2) {
                n2 = n4;
                n = n3;
            }
            ++n3;
        }
        this.BestMove = nArray[n];
        while (this.McCanvas.MessageMode != 17 && this.McCanvas.MessageMode != 23) {
        }
        this.McCanvas.TurnAgent();
        this.McCanvas.DrawScreen();
        this.McCanvas.repaint();
    }

    void Swap(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
        n3 = nArray2[n];
        nArray2[n] = nArray2[n2];
        nArray2[n2] = n3;
    }

    void Sort(int[] nArray, int[] nArray2) {
        this.QuickSort(nArray, nArray2, 1, nArray[0]);
    }

    void QuickSort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n < n2) {
            int n3 = this.Partition(nArray, nArray2, n, n2);
            this.QuickSort(nArray, nArray2, n, n3);
            this.QuickSort(nArray, nArray2, n3 + 1, n2);
        }
    }

    int Partition(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray2[n];
        int n4 = n - 1;
        int n5 = n2 + 1;
        while (true) {
            if (nArray2[--n5] < n3) {
                continue;
            }
            while (nArray2[++n4] > n3) {
            }
            if (n4 >= n5) break;
            this.Swap(nArray, nArray2, n4, n5);
        }
        return n5;
    }

    int[] Estimates(int[] nArray) {
        int[] nArray2 = new int[nArray[0] + 1];
        nArray2[0] = nArray[0];
        int n = 1;
        while (n <= nArray[0]) {
            if (nArray[n] == 0) {
                nArray2[n] = 0;
            } else {
                int n2 = MobileChessBoard.MoveNewPiece(nArray[n]);
                if (n2 == 0) {
                    nArray2[n] = this.Value(this.McBoardCopy.GetPiece(MobileChessBoard.MoveTo(nArray[n])));
                }
                nArray2[n] = n2 == 3 ? 110 : (n2 == 5 ? 20 : (n2 == 7 ? 16 : this.Value(n2)));
            }
            ++n;
        }
        return nArray2;
    }

    int Value(int n) {
        switch (n) {
            case 2: {
                return 105;
            }
            case 8: {
                return 300;
            }
            case 6: {
                return 450;
            }
            case 12: {
                return 850;
            }
            case 10: {
                return 320;
            }
            case 14: {
                return 3200;
            }
            case -1: {
                return 0;
            }
        }
        return 0;
    }

    int[] MakeFullList() {
        int[] nArray = this.McBoardCopy.ListOfMoves();
        int[] nArray2 = this.Estimates(nArray);
        this.Sort(nArray, nArray2);
        return nArray;
    }

    int FullSearch(int n, int n2, int n3) {
        if (n3 >= MinLevel) {
            return this.JustAttackSearch(n, n2, n3);
        }
        int[] nArray = this.MakeFullList();
        if (nArray[0] == 0) {
            if (this.McBoardCopy.Check(this.McBoardCopy.GetSide())) {
                return -65534;
            }
            return 0;
        }
        int n4 = 1;
        while (n4 <= nArray[0]) {
            this.McBoardCopy.DoMove(nArray[n4]);
            int n5 = -this.FullSearch(-n2, -n, n3 + 1);
            this.McBoardCopy.UndoMove();
            if (n5 > n2) {
                return n5;
            }
            if (n5 > n) {
                n = n5;
            }
            ++n4;
        }
        return n;
    }

    int[] MakeJustAttackList() {
        int[] nArray = this.McBoardCopy.ListOfPseudoMoves();
        int[] nArray2 = this.Estimates(nArray);
        int n = 1;
        while (n <= nArray[0]) {
            if (nArray2[n] < 50) {
                MobileChessBoard.Delete(nArray, n);
                continue;
            }
            ++n;
        }
        MobileChessBoard.Add(nArray, 0);
        return nArray;
    }

    int JustAttackSearch(int n, int n2, int n3) {
        if (n3 >= MaxLevel) {
            return this.JustBackSearch(n, n2);
        }
        int[] nArray = this.MakeJustAttackList();
        int n4 = 1;
        while (n4 <= nArray[0]) {
            this.McBoardCopy.DoMove(nArray[n4]);
            int n5 = -this.JustAttackSearch(-n2, -n, n3 + 1);
            this.McBoardCopy.UndoMove();
            if (n5 > n2) {
                return n5;
            }
            if (n5 > n) {
                n = n5;
            }
            ++n4;
        }
        return n;
    }

    int JustBackSearch(int n, int n2) {
        if (this.McBoardCopy.IllMoveDone()) {
            return 65536;
        }
        int n3 = MobileChessBoard.MoveTo(this.McBoardCopy.GetStoredM(this.McBoardCopy.Moves - 1));
        int n4 = this.BasicScore();
        if (n4 > n2) {
            return n4;
        }
        if (n4 > n) {
            n = n4;
        }
        if (this.McBoardCopy.Attack(n3, this.McBoardCopy.GetSide())) {
            int[] nArray = this.HitBackList();
            int n5 = 1;
            while (n5 <= nArray[0]) {
                this.McBoardCopy.DoMove(nArray[n5]);
                n4 = -this.JustBackSearch(-n2, -n);
                this.McBoardCopy.UndoMove();
                if (n4 > n2) {
                    return n4;
                }
                if (n4 > n) {
                    n = n4;
                }
                ++n5;
            }
        }
        return n;
    }

    int[] HitBackList() {
        int[] nArray = this.McBoardCopy.ListOfPseudoMoves();
        int n = MobileChessBoard.MoveTo(this.McBoardCopy.GetStoredM(this.McBoardCopy.Moves - 1));
        int n2 = 1;
        while (n2 <= nArray[0]) {
            if (MobileChessBoard.MoveTo(nArray[n2]) != n) {
                MobileChessBoard.Delete(nArray, n2);
                continue;
            }
            ++n2;
        }
        MobileChessBoard.Add(nArray, 0);
        return nArray;
    }

    int BasicScore() {
        int n;
        int[] nArray = new int[2];
        int n2 = 24;
        while (n2 < 120) {
            n = n2 + 2;
            while (n < n2 + 10) {
                int n3 = this.McBoardCopy.GetSide(n);
                if (n3 != -1) {
                    switch (this.McBoardCopy.GetPiece(n)) {
                        case 2: {
                            if (n3 == 0) {
                                int n4 = n3;
                                nArray[n4] = nArray[n4] + PawnScore[n];
                            } else {
                                int n5 = n3;
                                nArray[n5] = nArray[n5] + PawnScore[144 - n];
                            }
                            if (this.McBoardCopy.A[n + 12] != 2 + n3) break;
                            int n6 = n3;
                            nArray[n6] = nArray[n6] - 20;
                            break;
                        }
                        case 8: {
                            int n7 = n3;
                            nArray[n7] = nArray[n7] + 295;
                            break;
                        }
                        case 10: {
                            int n8 = n3;
                            nArray[n8] = nArray[n8] + 300;
                            break;
                        }
                        case 6: {
                            int n9 = n3;
                            nArray[n9] = nArray[n9] + 450;
                            break;
                        }
                        case 12: {
                            int n10 = n3;
                            nArray[n10] = nArray[n10] + 850;
                            break;
                        }
                        case 14: {
                            int n11 = n3;
                            nArray[n11] = nArray[n11] + 3200;
                        }
                    }
                }
                ++n;
            }
            n2 += 12;
        }
        n = nArray[0] - nArray[1];
        return this.McBoardCopy.GetSide() == 0 ? n : -n;
    }
}

