/*
 * Decompiled with CFR 0.152.
 */
package midp.shopper;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import midp.shopper.Category;
import midp.shopper.Locale;
import midp.shopper.Product;

public class Shopper
extends MIDlet
implements CommandListener {
    private static Shopper instance = null;
    private Vector categories;
    private RecordStore store;
    private static Image[] categoryImages;
    private static Image productsImage;
    private static Hashtable imageHash;
    byte[] selected;
    byte[] origSelected;
    byte[] predefined;
    int nPredefined;
    static Command BACK_CMD;
    static Command ADD_CMD;
    static Command SELECT_CMD;
    static Command REMOVE_CMD;
    static Command RENAME_CMD;
    static Command ENTER_CMD;
    static Command QUIT_CMD;
    static final int PREDEFINED_ID = 1;
    static final int SELECTED_ID = 2;
    private Class[] actions = new Class[]{Shopper.getClassObject("midp.shopper.NeedList"), Shopper.getClassObject("midp.shopper.CategoryList"), Shopper.getClassObject("midp.shopper.ResetList")};
    private List actionList;
    static final String STORE_NAME = "Shopper107";

    public Vector getCategories() {
        return this.categories;
    }

    private static Class getClassObject(String string) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getClass().getName() + ": " + throwable.getMessage());
            throwable.printStackTrace();
            return null;
        }
    }

    static Shopper getInstance() {
        return instance;
    }

    public Shopper() {
        String string = this.getAppProperty("Shopper.Locale");
        if (string == null || string.length() == 0) {
            string = System.getProperty("microedition.locale");
        }
        new Locale(string);
        BACK_CMD = new Command(Locale.current.back, 2, 1);
        ADD_CMD = new Command(Locale.current.add, 1, 1);
        SELECT_CMD = new Command(Locale.current.select, 8, 1);
        REMOVE_CMD = new Command(Locale.current.remove, 8, 1);
        RENAME_CMD = new Command(Locale.current.rename, 8, 1);
        ENTER_CMD = new Command(Locale.current.enter, 1, 1);
        QUIT_CMD = new Command(Locale.current.quit, 2, 1);
        categoryImages = new Image[Locale.current.categoryIcons.length];
        imageHash = new Hashtable();
        try {
            productsImage = Image.createImage((String)"/midp/shopper/products.png");
            for (int i = 0; i < Locale.current.categoryIcons.length; ++i) {
                Shopper.categoryImages[i] = Image.createImage((String)("/midp/shopper/" + Locale.current.categoryIcons[i] + ".png"));
                imageHash.put(Locale.current.categories[i], categoryImages[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.actionList = new List(Locale.current.name, 3, Locale.current.actionNames, null);
        this.actionList.addCommand(SELECT_CMD);
        this.actionList.addCommand(QUIT_CMD);
        this.actionList.setCommandListener((CommandListener)this);
        instance = this;
    }

    private void openStore() {
        try {
            try {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
                this.loadData();
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                this.initializeStore();
            }
            this.origSelected = new byte[this.selected.length];
            System.arraycopy(this.selected, 0, this.origSelected, 0, this.selected.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    private static void pack(byte[] byArray, int n) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
    }

    private static int unpack(byte[] byArray) {
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static byte[] str2Bytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i * 2] = (byte)(cArray[i] >> 8);
            byArray[i * 2 + 1] = (byte)cArray[i];
        }
        return byArray;
    }

    private void initializeStore() {
        try {
            this.categories = new Vector();
            int n = 0;
            for (int i = 0; i < Locale.current.categories.length; ++i) {
                Category category = new Category(-(++n), Locale.current.categories[i], categoryImages[i]);
                this.categories.addElement(category);
                for (int j = 0; j < Locale.current.products[i].length; ++j) {
                    Product product = new Product(-(++n), category, Locale.current.products[i][j]);
                    category.products.addElement(product);
                }
            }
            this.nPredefined = n + 1;
            this.predefined = new byte[n + 8 >> 3];
            this.store.addRecord(this.predefined, 0, this.predefined.length);
            this.selected = new byte[this.predefined.length];
            this.store.addRecord(this.selected, 0, this.selected.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    private void loadData() throws Exception {
        Hashtable<Integer, Category> hashtable = new Hashtable<Integer, Category>();
        try {
            Object object;
            Object object2;
            int n;
            int n2;
            this.predefined = this.store.getRecord(1);
            this.selected = this.store.getRecord(2);
            byte[] byArray = this.predefined;
            while (true) {
                n2 = 0;
                this.categories = new Vector();
                for (n = 0; n < Locale.current.categories.length; ++n) {
                    object2 = null;
                    if (++n2 >> 3 >= byArray.length || (byArray[n2 >> 3] & 1 << (n2 & 7)) == 0) {
                        object2 = new Category(-n2, Locale.current.categories[n], categoryImages[n]);
                        hashtable.put(new Integer(-n2), (Category)object2);
                        this.categories.addElement(object2);
                    }
                    for (int i = 0; i < Locale.current.products[n].length; ++i) {
                        if (object2 == null || ++n2 >> 3 < byArray.length && (byArray[n2 >> 3] & 1 << (n2 & 7)) != 0) continue;
                        object = new Product(-n2, (Category)object2, Locale.current.products[n][i]);
                        ((Category)object2).products.addElement(object);
                    }
                }
                this.nPredefined = n2 + 1;
                n = (n2 + 8 >> 3) - byArray.length;
                if (n <= 0) break;
                this.predefined = byArray = new byte[n2 + 8 >> 3];
                this.store.setRecord(1, byArray, 0, byArray.length);
                this.selected = new byte[this.selected.length + n + 1];
                this.store.setRecord(2, this.selected, 0, this.selected.length);
            }
            n2 = this.store.getNextRecordID();
            n = 2;
            while (++n < n2) {
                Category category;
                object2 = null;
                try {
                    object2 = this.store.getRecord(n);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
                if (object2 == null) continue;
                int n3 = Shopper.unpack((byte[])object2);
                object = new char[((Object)object2).length - 4 >> 1];
                for (int i = 0; i < ((char[])object).length; ++i) {
                    object[i] = (char)(object2[4 + i * 2] << 8 | object2[5 + i * 2] & 0xFF);
                }
                String string = new String((char[])object);
                if (n3 == 0) {
                    category = new Category(n, string, productsImage);
                    this.categories.addElement(category);
                    hashtable.put(new Integer(n), category);
                    continue;
                }
                category = (Category)hashtable.get(new Integer(n3));
                if (category == null) {
                    this.criticalError("Failed to locate category");
                    continue;
                }
                Product product = new Product(n, category, string);
                category.products.addElement(product);
            }
        }
        catch (Exception exception) {
            try {
                this.store.closeRecordStore();
                RecordStore.deleteRecordStore((String)STORE_NAME);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.criticalException(exception);
        }
    }

    public void storeCategory(Category category) {
        try {
            byte[] byArray = Shopper.str2Bytes(category.name);
            byte[] byArray2 = new byte[byArray.length + 4];
            System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
            this.store.setRecord(category.recordId, byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    public Category addCategory(String string) {
        byte[] byArray = Shopper.str2Bytes(string);
        byte[] byArray2 = new byte[byArray.length + 4];
        int n = 0;
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        try {
            n = this.store.addRecord(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
        Category category = new Category(n, string, productsImage);
        this.categories.addElement(category);
        return category;
    }

    public boolean removeCategory(int n) {
        Category category = (Category)this.categories.elementAt(n);
        if (category.products.size() != 0) {
            this.error(Locale.current.notEmpty);
            return false;
        }
        if (category.isPredefined()) {
            int n2 = -category.recordId;
            int n3 = n2 >> 3;
            this.predefined[n3] = (byte)(this.predefined[n3] | (byte)(1 << (n2 & 7)));
            try {
                this.store.setRecord(1, this.predefined, 0, this.predefined.length);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        } else {
            try {
                this.store.deleteRecord(category.recordId);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
        this.categories.removeElementAt(n);
        return true;
    }

    public Product addProduct(String string, Category category) {
        byte[] byArray = Shopper.str2Bytes(string);
        byte[] byArray2 = new byte[byArray.length + 4];
        int n = 0;
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        Shopper.pack(byArray2, category.recordId);
        try {
            n = this.store.addRecord(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
        Product product = new Product(n, category, string);
        category.products.addElement(product);
        int n2 = this.nPredefined + n + 7 >> 3;
        while (n2 >= this.selected.length) {
            byte[] byArray3 = new byte[this.selected.length * 2];
            System.arraycopy(this.selected, 0, byArray3, 0, this.selected.length);
            this.selected = byArray3;
            try {
                this.store.setRecord(2, byArray3, 0, byArray3.length);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
        return product;
    }

    public void removeProduct(int n, Product product) {
        if (product.isPredefined()) {
            int n2 = -product.recordId;
            int n3 = n2 >> 3;
            this.predefined[n3] = (byte)(this.predefined[n3] | (byte)(1 << (n2 & 7)));
            try {
                this.store.setRecord(1, this.predefined, 0, this.predefined.length);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        } else {
            try {
                this.store.deleteRecord(product.recordId);
            }
            catch (Exception exception) {
                this.criticalException(exception);
                return;
            }
        }
        product.category.products.removeElementAt(n);
    }

    public void restoreData() {
        System.arraycopy(this.origSelected, 0, this.selected, 0, this.origSelected.length);
        for (int i = this.origSelected.length; i < this.selected.length; ++i) {
            this.selected[i] = 0;
        }
        this.saveSelected();
    }

    public void clearData() {
        byte[] byArray = this.selected;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = 0;
        }
        this.saveSelected();
    }

    public void setData() {
        byte[] byArray = this.selected;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = -1;
        }
        this.saveSelected();
    }

    protected void destroyApp(boolean bl) {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
        this.actionList = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        if (this.store == null) {
            this.openStore();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.actionList);
    }

    public static void goBack() {
        instance.startApp();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            int n = this.actionList.getSelectedIndex();
            try {
                Displayable displayable2 = (Displayable)this.actions[n].newInstance();
                Display.getDisplay((MIDlet)this).setCurrent(displayable2);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
    }

    void criticalException(Exception exception) {
        exception.printStackTrace();
        this.criticalError(exception.toString());
    }

    void criticalError(String string) {
        System.err.println(string);
        this.error(string);
    }

    boolean isSelected(Product product) {
        int n = this.nPredefined + product.recordId;
        return (this.selected[n >> 3] & 1 << (n & 7)) != 0;
    }

    boolean setSelected(Product product, boolean bl) {
        int n = this.nPredefined + product.recordId;
        if ((this.selected[n >> 3] & 1 << (n & 7)) != 0 ^ bl) {
            int n2 = n >> 3;
            this.selected[n2] = (byte)(this.selected[n2] ^ 1 << (n & 7));
            return true;
        }
        return false;
    }

    void saveSelected() {
        try {
            this.store.setRecord(2, this.selected, 0, this.selected.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
            return;
        }
    }

    void error(String string) {
        Alert alert = new Alert(Locale.current.error);
        alert.setType(AlertType.ERROR);
        alert.setString(string);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
    }
}

