/*
 * Decompiled with CFR 0.152.
 */
package Logger;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class MTLogger {
    public static String LogFile = "E:/Others/MTLog.txt";
    public static String LogFileEmulator = "e/Others/MTLog.txt";
    private static boolean EnableLog = false;
    private static FileConnection conn = null;
    private static OutputStream out = null;
    private static final Object sync = new Object();
    private static final int infoFreq = 20;
    private static int infoCnt = 0;

    private static boolean isEmulator() {
        Enumeration enumeration = FileSystemRegistry.listRoots();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.equals("emulator/")) continue;
            return true;
        }
        return false;
    }

    private static OutputStream getStream() {
        if (out == null) {
            try {
                String string = MTLogger.isEmulator() ? LogFileEmulator : LogFile;
                conn = (FileConnection)Connector.open((String)("file:///" + string));
                if (conn.exists()) {
                    conn.delete();
                }
                conn.create();
                out = conn.openOutputStream();
                out.write("Starting log.\n".getBytes());
                out.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return out;
    }

    public static void close() {
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeLine(String string) {
        if (string == null) {
            MTLogger.writeLine("\n");
        } else {
            MTLogger.write(string + '\n');
        }
    }

    public static void writeLine() {
        MTLogger.write("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String string) {
        if (!EnableLog) {
            return;
        }
        Object object = sync;
        synchronized (object) {
            try {
                MTLogger.getStream().write(string.getBytes());
                MTLogger.getStream().flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void writeLine(int n) {
        MTLogger.write(String.valueOf(n) + '\n');
    }

    public static void write(int n) {
        MTLogger.write(String.valueOf(n));
    }

    public static void writeMemoryInfo() {
        if (infoCnt == 0) {
            int n = (int)(Runtime.getRuntime().totalMemory() / 1024L);
            int n2 = (int)(Runtime.getRuntime().freeMemory() / 1024L);
            MTLogger.write("[Memory info] " + n2 + " kB / " + n + " kB\n");
        }
        if (++infoCnt >= 20) {
            infoCnt = 0;
        }
    }
}

