/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Logger.MTLogger;
import Settings.Preferences;
import TorrentEngine.MTTorrent;
import TorrentEngine.Statistics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import sha1.SHA1;

public class MTNetworkStatusManager {
    public static Connection connect(String string) throws IOException {
        return MTNetworkStatusManager.connect(string, 3, true);
    }

    public static Connection connect(String string, int n) throws IOException {
        return MTNetworkStatusManager.connect(string, n, true);
    }

    public static synchronized Connection connect(String string, int n, boolean bl) throws IOException {
        return Connector.open((String)string, (int)n, (boolean)bl);
    }

    public static boolean testIP(String string, int n, MTTorrent mTTorrent, Statistics statistics) {
        if (string.startsWith("192.168.")) {
            MTLogger.writeLine("Local peer IP test is skipped. " + string + ":" + n);
            return true;
        }
        if (string.equals("127.0.0.1") && n == 6882) {
            MTLogger.write("Got back own address.");
            return false;
        }
        if (!Preferences.EnableAddressBooster) {
            return true;
        }
        boolean bl = false;
        String string2 = "http://avalon.aut.bme.hu/~tyrael/mobtorrent/testip.php?ip=" + string + "&port=" + n;
        if (statistics != null && mTTorrent != null) {
            string2 = string2 + "&info_hash=" + SHA1.resultToString(mTTorrent.getInfoHashByteArray());
            string2 = string2 + "&id=" + statistics.getPhoneID();
        }
        try {
            int n2;
            HttpConnection httpConnection = (HttpConnection)MTNetworkStatusManager.connect(string2, 3, true);
            MTLogger.writeLine("Connect ok to PeerChecker: " + string2);
            httpConnection.setRequestMethod("GET");
            InputStream inputStream = httpConnection.openInputStream();
            MTLogger.writeLine("InputStream ok to PeerChecker: " + string2);
            Thread.sleep(2000L);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            if (byteArrayOutputStream.toString().startsWith("ok")) {
                bl = true;
                MTLogger.writeLine("Peer IP checked: " + string2);
            }
            try {
                inputStream.close();
                httpConnection.close();
            }
            catch (Exception exception) {
                MTLogger.writeLine("PeerChecker connection close failed: " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            MTLogger.writeLine("Connection to PeerChecker failed: " + string2 + " message: " + exception.getMessage());
        }
        return bl;
    }

    public static boolean testURL(String string) {
        int n;
        if (!Preferences.EnableAddressBooster) {
            return true;
        }
        String string2 = string;
        String string3 = "80";
        if (string2.startsWith("http://")) {
            string2 = string2.substring(7);
        }
        if (string2.indexOf(58) > 0) {
            string3 = string2.substring(string2.indexOf(58) + 1);
            if (string3.indexOf(47) != -1) {
                string3 = string3.substring(0, string3.indexOf(47));
            }
            string2 = string2.substring(0, string2.indexOf(58));
        }
        if ((n = string2.indexOf(47)) >= 0) {
            string2 = string2.substring(0, n);
        }
        try {
            return MTNetworkStatusManager.testIP(string2, Integer.parseInt(string3), null, null);
        }
        catch (NumberFormatException numberFormatException) {
            MTLogger.writeLine("Numberformat exception while tracker url check: " + numberFormatException.getMessage());
            numberFormatException.printStackTrace();
            return false;
        }
    }
}

