/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Bencode.MTBencode;
import Bencode.MTBencodedDictionary;
import Bencode.MTBencodedInteger;
import Bencode.MTBencodedList;
import Bencode.MTBencodedString;
import Logger.MTLogger;
import Settings.Preferences;
import Tools.NetTools;
import Tools.VectorSorter;
import TorrentEngine.MTBitfield;
import TorrentEngine.MTFile;
import TorrentEngine.MTFileManager;
import TorrentEngine.MTPeer;
import TorrentEngine.MTPiece;
import TorrentEngine.MTPieceToDownload;
import TorrentEngine.MTTorrentManager;
import TorrentEngine.MTTracker;
import TorrentEngine.MTTrackerConnection;
import TorrentEngine.Statistics;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import sha1.SHA1;

public class MTTorrent {
    private final int MaxStoredPeers;
    private final int DefaultTrackerRequestInterval;
    private final int DefaultEmergencyTrackerRequestInterval;
    public static final int KMaxPeerConnectionLimit = 5;
    public static final int KIncomingConnectionSlots = 2;
    private final int KDownloadingPiecesCheckInterval;
    private final int KMaxNotInterested;
    private static final int ENotSpecified = 0;
    private static final int ETrackerConnecting = 1;
    private static final int ETrackerSuccessful = 2;
    private static final int ETrackerFailed = 3;
    private static final int ETorrentFailed = 4;
    private static final int ETorrentRemoving = 5;
    private String downloadFolder;
    private int lastTrackerEvent = 0;
    private int notInterestedMessages = 0;
    private String torrentNameWithoutPath;
    private MTTorrentManager torrentManager;
    private MTFileManager fileManager;
    private MTTrackerConnection trackerConnection = null;
    private int trackerRequestInterval;
    private String announce;
    private String infoHash;
    private byte[] infoHashByteArray;
    private boolean multitrackerEnabled = false;
    private int pieceLength;
    private String name;
    private String path;
    private String torrentFilePath;
    private int bytesLeft;
    private String comment;
    private String createdBy;
    private int creationDate;
    private MTBitfield bitField;
    private int bytesDownloaded;
    private boolean active = false;
    private boolean complete = false;
    private boolean valid = false;
    private boolean failed = false;
    private int ellapsedTime = 0;
    private long randomSeed;
    private double downloadPercent = 0.0;
    private int downloadedPieceCount;
    private int peerWireConnectionCount = 0;
    private double avarageBytesPerSecond = 0.0;
    private double avarageUploadedBytesPerSecond = 0.0;
    private int bytesPerSecond = 0;
    private int uploadedBytesPerSecond = 0;
    private int activeConnectionCount = 0;
    private int statusInfo;
    private int statusInfoDelay;
    private boolean endGame = false;
    private boolean peerConnectingActive = false;
    private int incomingConnectionsNum = 0;
    private int reorderrequest = 0;
    private static final int autosavePeriod = 3600000;
    private static final int autosaveSize = 524288;
    private long lastAutosaveTime;
    private long downloadedSinceLastSave;
    private Vector announceList = null;
    private Vector trackerList = null;
    private MTTracker currentTracker = null;
    private Vector files;
    private Vector torrentPieces;
    private final Vector peers;
    private final Vector downloadingPieces;
    private Vector disconnectedPeers;

    public MTTorrent(MTTorrentManager mTTorrentManager, String string) {
        this.MaxStoredPeers = 50;
        this.DefaultTrackerRequestInterval = 600;
        this.DefaultEmergencyTrackerRequestInterval = 60;
        this.KDownloadingPiecesCheckInterval = 30;
        this.KMaxNotInterested = 3;
        this.torrentManager = mTTorrentManager;
        this.downloadFolder = string;
        this.fileManager = new MTFileManager();
        this.files = new Vector();
        this.torrentPieces = new Vector();
        this.peers = new Vector();
        this.downloadingPieces = new Vector();
        this.disconnectedPeers = new Vector();
        this.lastAutosaveTime = new Date().getTime();
        this.downloadedSinceLastSave = 0L;
        this.randomSeed = this.lastAutosaveTime;
    }

    public String getDownloadFolder() {
        return this.downloadFolder;
    }

    public boolean isMultitrackerEnabled() {
        return this.multitrackerEnabled;
    }

    public Vector getAnnounceList() {
        return this.announceList;
    }

    public Vector getTrackerList() {
        return this.trackerList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readFromBencodedData(MTBencode mTBencode, boolean bl) {
        int n;
        Object object;
        int n2;
        Object object2;
        MTBencode mTBencode2;
        if (mTBencode.type() != MTBencode.BencodedDictionary) {
            return -1;
        }
        MTBencodedDictionary mTBencodedDictionary = (MTBencodedDictionary)mTBencode;
        MTBencode mTBencode3 = null;
        mTBencode3 = mTBencodedDictionary.entryValue("announce");
        if (mTBencode3 == null) return -1;
        if (mTBencode3.type() != MTBencode.BencodedString) {
            return -1;
        }
        this.announce = ((MTBencodedString)mTBencode3).getStringValue();
        this.trackerList = new Vector();
        Vector<MTTracker> vector = new Vector<MTTracker>();
        this.trackerList.addElement(vector);
        vector.addElement(new MTTracker(this.announce));
        mTBencode3 = mTBencodedDictionary.entryValue("announce-list");
        if (mTBencode3 != null && mTBencode3.type() == MTBencode.BencodedList) {
            this.announceList = new Vector();
            this.trackerList.removeAllElements();
            this.multitrackerEnabled = true;
            mTBencode2 = (MTBencodedList)mTBencode3;
            for (int i = 0; i < ((MTBencodedList)mTBencode2).count(); ++i) {
                mTBencode3 = ((MTBencodedList)mTBencode2).item(i);
                if (mTBencode3 == null || mTBencode3.type() != MTBencode.BencodedList) continue;
                object2 = (MTBencodedList)mTBencode3;
                vector = new Vector();
                this.trackerList.addElement(vector);
                for (n2 = 0; n2 < ((MTBencodedList)object2).count(); ++n2) {
                    mTBencode3 = ((MTBencodedList)object2).item(n2);
                    if (mTBencode3 == null || mTBencode3.type() != MTBencode.BencodedString || ((String)(object = ((MTBencodedString)mTBencode3).getStringValue())).startsWith("udp")) continue;
                    this.announceList.addElement(object);
                    vector.addElement(new MTTracker((String)object));
                }
                VectorSorter.shuffle(vector);
            }
        }
        if ((mTBencode3 = mTBencodedDictionary.entryValue("info")) == null || mTBencode3.type() != MTBencode.BencodedDictionary) {
            return -1;
        }
        mTBencode2 = (MTBencodedDictionary)mTBencode3;
        SHA1 sHA1 = new SHA1();
        sHA1.update(((MTBencodedDictionary)mTBencode2).Bencode());
        object2 = sHA1.digest();
        this.infoHash = SHA1.resultToByteString((int[])object2);
        this.infoHashByteArray = SHA1.resultToByte((int[])object2);
        object2 = null;
        if (!bl && this.torrentManager.thisTorrentAlreadyAdded(this, this.infoHash)) {
            return -2;
        }
        this.torrentManager.notifyTorrentObserverMain(this.getThisTorrent(), 1);
        mTBencode3 = ((MTBencodedDictionary)mTBencode2).entryValue("piece length");
        if (mTBencode3 == null || mTBencode3.type() != MTBencode.BencodedInteger) {
            return -1;
        }
        this.pieceLength = ((MTBencodedInteger)mTBencode3).getValue();
        mTBencode3 = ((MTBencodedDictionary)mTBencode2).entryValue("files");
        if (mTBencode3 != null) {
            if (mTBencode3.type() != MTBencode.BencodedList) {
                return -1;
            }
            MTBencodedList mTBencodedList = (MTBencodedList)mTBencode3;
            mTBencode3 = ((MTBencodedDictionary)mTBencode2).entryValue("name");
            if (mTBencode3 == null || mTBencode3.type() != MTBencode.BencodedString) {
                return -1;
            }
            this.name = ((MTBencodedString)mTBencode3).getStringValue();
            this.path = this.getDownloadFolder() + this.name + "/";
            object = new Vector();
            n = 0;
            for (int i = 0; i < mTBencodedList.count(); ++i) {
                Object object3;
                MTBencode mTBencode4 = mTBencodedList.item(i);
                if (mTBencode4.type() != MTBencode.BencodedDictionary) {
                    return -1;
                }
                MTBencodedDictionary mTBencodedDictionary2 = (MTBencodedDictionary)mTBencode4;
                if ((mTBencode4 = mTBencodedDictionary2.entryValue("path")) == null || mTBencode4.type() != MTBencode.BencodedList) {
                    return -1;
                }
                MTBencodedList mTBencodedList2 = (MTBencodedList)mTBencode4;
                int n3 = 0;
                int n4 = 0;
                for (n4 = 0; n4 < mTBencodedList2.count(); ++n4) {
                    object3 = mTBencodedList2.item(n4);
                    if (((MTBencode)object3).type() != MTBencode.BencodedString) {
                        return -1;
                    }
                    n3 += ((MTBencodedString)object3).getStringValue().length() + 1;
                }
                object3 = "";
                for (n4 = 0; n4 < mTBencodedList2.count(); ++n4) {
                    MTBencode mTBencode5 = mTBencodedList2.item(n4);
                    object3 = (String)object3 + ((MTBencodedString)mTBencode5).getStringValue();
                    if (n4 == mTBencodedList2.count() - 1) continue;
                    object3 = (String)object3 + "/";
                }
                mTBencode4 = mTBencodedDictionary2.entryValue("length");
                if (mTBencode4 == null || mTBencode4.type() != MTBencode.BencodedInteger) {
                    return -1;
                }
                int n5 = ((MTBencodedInteger)mTBencode4).getValue();
                if (!bl) {
                    ((Vector)object).addElement(new CreateFile((String)object3, n5));
                } else {
                    this.addFile((String)object3, n5, true, bl);
                    this.bytesLeft += n5;
                }
                n += n5;
            }
            if (!bl) {
                if (MTFileManager.freeSize(this.path) < (long)n) return -4;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    CreateFile createFile = (CreateFile)((Vector)object).elementAt(i);
                    int n6 = this.addFile(createFile.getFilePath(), createFile.getFileSize(), false, bl);
                    if (n6 != 0) {
                        return n6;
                    }
                    this.bytesLeft += createFile.getFileSize();
                }
            }
        } else {
            n2 = 0;
            mTBencode3 = ((MTBencodedDictionary)mTBencode2).entryValue("length");
            if (mTBencode3 == null) return -1;
            if (mTBencode3.type() != MTBencode.BencodedInteger) {
                return -1;
            }
            this.bytesLeft = n2 = ((MTBencodedInteger)mTBencode3).getValue();
            mTBencode3 = ((MTBencodedDictionary)mTBencode2).entryValue("name");
            if (mTBencode3 == null || mTBencode3.type() != MTBencode.BencodedString) {
                return -1;
            }
            this.name = ((MTBencodedString)mTBencode3).getStringValue();
            this.path = this.getDownloadFolder() + this.name + "/";
            int n7 = this.addFile(((MTBencodedString)mTBencode3).getStringValue(), n2, true, bl);
            if (n7 != 0) {
                return n7;
            }
        }
        if ((mTBencode3 = ((MTBencodedDictionary)mTBencode2).entryValue("pieces")) == null || mTBencode3.type() != MTBencode.BencodedString) {
            return -1;
        }
        byte[] byArray = ((MTBencodedString)mTBencode3).getValue();
        if (byArray.length % 20 != 0) {
            return -1;
        }
        int n8 = 0;
        n = byArray.length / 20;
        byte[] byArray2 = new byte[20];
        for (int i = 0; i < n; ++i) {
            MTPiece mTPiece;
            System.arraycopy(byArray, i * 20, byArray2, 0, 20);
            if (i != n - 1) {
                n8 += this.pieceLength;
                mTPiece = new MTPiece(this, byArray2, this.pieceLength);
            } else {
                mTPiece = new MTPiece(this, byArray2, this.size() - n8);
            }
            this.torrentPieces.addElement(mTPiece);
        }
        this.bitField = new MTBitfield(this.torrentPieces.size(), false);
        mTBencode3 = mTBencodedDictionary.entryValue("comment");
        if (mTBencode3 != null && mTBencode3.type() == MTBencode.BencodedString) {
            this.comment = ((MTBencodedString)mTBencode3).getStringValue();
        }
        if ((mTBencode3 = mTBencodedDictionary.entryValue("created by")) != null && mTBencode3.type() == MTBencode.BencodedString) {
            this.createdBy = ((MTBencodedString)mTBencode3).getStringValue();
        }
        if ((mTBencode3 = mTBencodedDictionary.entryValue("creation date")) != null && mTBencode3.type() == MTBencode.BencodedInteger) {
            this.creationDate = ((MTBencodedInteger)mTBencode3).getValue();
        }
        this.calculateFileFragments();
        this.valid = true;
        this.torrentManager.notifyOpenTorrentStateChanged(2, this, null, 0.0);
        return 0;
    }

    void calculateFileFragments() {
        int n = 0;
        MTPiece mTPiece = (MTPiece)this.torrentPieces.elementAt(n);
        int n2 = 0;
        block0: for (int i = 0; i < this.files.size(); ++i) {
            MTFile mTFile = (MTFile)this.files.elementAt(i);
            if (n2 + mTFile.getSize() <= mTPiece.getTotalSize()) {
                mTPiece.addFileFragment(mTFile, 0, mTFile.getSize());
                if ((n2 += mTFile.getSize()) + mTFile.getSize() != mTPiece.getTotalSize()) continue;
                mTPiece = (MTPiece)this.torrentPieces.elementAt(++n);
                n2 = 0;
                continue;
            }
            for (int j = 0; j < mTFile.getSize(); j += mTPiece.getTotalSize() - n2) {
                if (mTFile.getSize() - j + n2 > mTPiece.getTotalSize()) {
                    mTPiece.addFileFragment(mTFile, j, mTPiece.getTotalSize() - n2);
                    mTPiece = (MTPiece)this.torrentPieces.elementAt(++n);
                    n2 = 0;
                    continue;
                }
                mTPiece.addFileFragment(mTFile, j, mTFile.getSize() - j);
                if ((n2 += mTFile.getSize() - j) != mTPiece.getTotalSize() || n >= this.torrentPieces.size() - 1) continue block0;
                mTPiece = (MTPiece)this.torrentPieces.elementAt(++n);
                n2 = 0;
                continue block0;
            }
        }
    }

    private int addFile(String string, int n, boolean bl, boolean bl2) {
        String string2 = this.path + string;
        if (bl2 && MTFileManager.fileExists(string2)) {
            this.files.addElement(new MTFile(string2, n));
            return 0;
        }
        if (this.path != null && !this.path.equals("")) {
            if (bl && MTFileManager.freeSize(this.path) < (long)n) {
                return -4;
            }
            this.files.addElement(new MTFile(string2, n));
            this.torrentManager.notifyOpenTorrentStateChanged(1, this, string, 0.0);
            if (MTFileManager.createFile(string2, n, this.torrentManager, this, string) == 0) {
                return 0;
            }
            return -5;
        }
        return -6;
    }

    public void start() {
        if (!this.isActive() && this.isValid()) {
            this.ellapsedTime = 0;
            this.failed = false;
            this.active = true;
            if (!this.complete) {
                this.torrentManager.notifyTorrentObserverMain(this.getThisTorrent(), 3);
                this.lastTrackerEvent = 1;
                this.trackerConnection = null;
                this.trackerConnection = new MTTrackerConnection(this.getThisTorrent(), this.lastTrackerEvent);
                this.trackerConnection.connectToTracker();
            } else if (this.lastTrackerEvent != 5) {
                this.torrentManager.notifyTorrentObserverMain(this.getThisTorrent(), 5);
                this.lastTrackerEvent = 3;
                this.trackerConnection = null;
                this.trackerConnection = new MTTrackerConnection(this.getThisTorrent(), this.lastTrackerEvent);
                this.trackerConnection.connectToTracker();
            }
        }
    }

    public void initializeByBitfield(byte[] byArray) {
        this.bitField.set(byArray);
        for (int i = 0; i < this.torrentPieces.size(); ++i) {
            if (!this.bitField.isBitSet(i)) continue;
            MTPiece mTPiece = (MTPiece)this.torrentPieces.elementAt(i);
            this.updateBytesDownloaded(mTPiece.getTotalSize(), false);
            mTPiece.setDownloaded();
            this.pieceDownloaded(mTPiece, true);
        }
        this.bytesPerSecond = 0;
    }

    public void setDownloadedBecauseDirectoryOpen() {
        if (!this.complete) {
            for (int i = 0; i < this.bitField.getLengthInBites(); ++i) {
                this.bitField.setBit(i);
            }
            for (int i = 0; i < this.torrentPieces.size(); ++i) {
                MTPiece mTPiece = (MTPiece)this.torrentPieces.elementAt(i);
                this.updateBytesDownloaded(mTPiece.getTotalSize(), false);
                mTPiece.setDownloaded();
                this.pieceDownloaded(mTPiece, true);
            }
            this.bytesPerSecond = 0;
        }
    }

    public void stop(boolean bl) {
        if (this.isActive()) {
            this.fileManager.closeAll();
            for (int i = 0; i < this.peers.size(); ++i) {
                ((MTPeer)this.peers.elementAt(i)).disconnect();
            }
            this.avarageBytesPerSecond = 0.0;
            this.bytesPerSecond = 0;
            this.avarageUploadedBytesPerSecond = 0.0;
            this.uploadedBytesPerSecond = 0;
            this.torrentManager.notifyTorrentObserver(this.getThisTorrent(), 32);
            this.torrentManager.notifyTorrentObserver(this.getThisTorrent(), 64);
            this.trackerConnection = null;
            this.lastTrackerEvent = 2;
            this.trackerConnection = new MTTrackerConnection(this.getThisTorrent(), this.lastTrackerEvent);
            this.trackerConnection.connectToTracker();
            this.active = false;
            if (!bl) {
                this.torrentManager.notifyTorrentObserver(this.getThisTorrent(), 256);
            } else {
                this.torrentManager.notifyTorrentObserver(this.getThisTorrent(), 8192);
            }
        }
    }

    public void close() {
        this.stop(false);
        this.torrentManager.notifyTorrentObserver(this, 4096);
    }

    public int processTrackerResponse(MTBencode mTBencode) {
        if (mTBencode.type() != MTBencode.BencodedDictionary) {
            MTLogger.writeLine("Value is not dictionary");
            return -6;
        }
        if (this.lastTrackerEvent == 1) {
            MTLogger.writeLine("Title changed");
            this.torrentManager.notifyTorrentObserverMain(this.getThisTorrent(), 4);
        }
        MTBencodedDictionary mTBencodedDictionary = (MTBencodedDictionary)mTBencode;
        MTBencode mTBencode2 = null;
        mTBencode2 = mTBencodedDictionary.entryValue("interval");
        if (mTBencode2 != null && mTBencode2.type() == MTBencode.BencodedInteger) {
            int n = ((MTBencodedInteger)mTBencode2).getValue();
            this.trackerRequestInterval = n > 0 && n < 12000 ? n : 600;
        }
        if ((mTBencode2 = mTBencodedDictionary.entryValue("failure reason")) != null && mTBencode2.type() == MTBencode.BencodedString) {
            MTLogger.write("[Tracker] Request failed, reason: ");
            MTLogger.writeLine(((MTBencodedString)mTBencode2).getStringValue());
            return -6;
        }
        MTLogger.write("[Torrent] Local peer id: ");
        MTLogger.writeLine(this.torrentManager.getPeerID());
        mTBencode2 = mTBencodedDictionary.entryValue("peers");
        if (mTBencode2 != null && mTBencode2.type() == MTBencode.BencodedList) {
            MTBencodedList mTBencodedList = (MTBencodedList)mTBencode2;
            MTLogger.write("[Tracker] Number of peers received: ");
            MTLogger.writeLine(mTBencodedList.count());
            for (int i = 0; i < mTBencodedList.count(); ++i) {
                mTBencode2 = mTBencodedList.item(i);
                if (mTBencode2.type() != MTBencode.BencodedDictionary) {
                    MTLogger.writeLine("Value has not dictionary type");
                    return -6;
                }
                MTBencodedDictionary mTBencodedDictionary2 = (MTBencodedDictionary)mTBencode2;
                if ((mTBencode2 = mTBencodedDictionary2.entryValue("peer id")) == null || mTBencode2.type() != MTBencode.BencodedString) continue;
                String string = ((MTBencodedString)mTBencode2).getStringValue();
                MTLogger.write("[Torrent] Processing peer id: ");
                MTLogger.writeLine(string);
                if (string.length() != 20) continue;
                if (string.equals(this.torrentManager.getPeerID())) {
                    MTLogger.writeLine("Got own local address from tracker (peer ID is the same), throwing it away...");
                    continue;
                }
                mTBencode2 = mTBencodedDictionary2.entryValue("ip");
                if (mTBencode2 == null || mTBencode2.type() != MTBencode.BencodedString) continue;
                String string2 = ((MTBencodedString)mTBencode2).getStringValue();
                MTLogger.write("[Tracker] Peer address: ");
                MTLogger.write(string2);
                MTLogger.write(":");
                mTBencode2 = mTBencodedDictionary2.entryValue("port");
                if (mTBencode2 == null || mTBencode2.type() != MTBencode.BencodedInteger) continue;
                int n = ((MTBencodedInteger)mTBencode2).getValue();
                MTLogger.write(((MTBencodedInteger)mTBencode2).getValue());
                if (Preferences.LocalAddress != null) {
                    if (Preferences.LocalAddress.equals(string2)) {
                        MTLogger.writeLine("Got own local address from tracker, throwing it away...");
                        continue;
                    }
                    MTLogger.writeLine("");
                } else {
                    MTLogger.writeLine("");
                }
                MTPeer mTPeer = new MTPeer(string2, n, string, this.torrentPieces.size());
                this.addPeer(mTPeer);
            }
        } else if (mTBencode2 != null && mTBencode2.type() == MTBencode.BencodedString) {
            MTBencodedString mTBencodedString = (MTBencodedString)mTBencode2;
            if (mTBencodedString.getStringValue().length() % 6 == 0) {
                int n;
                byte[] byArray = mTBencodedString.getValue();
                int[] nArray = new int[byArray.length / 6];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = n;
                }
                NetTools.shuffle(nArray);
                for (n = 0; n < byArray.length / 6 && this.peers.size() < 50; ++n) {
                    int n2 = nArray[n] * 6;
                    int n3 = byArray[n2] < 0 ? 256 + byArray[n2] : byArray[n2];
                    int n4 = byArray[n2 + 1] < 0 ? 256 + byArray[n2 + 1] : byArray[n2 + 1];
                    int n5 = byArray[n2 + 2] < 0 ? 256 + byArray[n2 + 2] : byArray[n2 + 2];
                    int n6 = byArray[n2 + 3] < 0 ? 256 + byArray[n2 + 3] : byArray[n2 + 3];
                    String string = "" + n3 + "." + n4 + "." + n5 + "." + n6;
                    int n7 = byArray[n2 + 4] < 0 ? 256 + byArray[n2 + 4] << 8 : byArray[n2 + 4] << 8;
                    int n8 = byArray[n2 + 5] < 0 ? 256 + byArray[n2 + 5] : byArray[n2 + 5];
                    int n9 = n7 + n8;
                    MTLogger.writeLine(string + ":" + n9);
                    if (Preferences.LocalAddress != null && Preferences.LocalAddress.equals(string) && n9 == 6882) {
                        MTLogger.writeLine("Got own local address from tracker, throwing it away...");
                        continue;
                    }
                    MTPeer mTPeer = new MTPeer(string, n9, null, this.torrentPieces.size());
                    int n10 = this.addPeer(mTPeer);
                    if (n10 == 0) continue;
                    MTLogger.writeLine("Peer not added, error code: " + n10);
                }
            } else {
                MTLogger.writeLine("[Tracker] Compact response invalid (length cannot be devided by 6 without remainder)");
            }
        } else {
            MTLogger.writeLine("[Tracker] No peers list / peers list invalid");
        }
        MTLogger.writeLine("[Tracker] Response procesed, peers: " + this.peers.size());
        if (this.lastTrackerEvent == 1) {
            this.torrentManager.notifyTorrentObserverMain(this.getThisTorrent(), 2);
        }
        this.torrentManager.notifyTorrentObserver(this, 65536);
        return 0;
    }

    public MTPeer peer(String string, int n) {
        for (int i = 0; i < this.peers.size(); ++i) {
            MTPeer mTPeer = (MTPeer)this.peers.elementAt(i);
            if (!mTPeer.getAddress().equals(string) || mTPeer.getPort() != n) continue;
            return mTPeer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPeer(MTPeer mTPeer) {
        if (this.peers.size() >= 50) {
            return -1;
        }
        if (this.peer(mTPeer.getAddress(), mTPeer.getPort()) != null) {
            return -2;
        }
        Vector vector = this.peers;
        synchronized (vector) {
            this.peers.addElement(mTPeer);
        }
        MTLogger.writeLine("[Peer]Number of peers: " + this.peers.size());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(String string, int n) {
        Vector vector = this.peers;
        synchronized (vector) {
            for (int i = 0; i < this.peers.size(); ++i) {
                MTPeer mTPeer = (MTPeer)this.peers.elementAt(i);
                if (!mTPeer.getAddress().equals(string) || mTPeer.getPort() != n) continue;
                this.peers.removeElementAt(i);
                mTPeer = null;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimer() {
        ++this.ellapsedTime;
        if (this.isValid()) {
            Vector vector = this.peers;
            synchronized (vector) {
                int n;
                this.activeConnectionCount = 0;
                for (int i = 0; i < this.peers.size(); ++i) {
                    MTPeer mTPeer = (MTPeer)this.peers.elementAt(i);
                    mTPeer.onTimer();
                    if (!mTPeer.isDeletable()) continue;
                    for (n = 0; n < this.pieceCount(); ++n) {
                        if (!mTPeer.getBitField().isBitSet(n)) continue;
                        this.decreaseNumberOfPeersHavingPiece(n);
                    }
                    MTLogger.writeLine("[Peer]Peer removed: " + mTPeer.getAddress() + ":" + mTPeer.getPort());
                    mTPeer = null;
                    this.peers.removeElementAt(i);
                    this.torrentManager.notifyTorrentObserver(this, 65536);
                    --i;
                }
                if (this.isActive()) {
                    if (!this.complete) {
                        double d = this.avarageBytesPerSecond;
                        this.avarageBytesPerSecond = 0.9 * this.avarageBytesPerSecond + 0.1 * (double)this.bytesPerSecond;
                        this.bytesPerSecond = 0;
                        if (this.avarageBytesPerSecond != d) {
                            this.torrentManager.notifyTorrentObserver(this, 32);
                        }
                    }
                    double d = this.avarageUploadedBytesPerSecond;
                    this.avarageUploadedBytesPerSecond = 0.9 * this.avarageUploadedBytesPerSecond + 0.1 * (double)this.uploadedBytesPerSecond;
                    this.uploadedBytesPerSecond = 0;
                    if (this.avarageUploadedBytesPerSecond != d) {
                        this.torrentManager.notifyTorrentObserver(this, 64);
                    }
                    for (n = 0; n < this.disconnectedPeers.size(); ++n) {
                        int n2 = this.peers.indexOf(this.disconnectedPeers.elementAt(n));
                        if (n2 < 0) continue;
                        this.peers.removeElementAt(n2);
                        this.peers.addElement(this.disconnectedPeers.elementAt(n));
                    }
                    this.disconnectedPeers.removeAllElements();
                    for (n = 0; n < this.peers.size(); ++n) {
                        MTPeer mTPeer = (MTPeer)this.peers.elementAt(n);
                        if (mTPeer.state() == 0) continue;
                        ++this.activeConnectionCount;
                    }
                    if (!this.complete && this.trackerRequestInterval != 0 && (this.ellapsedTime % this.trackerRequestInterval == 0 || this.peers.size() < 5 && this.ellapsedTime % 60 == 0) && this.trackerConnection != null) {
                        this.trackerConnection.connectToTracker();
                    }
                    n = 5 - this.activeConnectionCount;
                    for (int i = 0; i < this.peers.size() && n > 0; ++i) {
                        MTPeer mTPeer = (MTPeer)this.peers.elementAt(i);
                        if (this.complete || mTPeer.state() != 0) continue;
                        if (this.hasTimeoutlessPeer()) {
                            if (mTPeer.isHadRequestTimeout()) continue;
                            mTPeer.connect(this.getThisTorrent(), this.torrentManager);
                            ++this.activeConnectionCount;
                            --n;
                            continue;
                        }
                        mTPeer.connect(this.getThisTorrent(), this.torrentManager);
                        ++this.activeConnectionCount;
                        --n;
                    }
                }
            }
        }
    }

    public void increaseNotInterestedMessages() {
        ++this.notInterestedMessages;
        this.recheckPieceDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recheckPieceDownloads() {
        MTLogger.writeLine("[Torrent] Searching for lost pieces");
        if (this.notInterestedMessages >= 3) {
            Vector vector = this.downloadingPieces;
            synchronized (vector) {
                this.downloadingPieces.removeAllElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePieceFromDownloading(MTPiece mTPiece) {
        Vector vector = this.downloadingPieces;
        synchronized (vector) {
            this.downloadingPieces.removeElement(mTPiece);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void increaseNumberOfPeersHavingPiece(int n) {
        ((MTPiece)this.torrentPieces.elementAt(n)).incNumberOfPeersHaveThis();
    }

    public void decreaseNumberOfPeersHavingPiece(int n) {
        ((MTPiece)this.torrentPieces.elementAt(n)).decNumberOfPeersHaveThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void peerDisconnected(MTPeer mTPeer, boolean bl) {
        Vector vector = mTPeer.piecesToDownload();
        if (vector != null) {
            int n;
            MTPieceToDownload[] mTPieceToDownloadArray = null;
            Vector vector2 = vector;
            synchronized (vector2) {
                mTPieceToDownloadArray = new MTPieceToDownload[vector.size()];
                for (n = 0; n < mTPieceToDownloadArray.length; ++n) {
                    mTPieceToDownloadArray[n] = (MTPieceToDownload)vector.elementAt(n);
                }
            }
            vector = null;
            vector2 = this.downloadingPieces;
            synchronized (vector2) {
                for (n = 0; n < mTPieceToDownloadArray.length; ++n) {
                    if (mTPieceToDownloadArray[n] == null) continue;
                    this.downloadingPieces.removeElement(mTPieceToDownloadArray[n]);
                }
            }
            mTPieceToDownloadArray = null;
        }
        if (bl) {
            --this.peerWireConnectionCount;
            this.torrentManager.notifyTorrentObserver(this, 4);
        }
        this.disconnectedPeers.addElement(mTPeer);
    }

    public void increasePWConnectionCount() {
        ++this.peerWireConnectionCount;
        this.torrentManager.notifyTorrentObserver(this, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTPiece getPieceToDownload(MTPeer mTPeer) {
        if (this.isComplete()) {
            return null;
        }
        MTPiece mTPiece = null;
        MTBitfield mTBitfield = this.bitField.clone();
        mTBitfield.bitwiseNot();
        mTBitfield.bitwiseAnd(mTPeer.getBitField());
        int n = 65535;
        int n2 = 0;
        if (this.isEndGame()) {
            for (int i = 0; i < this.torrentPieces.size(); ++i) {
                MTPiece mTPiece2 = (MTPiece)this.torrentPieces.elementAt(i);
                if (!mTBitfield.isBitSet(i) || !this.downloadingPieces.contains(mTPiece2)) continue;
                boolean bl = false;
                for (int j = 0; j < mTPeer.piecesToDownload().size(); ++j) {
                    if (!((MTPieceToDownload)mTPeer.piecesToDownload().elementAt((int)j)).piece.equals(mTPiece2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                mTPiece = mTPiece2;
            }
        } else {
            Vector vector = this.downloadingPieces;
            synchronized (vector) {
                int n3;
                for (n3 = 0; n3 < this.torrentPieces.size(); ++n3) {
                    MTPiece mTPiece3 = (MTPiece)this.torrentPieces.elementAt(n3);
                    if (!mTBitfield.isBitSet(n3) || this.downloadingPieces.indexOf(mTPiece3) >= 0) continue;
                    ++n2;
                }
                n3 = 0;
                if (n2 > 0) {
                    n3 = new Random(this.randomSeed).nextInt(n2);
                }
                for (int i = 0; i < this.torrentPieces.size(); ++i) {
                    MTPiece mTPiece4 = (MTPiece)this.torrentPieces.elementAt(i);
                    if (!mTBitfield.isBitSet(i) || this.downloadingPieces.indexOf(mTPiece4) >= 0) continue;
                    if (n3 == 0) {
                        this.downloadingPieces.addElement(mTPiece4);
                        mTPiece = mTPiece4;
                        break;
                    }
                    --n3;
                }
            }
            if (mTPiece == null && (this.torrentPieces.size() - this.downloadedPieceCount <= this.downloadingPieces.size() && this.downloadingPieces.size() < 30 || this.torrentPieces.size() - this.downloadedPieceCount < 20)) {
                ++this.reorderrequest;
                if (this.reorderrequest % 3 == 0) {
                    this.reorderDownload();
                }
            }
        }
        return mTPiece;
    }

    private void endGameCheck() {
        if (this.endGame) {
            return;
        }
        int n = this.downloadedPieceCount * 100 / this.torrentPieces.size();
        if (n >= 90) {
            this.enableEndGame();
        }
    }

    private void enableEndGame() {
        this.endGame = true;
        this.reorderDownload();
        MTLogger.writeLine("[Torrent] Entering End Game mode.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorderDownload() {
        Vector vector = this.peers;
        synchronized (vector) {
            for (int i = 0; i < this.peers.size(); ++i) {
                MTPeer mTPeer = (MTPeer)this.peers.elementAt(i);
                if (mTPeer.state() != 4) continue;
                mTPeer.cancelAllPieceRequests();
            }
        }
        vector = this.downloadingPieces;
        synchronized (vector) {
            this.downloadingPieces.removeAllElements();
        }
    }

    public void endGamePieceReceived(MTPiece mTPiece, MTPeer mTPeer) {
        if (this.downloadingPieces.indexOf(mTPiece) < 0) {
            MTLogger.writeLine("[Torrent] endgame piece received." + mTPiece.index());
            this.downloadingPieces.addElement(mTPiece);
            for (int i = 0; i < this.peers.size(); ++i) {
                if (this.peers.elementAt(i).equals(mTPeer)) continue;
                ((MTPeer)this.peers.elementAt(i)).cancelPieceRequest(mTPiece);
            }
        }
    }

    public void updateBytesDownloaded(int n, boolean bl) {
        this.bytesDownloaded += n;
        this.bytesLeft -= n;
        this.downloadPercent = (double)this.bytesDownloaded / ((double)this.size() / 100.0);
        if (bl) {
            this.bytesPerSecond += n;
            if (this.bytesPerSecond < 0) {
                this.bytesPerSecond = 0;
            }
            this.torrentManager.notifyTorrentObserver(this, 8);
        }
    }

    public void updateBytesUploaded(int n, boolean bl) {
        this.uploadedBytesPerSecond += n;
        if (bl) {
            this.torrentManager.notifyTorrentObserver(this, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceDownloaded(MTPiece mTPiece, boolean bl) {
        Object object = this.downloadingPieces;
        synchronized (object) {
            this.downloadingPieces.removeElement(mTPiece);
        }
        this.bitField.setBit(mTPiece.index());
        ++this.downloadedPieceCount;
        this.torrentManager.notifyTorrentObserver(this, 2048);
        if (!bl) {
            this.autosave(false);
        }
        if (this.downloadedPieceCount == this.torrentPieces.size()) {
            this.complete = true;
            this.downloadPercent = 100.0;
            this.torrentManager.notifyTorrentObserver(this, 8);
            MTLogger.writeLine("[Torrent] DOWNLOAD COMPLETE");
            this.fileManager.closeAll();
            this.trackerConnection = null;
            this.lastTrackerEvent = 3;
            this.trackerConnection = new MTTrackerConnection(this.getThisTorrent(), this.lastTrackerEvent);
            this.trackerConnection.connectToTracker();
            if (!bl) {
                object = this.getTorrentManager().getSatistics();
                if (object != null) {
                    ((Statistics)object).onTorrentFinished(this);
                    ((Statistics)object).sendStatistics();
                }
                object = null;
                Vector vector = this.peers;
                synchronized (vector) {
                    for (int i = 0; i < this.peers.size(); ++i) {
                        if (((MTPeer)this.peers.elementAt(i)).isIncommingPeer()) continue;
                        ((MTPeer)this.peers.elementAt(i)).disconnect();
                    }
                }
            }
            this.avarageBytesPerSecond = 0.0;
            this.bytesPerSecond = 0;
            this.torrentManager.notifyTorrentObserverMain(this, 5);
            this.autosave(true);
            this.endGameCheck();
        }
        object = this.peers;
        synchronized (object) {
            for (int i = 0; i < this.peers.size(); ++i) {
                ((MTPeer)this.peers.elementAt(i)).notifyThatClientHavePiece(mTPiece.index());
            }
        }
    }

    private void autosave(boolean bl) {
        long l = new Date().getTime();
        long l2 = l - this.lastAutosaveTime;
        this.downloadedSinceLastSave = this.downloadedPieceCount * this.pieceLength;
        if (bl || l2 >= 3600000L || this.downloadedSinceLastSave >= 524288L) {
            MTLogger.writeLine("[Torrent] autosaving...");
            this.torrentManager.notifyTorrentObserver(this, 131072);
            this.lastAutosaveTime = l;
            this.downloadedSinceLastSave = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceHashFailed(MTPiece mTPiece) {
        Vector vector = this.downloadingPieces;
        synchronized (vector) {
            this.downloadingPieces.removeElement(mTPiece);
        }
        this.updateBytesDownloaded(-mTPiece.getTotalSize(), true);
    }

    public boolean hasTimeoutlessPeer() {
        for (int i = 0; i < this.peers.size(); ++i) {
            if (((MTPeer)this.peers.elementAt(i)).isHadRequestTimeout()) continue;
            return true;
        }
        return false;
    }

    void setStatusInfo(int n) {
        if (this.statusInfo != n) {
            this.statusInfo = n;
            this.torrentManager.notifyTorrentObserver(this, 128);
            if (this.statusInfo == 3 || this.statusInfo == 2) {
                this.statusInfoDelay = 3;
            }
        }
    }

    public int indexOfPiece(MTPiece mTPiece) {
        return this.torrentPieces.indexOf(mTPiece);
    }

    public int pieceCount() {
        return this.torrentPieces.size();
    }

    public MTPiece piece(int n) {
        return (MTPiece)this.torrentPieces.elementAt(n);
    }

    public int size() {
        return this.bytesDownloaded + this.bytesLeft;
    }

    public String getName() {
        return this.name;
    }

    public String getAnnounce() {
        return this.announce;
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public String getPath() {
        return this.path;
    }

    public String getComment() {
        return this.comment;
    }

    public String getInfoHash() {
        return this.infoHash;
    }

    public MTTorrentManager getTorrentManager() {
        return this.torrentManager;
    }

    public int getBytesLeft() {
        return this.bytesLeft;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public byte[] getInfoHashByteArray() {
        return this.infoHashByteArray;
    }

    public MTBitfield getBitField() {
        return this.bitField;
    }

    public double getDownloadPercent() {
        return this.downloadPercent;
    }

    public MTTorrent getThisTorrent() {
        return this;
    }

    public MTFileManager getFileManager() {
        return this.fileManager;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getActiveConnectionCount() {
        return this.activeConnectionCount;
    }

    public double getAvarageBytesPerSecond() {
        return this.avarageBytesPerSecond;
    }

    public String getTorrentNameWithoutPath() {
        return this.torrentNameWithoutPath;
    }

    public void setTorrentNameWithoutPath(String string) {
        this.torrentNameWithoutPath = string;
    }

    public int getPeerWireConnectionCount() {
        return this.peerWireConnectionCount;
    }

    public Vector getFiles() {
        return this.files;
    }

    public boolean isEndGame() {
        return this.endGame;
    }

    public int getAllPeersNum() {
        return this.peers.size();
    }

    public String getTorrentFilePath() {
        return this.torrentFilePath;
    }

    public void setTorrentFilePath(String string) {
        this.torrentFilePath = string;
    }

    public double getAvarageUploadedBytesPerSecond() {
        return this.avarageUploadedBytesPerSecond;
    }

    public int getIncomingConnectionsNum() {
        return this.incomingConnectionsNum;
    }

    public void incIncomingConnectionsNum() {
        if (this.incomingConnectionsNum == 0 && this.complete) {
            this.torrentManager.notifyTorrentObserverMain(this, 6);
        }
        ++this.incomingConnectionsNum;
    }

    public void decIncomingConnectionsNum() {
        --this.incomingConnectionsNum;
        if (this.incomingConnectionsNum == 0 && this.complete) {
            this.torrentManager.notifyTorrentObserverMain(this, 7);
        }
    }

    public int getSeedersNumber() {
        if (this.currentTracker == null || this.currentTracker.getStatus() != 1 || this.currentTracker.getSeeders() < 0) {
            return 0;
        }
        return this.currentTracker.getSeeders();
    }

    public int getLeechersNumber() {
        if (this.currentTracker == null || this.currentTracker.getStatus() != 1 || this.currentTracker.getLeechers() < 0) {
            return 0;
        }
        return this.currentTracker.getLeechers();
    }

    public MTTracker getCurrentTracker() {
        return this.currentTracker;
    }

    public void setCurrentTracker(MTTracker mTTracker) {
        this.currentTracker = mTTracker;
    }

    class CreateFile {
        private String filePath;
        private int fileSize;

        public CreateFile(String string, int n) {
            this.filePath = string;
            this.fileSize = n;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public int getFileSize() {
            return this.fileSize;
        }
    }
}

