/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Bencode.MTBencode;
import Logger.MTLogger;
import Tools.NetTools;
import TorrentEngine.MTNetworkStatusManager;
import TorrentEngine.MTTorrent;
import TorrentEngine.MTTracker;
import TorrentEngine.Statistics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.HttpConnection;

public class MTTrackerConnection {
    private MTTorrent torrent;
    private int trackerEvent;
    public static final int ETrackerEventNotSpecified = 0;
    public static final int ETrackerEventStarted = 1;
    public static final int ETrackerEventStopped = 2;
    public static final int ETrackerEventCompleted = 3;
    private String uriEnd;
    private TrackerHttpConnection trackerHttpConnectionThread;
    private boolean interrupted;

    public MTTrackerConnection(MTTorrent mTTorrent, int n) {
        this.torrent = mTTorrent;
        this.trackerEvent = n;
        this.createUri();
    }

    private void createUri() {
        String string = "?";
        string = string + "info_hash=" + NetTools.urlEncoder(this.torrent.getInfoHash());
        string = string + "&peer_id=" + this.torrent.getTorrentManager().getPeerID();
        string = string + "&key=" + this.torrent.getTorrentManager().getKey();
        string = string + "&port=" + 6882;
        string = string + "&uploaded=0";
        string = string + "&downloaded=0";
        string = string + "&left=" + this.torrent.getBytesLeft();
        string = string + "&compact=1";
        if (this.trackerEvent != 0) {
            string = string + "&event=";
            switch (this.trackerEvent) {
                case 1: {
                    string = string + "started";
                    break;
                }
                case 2: {
                    string = string + "stopped";
                    break;
                }
                case 3: {
                    string = string + "completed";
                    break;
                }
            }
        }
        this.uriEnd = string;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    private void connectTracker(MTTracker mTTracker, String string) throws IOException {
        InputStream inputStream = null;
        HttpConnection httpConnection = null;
        try {
            MTBencode mTBencode;
            int n;
            if (string.indexOf("http://") != 0) {
                string = "http://" + string;
            }
            MTLogger.writeLine("[Tracker]Trying to connect to tracker: " + string);
            httpConnection = (HttpConnection)MTNetworkStatusManager.connect(string, 3, true);
            MTLogger.writeLine("[Tracker]Connect ok to tracker: " + string);
            httpConnection.setRequestMethod("GET");
            inputStream = httpConnection.openInputStream();
            MTLogger.writeLine("[Tracker]InputStream ok to tracker: " + string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            if (this.trackerEvent == 1 || this.trackerEvent == 3) {
                this.torrent.getTorrentManager().getNetworkManager().startListening();
            }
            if ((mTBencode = MTBencode.parse(byteArrayOutputStream.toByteArray())) != null) {
                mTTracker.processResponse(mTBencode);
                int n2 = this.torrent.processTrackerResponse(mTBencode);
                if (n2 != 0) {
                    this.torrent.getTorrentManager().notifyTorrentObserverMain(this.torrent, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                httpConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void connectToTracker() {
        Statistics statistics = this.torrent.getTorrentManager().getSatistics();
        if (statistics != null) {
            if (statistics.isFirstTime()) {
                statistics.register();
            }
            statistics.sendStatistics();
        }
        this.trackerHttpConnectionThread = new TrackerHttpConnection();
        this.trackerHttpConnectionThread.start();
    }

    private class TrackerHttpConnection
    extends Thread {
        private TrackerHttpConnection() {
        }

        public void run() {
            try {
                boolean bl = false;
                MTTracker mTTracker = MTTrackerConnection.this.torrent.getCurrentTracker();
                if (mTTracker != null && !mTTracker.canRequest()) {
                    return;
                }
                try {
                    Vector vector = MTTrackerConnection.this.torrent.getTrackerList();
                    for (int i = 0; !bl && i < vector.size(); ++i) {
                        Vector vector2 = (Vector)vector.elementAt(i);
                        for (int j = 0; !bl && j < vector2.size(); ++j) {
                            MTTracker mTTracker2 = (MTTracker)vector2.elementAt(j);
                            if (!MTNetworkStatusManager.testURL(mTTracker2.getUrl())) {
                                mTTracker2.setStatus(2);
                                continue;
                            }
                            try {
                                MTTrackerConnection.this.connectTracker(mTTracker2, mTTracker2.getUrl() + MTTrackerConnection.this.uriEnd);
                                bl = true;
                                mTTracker2.setStatus(1);
                                Object e = vector2.firstElement();
                                vector2.setElementAt(mTTracker2, 0);
                                vector2.setElementAt(e, j);
                                MTTrackerConnection.this.torrent.setCurrentTracker(mTTracker2);
                                continue;
                            }
                            catch (IOException iOException) {
                                MTLogger.writeLine("[Tracker]Tracker connection iofailed: " + iOException.getMessage());
                                mTTracker2.setStatus(2);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    MTLogger.writeLine("[Tracker]Tracker connection failed: " + exception.getMessage());
                    MTTrackerConnection.this.torrent.getTorrentManager().notifyTorrentObserverMain(MTTrackerConnection.this.torrent, 0);
                }
                if (!bl) {
                    MTTrackerConnection.this.torrent.getTorrentManager().notifyTorrentObserverMain(MTTrackerConnection.this.torrent, 0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

