/*
 * Decompiled with CFR 0.152.
 */
package data;

import TorrentEngine.Statistics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.util.Date;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class MEStatistics
extends Statistics {
    private static final String rmsDBName = "MobTorrentStats";
    private final int HEADER;
    private final int CURRENT_VERSION;
    private static final String[] imeiQuery = new String[]{"phone.imei", "com.nokia.IMEI", "com.sonyericsson.imei", "IMEI", "com.motorola.IMEI", "com.samsung.imei", "com.siemens.imei"};
    private String phoneID;
    private boolean registered;

    public MEStatistics() {
        this.HEADER = 0;
        this.CURRENT_VERSION = 1;
        try {
            this.phoneID = this.loadIDFromRMS();
            this.registered = true;
        }
        catch (Exception exception) {
            this.phoneID = this.generateID();
            this.registered = false;
        }
    }

    private String loadIDFromRMS() throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)rmsDBName, (boolean)false);
        RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)new HeaderFilter(), null, true);
        byte[] byArray = recordEnumeration.nextRecord();
        FilterInputStream filterInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            ((DataInputStream)filterInputStream).readInt();
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n != 1) {
                throw new Exception("Wrong version.");
            }
            int n2 = ((DataInputStream)filterInputStream).readInt();
            if (n2 <= 0) {
                throw new Exception("Invalid length");
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(((DataInputStream)filterInputStream).readChar());
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            try {
                filterInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw exception;
        }
    }

    private String generateID() {
        for (int i = 0; i < imeiQuery.length; ++i) {
            String string = System.getProperty(imeiQuery[i]);
            if (string == null) continue;
            return string;
        }
        return "DATE" + String.valueOf(new Date().getTime());
    }

    public boolean isFirstTime() {
        return !this.registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPhoneRegistered() {
        DataOutputStream dataOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        RecordStore recordStore = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.phoneID.length());
            dataOutputStream.writeChars(this.phoneID);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            dataOutputStream.close();
            try {
                RecordStore.deleteRecordStore((String)rmsDBName);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                // empty catch block
            }
            recordStore = RecordStore.openRecordStore((String)rmsDBName, (boolean)true);
            recordStore.addRecord(byArray, 0, byArray.length);
            this.registered = true;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    public String getPhoneID() {
        return this.phoneID;
    }

    private class HeaderFilter
    implements RecordFilter {
        private HeaderFilter() {
        }

        public boolean matches(byte[] byArray) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n = dataInputStream.readInt();
                dataInputStream.close();
                return n == 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

