/*
 * Decompiled with CFR 0.152.
 */
package data;

import TorrentEngine.MTTorrent;
import TorrentEngine.MTTorrentManager;
import data.MTPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import ui.MTUIManager;

public class MTRMSManager {
    public static void storeSettingsToRMS() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        RecordStore recordStore = null;
        dataOutputStream.writeInt(MTPreferences.LanguageCode);
        dataOutputStream.writeUTF(MTPreferences.DownloadFolder);
        dataOutputStream.writeBoolean(MTPreferences.EnableAddressBooster);
        dataOutputStream.writeBoolean(MTPreferences.EnableStats);
        dataOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        recordStore = RecordStore.openRecordStore((String)"MTSettingsDB", (boolean)true);
        try {
            recordStore.setRecord(1, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            recordStore.addRecord(byArray, 0, byArray.length);
        }
        dataOutputStream.close();
        byteArrayOutputStream.close();
        recordStore.closeRecordStore();
    }

    public static void restoreSettingsFromRMS() throws Exception {
        RecordStore recordStore = null;
        recordStore = RecordStore.openRecordStore((String)"MTSettingsDB", (boolean)true);
        if (recordStore != null) {
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            MTPreferences.setLanguage(dataInputStream.readInt());
            MTPreferences.DownloadFolder = dataInputStream.readUTF();
            MTPreferences.EnableAddressBooster = dataInputStream.readBoolean();
            MTPreferences.EnableStats = dataInputStream.readBoolean();
            dataInputStream.close();
            byteArrayInputStream.close();
            recordStore.closeRecordStore();
        }
    }

    public static void storeTorrentsToRMS(MTTorrentManager mTTorrentManager) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        RecordStore recordStore = null;
        dataOutputStream.writeInt(mTTorrentManager.getSimpleTorrentsNum());
        for (int i = 0; i < mTTorrentManager.getSimpleTorrentsNum(); ++i) {
            MTTorrent mTTorrent = mTTorrentManager.simpleTorrentAtIndex(i);
            if (mTTorrent.isValid()) {
                dataOutputStream.writeUTF(mTTorrent.getTorrentFilePath());
                dataOutputStream.writeUTF(mTTorrent.getTorrentNameWithoutPath());
                dataOutputStream.writeUTF(mTTorrent.getDownloadFolder());
                dataOutputStream.writeInt(mTTorrent.getBitField().data().length);
                dataOutputStream.write(mTTorrent.getBitField().data());
                continue;
            }
            dataOutputStream.writeUTF("-");
        }
        dataOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        recordStore = RecordStore.openRecordStore((String)"MTTorrentsDB", (boolean)true);
        try {
            recordStore.setRecord(1, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            recordStore.addRecord(byArray, 0, byArray.length);
        }
        dataOutputStream.close();
        byteArrayOutputStream.close();
        recordStore.closeRecordStore();
    }

    public static void restoreTorrentsFromRMS(MTUIManager mTUIManager) throws Exception {
        RecordStore recordStore = null;
        recordStore = RecordStore.openRecordStore((String)"MTTorrentsDB", (boolean)true);
        if (recordStore != null) {
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                if (string.equals("-")) continue;
                String string2 = dataInputStream.readUTF();
                String string3 = dataInputStream.readUTF();
                int n2 = dataInputStream.readInt();
                byte[] byArray2 = new byte[n2];
                dataInputStream.read(byArray2);
                mTUIManager.openNewTorrent(string, string2, true, byArray2, string3);
            }
            dataInputStream.close();
            byteArrayInputStream.close();
            recordStore.closeRecordStore();
        }
    }
}

