/*
 * Decompiled with CFR 0.152.
 */
package sha1;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SHA1 {
    private final int[] w = new int[80];
    private final byte[] end = new byte[64];
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int length;
    private int endLength;

    public SHA1() {
        this.reset();
    }

    public void reset() {
        this.endLength = 0;
        this.length = 0;
        this.a = 1732584193;
        this.b = -271733879;
        this.c = -1732584194;
        this.d = 271733878;
        this.e = -1009589776;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.length += n2;
        if (this.endLength + n2 < 64) {
            System.arraycopy(byArray, n, this.end, this.endLength, n2);
            this.endLength += n2;
            return;
        }
        if (this.endLength > 0) {
            System.arraycopy(byArray, n, this.end, this.endLength, 64 - this.endLength);
            this.addChunk(this.end, 0);
            n += 64 - this.endLength;
            n2 -= 64 - this.endLength;
            this.endLength = 0;
        }
        while (n2 >= 64) {
            this.addChunk(byArray, n);
            n2 -= 64;
            n += 64;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.end, 0, n2);
            this.endLength = n2;
        }
    }

    public int[] digest() {
        int n;
        boolean bl = false;
        if (this.endLength + 8 > 64) {
            bl = true;
            this.end[this.endLength] = -128;
            for (n = this.endLength + 1; n < 64; ++n) {
                this.end[n] = 0;
            }
            this.addChunk(this.end, 0);
            this.endLength = 0;
        }
        for (n = this.endLength; n < 56; ++n) {
            this.end[n] = !bl ? -128 : 0;
            bl = true;
        }
        long l = (long)this.length * 8L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, this.end, 56, 8);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.addChunk(this.end, 0);
        int[] nArray = new int[]{this.a, this.b, this.c, this.d, this.e};
        this.reset();
        return nArray;
    }

    public static String resultToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = 0; i < 5; ++i) {
            String string = Integer.toHexString(nArray[i]).toUpperCase();
            for (int j = 0; j < 8 - string.length(); ++j) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String resultToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = 0; i < 20; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF).toUpperCase();
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] resultToByte(int[] nArray) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(160);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < 5; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public static String resultToByteString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(20);
        byte[] byArray = SHA1.resultToByte(nArray);
        for (int i = 0; i < 20; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void addChunk(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = this.a;
        int n5 = this.b;
        int n6 = this.c;
        int n7 = this.d;
        int n8 = this.e;
        for (int i = n; i < n + 64; i += 4) {
            this.w[n3++] = (byArray[i] & 0xFF) << 24 | (byArray[i + 1] & 0xFF) << 16 | (byArray[i + 2] & 0xFF) << 8 | byArray[i + 3] & 0xFF;
        }
        for (n3 = 16; n3 < 80; ++n3) {
            n2 = this.w[n3 - 3] ^ this.w[n3 - 8] ^ this.w[n3 - 14] ^ this.w[n3 - 16];
            this.w[n3] = n2 << 1 | n2 >>> 31;
        }
        for (n3 = 0; n3 < 20; ++n3) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | ~n5 & n7) + n8 + this.w[n3] + 1518500249;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        for (n3 = 20; n3 < 40; ++n3) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + this.w[n3] + 1859775393;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        for (n3 = 40; n3 < 60; ++n3) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | n5 & n7 | n6 & n7) + n8 + this.w[n3] + -1894007588;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        for (n3 = 60; n3 < 80; ++n3) {
            n2 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + this.w[n3] + -899497514;
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        this.a += n4;
        this.b += n5;
        this.c += n6;
        this.d += n7;
        this.e += n8;
    }
}

