/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Logger.MTLogger;
import TorrentEngine.MTOpenTorrentResult;
import TorrentEngine.MTStringFormatter;
import TorrentEngine.MTTorrent;
import TorrentEngine.MTTorrentManager;
import TorrentEngine.MTTorrentObserver;
import data.LocalizationSupport;
import data.MEStatistics;
import data.MTPreferences;
import data.MTRMSManager;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import ui.MTCanvasDownloadState;
import ui.MTFormAbout;
import ui.MTFormFileCreateState;
import ui.MTFormHelp;
import ui.MTFormProperties;
import ui.MTFormSettings;
import ui.MTFormUpdate;
import ui.MTListFiles;
import ui.MTListTorrents;
import ui.MobTorrentMidlet;

public class MTUIManager
implements MTTorrentObserver {
    private MobTorrentMidlet midlet;
    private MTTorrentManager torrentManager;
    private MTListTorrents listTorrents = null;
    private MTFormSettings formSettings = null;
    private MTCanvasDownloadState canvasDownloadState = null;
    private MTFormProperties formProperties = null;
    private MTFormFileCreateState formFileCreateState = null;
    private MTListFiles listFiles = null;
    private MTFormAbout formAbout = null;
    private MTFormHelp formHelp = null;
    private MTFormUpdate formUpdate = null;
    private int currentScreenID = -1;
    private Image iconComplete = null;
    private Image iconDownloading = null;
    private Image iconFailed = null;
    private Image iconParsingCreating = null;
    private Image iconPaused = null;
    private Image iconUploading = null;
    private Image iconWaiting = null;

    public MTUIManager(MobTorrentMidlet mobTorrentMidlet) {
        this.midlet = mobTorrentMidlet;
        MEStatistics mEStatistics = null;
        if (MTPreferences.EnableStats) {
            mEStatistics = new MEStatistics();
        }
        this.torrentManager = new MTTorrentManager(this, mEStatistics);
    }

    public void showScreen(int n) {
        this.currentScreenID = n;
        switch (n) {
            case 1: {
                if (this.listTorrents == null) {
                    this.listTorrents = new MTListTorrents(this);
                }
                this.show((Displayable)this.listTorrents);
                break;
            }
            case 2: {
                if (this.formSettings == null) {
                    this.formSettings = new MTFormSettings(LocalizationSupport.getMessage("title_formSettings"), this);
                }
                this.show((Displayable)this.formSettings);
                break;
            }
            case 3: {
                if (this.torrentManager.simpleTorrentAtIndex(this.listTorrents.getSelectedIndex()).isValid()) {
                    if (this.canvasDownloadState == null) {
                        this.canvasDownloadState = new MTCanvasDownloadState(LocalizationSupport.getMessage("title_formDownloadState"), this);
                    }
                    this.canvasDownloadState.initialize(this.torrentManager.simpleTorrentAtIndex(this.listTorrents.getSelectedIndex()));
                    this.show((Displayable)this.canvasDownloadState);
                    break;
                }
                if (this.formFileCreateState == null) {
                    this.formFileCreateState = new MTFormFileCreateState(LocalizationSupport.getMessage("title_formFileCreateState"), this);
                }
                this.currentScreenID = 6;
                this.show((Displayable)this.formFileCreateState);
                break;
            }
            case 4: {
                if (this.formProperties == null) {
                    this.formProperties = new MTFormProperties(LocalizationSupport.getMessage("title_formProperties"), this);
                }
                this.formProperties.initialize(this.torrentManager.simpleTorrentAtIndex(this.listTorrents.getSelectedIndex()));
                this.show((Displayable)this.formProperties);
                break;
            }
            case 5: {
                if (this.listFiles == null) {
                    this.listFiles = new MTListFiles(LocalizationSupport.getMessage("title_listFiles"), this);
                }
                this.listFiles.refreshFilesData(this.torrentManager.simpleTorrentAtIndex(this.listTorrents.getSelectedIndex()));
                this.show((Displayable)this.listFiles);
                break;
            }
            case 6: {
                if (this.formFileCreateState == null) {
                    this.formFileCreateState = new MTFormFileCreateState(LocalizationSupport.getMessage("title_formFileCreateState"), this);
                }
                this.currentScreenID = 6;
                this.show((Displayable)this.formFileCreateState);
                break;
            }
            case 7: {
                if (this.formAbout == null) {
                    this.formAbout = new MTFormAbout(this);
                }
                this.currentScreenID = 7;
                this.show((Displayable)this.formAbout);
                break;
            }
            case 8: {
                if (this.formHelp == null) {
                    this.formHelp = new MTFormHelp(this);
                }
                this.currentScreenID = 8;
                this.show((Displayable)this.formHelp);
                break;
            }
            case 9: {
                if (this.formUpdate == null) {
                    this.formUpdate = new MTFormUpdate(this);
                }
                this.currentScreenID = 9;
                this.show((Displayable)this.formUpdate);
                break;
            }
            default: {
                if (this.listTorrents == null) {
                    this.listTorrents = new MTListTorrents(this);
                }
                this.show((Displayable)this.listTorrents);
            }
        }
    }

    public void show(Displayable displayable) {
        Display.getDisplay((MIDlet)this.getMidlet()).setCurrent(displayable);
    }

    public void exit() {
        this.getMidlet().destroyApp(true);
        this.getMidlet().notifyDestroyed();
    }

    public void endTorrentManager() {
        if (this.torrentManager != null) {
            this.torrentManager.endTorrentManager();
        }
    }

    public MTTorrentManager getTorrentManager() {
        return this.torrentManager;
    }

    public void showMessage(String string) {
        Alert alert = new Alert("MobTorrent", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.getMidlet()).setCurrent(alert, Display.getDisplay((MIDlet)this.getMidlet()).getCurrent());
    }

    public MobTorrentMidlet getMidlet() {
        return this.midlet;
    }

    public Image getIconComplete() {
        if (this.iconComplete == null) {
            try {
                this.iconComplete = Image.createImage((String)"/resources/complete.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconComplete;
    }

    public Image getIconDownloading() {
        if (this.iconDownloading == null) {
            try {
                this.iconDownloading = Image.createImage((String)"/resources/downloading.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconDownloading;
    }

    public Image getIconFailed() {
        if (this.iconFailed == null) {
            try {
                this.iconFailed = Image.createImage((String)"/resources/failed.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconFailed;
    }

    private Image getIconParsingCreating() {
        if (this.iconParsingCreating == null) {
            try {
                this.iconParsingCreating = Image.createImage((String)"/resources/parsingcreating.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconParsingCreating;
    }

    public Image getIconPaused() {
        if (this.iconPaused == null) {
            try {
                this.iconPaused = Image.createImage((String)"/resources/paused.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconPaused;
    }

    private Image getIconUploading() {
        if (this.iconUploading == null) {
            try {
                this.iconUploading = Image.createImage((String)"/resources/uploading.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconUploading;
    }

    private Image getIconWaiting() {
        if (this.iconWaiting == null) {
            try {
                this.iconWaiting = Image.createImage((String)"/resources/waiting.png");
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
        return this.iconWaiting;
    }

    public void startTorrent(int n) {
        this.torrentManager.simpleTorrentAtIndex(n).start();
    }

    public void stopTorrent(int n) {
        MTTorrent mTTorrent = this.torrentManager.simpleTorrentAtIndex(n);
        if (mTTorrent != null) {
            mTTorrent.stop(true);
        }
    }

    public void removeTorrent(int n) {
        this.torrentManager.simpleTorrentAtIndex(n).close();
    }

    public void openNewTorrent(final String string, final String string2, final boolean bl, final byte[] byArray, final String string3) {
        new Thread(){

            public void run() {
                MTOpenTorrentResult mTOpenTorrentResult = MTUIManager.this.torrentManager.openTorrent(string, string2, bl, byArray, string3);
                switch (mTOpenTorrentResult.getOpenResult()) {
                    case 0: {
                        mTOpenTorrentResult.getOpenedTorrent().start();
                        break;
                    }
                    case -2: {
                        MTUIManager.this.torrentManager.removeTorrentFromVector(mTOpenTorrentResult.getOpenedTorrent());
                        MTUIManager.this.showMessage(LocalizationSupport.getMessage("text_alreadyAdded"));
                        break;
                    }
                    case -4: {
                        MTUIManager.this.torrentManager.removeTorrentFromVector(mTOpenTorrentResult.getOpenedTorrent());
                        MTUIManager.this.showMessage(LocalizationSupport.getMessage("text_errorNotEnoughFreeSize"));
                        break;
                    }
                    case -5: {
                        MTUIManager.this.torrentManager.removeTorrentFromVector(mTOpenTorrentResult.getOpenedTorrent());
                        MTUIManager.this.showMessage(LocalizationSupport.getMessage("text_errorFileHandling"));
                        break;
                    }
                    default: {
                        MTUIManager.this.torrentManager.removeTorrentFromVector(mTOpenTorrentResult.getOpenedTorrent());
                        MTUIManager.this.showMessage(LocalizationSupport.getMessage("text_errorFailedToOpen"));
                    }
                }
            }
        }.start();
    }

    public void torrentChanged(MTTorrent mTTorrent, int n, int n2) {
        try {
            switch (n2) {
                case 8: {
                    if (this.currentScreenID == 3 && this.listTorrents.getSelectedIndex() == n) {
                        this.canvasDownloadState.updateDownloadPercent(mTTorrent.getDownloadPercent());
                        break;
                    }
                    if (this.currentScreenID != 1 || n != this.listTorrents.getSelectedIndex()) break;
                    this.listTorrents.setTitle(MTStringFormatter.getFormattedPercent(mTTorrent.getDownloadPercent()) + " " + LocalizationSupport.getMessage("text_down") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec") + " " + LocalizationSupport.getMessage("text_up") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageUploadedBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec"));
                    break;
                }
                case 32: {
                    if (this.currentScreenID == 3 && this.listTorrents.getSelectedIndex() == n) {
                        this.canvasDownloadState.updateDownloadSpeed(mTTorrent.getAvarageBytesPerSecond(), mTTorrent.getAvarageUploadedBytesPerSecond());
                    }
                    if (this.currentScreenID != 1 || n != this.listTorrents.getSelectedIndex()) break;
                    this.listTorrents.setTitle(MTStringFormatter.getFormattedPercent(mTTorrent.getDownloadPercent()) + " " + LocalizationSupport.getMessage("text_down") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec") + " " + LocalizationSupport.getMessage("text_up") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageUploadedBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec"));
                    break;
                }
                case 16: {
                    if (this.currentScreenID == 3 && this.listTorrents.getSelectedIndex() == n) {
                        this.canvasDownloadState.updateDownloadPercent(mTTorrent.getDownloadPercent());
                    }
                    if (this.currentScreenID != 1 || n != this.listTorrents.getSelectedIndex()) break;
                    this.listTorrents.setTitle(MTStringFormatter.getFormattedPercent(mTTorrent.getDownloadPercent()) + " " + LocalizationSupport.getMessage("text_down") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec") + " " + LocalizationSupport.getMessage("text_up") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageUploadedBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec"));
                    break;
                }
                case 64: {
                    if (this.currentScreenID == 3 && this.listTorrents.getSelectedIndex() == n) {
                        this.canvasDownloadState.updateDownloadSpeed(mTTorrent.getAvarageBytesPerSecond(), mTTorrent.getAvarageUploadedBytesPerSecond());
                    }
                    if (this.currentScreenID != 1 || n != this.listTorrents.getSelectedIndex()) break;
                    this.listTorrents.setTitle(MTStringFormatter.getFormattedPercent(mTTorrent.getDownloadPercent()) + " " + LocalizationSupport.getMessage("text_down") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec") + " " + LocalizationSupport.getMessage("text_up") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageUploadedBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec"));
                    break;
                }
                case 4: {
                    if (this.currentScreenID != 3 || this.listTorrents.getSelectedIndex() != n) break;
                    this.canvasDownloadState.updateConnections(mTTorrent.getPeerWireConnectionCount(), mTTorrent.getIncomingConnectionsNum());
                    break;
                }
                case 65536: {
                    if (this.currentScreenID != 3 || this.listTorrents.getSelectedIndex() != n) break;
                    this.canvasDownloadState.updateConnections(mTTorrent.getPeerWireConnectionCount(), mTTorrent.getIncomingConnectionsNum());
                    break;
                }
                case 32768: {
                    if (this.currentScreenID != 3 || this.listTorrents.getSelectedIndex() != n) break;
                    this.canvasDownloadState.updateConnections(mTTorrent.getPeerWireConnectionCount(), mTTorrent.getIncomingConnectionsNum());
                    break;
                }
                case 2048: {
                    if (this.currentScreenID != 3 || this.listTorrents.getSelectedIndex() != n) break;
                    this.canvasDownloadState.updatePieceDownload();
                    break;
                }
                case 256: {
                    if (this.currentScreenID != 1 || n == -1) break;
                    this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconFailed());
                    break;
                }
                case 4096: {
                    if (this.currentScreenID == 1) {
                        this.listTorrents.delete(n);
                    }
                    this.listTorrents.setCommandsByState();
                    this.torrentManager.removeSimpleTorrentFromVector(n);
                    if (this.listTorrents.size() != 0) break;
                    this.listTorrents.setTitle(LocalizationSupport.getMessage("title_listTorrents"));
                    break;
                }
                case 8192: {
                    if (this.currentScreenID != 1) break;
                    this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconPaused());
                    break;
                }
                case 16384: {
                    if (this.currentScreenID != 5) break;
                    this.listFiles.refreshFilesData(mTTorrent);
                    break;
                }
                case 131072: {
                    MTRMSManager.storeTorrentsToRMS(this.torrentManager);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MTLogger.writeLine("Error in torrentChanged(): " + exception.getMessage());
        }
    }

    public void torrentMainChanged(MTTorrent mTTorrent, int n, int n2) {
        if (n != -1) {
            try {
                switch (n2) {
                    case 1: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.append(mTTorrent.getTorrentNameWithoutPath(), this.getIconParsingCreating());
                        this.listTorrents.setCommandsByState();
                        break;
                    }
                    case 3: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconWaiting());
                        if (this.listTorrents.getSelectedIndex() != n) break;
                        this.listTorrents.setTitle(LocalizationSupport.getMessage("text_trackerConnecting"));
                        break;
                    }
                    case 4: {
                        if (this.currentScreenID == 1 && this.listTorrents.getSelectedIndex() == n) {
                            this.listTorrents.setTitle(LocalizationSupport.getMessage("text_trackerConnected"));
                        }
                        if (this.currentScreenID != 3 || this.listTorrents.getSelectedIndex() != n || this.canvasDownloadState == null) break;
                        this.canvasDownloadState.repaint();
                        break;
                    }
                    case 2: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconDownloading());
                        if (this.listTorrents.getSelectedIndex() != n) break;
                        this.listTorrents.setTitle(LocalizationSupport.getMessage("text_startDownload"));
                        break;
                    }
                    case 5: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconComplete());
                        if (this.listTorrents.getSelectedIndex() != n) break;
                        this.listTorrents.setTitle(LocalizationSupport.getMessage("text_completed"));
                        break;
                    }
                    case 0: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconFailed());
                        if (this.listTorrents.getSelectedIndex() != n) break;
                        this.listTorrents.setTitle(LocalizationSupport.getMessage("text_failed"));
                        break;
                    }
                    case 6: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconUploading());
                        if (this.listTorrents.getSelectedIndex() != n) break;
                        this.listTorrents.setTitle(LocalizationSupport.getMessage("text_uploading"));
                        break;
                    }
                    case 7: {
                        if (this.listTorrents == null) break;
                        this.listTorrents.set(n, mTTorrent.getTorrentNameWithoutPath(), this.getIconComplete());
                        if (this.listTorrents.getSelectedIndex() != n) break;
                        this.listTorrents.setTitle(LocalizationSupport.getMessage("text_completed"));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MTLogger.writeLine("Error in torrentMainChanged(): " + exception.getMessage());
            }
        }
    }

    public void openTorrentStateChanged(int n, MTTorrent mTTorrent, String string, double d) {
        if (this.currentScreenID == 6 && this.listTorrents.getSelectedIndex() == this.torrentManager.getTorrentIndex(mTTorrent)) {
            switch (n) {
                case 1: {
                    this.formFileCreateState.fileCreateStateChanged(string, d);
                    break;
                }
                case 2: {
                    this.showScreen(3);
                }
            }
        }
    }

    public void statusChanged(String string) {
    }

    public void synchronizeAddressBooster() {
        this.torrentManager.setAddressBooster(MTPreferences.EnableAddressBooster);
    }
}

