/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Logger.MTLogger;
import TorrentEngine.MTBitfield;
import TorrentEngine.MTPeerConnection;
import TorrentEngine.MTPiece;
import TorrentEngine.MTTorrent;
import TorrentEngine.MTTorrentManager;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.SocketConnection;

public class MTPeer {
    private int MaxPeerErrorCount = 3;
    private final long KIPAliveTimeOut;
    private String address;
    private int port;
    private String peerId = null;
    private MTBitfield bitField;
    private int errorCounter = 0;
    private boolean deletable;
    private boolean hadRequestTimeout;
    private MTPeerConnection connection;
    private boolean ipOK = false;
    private long lastIPCheckTime = 0L;

    public MTPeer(String string, int n, String string2, int n2) {
        this.KIPAliveTimeOut = 180000L;
        this.address = string;
        this.port = n;
        this.peerId = string2;
        this.bitField = new MTBitfield(n2, false);
    }

    public MTPeer(SocketConnection socketConnection, MTTorrentManager mTTorrentManager) {
        this.KIPAliveTimeOut = 180000L;
        this.bitField = new MTBitfield(1, false);
        try {
            this.address = socketConnection.getAddress();
            this.port = socketConnection.getPort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.connection = new MTPeerConnection(this, null, mTTorrentManager);
        this.connection.initializeIncomingConnection(socketConnection);
    }

    public void onTimer() {
        if (this.connection != null) {
            this.connection.onTimer();
            if (this.connection.state() == 5) {
                switch (this.connection.getCloseOrder()) {
                    case 1: {
                        ++this.errorCounter;
                        break;
                    }
                    case 0: {
                        this.deletable = true;
                        break;
                    }
                }
                if (this.errorCounter >= this.MaxPeerErrorCount) {
                    MTLogger.writeLine("[Peer] Max error count reached, deleting peer.");
                    this.deletable = true;
                }
                this.connection = null;
            }
        } else if (this.errorCounter >= this.MaxPeerErrorCount) {
            MTLogger.writeLine("[Peer] Max error count reached with connection==null, deleting peer.");
            this.deletable = true;
        }
    }

    public void incErrorCounter() {
        ++this.errorCounter;
    }

    public void connect(MTTorrent mTTorrent, MTTorrentManager mTTorrentManager) {
        if (this.connection == null) {
            this.connection = new MTPeerConnection(this, mTTorrent, mTTorrentManager);
        }
        if (this.connection.state() == 0) {
            this.connection.connect();
        }
    }

    public void havePiece(int n, MTTorrent mTTorrent) {
        this.bitField.setBit(n);
        mTTorrent.increaseNumberOfPeersHavingPiece(n);
    }

    public void havePieces(byte[] byArray, MTTorrent mTTorrent) {
        MTBitfield mTBitfield = new MTBitfield(mTTorrent.pieceCount(), false);
        mTBitfield.set(byArray);
        for (int i = 0; i < mTTorrent.pieceCount(); ++i) {
            if (!mTBitfield.isBitSet(i) || this.bitField.isBitSet(i)) continue;
            mTTorrent.increaseNumberOfPeersHavingPiece(i);
        }
        this.bitField.set(byArray);
    }

    public void notifyThatClientHavePiece(int n) {
        try {
            if (this.connection != null && this.state() == 4 && !this.getBitField().isBitSet(n)) {
                this.connection.sendHaveMessage(n);
            }
        }
        catch (Exception exception) {
            this.connection.close("MODEL SEND ERROR");
        }
    }

    public void setBitFieldLength(int n) {
        this.bitField = null;
        this.bitField = new MTBitfield(n, false);
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.close("Torrent paused");
            this.connection = null;
        }
    }

    public Vector piecesToDownload() {
        MTPeerConnection mTPeerConnection = this.connection;
        if (mTPeerConnection == null) {
            return null;
        }
        return mTPeerConnection.getPiecesToDownload();
    }

    public void resetAddress() {
    }

    void cancelPieceRequest(MTPiece mTPiece) {
        if (this.connection != null) {
            this.connection.cancelPieceRequest(mTPiece);
        }
    }

    void cancelAllPieceRequests() {
        if (this.connection != null) {
            this.connection.cancelAllPieceRequests();
        }
    }

    public void resetErrorCounter() {
        this.errorCounter = 0;
    }

    public void terminate() {
        try {
            this.connection.close(0, "Invalid hash! Terminating connection.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String string) {
        this.peerId = string;
    }

    public MTBitfield getBitField() {
        return this.bitField;
    }

    public void setBitField(MTBitfield mTBitfield) {
        this.bitField = mTBitfield;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public boolean isHadRequestTimeout() {
        return this.hadRequestTimeout;
    }

    public void setHadRequestTimeout(boolean bl) {
        this.hadRequestTimeout = bl;
    }

    public int state() {
        if (this.connection != null) {
            return this.connection.state();
        }
        return 0;
    }

    public boolean isIncommingPeer() {
        if (this.connection != null) {
            return this.connection.isIncomingConnection();
        }
        return false;
    }

    public boolean isIpOK() {
        return this.ipOK && !this.isIpCheckTimeout();
    }

    public boolean isIpCheckTimeout() {
        return System.currentTimeMillis() - this.lastIPCheckTime > 180000L;
    }

    public void setIpOK(boolean bl) {
        this.ipOK = bl;
    }

    public void setLastIPCheckTime(long l) {
        this.lastIPCheckTime = l;
    }

    public String getClient() {
        if (this.peerId == null || this.peerId.length() < 8) {
            return "";
        }
        return this.peerId.substring(1, 7);
    }
}

