/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Logger.MTLogger;
import Tools.NetTools;
import TorrentEngine.MTFile;
import TorrentEngine.MTFileFragment;
import TorrentEngine.MTFileManager;
import TorrentEngine.MTPeer;
import TorrentEngine.MTTorrent;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import sha1.SHA1;

public class MTPiece {
    private MTTorrent torrent;
    private byte[] hash;
    private String hashHex;
    private int totalSize;
    private int numberOfPeersHaveThis;
    private int downloadedSize;
    private Vector files;
    private SHA1 incommingHash = null;

    public MTPiece(MTTorrent mTTorrent, byte[] byArray, int n) {
        this.torrent = mTTorrent;
        this.hash = byArray;
        this.hashHex = NetTools.bytesToHex(this.hash);
        this.totalSize = n;
        this.files = new Vector();
    }

    public void setDownloaded() {
        this.downloadedSize = this.totalSize;
        this.setFilesDownloaded();
    }

    public void setFilesDownloaded() {
        for (int i = 0; i < this.files.size(); ++i) {
            boolean bl = true;
            for (int j = 0; j < this.torrent.pieceCount(); ++j) {
                if (!this.torrent.piece(j).hasFile(((MTFileFragment)this.files.elementAt(i)).getFile()) || this.torrent.piece(j).isDownloaded()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ((MTFileFragment)this.files.elementAt(i)).getFile().setDownloadState(2);
            this.torrent.getTorrentManager().notifyTorrentObserver(this.torrent, 16384);
        }
    }

    private boolean hasFile(MTFile mTFile) {
        for (int i = 0; i < this.files.size(); ++i) {
            if (((MTFileFragment)this.files.elementAt(i)).getFile() != mTFile) continue;
            return true;
        }
        return false;
    }

    public void addFileFragment(MTFile mTFile, int n, int n2) {
        this.files.addElement(new MTFileFragment(mTFile, n, n2));
    }

    private boolean checkHash() {
        if (this.remaining() != 0) {
            return false;
        }
        boolean bl = false;
        int[] nArray = this.incommingHash.digest();
        if (nArray != null) {
            String string = NetTools.getHexStringFromIntArray(nArray);
            if (string.equals(this.hashHex)) {
                bl = true;
            } else {
                MTLogger.writeLine("HASH FAILED (origi): " + this.hashHex);
                MTLogger.writeLine("HASH FAILED (new): " + string);
            }
            nArray = null;
            System.gc();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendBlock(byte[] byArray, int n, MTPeer mTPeer) {
        if (this.downloadedSize != n) {
            MTLogger.writeLine("[Piece] Wrong block received: " + n + " excepted: " + this.downloadedSize);
            return 0;
        }
        MTPiece mTPiece = this;
        synchronized (mTPiece) {
            if (this.downloadedSize != n) {
                MTLogger.writeLine("[Piece] Wrong block received: " + n + " excepted: " + this.downloadedSize);
                return 0;
            }
            if (this.incommingHash == null) {
                this.incommingHash = new SHA1();
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                GetFilePositionResponse getFilePositionResponse = this.getFilePosition(this.downloadedSize);
                MTFile mTFile = getFilePositionResponse.file;
                int n3 = getFilePositionResponse.filePosition;
                if (mTFile.getDownloadState() != 1) {
                    mTFile.setDownloadState(1);
                    this.torrent.getTorrentManager().notifyTorrentObserver(this.torrent, 16384);
                }
                if (mTFile != null) {
                    int n4 = 0;
                    int n5 = mTFile.getSize() - n3;
                    MTLogger.write("[Piece] Appending block to ");
                    MTLogger.writeLine(mTFile.getPath());
                    if (n5 <= byArray.length - n2) {
                        MTLogger.write("[Piece] File complete: ");
                        MTLogger.writeLine(mTFile.getPath());
                        n4 = this.torrent.getFileManager().writeFile(mTFile, n3, byArray, n2, n5);
                        if (n4 != 0) {
                            return n4;
                        }
                        n2 += n5;
                        this.downloadedSize += n5;
                        continue;
                    }
                    int n6 = byArray.length - n2;
                    n4 = this.torrent.getFileManager().writeFile(mTFile, n3, byArray, byArray.length - n6, n6);
                    MTLogger.writeLine("---PIECE BLOCK SAVE FROM---: " + mTPeer.getAddress() + ":" + mTPeer.getPort());
                    if (n4 != 0) {
                        return n4;
                    }
                    this.downloadedSize += n6;
                    break;
                }
                return -6;
            }
            this.torrent.updateBytesDownloaded(byArray.length, true);
            this.incommingHash.update(byArray);
            if (this.remaining() == 0) {
                MTLogger.writeLine("[Piece] Downloading piece completed!");
                if (this.checkHash()) {
                    MTLogger.writeLine("[Piece] Hash OK!");
                    this.setFilesDownloaded();
                    this.torrent.pieceDownloaded(this, false);
                } else {
                    MTLogger.writeLine("[Piece] Hash FAILED!");
                    this.downloadedSize = 0;
                    this.torrent.pieceHashFailed(this);
                    mTPeer.terminate();
                }
                this.incommingHash = null;
            } else if (this.remaining() < 0) {
                return -6;
            }
            return 0;
        }
    }

    private GetFilePositionResponse getFilePosition(int n) {
        int n2 = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            if (n < n2 + ((MTFileFragment)this.files.elementAt(i)).getLength()) {
                GetFilePositionResponse getFilePositionResponse = new GetFilePositionResponse();
                getFilePositionResponse.file = ((MTFileFragment)this.files.elementAt(i)).getFile();
                getFilePositionResponse.filePosition = ((MTFileFragment)this.files.elementAt(i)).getOffset() + (n - n2);
                return getFilePositionResponse;
            }
            n2 += ((MTFileFragment)this.files.elementAt(i)).getLength();
        }
        return null;
    }

    public byte[] getBlock(int n, int n2) {
        Object object;
        int n3;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MTFile mTFile = null;
        int n5 = 0;
        for (n3 = 0; n3 < this.files.size(); ++n3) {
            object = (MTFileFragment)this.files.elementAt(n3);
            if (n < n5 + ((MTFileFragment)object).getLength()) {
                mTFile = ((MTFileFragment)object).getFile();
                n4 = ((MTFileFragment)object).getOffset() + (n - n5);
                break;
            }
            n5 += ((MTFileFragment)object).getLength();
        }
        if (mTFile == null) {
            return null;
        }
        while (n2 > 0) {
            if (n2 >= mTFile.getSize() - n4) {
                object = this.torrent.getFileManager().read(mTFile, n4, mTFile.getSize() - n4);
                if (object == null) break;
                byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
                object = null;
                n2 -= mTFile.getSize() - n4;
            } else {
                object = this.torrent.getFileManager().read(mTFile, n4, n2);
                if (object == null) break;
                byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
                n2 = 0;
                object = null;
                break;
            }
            if (n3 >= this.files.size() - 1) break;
            mTFile = ((MTFileFragment)this.files.elementAt(++n3)).getFile();
            n4 = 0;
        }
        if (n2 != 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int[] getHashedBlock(int n, int n2) {
        Object object;
        int n3;
        int n4 = 0;
        Object var4_4 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MTFile mTFile = null;
        int n5 = 0;
        for (n3 = 0; n3 < this.files.size(); ++n3) {
            object = (MTFileFragment)this.files.elementAt(n3);
            if (n < n5 + ((MTFileFragment)object).getLength()) {
                mTFile = ((MTFileFragment)object).getFile();
                n4 = ((MTFileFragment)object).getOffset() + (n - n5);
                break;
            }
            n5 += ((MTFileFragment)object).getLength();
        }
        if (mTFile == null) {
            return null;
        }
        object = new SHA1();
        while (n2 > 0) {
            if (n2 >= mTFile.getSize() - n4) {
                object = this.torrent.getFileManager().readHashed(mTFile, n4, mTFile.getSize() - n4, (SHA1)object);
                if (object == null) break;
                n2 -= mTFile.getSize() - n4;
            } else {
                object = this.torrent.getFileManager().readHashed(mTFile, n4, n2, (SHA1)object);
                if (object == null) break;
                n2 = 0;
                break;
            }
            if (n3 >= this.files.size() - 1) break;
            mTFile = ((MTFileFragment)this.files.elementAt(++n3)).getFile();
            n4 = 0;
        }
        if (n2 != 0) {
            return null;
        }
        return ((SHA1)object).digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHashFail() {
        int n = 0;
        while (MTFileManager.fileExists("e/others/hash_fail" + n + ".dat")) {
            ++n;
        }
        FileConnection fileConnection = null;
        OutputStream outputStream = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file:///e/others/hash_fail" + n + ".dat"), (int)3);
            fileConnection.create();
            outputStream = fileConnection.openOutputStream();
            int n2 = 16384;
            int n3 = 0;
            for (int i = this.totalSize; i > 0; i -= n2) {
                if (n2 > i) {
                    n2 = i;
                }
                outputStream.write(this.getBlock(n3, n2));
                n3 += n2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    public int index() {
        return this.torrent.indexOfPiece(this);
    }

    public int remaining() {
        return this.getTotalSize() - this.downloadedSize;
    }

    public void incNumberOfPeersHaveThis() {
        ++this.numberOfPeersHaveThis;
    }

    public void decNumberOfPeersHaveThis() {
        --this.numberOfPeersHaveThis;
    }

    public boolean isDownloaded() {
        return this.getTotalSize() == this.getDownloadedSize();
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getDownloadedSize() {
        return this.downloadedSize;
    }

    public int getNumberOfPeersHaveThis() {
        return this.numberOfPeersHaveThis;
    }

    public MTPiece getThisPiece() {
        return this;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setDownloadedSize(int n) {
        this.downloadedSize = n;
    }

    class GetFilePositionResponse {
        public MTFile file;
        public int filePosition;
    }
}

